
var gIsEnableHandFree = false;
var gIsUseGlobalBackToHomeControl = true;

function updateStreamRtmpValue() {
    $("#rtmpUrlTextInput").val(cameraSettings.RtmpServerUrl1);
    if (cameraSettings.RtmpStreamKey1Used == "1") {
        $("#streamKeyInput").val("xxxxxxxxxx");
    } else {
        $("#streamKeyInput").val("");
    }
    $("#authenRtmpCheckboxInput").prop("checked", OnOff2BoolMap.get(cameraSettings.AuthenRtmp))
    $("#authenRtmpUserNameTextInput").val(cameraSettings.AuthenRtmpUserName);
    if (cameraSettings.AuthenRtmpPasswordUsed == "1") {
        $("#authenRtmpPasswordInput").val("xxxxxxxxxx");
    } else {
        $("#authenRtmpPasswordInput").val("");
    }
    $("#videoEncoderTypeSpan").text(cameraSettings.RtmpVideoInfo);
    $("#audioEncoderTypeSpan").text(cameraSettings.RtmpAudioInfo);
    $("#resolutionFormatSpan").text(cameraSettings.RtmpVideoResolution);
    $("#chunkSizeSpan").text(cameraSettings.RtmpChunkSize);
    $("#rtmpServerStatusSpan").text(cameraSettings.RtmpStatus);
    updateRTMPAuth();
    if (cameraSettings.RtmpEnable == "on") {
        AutoUpdateRTMPStatus();
    }
}

const imagesize2WebMap = new Map([
    ["3840,2160", "4K"],
    ["1920,1080", "1080P"],
    ["1280,720", "720P"]
]);

function updateStream1Select() {
    $("#resolution1Select option").remove();
    $("#resolution1Select").append($("<option></option>").val(cameraSettings.ImageSize1).text(imagesize2WebMap.get(cameraSettings.ImageSize1)));

    $("#frameRate1Select option").remove();
    $("#frameRate1Select").append($("<option></option>").val(cameraSettings.FrameRate1).text(cameraSettings.FrameRate1));

    $("#ipRatio1Select option").remove();
    switch (cameraSettings.FrameRate1) {
        case "60":
        case "59.94":
            $("#ipRatio1Select").append($("<option></option>").val("60").text("60"));
            $("#ipRatio1Select").append($("<option></option>").val("30").text("30"));
            $("#ipRatio1Select").append($("<option></option>").val("15").text("15"));
            $("#ipRatio1Select").append($("<option></option>").val("10").text("10"));
            break;
        case "50":
            $("#ipRatio1Select").append($("<option></option>").val("50").text("50"));
            $("#ipRatio1Select").append($("<option></option>").val("25").text("25"));
            break;
        case "30":
        case "29.97":
            $("#ipRatio1Select").append($("<option></option>").val("30").text("30"));
            $("#ipRatio1Select").append($("<option></option>").val("15").text("15"));
            $("#ipRatio1Select").append($("<option></option>").val("10").text("10"));
            break;
        case "25":
            $("#ipRatio1Select").append($("<option></option>").val("25").text("25"));
            break;
        default:
    }
}

function updateStream2IpRatioSelect() {
    $("#ipRatio2Select option").remove();
    switch ($("#frameRate2Select").val()) {
        case "60":
        case "59.94":
            $("#ipRatio2Select").append($("<option></option>").val("60").text("60"));
            $("#ipRatio2Select").append($("<option></option>").val("30").text("30"));
            $("#ipRatio2Select").append($("<option></option>").val("15").text("15"));
            $("#ipRatio2Select").append($("<option></option>").val("10").text("10"));
            break;
        case "50":
            $("#ipRatio2Select").append($("<option></option>").val("50").text("50"));
            $("#ipRatio2Select").append($("<option></option>").val("25").text("25"));
            break;
        case "30":
        case "29.97":
            $("#ipRatio2Select").append($("<option></option>").val("30").text("30"));
            $("#ipRatio2Select").append($("<option></option>").val("15").text("15"));
            $("#ipRatio2Select").append($("<option></option>").val("10").text("10"));
            break;
        case "25":
            $("#ipRatio2Select").append($("<option></option>").val("25").text("25"));
            $("#ipRatio2Select").append($("<option></option>").val("13").text("13"));
            $("#ipRatio2Select").append($("<option></option>").val("12").text("12"));
            break;
        default:
    }
}

function updateStream2Select() {
    $("#resolution2Select option").remove();
    if (cameraSettings.OutputSource == "stream") {
        $("#resolution2Select").append($("<option></option>").val("640,360").text("640x360"));
        $("#resolution2Select").prop("disabled", "disabled");
    } else {
        switch (cameraSettings.Resolution) {
            case "2160p_60":
            case "2160p_5994":
            case "2160p_50":
            case "2160p_30":
            case "2160p_2997":
            case "2160p_25":
            case "1080p_60":
            case "1080p_5994":
            case "1080p_50":
            case "1080p_30":
            case "1080p_2997":
            case "1080p_25":
                $("#resolution2Select").append($("<option></option>").val("1920,1080").text("1080P"));
                $("#resolution2Select").append($("<option></option>").val("1280,720").text("720P"));
                break;
            case "720p_60":
            case "720p_5994":
            case "720p_50":
            case "720p_30":
            case "720p_2997":
            case "720p_25":
                $("#resolution2Select").append($("<option></option>").val("1280,720").text("720P"));
                break;
            case "1080i_60":
            case "1080i_5994":
            case "1080i_50":
                $("#resolution2Select").append($("<option></option>").val("1920,1080").text("1080i"));
                break;
            default:
        }
    }
    $("#frameRate2Select option").remove();
    switch (cameraSettings.Resolution) {
        case "2160p_60":
        case "1080p_60":
        case "720p_60":
            $("#frameRate2Select").append($("<option></option>").val("60").text("60"));
            $("#frameRate2Select").append($("<option></option>").val("30").text("30"));
            break;
        case "2160p_5994":
        case "1080p_5994":
        case "720p_5994":
            $("#frameRate2Select").append($("<option></option>").val("59.94").text("59.94"));
            $("#frameRate2Select").append($("<option></option>").val("29.97").text("29.97"));
            break;
        case "2160p_50":
        case "1080p_50":
        case "720p_50":
            $("#frameRate2Select").append($("<option></option>").val("50").text("50"));
            $("#frameRate2Select").append($("<option></option>").val("25").text("25"));
            break;
        case "2160p_30":
        case "1080p_30":
        case "720p_30":
            $("#frameRate2Select").append($("<option></option>").val("30").text("30"));
            break;
        case "2160p_2997":
        case "1080p_2997":
        case "720p_2997":
            $("#frameRate2Select").append($("<option></option>").val("29.97").text("29.97"));
            break;
        case "2160p_25":
        case "1080p_25":
        case "720p_25":
            $("#frameRate2Select").append($("<option></option>").val("25").text("25"));
            break;
        case "1080i_60":
            $("#frameRate2Select").append($("<option></option>").val("60").text("60"));
            break;
        case "1080i_5994":
            $("#frameRate2Select").append($("<option></option>").val("59.94").text("59.94"));
            break;
        case "1080i_50":
            $("#frameRate2Select").append($("<option></option>").val("50").text("50"));
            break;
        default:
    }
}

function updateStream3Select() {
    $("#resolution3Select option").remove();
    $("#resolution3Select").append($("<option></option>").val("640,360").text("640x360"));

    $("#frameRate3Select option").remove();
    $("#frameRate3Select").append($("<option></option>").val(cameraSettings.FrameRate3).text(cameraSettings.FrameRate3));

    $("#ipRatio3Select option").remove();
    switch (cameraSettings.FrameRate3) {
        case "30":
        case "29.97":
            $("#ipRatio3Select").append($("<option></option>").val("30").text("30"));
            $("#ipRatio3Select").append($("<option></option>").val("15").text("15"));
            $("#ipRatio3Select").append($("<option></option>").val("10").text("10"));
            break;
        case "25":
            $("#ipRatio3Select").append($("<option></option>").val("25").text("25"));
            $("#ipRatio3Select").append($("<option></option>").val("13").text("13"));
            $("#ipRatio3Select").append($("<option></option>").val("12").text("12"));
            break;
        default:
    }
}

function checkInterlaceStream2() {
    if (cameraSettings.Resolution.indexOf("1080i") >= 0) {
        document.getElementById("resolution2Select").disabled = true;
        document.getElementById("frameRate2Select").disabled = true;
        document.getElementById("ipRatio2Select").disabled = true;
    } else if (cameraSettings.OutputSource == "stream") {
        document.getElementById("resolution2Select").disabled = true;
        document.getElementById("frameRate2Select").disabled = false;
        document.getElementById("ipRatio2Select").disabled = false;
    } else {
        document.getElementById("resolution2Select").disabled = false;
        document.getElementById("frameRate2Select").disabled = false;
        document.getElementById("ipRatio2Select").disabled = false;
    }
}

function updateStreamRtspValue() {
    $("#authenRtspCheckboxInput").prop("checked", OnOff2BoolMap.get(cameraSettings.AuthenRTSP))
    $("#multicastCheckboxInput").prop("checked", OnOff2BoolMap.get(cameraSettings.Multicast))
    updateStream1Select();
    $("#resolution1Select").val(cameraSettings.ImageSize1);
    $("#frameRate1Select").val(cameraSettings.FrameRate1);
    $("#bitRate1TextInput").val(cameraSettings.BitRate1);
    $("#rateControl1Select").val(cameraSettings.CBR1);
    $("#ipRatio1Select").val(cameraSettings.IFrameRatio1);
    updateStream2Select();
    $("#resolution2Select").val(cameraSettings.ImageSize2);
    $("#frameRate2Select").val(cameraSettings.FrameRate2);
    $("#bitRate2TextInput").val(cameraSettings.BitRate2);
    $("#rateControl2Select").val(cameraSettings.CBR2);
    updateStream2IpRatioSelect();
    $("#ipRatio2Select").val(cameraSettings.IFrameRatio2);
    updateStream3Select();
    $("#resolution3Select").val(cameraSettings.ImageSize3);
    $("#frameRate3Select").val(cameraSettings.FrameRate3);
    $("#bitRate3TextInput").val(cameraSettings.BitRate3);
    $("#rateControl3Select").val(cameraSettings.CBR3);
    $("#ipRatio3Select").val(cameraSettings.IFrameRatio3);
}

function updateStreamMpeg2tsValue() {
    $("#mpeg2tsIpTextInput").val(cameraSettings.MPEG2TSIP);
    $("#mpeg2tsPortTextInput").val(cameraSettings.MPEG2TSPort);
}

function updateStreamSrtValue() {
    $("#connectionModeSelect").val(cameraSettings.SRTConnectMode);
    $("#srtUrlTextInput").val(cameraSettings.SRTUrl);
    $("#srtPortTextInput").val(cameraSettings.SRTPort);
    $("#streamIdTextInput").val(cameraSettings.SRTStreamID);
    $("#latencyTextInput").val(cameraSettings.SRTLatency);
    $("#encryptionSelect").val(cameraSettings.SRTEncryption);
    if (cameraSettings.SRTPassphraseUsed == "1") {
        $("#passphraseInput").val("xxxxxxxxxx");
    } else {
        $("#passphraseInput").val("");
    }
    if (cameraSettings.SRTEnable == "on") {
        $("#srtStatusSpan").text("SRT Enable");
    } else {
        $("#srtStatusSpan").text("SRT Disable");
    }
    updateSRTConnectMode();
    updateSrtEncryption();
}

function showRTMP() {
    document.getElementById("Div_Rtmp").style.display = "block";
    document.getElementById("Div_Rtsp").style.display = "none";
    document.getElementById("Div_Mpegts").style.display = "none";
    document.getElementById("Div_Srt").style.display = "none";
    document.getElementById("Div_Stream1").style.display = "none";
    document.getElementById("Div_Stream2").style.display = "block";
    document.getElementById("Div_Stream3").style.display = "none";
    document.getElementById("streamSource2Radio").style.display = "block";
    document.getElementById("stream2EnableCheckboxInput").style.display = "none";
    $("#streamSource2Radio").prop("checked", true);
    document.getElementById("bitRate2TextInput").disabled = false;
    document.getElementById("rateControl2Select").disabled = false;
    checkInterlaceStream2();
}

function showRTSP() {
    document.getElementById("Div_Rtmp").style.display = "none";
    document.getElementById("Div_Rtsp").style.display = "block";
    document.getElementById("Div_Mpegts").style.display = "none";
    document.getElementById("Div_Srt").style.display = "none";
    document.getElementById("Div_Stream1").style.display = "block";
    document.getElementById("Div_Stream2").style.display = "block";
    document.getElementById("Div_Stream3").style.display = "block";
    document.getElementById("streamSource1Radio").style.display = "none";
    document.getElementById("streamSource2Radio").style.display = "none";
    document.getElementById("stream1EnableCheckboxInput").style.display = "block";
    document.getElementById("stream2EnableCheckboxInput").style.display = "block";
}

function showMPEG2TS() {
    document.getElementById("Div_Rtmp").style.display = "none";
    document.getElementById("Div_Rtsp").style.display = "none";
    document.getElementById("Div_Mpegts").style.display = "block";
    document.getElementById("Div_Srt").style.display = "none";
    document.getElementById("Div_Stream1").style.display = "block";
    document.getElementById("Div_Stream2").style.display = "block";
    document.getElementById("Div_Stream3").style.display = "none";
    document.getElementById("streamSource1Radio").style.display = "block";
    document.getElementById("streamSource2Radio").style.display = "block";
    document.getElementById("stream1EnableCheckboxInput").style.display = "none";
    document.getElementById("stream2EnableCheckboxInput").style.display = "none";
}

function showSRT() {
    document.getElementById("Div_Rtmp").style.display = "none";
    document.getElementById("Div_Rtsp").style.display = "none";
    document.getElementById("Div_Mpegts").style.display = "none";
    document.getElementById("Div_Srt").style.display = "block";
    document.getElementById("Div_Stream1").style.display = "block";
    document.getElementById("Div_Stream2").style.display = "block";
    document.getElementById("Div_Stream3").style.display = "none";
    document.getElementById("streamSource1Radio").style.display = "block";
    document.getElementById("streamSource2Radio").style.display = "block";
    document.getElementById("stream1EnableCheckboxInput").style.display = "none";
    document.getElementById("stream2EnableCheckboxInput").style.display = "none";
}

function updateStreamPageCommonSelect() {
    $("#connectionModeSelect").append($("<option></option>").val("caller").text("Caller"));
    $("#connectionModeSelect").append($("<option></option>").val("listener").text("Listener"));
    $("#encryptionSelect").append($("<option></option>").val("none").text("None"));
    $("#encryptionSelect").append($("<option></option>").val("aes-128").text("AES-128"));
    $("#encryptionSelect").append($("<option></option>").val("aes-256").text("AES-256"));
    $("#rateControl1Select").append($("<option></option>").val("on").text("CBR"));
    $("#rateControl1Select").append($("<option></option>").val("off").text("VBR"));
    $("#rateControl2Select").append($("<option></option>").val("on").text("CBR"));
    $("#rateControl2Select").append($("<option></option>").val("off").text("VBR"));
    $("#rateControl3Select").append($("<option></option>").val("on").text("CBR"));
    $("#rateControl3Select").append($("<option></option>").val("off").text("VBR"));
}

function saveNdiSettings() {
    var cgiParam = {};
    addTime = 0;
    urlToSend = "/command/ndi.cgi?";

    cgiParam.NdiGroupName = $("#groupNameTextInput").val();
    cgiParam.NdiEnable = $("#ndihxEnableSelect").val();
    cgiParam.NdiMulticast = ($("#ndiMulticastCheckboxInput").is(':checked') == true) ? "on" : "off";
    cgiParam.NdiMulticastIp = $("#ndiMulticastIpTextInput").val();
    cgiParam.NdiMulticastNetmask = $("#ndiMulticastNetmaskTextInput").val();
    AddParameter("NdiGroupName", cgiParam.NdiGroupName);
    AddParameter("NdiEnable", cgiParam.NdiEnable);
    AddParameter("NdiMulticast", cgiParam.NdiMulticast);
    if (cgiParam.NdiMulticast == "on") {
        AddParameter("NdiMulticastIp", cgiParam.NdiMulticastIp);
        AddParameter("NdiMulticastNetmask", cgiParam.NdiMulticastNetmask);
    }

    blockUIforPage();
    $.ajax({
        url: urlToSend,
        type: "POST",
        error: function (xhr) {
            UnblockUIforPage();
            console.log("Send NDI Setting Error");
            alert("Fail to set, please try again");
        },
        success: function (response) {
            console.log("NDI settings saved to " + cameraSettings.CameraName);
            reloadNdi();
            UnblockUIforPage();
        }
    });
}

/* ----------------------------------------------------START---------------------------------------------------- */
var gDeviceIndex   = 0;//current focus tab index
var gTableRowIndex = 0;
var gCameraConnCnt = 0;
var gPTZTimerId = 0;
var gVideoOutputStatus = 0;
var gNurevaPort = 8931;
var gSelectMicChannelChange = 0;
var gVideoOutputSwichingMode = 0;//0: SeamlessSwitching 1: No Switching
var gcameraCoordinateAngle = 0;
var gClearFixedCameraIcon = 0;
var gMicDeviceIndex = 4;

const gMicDevice_Index = {
    UnKnow:-1,

    Shure_Start: 0,
    Shure_MXA910:1,
    Shure_MXA920:2,
    Shure_MXA710:3,
    Shure_MXA310:4,
    Shure_MXCW:5,
    Shure_MXA920_XY:6,
    Shure_P300:7,
    Shure_End:20,

    Sennheiser_Start:1000,
    Sennheiser_TCC2:1001,
    Sennheiser_TCCM:1002,
    Sennheiser_TCC2_XY:1003,
    Sennheiser_TCCM_XY:1004,
    Sennheiser_End:1999,

    Nureva_Start:2000,
    Nureva_HDL300:2001,
    Nureva_DUAL_HDL300:2002,
    Nureva_HDL310:2003,
    Nureva_HDL410:2004,
    Nureva_HDL410_XY:2005,
    Nureva_End:2999,

    Yamaha_Start:3000,
    Yamaha_RMCG:3001,
    Yamaha_RMW:3002,
    Yamaha_RMCR:3003,
    Yamaha_RMTT:3004,
    Yamaha_RMCG_XY:3005,
    Yamaha_End:3999,

    AudioTechnica_Start:4000,    //@andrew 2023/08/18
    AudioTechnica_ATND1061:4001,
    AudioTechnica_ATND1061_XY:4002,
    AudioTechnica_ATUC_50CU:4003,
    AudioTechnica_End:4999,

    Televic_Start:5000,
    Televic_D_Cerno_AE:5001,
    Televic_D_Cerno_AE_HTTPS:5002,
    Televic_End:5999,

    LumensVirtualMic_Start:10000,    //@Jeff 2024/07/10
    LumensVirtualMic_Mic1:10001,
    LumensVirtualMic_End:10005,

    MicrophoneDevice_End: 99999,
};

const gMicSelect_Index = { //same gdeviceTypeSelOptions display options
    Shure_MXA910: 0,
    Shure_MXA920: 1,
    Shure_MXA920_XY: 2,
    Shure_MXA710: 3,
    Shure_MXA310: 4,
    Shure_MXCW: 5,
    Shure_P300: 6,
    Sennheiser_TCC2: 7,
    Sennheiser_TCCM: 8,
    Sennheiser_TCC2_XY: 9,
    Sennheiser_TCCM_XY: 10,
    Nureva_HDL300: 11,
    Nureva_DUAL_HDL300: 12,
    Nureva_HDL310: 13,
    Nureva_HDL410: 14,
    Nureva_HDL410_XY: 15,
    Yamaha_RMCG: 16,
    Yamaha_RMCG_XY: 17,
    Yamaha_RMW: 18,
    Yamaha_RMCR: 19,
    Yamaha_RMTT: 20,
    AudioTechnica_ATND1061: 21,
    AudioTechnica_ATND1061_XY: 22,
    AudioTechnica_ATUC_50CU: 23,
    Televic_D_Cerno_AE: 24,
    Televic_D_Cerno_AE_HTTPS: 25,
    LumensVirtualMic_Mic1: 26,
};

var gMicDeviceIndexMapSelectIndex = {
    [gMicDevice_Index.Shure_MXA910] : gMicSelect_Index.Shure_MXA910,
    [gMicDevice_Index.Shure_MXA920 ] :gMicSelect_Index.Shure_MXA920,
    [gMicDevice_Index.Shure_MXA920_XY] :gMicSelect_Index.Shure_MXA920_XY,
    [gMicDevice_Index.Shure_MXA310] : gMicSelect_Index.Shure_MXA310,
    [gMicDevice_Index.Shure_MXA710] : gMicSelect_Index.Shure_MXA710,
    [gMicDevice_Index.Shure_MXCW] : gMicSelect_Index.Shure_MXCW,
    [gMicDevice_Index.Shure_P300] : gMicSelect_Index.Shure_P300,
    [gMicDevice_Index.Sennheiser_TCC2] : gMicSelect_Index.Sennheiser_TCC2,
    [gMicDevice_Index.Sennheiser_TCCM] : gMicSelect_Index.Sennheiser_TCCM,
    [gMicDevice_Index.Sennheiser_TCC2_XY] : gMicSelect_Index.Sennheiser_TCC2_XY,
    [gMicDevice_Index.Sennheiser_TCCM_XY] : gMicSelect_Index.Sennheiser_TCCM_XY,
    [gMicDevice_Index.Nureva_HDL300] : gMicSelect_Index.Nureva_HDL300,
    [gMicDevice_Index.Nureva_DUAL_HDL300] : gMicSelect_Index.Nureva_DUAL_HDL300,
    [gMicDevice_Index.Nureva_HDL310] : gMicSelect_Index.Nureva_HDL310,
    [gMicDevice_Index.Nureva_HDL410] : gMicSelect_Index.Nureva_HDL410,
    [gMicDevice_Index.Nureva_HDL410_XY] : gMicSelect_Index.Nureva_HDL410_XY,
    [gMicDevice_Index.Yamaha_RMCG] : gMicSelect_Index.Yamaha_RMCG,
    [gMicDevice_Index.Yamaha_RMCG_XY] : gMicSelect_Index.Yamaha_RMCG_XY,
    [gMicDevice_Index.Yamaha_RMW] : gMicSelect_Index.Yamaha_RMW,
    [gMicDevice_Index.Yamaha_RMCR] : gMicSelect_Index.Yamaha_RMCR,
    [gMicDevice_Index.Yamaha_RMTT] : gMicSelect_Index.Yamaha_RMTT,
    [gMicDevice_Index.AudioTechnica_ATND1061] : gMicSelect_Index.AudioTechnica_ATND1061,
    [gMicDevice_Index.AudioTechnica_ATND1061_XY] : gMicSelect_Index.AudioTechnica_ATND1061_XY,
    [gMicDevice_Index.AudioTechnica_ATUC_50CU] : gMicSelect_Index.AudioTechnica_ATUC_50CU,
    [gMicDevice_Index.Televic_D_Cerno_AE] : gMicSelect_Index.Televic_D_Cerno_AE,
    [gMicDevice_Index.Televic_D_Cerno_AE_HTTPS] : gMicSelect_Index.Televic_D_Cerno_AE_HTTPS,
    [gMicDevice_Index.LumensVirtualMic_Mic1] : gMicSelect_Index.LumensVirtualMic_Mic1,
};

function getMicDeviceIndexBySelectIndex(micSelectIndex) {

    for(var key in gMicDeviceIndexMapSelectIndex)
    {
        if(gMicDeviceIndexMapSelectIndex.hasOwnProperty(key))
        {
            if(micSelectIndex == gMicDeviceIndexMapSelectIndex[key])
            {
                return parseInt(key,10);
            }
                
        }
    }
    return gMicDevice_Index.UnKnow;
}

function getMicSelectIndexByDeviceIndex(micDeviceIndex) {

    if(gMicDeviceIndexMapSelectIndex.hasOwnProperty(micDeviceIndex))
    {
        return parseInt(gMicDeviceIndexMapSelectIndex[micDeviceIndex],10);
    }
    else
        return gMicSelect_Index.Shure_MXA310;
}

const gdeviceTypeSelOptions = [
    "Shure:MXA910",                         //0
    "Shure:MXA920",                         //1
    "Shure:MXA920(Coordinate)",             //2
    "Shure:MXA710",                         //3
    "Shure:MXA310",                         //4
    "Shure:MXCW",                           //5
    "Shure:P300",                           //6
    "Sennheiser:TCC2",                      //7
    "Sennheiser:TCCM",                      //7
    "Sennheiser:TCC2(Coordinate)",          //8
    "Sennheiser:TCCM(Coordinate)",          //9
    "Nureva:HDL300",                        //8
    "Nureva:Dual HDL300",                   //9
    "Nureva:HDL310",                        //10
    "Nureva:HDL410",                        //11
    "Nureva:HDL410(Coordinate)",            //12
    "Yamaha:RM-CG",                         //13    
    "Yamaha:RM-CG(Coordinate)",             //14
    "Yamaha:RM-W",                          //15
    "Yamaha:RM-CR",                         //16
    "Yamaha:RM-TT",                         //17   
    "Audio-Technica:ATND1061",              //18
    "Audio-Technica:ATND1061(Coordinate)",  //19
    "Audio-Technica:ATUC-50CU",  //19
    "Televic:D-Cerno AE",
    "Televic:D-Cerno AE(HTTPS)",
    "Lumens:Virtual Mic"                    //20
];

const deviceTypeMap = {
    "Shure:MXA910": gMicSelect_Index.Shure_MXA910,
    "Shure:MXA920": gMicSelect_Index.Shure_MXA920,
    "Shure:MXA920(Coordinate)": gMicSelect_Index.Shure_MXA920_XY,
    "Shure:MXA310": gMicSelect_Index.Shure_MXA310,
    "Shure:MXA710": gMicSelect_Index.Shure_MXA710,
    "Shure:MXCW": gMicSelect_Index.Shure_MXCW,
    "Shure:P300": gMicSelect_Index.Shure_P300,
    "Sennheiser:TCC2": gMicSelect_Index.Sennheiser_TCC2,
    "Sennheiser:TCCM": gMicSelect_Index.Sennheiser_TCCM,
    "Sennheiser:TCC2(Coordinate)": gMicSelect_Index.Sennheiser_TCC2_XY,
    "Sennheiser:TCCM(Coordinate)": gMicSelect_Index.Sennheiser_TCCM_XY,
    "Nureva:HDL300": gMicSelect_Index.Nureva_HDL300,
    "Nureva:Dual HDL300": gMicSelect_Index.Nureva_DUAL_HDL300,
    "Nureva:HDL310": gMicSelect_Index.Nureva_HDL310,
    "Nureva:HDL410": gMicSelect_Index.Nureva_HDL410,
    "Nureva:HDL410(Coordinate)": gMicSelect_Index.Nureva_HDL410_XY,
    "Yamaha:RM-CG": gMicSelect_Index.Yamaha_RMCG,
    "Yamaha:RM-CG(Coordinate)": gMicSelect_Index.Yamaha_RMCG_XY,
    "Yamaha:RM-W": gMicSelect_Index.Yamaha_RMW,
    "Yamaha:RM-CR": gMicSelect_Index.Yamaha_RMCR,
    "Yamaha:RM-TT": gMicSelect_Index.Yamaha_RMTT,
    "Audio-Technica:ATND1061": gMicSelect_Index.AudioTechnica_ATND1061,
    "Audio-Technica:ATND1061(Coordinate)": gMicSelect_Index.AudioTechnica_ATND1061_XY,
    "Audio-Technica:ATUC-50CU": gMicSelect_Index.AudioTechnica_ATUC_50CU,
    "Televic:D-Cerno AE": gMicSelect_Index.Televic_D_Cerno_AE,
    "Televic:D-Cerno AE(HTTPS)": gMicSelect_Index.Televic_D_Cerno_AE_HTTPS,
    "Lumens:Virtual Mic": gMicSelect_Index.LumensVirtualMic_Mic1,
};

const OpenAudioTriggerLevelSoundDevice = [
    gMicSelect_Index.Sennheiser_TCC2,
    gMicSelect_Index.Sennheiser_TCCM,
    gMicSelect_Index.Sennheiser_TCC2_XY,
    gMicSelect_Index.Sennheiser_TCCM_XY,
    gMicSelect_Index.Nureva_HDL300,
    gMicSelect_Index.Nureva_DUAL_HDL300,
    gMicSelect_Index.Nureva_HDL310,
    gMicSelect_Index.Nureva_HDL410,
    gMicSelect_Index.Nureva_HDL410_XY,
    gMicSelect_Index.Yamaha_RMCG,
    gMicSelect_Index.Yamaha_RMCG_XY,
    gMicSelect_Index.Yamaha_RMW,
    gMicSelect_Index.Yamaha_RMCR,
    gMicSelect_Index.Yamaha_RMTT,
    gMicSelect_Index.AudioTechnica_ATND1061,
    gMicSelect_Index.AudioTechnica_ATND1061_XY,
    gMicSelect_Index.AudioTechnica_ATUC_50CU,
    gMicSelect_Index.Televic_D_Cerno_AE,
    gMicSelect_Index.Televic_D_Cerno_AE_HTTPS,
];
var gMicInfoDivMap = {
    [gMicSelect_Index.Shure_MXA910]:              "micInfo_div1",
    [gMicSelect_Index.Shure_MXA920]:              "micInfo_div1",
    [gMicSelect_Index.Shure_MXA920_XY]:           "micInfo_div15",
    [gMicSelect_Index.Shure_MXA710]:              "micInfo_div1",
    [gMicSelect_Index.Shure_MXA310]:              "micInfo_div2",
    [gMicSelect_Index.Shure_MXCW]:                "micInfo_div3",
    [gMicSelect_Index.Shure_P300]:                "micInfo_div16",
    [gMicSelect_Index.Sennheiser_TCC2]:           "micInfo_div4",
    [gMicSelect_Index.Sennheiser_TCCM]:           "micInfo_div4",
    [gMicSelect_Index.Sennheiser_TCC2_XY]:        "micInfo_div14",
    [gMicSelect_Index.Sennheiser_TCCM_XY]:        "micInfo_div14",
    [gMicSelect_Index.Nureva_HDL300]:             "micInfo_div5",
    [gMicSelect_Index.Nureva_DUAL_HDL300]:        "micInfo_div5",
    [gMicSelect_Index.Nureva_HDL310]:             "micInfo_div5",
    [gMicSelect_Index.Nureva_HDL410]:             "micInfo_div5",
    [gMicSelect_Index.Yamaha_RMCG]:               "micInfo_div6",
    [gMicSelect_Index.Yamaha_RMW]:                "micInfo_div7",
    [gMicSelect_Index.AudioTechnica_ATND1061]:    "micInfo_div8",
    [gMicSelect_Index.AudioTechnica_ATND1061_XY]: "micInfo_div13",
    [gMicSelect_Index.AudioTechnica_ATUC_50CU]:   "micInfo_div18",
    [gMicSelect_Index.Nureva_HDL410_XY]:          "micInfo_div9",
    [gMicSelect_Index.Yamaha_RMCR]:               "micInfo_div10",
    [gMicSelect_Index.Yamaha_RMTT]:               "micInfo_div11",
    [gMicSelect_Index.Yamaha_RMCG_XY]:            "micInfo_div12",
    [gMicSelect_Index.Televic_D_Cerno_AE]:        "micInfo_div17",
    [gMicSelect_Index.Televic_D_Cerno_AE_HTTPS]:  "micInfo_div17",
    [gMicSelect_Index.LumensVirtualMic_Mic1]:     "micInfo_div1"
};

const deviceMappings = {
    'Lumens:Virtual Mic':1,
    'Shure:MXA910': 1, 
    'Shure:MXA920': 1,
    'Shure:MXA710': 1, 
    'Shure:MXA310': 2, 
    'Shure:MXCW': 3, 
    'Sennheiser:TCC2': 4,
    'Sennheiser:TCCM': 4,
    'Nureva:HDL300': 5, 
    'Nureva:Dual HDL300': 5, 
    'Nureva:HDL310': 5, 
    'Nureva:HDL410': 5, 
    'Yamaha:RM-CG': 6, 
    'Yamaha:RM-W': 7, 
    'Audio-Technica:ATND1061': 8,
    'Nureva:HDL410(Coordinate)': 9,
    'Yamaha:RM-CR': 10,
    'Yamaha:RM-TT': 11,
    'Yamaha:RM-CG(Coordinate)': 12,
    'Audio-Technica:ATND1061(Coordinate)': 13,
    'Sennheiser:TCC2(Coordinate)': 14 ,
    'Sennheiser:TCCM(Coordinate)': 14 , 
    'Shure:MXA920(Coordinate)': 15, 
    'Shure:P300': 16,
    'Televic:D-Cerno AE': 17,
    'Televic:D-Cerno AE(HTTPS)': 17,
    'Audio-Technica:ATUC-50CU': 18,
};

var gSelectModelPresetOptions = [
    [
        "0.1 Sec",
        "0.3 Sec",
        "0.5 Sec",
        "1 Sec",
        "1.5 Sec",
        "2 Sec",
        "3 Sec",
        "4 Sec",
        "5 Sec",
    ],
    [
        "0.1 秒",
        "0.3 秒",
        "0.5 秒",
        "1 秒",
        "1.5 秒",
        "2 秒",
        "3 秒",
        "4 秒",
        "5 秒",
    ],
    [
        "0.1 秒",
        "0.3 秒",
        "0.5 秒",
        "1 秒",
        "1.5 秒",
        "2 秒",
        "3 秒",
        "4 秒",
        "5 秒",
    ],

];

var gSelectModelHomeTimesOptions = [
    [
        "Off",
        "10 Sec",
        "20 Sec",
        "30 Sec",
        "40 Sec",
        "50 Sec",
        "1 Min",
        "2 Min",
        "3 Min"
    ],
    [
        "關閉",
        "10 秒",
        "20 秒",
        "30 秒",
        "40 秒",
        "50 秒",
        "1 分鐘",
        "2 分鐘",
        "3 分鐘"
    ],
    [
        "关闭",
        "10 秒",
        "20 秒",
        "30 秒",
        "40 秒",
        "50 秒",
        "1 分钟",
        "2 分钟",
        "3 分钟"
    ],
];

const XYModeSelectCameraDirection_t = 
{ 
    Forward: 0, 
    Backward: 1, 
    Left: 3, 
    Right: 4
};

const gMaxMappingGroupIndex = Math.max(...Object.values(deviceMappings));

const indexToDeviceTypeMap = Object.entries(deviceTypeMap).reduce((acc, [key, value]) => {
    acc[value] = key;
    return acc;
}, {});

const gmaxZones = 8;
const gminRectSize = 50;
var gisRectDrawing = false;
var gselectedRect = null;
var ginitialRectPosition = null;
var gcurrentRect = null;
var gstartX, gstartY;
var grectangles = [];
var contextMenu = null;

function onCameraMappingApply(e){
    onChangecameraMappingPresetStatus('true');
    var micTabPage = gDeviceIndex;
    var currentSoundType = document.getElementById("deviceTypeSel_" + micTabPage).value;
    var micSelect = parseInt(currentSoundType);
    var micGroup = getDeviceCameraMappingIndex();

    if(!document.getElementById("selectMicChannel_" + micGroup))
        return;

    var selectChannel = document.getElementById("selectMicChannel_" + micGroup).value;
    var micSelectChannel = parseInt(selectChannel);

    var presetLinkMap = {
        MapArray: [],
    };

    var azimuthRange = {
        RangeArray: [],
    };

    for (var arrayIndex = 0; arrayIndex < micSelectChannel; arrayIndex++) {
        var cameraMappingSelectItem = $("#cameraMappingSeleceItem_div_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" + arrayIndex);
        var cameraMappingSecondSelectItem = $("#cameraMappingSecondSeleceItem_div_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" + arrayIndex);
        var presetValue = parseInt($("#cameraMappingPreset_div_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" + arrayIndex).val(), 10);
        var AIPeopleTrackingModeValue = parseInt($("#cameraMappingAIPeopleTrackingModeSeleceItem_div_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" + arrayIndex).val(), 10);
        var XYinputcheckboxValue = $("#cameraMappingXYinputcheckbox_div_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" + arrayIndex).prop('checked');
        var mapping = {
            PosIndex: arrayIndex,
            Camera: cameraMappingSelectItem.val(),
            SecondCamera:cameraMappingSecondSelectItem.val(),
            Preset: presetValue,
            AIPeopleTrackingMode: AIPeopleTrackingModeValue,
            XyMode:XYinputcheckboxValue,
        };

        presetLinkMap.MapArray.push(mapping);

        var azimuthFrom = parseInt($("#cameraMappingAzimuth_div_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" + (arrayIndex + 1) + "_1").val(), 10);
        var azimuthTo = parseInt($("#cameraMappingAzimuth_div_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" + (arrayIndex + 1) + "_2").val(), 10);

        var azimuthRangeItem = {
            RangeIndex: arrayIndex,
            From: azimuthFrom,
            To: azimuthTo,
        };

        azimuthRange.RangeArray.push(azimuthRangeItem);
    }

    var obj1 = {
        Command: "SetSoundCamMap",
        SoundTabIndex: gDeviceIndex,
        SoundCamMap: {
            PresetShowNum: micSelectChannel,
            PresetLinkMap: presetLinkMap,
            AzimuthRange: azimuthRange,
        },
    };
    sendMessage("SetSoundCamMap", obj1);
    blockUIforPage();
    let intervalId = setInterval(function() {
        UnblockUIforPage();
        sendMessage("GetMicEnableHandFree",gDeviceIndex);
        sendMessage("GetSoundCamMap", gDeviceIndex);
        sendMessage("GetMicEnableHandFree",gDeviceIndex);
        clearInterval(intervalId);
    }, 1000);
    // blockUIforPage();
    // let intervalId = setInterval(function() {
    //     UnblockUIforPage();
    //     sendMessage("GetSoundCamMap", gDeviceIndex);
    //     clearInterval(intervalId);
    // }, 500);

    e.disabled = true;

    if(gSelectMicChannelChange == 1)
        gSelectMicChannelChange = 0;

}

var gSoundConnectReceived = false;
var gSoundRetryCount = false;
var gSoundRetryLimit = false;
var gSoundRetryTimer;

function changeConnectStatus(e){
    var deviceIndex = gDeviceIndex;
    var connectCheckbox = document.getElementById("connectCheckboxInput_" + deviceIndex);
    var deviceIPInput = document.getElementById("DeviceIPInput_" + deviceIndex);
    var deviceTypeSelect = document.getElementById("deviceTypeSel_" + deviceIndex);

    let devicesel = document.getElementById("deviceTypeSel_"+gDeviceIndex);
    let deviceType = transferDeviceTypeToString(devicesel.value); 

    if(deviceType == 'Lumens:Virtual Mic')
    {
        document.getElementById("DevicePortInput_" + gDeviceIndex).disabled = true; 

        document.getElementById("PasswordInput_" + deviceIndex).disabled = true;
        document.getElementById("InputModelAudioTrigger_" + deviceIndex).disabled = true;
        document.getElementById("SelectModelPreset_" + deviceIndex).disabled = true;
        if(!gIsUseGlobalBackToHomeControl)
        {
            document.getElementById("SelectModelHomeTimes_" + deviceIndex).disabled = true;
            document.getElementById("SelectModelHomeCamera_" + deviceIndex).disabled = true;
            document.getElementById("SelectModelHomePosition_" + deviceIndex).disabled = true;        
            document.getElementById("InputModelHomePosition_" + deviceIndex).disabled = true;
        }
        else
        {
            var backHomeSetting   = document.getElementById("BtnModelBackToHomeSetting_" +deviceIndex);
            if(backHomeSetting)
            {
                backHomeSetting.disabled = true;
            }
        }
        
        document.getElementById("BtnModelCancel_" + deviceIndex).disabled = true;
        document.getElementById("BtnModelApply_" + deviceIndex).disabled = true;
        if(document.getElementById("img_DeviceStatus_"+gDeviceIndex))
        {
            document.getElementById("img_DeviceStatus_"+gDeviceIndex).style.visibility = "hidden";
        }
    
        return;
    }
    
    if(e.checked)
    {

        if(document.getElementById("DeviceIPInput_"+gDeviceIndex).value != "")
        {
            soundSettingMap[gDeviceIndex] = true;
            sendMessage("SoundConnect",gDeviceIndex);
            blockUIforPage();
            if(document.getElementById("img_DeviceStatus_"+gDeviceIndex))
            {
                document.getElementById("img_DeviceStatus_"+gDeviceIndex).style.visibility = "visible";
                document.getElementById("img_DeviceStatus_"+gDeviceIndex).src = "./images/MicDisconnect.png";
            }

            gSoundRetryTimer = setTimeout(function checkMessage() 
            {
                sendMessage("SoundConnect",gDeviceIndex);
                if (!gSoundConnectReceived) 
                {
                    //if (gSoundRetryCount < gSoundRetryLimit) 
                    {
                        sendMessage("SoundConnect", gDeviceIndex);
                        gSoundRetryTimer = setTimeout(checkMessage(),1500);
                        
                        gSoundRetryCount++;
                    }
                    /*else 
                    {
                        gSoundConnectReceived = true;
                        gSoundRetryCount = 0;
                        document.getElementById("connectCheckboxInput_"+gDeviceIndex).checked = false;
                        clearTimeout(gSoundRetryTimer);
                        sendMessage("SoundDisconnect",gDeviceIndex);
                        UnblockUIforPage();
                        alert('Microphone cannot be found, please check Microphone connection status and try to connect it again.');
                    }*/
                } 
                /*else 
                {
                    gSoundConnectReceived = true;
                    gSoundRetryCount = 0;
                    document.getElementById("connectCheckboxInput_"+gDeviceIndex).checked = false;
                    clearTimeout(gSoundRetryTimer);
                    UnblockUIforPage();
                    alert('Microphone cannot be found, please check Microphone connection status and try to connect it again.');
                }*/
            }, 8500);
        }
        else
        {
            e.checked = false;
            soundSettingMap[gDeviceIndex] = false;
            if(document.getElementById("img_DeviceStatus_"+gDeviceIndex))
            {
                document.getElementById("img_DeviceStatus_"+gDeviceIndex).style.visibility = "hidden";
                document.getElementById("img_DeviceStatus_"+gDeviceIndex).src = "./images/MicDisconnect.png";
            }
        
        }
    }
    else{
        soundSettingMap[gDeviceIndex] = false;
        clearTimeout(gSoundRetryTimer);
        sendMessage("SoundDisconnect",gDeviceIndex);
        connectCheckbox.disabled = false;
        deviceTypeSelect.disabled = false;
        deviceIPInput.disabled = false;

        gSoundRetryCount = 0;

        console.log('changeConnectStatus--->',deviceType);
        if(deviceType == 'Nureva:HDL300' || deviceType == 'Nureva:Dual HDL300' || deviceType == 'Nureva:HDL310' 
        || deviceType == 'Nureva:HDL410' || deviceType == 'Nureva:HDL410(Coordinate)'
        || deviceType == 'Audio-Technica:ATND1061' || deviceType == 'Audio-Technica:ATND1061(Coordinate)' || deviceType == 'Audio-Technica:ATUC-50CU')
        {
            
            document.getElementById("DevicePortInput_" + gDeviceIndex).disabled = false;
        }
        else
            document.getElementById("DevicePortInput_" + gDeviceIndex).disabled = true; 

        document.getElementById("DeviceAPIKeyInput_" + gDeviceIndex).disabled = false; 
        document.getElementById("PasswordInput_" + deviceIndex).disabled = false;
        document.getElementById("InputModelAudioTrigger_" + deviceIndex).disabled = false;
        document.getElementById("SelectModelPreset_" + deviceIndex).disabled = false;

        setDeviceCertificateDisabled(deviceIndex,false);

        if(!gIsUseGlobalBackToHomeControl)
        {
            document.getElementById("SelectModelHomeTimes_" + deviceIndex).disabled = false;
            document.getElementById("SelectModelHomeCamera_" + deviceIndex).disabled = false;
            document.getElementById("SelectModelHomePosition_" + deviceIndex).disabled = false;
            if(document.getElementById("SelectModelHomePosition_" + deviceIndex).value == 1)
            {
                document.getElementById("InputModelHomePosition_" + deviceIndex).disabled = false;
            }
        }
        else
        {
            var backHomeSetting   = document.getElementById("BtnModelBackToHomeSetting_" +deviceIndex);
            if(backHomeSetting)
            {
                backHomeSetting.disabled = false;
            }
        }
        
        document.getElementById("BtnModelCancel_" + deviceIndex).disabled = true;
        document.getElementById("BtnModelApply_" + deviceIndex).disabled = true;

        if(document.getElementById("img_DeviceStatus_"+gDeviceIndex))
        {
            document.getElementById("img_DeviceStatus_"+gDeviceIndex).style.visibility = "hidden";
            document.getElementById("img_DeviceStatus_"+gDeviceIndex).src = "./images/MicDisconnect.png";
        }
    
    }
    // onAdvanceApplyClick();

}

function changeExclusionModeStatus(e){

    var deviceIndex=gDeviceIndex;
    var ExclusionModeconnectCheckbox=document.getElementById("ExclusionMode_connectCheckboxInput_"+deviceIndex);
    
    if(e.checked){
        var jsonmsg = {};
        jsonmsg.Command = "SetYamahaExclusionMode";
        jsonmsg.SoundTabIndex = gDeviceIndex;
        jsonmsg.Status = true;
        sendMessage("SetYamahaExclusionMode",jsonmsg);
    }
    else{
        var jsonmsg = {};
        jsonmsg.Command = "SetYamahaExclusionMode";
        jsonmsg.SoundTabIndex = gDeviceIndex;
        jsonmsg.Status = false;
        sendMessage("SetYamahaExclusionMode",jsonmsg);
        ExclusionModeconnectCheckbox.disabled=false;
    }
}

function changeZoneModeStatus(e){
    var micGroup = getDeviceCameraMappingIndex();  
    var zoneSetting = document.getElementById("zoneModeSetting_" + micGroup);
    let devicesel = document.getElementById("deviceTypeSel_"+gDeviceIndex);
    let deviceTypeString = transferDeviceTypeToString(devicesel.value); 
    var deviceMappingIndex = getDeviceCameraMappingIndex();

    if(deviceTypeString == "Audio-Technica:ATND1061(Coordinate)")
    {
        
    }
    else
    {
        console.log('changeZoneModeStatus e.checked--->',e.checked);
        if(!e.checked)  
        {
            zoneSetting.disabled = true;

            console.log('Run changeZoneModeStatus()');
            

            const selectMicChannel = document.getElementById("selectMicChannel_"+deviceMappingIndex);
            selectMicChannel.innerHTML = '';

            const Option1 = document.createElement("option");
            Option1.text = "8";
            Option1.value = 8;

            const Option2 = document.createElement("option");
            Option2.text = "16";
            Option2.value = 16;

            const Option3 = document.createElement("option");
            Option3.text = "32";
            Option3.value = 32;
            
            const Option4 = document.createElement("option");
            Option4.text = "64";
            Option4.value = 64;
            
            if(deviceTypeString === 'Sennheiser:TCC2(Coordinate)'
            || deviceTypeString === 'Sennheiser:TCCM(Coordinate)')
            {
                console.log('Run changeZoneModeStatus() Sennheiser:TCC2(Coordinate) createCameraMappingAzimuthDiv(12,128);');
                createCameraMappingAzimuthDiv(12,128);
                selectMicChannel.appendChild(Option4);
                document.getElementById("selectMicChannel_"+deviceMappingIndex).value = 128;
                document.getElementById("selectMicChannel_"+deviceMappingIndex).disabled = false; 
            }
            else
            {
                createCameraMappingAzimuthDiv(12,128);
                selectMicChannel.appendChild(Option1);
                document.getElementById("selectMicChannel_"+deviceMappingIndex).value = 128;
                document.getElementById("selectMicChannel_"+deviceMappingIndex).disabled = true; 
            }
        }
        else
        {
            micGroup = getDeviceCameraMappingIndex();
            createCameraMappingArrayDiv(micGroup,128);

            console.log('Run changeZoneModeStatus() micGroup('+micGroup+',128)');

            const selectMicChannel = document.getElementById("selectMicChannel_"+deviceMappingIndex);
            selectMicChannel.innerHTML = '';

            const Option1 = document.createElement("option");
            Option1.text = "128";
            Option1.value = "128";
            selectMicChannel.appendChild(Option1);

            document.getElementById("selectMicChannel_"+deviceMappingIndex).value = 128;
            document.getElementById("selectMicChannel_"+deviceMappingIndex).disabled = true;
        }
    }

    sendMessage("GetMicEnableHandFree",gDeviceIndex);     
    sendMessage("GetSoundCamMap",gDeviceIndex);
    sendMessage("GetZoneMapDetection",gDeviceIndex);
    sendMessage("GetMicEnableHandFree",gDeviceIndex);
    
    var jsonmsg = {};
    jsonmsg.Command = "SetZoneModeConfig";
    jsonmsg.SoundTabIndex = gDeviceIndex;
    jsonmsg.ZoneModeEnable = (e.checked);
    
    if(deviceTypeString == "Audio-Technica:ATND1061(Coordinate)")
    {
        
    }
    else
    {
        setTimeout(() => {
            sendMessage("SetZoneModeConfig", jsonmsg);
            blockUIforPage();
        }, 500);
    }
}

function changeHandFreeModeStatus(e)
{
    var deviceIndex = gDeviceIndex;
    var micGroup = getDeviceCameraMappingIndex();   
    var HandFreeCheckbox=document.getElementById("HandFreeMode_connectCheckboxInput_"+gDeviceIndex);
    var isChecked = e.checked;

    if(!document.getElementById("selectMicChannel_" + micGroup))
        return;

    var jsonmsg = {};
    jsonmsg.Command = "SetMicEnableHandFree";
    jsonmsg.SoundTabIndex = deviceIndex;
    jsonmsg.IsEnable = isChecked;
    sendMessage("SetMicEnableHandFree",jsonmsg);

    //onChangeCameraItem();

    var currentSoundType = document.getElementById("deviceTypeSel_" + deviceIndex).value;
    var micSelect = parseInt(currentSoundType);
    var selectChannel = document.getElementById("selectMicChannel_" + micGroup).value;
    var micSelectChannel = parseInt(selectChannel);
    let deviceTypeString = transferDeviceTypeToString(currentSoundType); 

    for (var arrayIndex = 0; arrayIndex < micSelectChannel; arrayIndex++) 
    {
        //XY
        if(isChecked)
        {
            if(document.getElementById("cameraMappingXYinputcheckbox_div_" + deviceIndex + "_" + micSelect + "_" + micGroup + "_" + arrayIndex))
                document.getElementById("cameraMappingXYinputcheckbox_div_" + deviceIndex + "_" + micSelect + "_" + micGroup + "_" + arrayIndex).disabled = true;
        }
        else
        {
            if(document.getElementById("cameraMappingXYinputcheckbox_div_" + deviceIndex + "_" + micSelect + "_" + micGroup + "_" + arrayIndex))
                document.getElementById("cameraMappingXYinputcheckbox_div_" + deviceIndex + "_" + micSelect + "_" + micGroup + "_" + arrayIndex).disabled = false;
        }

        //Secondary
        if(gVideoOutputSwichingMode== 0) //Seamless
        {
            var XYinputcheckboxValue = $("#cameraMappingXYinputcheckbox_div_" + deviceIndex + "_" + micSelect + "_" + micGroup + "_" + arrayIndex).prop('checked');
            
            if(deviceTypeString.includes("Coordinate"))
            {
                if(XYinputcheckboxValue)
                {
                    document.getElementById("cameraMappingSecondSeleceItem_div_" + deviceIndex + "_" + micSelect + "_" + micGroup + "_" + arrayIndex).disabled = true;
                }
                else
                {
                    if(isChecked)
                        document.getElementById("cameraMappingSecondSeleceItem_div_" + deviceIndex + "_" + micSelect + "_" + micGroup + "_" + arrayIndex).disabled = true;
                    else
                        document.getElementById("cameraMappingSecondSeleceItem_div_" + deviceIndex + "_" + micSelect + "_" + micGroup + "_" + arrayIndex).disabled = false;
                }

            }
            else
            {
                if(isChecked)
                    document.getElementById("cameraMappingSecondSeleceItem_div_" + deviceIndex + "_" + micSelect + "_" + micGroup + "_" + arrayIndex).disabled = true;
                else
                    document.getElementById("cameraMappingSecondSeleceItem_div_" + deviceIndex + "_" + micSelect + "_" + micGroup + "_" + arrayIndex).disabled = false;
            }
        }
        else
        {
            document.getElementById("cameraMappingSecondSeleceItem_div_" + deviceIndex + "_" + micSelect + "_" + micGroup + "_" + arrayIndex).disabled = true;
        }        

    }

}

function changeCameraInformationStatus(e){
    var cameraIP = document.getElementById('CameraInformation_Camera_select_' + gDeviceIndex).value;
    var deviceType = document.getElementById('deviceTypeSel_' + gDeviceIndex).value;
    let deviceTypeString = transferDeviceTypeToString(deviceType); 
    if(e.checked){
        
        const cameraIPIndex = parseInt(cameraIP,10);
        if(cameraIPIndex != -1)
        {
            let jsonmsg = {};
            jsonmsg.SoundTabIndex = gDeviceIndex;
            jsonmsg.Command = "SetZoneMapDetection";
            jsonmsg.ZoneMap = {};
            jsonmsg.ZoneMap.CameraInfoOnOff = true;
            jsonmsg.ZoneMap.CameraIP = cameraIP;
            sendMessage("SetZoneMapDetection",jsonmsg);

            if(deviceTypeString !== 'Nureva:HDL410(Coordinate)')
            {
                canvasupdatecameraXY();
                updateCameraDirectionArrowHead(); 
            }
            if(deviceTypeString !== 'Nureva:HDL410(Coordinate)')
            {
                canvasupdatemicXY();
            }
        }
    }
    else{
        var canvas = document.getElementById('xy-canvas_camera_' + gDeviceIndex);
        if (canvas) {
            var ctx = canvas.getContext('2d');
            ctx.clearRect(0, 0, canvas.width, canvas.height);
        }
        var miccanvas = document.getElementById('xy-canvas_microphone_' + gDeviceIndex);
        if (miccanvas) {
            var ctx = miccanvas.getContext('2d');
            ctx.clearRect(0, 0, miccanvas.width, miccanvas.height);
        }
        var arrowheadcanvas = document.getElementById('xy-canvas_arrowheadpos_' + gDeviceIndex);
        if (arrowheadcanvas) {
            var ctx = arrowheadcanvas.getContext('2d');
            ctx.clearRect(0, 0, arrowheadcanvas.width, arrowheadcanvas.height);
        }
    
        let jsonmsg = {};
	    jsonmsg.SoundTabIndex = gDeviceIndex;
    	jsonmsg.Command = "SetZoneMapDetection";
    	jsonmsg.ZoneMap = {};
        jsonmsg.ZoneMap.CameraInfoOnOff = false;
    	jsonmsg.ZoneMap.CameraIP = cameraIP;
        sendMessage("SetZoneMapDetection",jsonmsg);
    }
}


function updateCameraInformationLocationX(e) {
    var CheckboxInput = document.getElementById('CameraInformation_connectCheckboxInput_' + gDeviceIndex);
    if (CheckboxInput.checked) {
        canvasupdatecameraXY();
        var deviceType = document.getElementById('deviceTypeSel_' + gDeviceIndex).value;
        let deviceTypeString = transferDeviceTypeToString(deviceType);         
        if(deviceTypeString !== 'Nureva:HDL410(Coordinate)')
        {
            canvasupdatemicXY();
        }
        updateCameraInfoCameraApply();
    }
}

function updateCameraInformationLocationY(e) {
    var CheckboxInput = document.getElementById('CameraInformation_connectCheckboxInput_' + gDeviceIndex);
    if (CheckboxInput.checked) {
        canvasupdatecameraXY();
        var deviceType = document.getElementById('deviceTypeSel_' + gDeviceIndex).value;        
        let deviceTypeString = transferDeviceTypeToString(deviceType);         
        if(deviceTypeString !== 'Nureva:HDL410(Coordinate)')
        {
            canvasupdatemicXY();
        }
        updateCameraInfoCameraApply();
    }
}

function canvasupdatemicXY(){

    var miccanvas = document.getElementById('xy-canvas_microphone_' + gDeviceIndex);
    var pointx = document.getElementById('CameraInformation_LocationXY_xvalue_input_' + gDeviceIndex);
    var pointy = document.getElementById('CameraInformation_LocationXY_yvalue_input_' + gDeviceIndex);

    if (miccanvas) {
        const rect = miccanvas.getBoundingClientRect();
        if (miccanvas.width !== rect.width || miccanvas.height !== rect.height) {
            miccanvas.width = rect.width;
            miccanvas.height = rect.height;
        }
        var ctx = miccanvas.getContext('2d');
        ctx.clearRect(0, 0, miccanvas.width, miccanvas.height);

        var x_scale = gZoneMaproomSizeH / miccanvas.width;
        var y_scale = gZoneMaproomSizeV / miccanvas.height;
        if (x_scale < 1) x_scale = 1;
        if (y_scale < 1) y_scale = 1;
    
        // var canvasPosX = (parseInt(pointx.value,10) + gZoneMapprimebarX) / x_scale;
        // var canvasPosY = (gZoneMaproomSizeV - parseInt(pointy.value,10)) / y_scale;

        //------rect mode-----
        // const gridSize = 600;
        // //console.log('gridSize------>',gridSize);
        // const step = gridSize / Math.max(x_scale, y_scale);
        // ctx.strokeStyle = '#888';
        // ctx.lineWidth = 1;
        // for (let x = 0; x <= miccanvas.width; x += step) {
        //     ctx.beginPath();
        //     ctx.moveTo(x, 0);
        //     ctx.lineTo(x, miccanvas.height);
        //     ctx.stroke();
        // }
        // for (let y = 0; y <= miccanvas.height; y += step) {
        //     ctx.beginPath();
        //     ctx.moveTo(0, y);
        //     ctx.lineTo(miccanvas.width, y);
        //     ctx.stroke();
        // }
        // //------rect mode-----

        const squareX = (4000) / x_scale;
        const squareY = (4000) / y_scale;
        // const squareX = canvasPosX ;
        // const squareY = canvasPosY ;

        const baseCenter = { x: squareX, y: squareY };
    
        const squareSize = 60;
        const halfSize = squareSize / 2;
        ctx.fillStyle = 'white';
        ctx.strokeStyle = 'white';
        ctx.lineWidth = 2;
        ctx.beginPath();
        ctx.moveTo(baseCenter.x - halfSize, baseCenter.y - halfSize);
        ctx.lineTo(baseCenter.x + halfSize, baseCenter.y - halfSize);
        ctx.lineTo(baseCenter.x + halfSize, baseCenter.y + halfSize);
        ctx.lineTo(baseCenter.x - halfSize, baseCenter.y + halfSize);
        ctx.closePath();
        ctx.fill();
        ctx.stroke();
    
        ctx.fillStyle = 'black';
        ctx.font = '16px Arial';
        ctx.textAlign = 'center';
        ctx.fillText("Mic.", baseCenter.x, baseCenter.y - halfSize + 35);
    

        ctx.fillStyle = 'gray';
        ctx.font = '9px Arial';
        ctx.fillText("FRONT", baseCenter.x, baseCenter.y - halfSize + 8);
    
        const smallTriangleSide = 10;
        const smallTriangleHeight = Math.sqrt(3) / 2 * smallTriangleSide;
        ctx.fillStyle = 'red';
        ctx.beginPath();
        ctx.moveTo(baseCenter.x - smallTriangleSide / 2 - 25, baseCenter.y - halfSize + 8);
        ctx.lineTo(baseCenter.x + smallTriangleSide / 2 - 25, baseCenter.y - halfSize + 8);
        ctx.lineTo(baseCenter.x - 25, baseCenter.y - halfSize - smallTriangleHeight + 8);
        ctx.closePath();
        ctx.fill();
    
        ctx.fillStyle = '#00FF00'; 
        const circleRadius = 3; 
        const rectInset = 5; 
        ctx.beginPath(); 
        ctx.arc(baseCenter.x - halfSize + rectInset + circleRadius, baseCenter.y + halfSize - rectInset - circleRadius, circleRadius, 0, Math.PI * 2); 
        ctx.fill();

    }

}

function canvasupdatecameraXY(){
    var canvas = document.getElementById('xy-canvas_camera_' + gDeviceIndex);
    var pointx = document.getElementById('CameraInformation_LocationXY_xvalue_input_' + gDeviceIndex);
    var pointy = document.getElementById('CameraInformation_LocationXY_yvalue_input_' + gDeviceIndex);
    var cameraSelect = document.getElementById("CameraInformation_Camera_select_" + gDeviceIndex);
    if(!cameraSelect)
        return;
    if(parseInt(cameraSelect.value,10) == -1)
        return;

    if (canvas)
    {
        var ctx = canvas.getContext('2d');
        ctx.clearRect(0, 0, canvas.width, canvas.height);
        ctx.clearRect(0, 0, canvas.width, canvas.height);
        ctx.clearRect(0, 0, canvas.width, canvas.height);

        if(gClearFixedCameraIcon)
        {
            ctx.clearRect(0, 0, canvas.width, canvas.height);
            return; 
        }

        var img = new Image();
        var imgSize = 32;

        const rect = canvas.getBoundingClientRect();
        if (canvas.width !== rect.width || canvas.height !== rect.height) 
        {
            canvas.width = rect.width;
            canvas.height = rect.height;
        }
        
        var x_scale = gZoneMaproomSizeH / canvas.width;
        var y_scale = gZoneMaproomSizeV / canvas.height;
        const xScale = (x_scale < 1) ? 1 : x_scale;
        const yScale = (y_scale < 1) ? 1 : y_scale;

        const displaycameraX = parseInt(pointx.value, 10);
        const displaycameraY = parseInt(pointy.value, 10);

        const graphicX = (displaycameraX+ gZoneMapprimebarX)  / xScale;
        const graphicY = (gZoneMaproomSizeV - displaycameraY) / yScale;

        img.src = '../images/icon_Camera.png';
        img.onload = function () {
            ctx.drawImage(img, graphicX - (imgSize / 2), graphicY - (imgSize / 2), imgSize, imgSize);
        };

        // var cameraSelect = document.getElementById("CameraInformation_Camera_select_" + gDeviceIndex);
        // if(cameraSelect)
        // {
        //     var cameraSelectIndex = parseInt(cameraSelect.value,10);
        //     if(cameraSelectIndex == -1)
        //     {
        //         var canvas = document.getElementById('xy-canvas_camera_' + gDeviceIndex);
        //         if (canvas) {
        //             var ctx = canvas.getContext('2d');
        //             ctx.clearRect(0, 0, canvas.width, canvas.height);
        //         }
        //         var miccanvas = document.getElementById('xy-canvas_microphone_' + gDeviceIndex);
        //         if (miccanvas) {
        //             var ctx = miccanvas.getContext('2d');
        //             ctx.clearRect(0, 0, miccanvas.width, miccanvas.height);
        //         }
        //         var arrowheadcanvas = document.getElementById('xy-canvas_arrowheadpos_' + gDeviceIndex);
        //         if (arrowheadcanvas) {
        //             var ctx = arrowheadcanvas.getContext('2d');
        //             ctx.clearRect(0, 0, arrowheadcanvas.width, arrowheadcanvas.height);
        //         }
        //     }
        // }

    }
}
/* AI setting */
function onAISettingModelApplyClick(){

    var jsonmsg = {};

    jsonmsg.Command = "SetCamAISetting";
    jsonmsg.IPAddress = document.getElementById("AISettingModelIPAddress").value;

    if(document.getElementById("AISettingModelInput").checked == true)
        jsonmsg.IsAI_PeopleTrackingEnable = true;
    else
        jsonmsg.IsAI_PeopleTrackingEnable = false;

    jsonmsg.AI_PeopleTrackingMode = parseInt(document.getElementById("SelectAISettingModelPeopleTracking").value,10);

    sendMessage("SetCamAISetting",jsonmsg);

    $('#AISettingModal').modal('hide');

    document.getElementById("BtnAISettingModalApply").disabled = true;
}

function FPSOnChange(){

    var FPS = parseInt(document.getElementById("selectFPS").value,10);

    sendMessage("SetVideoFps",FPS);
}

function ResolutionOnChange(){

    var resolution = document.getElementById("selectResolution").value;

    sendMessage("SetVideoResolution",resolution);
}

function InputAISettingModelPeopleTrackingOnChange(){

    document.getElementById("BtnAISettingModalApply").disabled = false;

}

function SelectAISettingModelPeopleTrackingOnChange(){

    document.getElementById("BtnAISettingModalApply").disabled = false;

}


function SelectModelHomePositionOnChange(){

    document.getElementById("BtnModelCancel_"+gDeviceIndex).disabled = false;
    document.getElementById("BtnModelApply_"+gDeviceIndex).disabled = false;
    var SelectModelHomePosition = document.getElementById("SelectModelHomePosition_"+gDeviceIndex).value;

    if(SelectModelHomePosition == 0){
        document.getElementById("InputModelHomePosition_"+gDeviceIndex).disabled = true;
    }
    else{
        document.getElementById("InputModelHomePosition_"+gDeviceIndex).disabled = false;
    }

}

function InputModelHomePositionOnChange(eventModel){

    document.getElementById("BtnModelCancel_"+gDeviceIndex).disabled = false;
    document.getElementById("BtnModelApply_"+gDeviceIndex).disabled = false;

    var curNumber = parseInt(eventModel.target.value);  
    if(curNumber < 0 )
        document.getElementById("InputModelHomePosition_"+gDeviceIndex).value = 0;
    if(curNumber > 256)
        document.getElementById("InputModelHomePosition_"+gDeviceIndex).value = 255;

}

function SelectModelApplyStatusChange(){
    document.getElementById("BtnModelApply_"+gDeviceIndex).disabled = false;
    document.getElementById("BtnModelCancel_"+gDeviceIndex).disabled = false;
}

function onAdvanceApplyClick(){

    const certificateInput = document.getElementById("DeviceAPICertificateInput_" + gDeviceIndex);
    const privateKeyInput = document.getElementById("DeviceAPIPrivateKeyInput_" + gDeviceIndex);
    if (certificateInput && privateKeyInput) 
    {
        const uploadResult = uploadFromCache(gDeviceIndex);
    }
    saveCurrentFileState(gDeviceIndex);


    setSoundSetting();
    setSoundAdvanceSetting();
    sendMessage("GetMicEnableHandFree",gDeviceIndex);

    setTimeout(function(){
        sendMessage("GetSoundSetting",gDeviceIndex);
        sendMessage("GetSoundAdvanceSetting",gDeviceIndex);    
        sendMessage("GetSoundCamMap" ,gDeviceIndex);
        sendMessage("GetMicEnableHandFree",gDeviceIndex);
    },100);


    document.getElementById("connectCheckboxInput_"+gDeviceIndex).disabled = false;
    document.getElementById("BtnModelCancel_"+gDeviceIndex).disabled = true;
    document.getElementById("BtnModelApply_"+gDeviceIndex).disabled = true;



}

function handleCertificateAndKeyUpload() {
    const deviceIndex = gDeviceIndex;
    // console.log('Starting upload from cache for device:', deviceIndex);
    
    uploadFromCache(deviceIndex);
}

function uploadCertificateToDevice(certificateContent, deviceIndex) {
    var obj1 = {
        Command: "SetSoundAdvanceSetting",
        SoundTabIndex: deviceIndex,
        CertificateAndKeyUpload: {
            Certificate: {
                content: certificateContent,
                fileName: document.getElementById("DeviceAPICertificateInput_" + deviceIndex).files[0].name
            }
        }
    };
    
    sendMessage("SetSoundAdvanceSetting", obj1);
}

function uploadPrivateKeyToDevice(privateKeyContent, deviceIndex) {
    var obj1 = {
        Command: "SetSoundAdvanceSetting",
        SoundTabIndex: deviceIndex,
        CertificateAndKeyUpload: {
            PrivateKey: {
                content: privateKeyContent,
                fileName: document.getElementById("DeviceAPIPrivateKeyInput_" + deviceIndex).files[0].name
            }
        }
    };
    
    sendMessage("SetSoundAdvanceSetting", obj1);
}

function setSoundSetting() {    
    var obj1 = {
        Command: "SetSoundSetting",
        SoundTabIndex: gDeviceIndex,
        SoundSetting: {
            MicDeviceIndex: getMicDeviceIndexBySelectIndex(parseInt(document.getElementById("deviceTypeSel_" + gDeviceIndex).value, 10)),
            IPAddress: document.getElementById("DeviceIPInput_" + gDeviceIndex).value,
            Port: parseInt(document.getElementById("DevicePortInput_" + gDeviceIndex).value, 10),
            Password: document.getElementById("PasswordInput_" + gDeviceIndex).value,
            APIKey: document.getElementById("DeviceAPIKeyInput_" + gDeviceIndex).value,
        },
    };
    sendMessage("GetMicEnableHandFree",gDeviceIndex);
    sendMessage("SetSoundSetting", obj1);    
    sendMessage("GetSoundCamMap", gDeviceIndex);
    sendMessage("GetMicEnableHandFree",gDeviceIndex);
}

function setSoundAdvanceSetting() {
    var obj1 = {
        Command: "SetSoundAdvanceSetting",
        SoundTabIndex: gDeviceIndex,
        SoundAdvanceSetting: {},
    };
    var deviceType = document.getElementById("deviceTypeSel_" + gDeviceIndex).value;

    let devicesel = document.getElementById("deviceTypeSel_"+gDeviceIndex);
    let deviceTypeString = transferDeviceTypeToString(devicesel.value); 

    const deviceTypeIndex = deviceTypeMap[deviceTypeString];

    if (OpenAudioTriggerLevelSoundDevice.includes(deviceTypeIndex)) 
    {
        obj1.SoundAdvanceSetting.AudioTriggerLevel = parseInt(document.getElementById("InputModelAudioTrigger_" + gDeviceIndex).value, 10);
    }
    // if (['Sennheiser:TCC2', 'Sennheiser:TCCM', 
    //      'Nureva:HDL300', 'Nureva:Dual HDL300', 'Nureva:HDL310', 'Nureva:HDL410', 'Nureva:HDL410(Coordinate)', 
    //      'Yamaha:RM-CG', 'Yamaha:RM-W','Yamaha:RM-CR','Yamaha:RM-TT',
    //      'Audio-Technica:ATND1061'].includes(deviceTypeString)) {
    //     obj1.SoundAdvanceSetting.AudioTriggerLevel = parseInt(document.getElementById("InputModelAudioTrigger_" + gDeviceIndex).value, 10);
    // }
    obj1.SoundAdvanceSetting.TimeToTriggerPreset = parseInt(document.getElementById("SelectModelPreset_" + gDeviceIndex).value, 10);
    if(!gIsUseGlobalBackToHomeControl)
    {
        obj1.SoundAdvanceSetting.BackToHomeTime = parseInt(document.getElementById("SelectModelHomeTimes_" + gDeviceIndex).value, 10);
        obj1.SoundAdvanceSetting.BackToHomeSwitchCamera = document.getElementById("SelectModelHomeCamera_" + gDeviceIndex).value;
        if(obj1.SoundAdvanceSetting.BackToHomeSwitchCamera == 0) obj1.SoundAdvanceSetting.BackToHomeSwitchCamera = 'All';
        obj1.SoundAdvanceSetting.BackToHomePos = parseInt(document.getElementById("SelectModelHomePosition_" + gDeviceIndex).value, 10);
        obj1.SoundAdvanceSetting.BackToHomePreset = parseInt(document.getElementById("InputModelHomePosition_" + gDeviceIndex).value, 10);
    }
    
   
    sendMessage("SetSoundAdvanceSetting", obj1);
    sendMessage("GetSoundAdvanceSetting",gDeviceIndex);
    //console.log(obj1);
}

function onAdvanceCancelClick(){   
    sendMessage("GetMicEnableHandFree",gDeviceIndex);
    sendMessage("GetSoundSetting",gDeviceIndex);
    sendMessage("GetSoundAdvanceSetting",gDeviceIndex);    
    sendMessage("GetSoundCamMap" ,gDeviceIndex);
    sendMessage("GetMicEnableHandFree",gDeviceIndex);
    
    const restored = restoreFileState(gDeviceIndex);
    
    const elements = {
        connectCheckbox: document.getElementById("connectCheckboxInput_" + gDeviceIndex),
        cancelButton: document.getElementById("BtnModelCancel_" + gDeviceIndex),
        applyButton: document.getElementById("BtnModelApply_" + gDeviceIndex)
    };
    
    if (elements.connectCheckbox) {
        elements.connectCheckbox.disabled = false;
    }
    if (elements.cancelButton) {
        elements.cancelButton.disabled = true;
    }
    if (elements.applyButton) {
        elements.applyButton.disabled = true;
    }
    
    if (typeof SelectModelApplyStatusChange === 'function') {
        SelectModelApplyStatusChange();
    }
}

function cameraMappingCancelClick(){
    if(gSelectMicChannelChange){
        gSelectMicChannelChange = 0;
        SelectMicChannelOnChange();
    }
    sendMessage("GetMicEnableHandFree",gDeviceIndex);
    sendMessage("GetSoundSetting",gDeviceIndex);
    sendMessage("GetSoundAdvanceSetting",gDeviceIndex);    
    sendMessage("GetSoundCamMap" ,gDeviceIndex);
    sendMessage("GetMicEnableHandFree",gDeviceIndex);
}

function onChangeCameraMappingApplyStatus(index){
    document.getElementById("cameraMapping_div"+index).disabled = false;
}

function onChangeSoundDeviceApplyStatus(){
    document.getElementById("connectCheckboxInput_"+gDeviceIndex).disabled = true;
    document.getElementById("BtnModelCancel_"+gDeviceIndex).disabled = false;
    document.getElementById("BtnModelApply_"+gDeviceIndex).disabled = false;
}

function onChangeSoundDeviceSettingApply(){

    var msgSend = {};
    var obj1 = {};
    var obj2 = {};
    //var deviceType = document.getElementById("deviceTypeSel_"+gDeviceIndex).value;

    obj1.Command = "SetSoundSetting";
    obj1.SoundTabIndex = gDeviceIndex;
    obj1.SoundSetting = {};

    obj2.MicDeviceIndex     = getMicDeviceIndexBySelectIndex(parseInt(document.getElementById("deviceTypeSel_"+gDeviceIndex).value,10));
    obj2.IPAddress          = document.getElementById("DeviceIPInput_"+gDeviceIndex).value;
    obj2.Port               = parseInt(document.getElementById("DevicePortInput_"+gDeviceIndex).value,10);
    obj2.Password           = document.getElementById("PasswordInput_"+gDeviceIndex).value;
    obj2.APIKey             = document.getElementById("DeviceAPIKeyInput_"+gDeviceIndex).value;

    Object.assign(obj1.SoundSetting, obj2);

    sendMessage("GetMicEnableHandFree",gDeviceIndex);
    sendMessage("SetSoundSetting",obj1);    
    sendMessage("GetSoundCamMap" ,gDeviceIndex);
    sendMessage("GetMicEnableHandFree",gDeviceIndex);

    document.getElementById("deviceApply_"+gDeviceIndex).disabled = true;
}

var gFirstInitWebTab_flag = false;

/*syncDeviceCount*/

var gMicTabCount; 
function syncDeviceShowTabName() {
    gFirstInitWebTab_flag = true;

    var tabcount; 
    if(document.getElementById("deviceCntSel"))
    {
        tabcount = document.getElementById("deviceCntSel").value;
        gMicTabCount = tabcount;
    }
    
    async function sendMessageWithDelay() {
        function delay(ms) {
            return new Promise(resolve => setTimeout(resolve, ms));
        }
        for(var loopindex = 1;loopindex <gMicTabCount;loopindex ++){
            sendMessage("GetSoundSetting",loopindex);
            await delay(5);
        }

        let devicesel = document.getElementById("deviceTypeSel_" + gDeviceIndex);
        let deviceTypeString = transferDeviceTypeToString(devicesel.value); 

        if(deviceTypeString === 'Yamaha:RM-CG(Coordinate)'
        //|| deviceTypeString === 'Nureva:HDL410(Coordinate)' //@Jeff Use zondmap
        || deviceTypeString === 'Audio-Technica:ATND1061(Coordinate)'
        || deviceTypeString === 'Shure:MXA920(Coordinate)'
        || deviceTypeString === 'Sennheiser:TCC2(Coordinate)'
        || deviceTypeString === 'Sennheiser:TCCM(Coordinate)')
        {
            var jsonmsg = {};
            jsonmsg.Command = "GetZoneModeConfig";
            jsonmsg.SoundTabIndex = gMicTabCount;
            jsonmsg.GetEnableStatus = true;
            sendMessage("GetZoneModeConfig", jsonmsg);
        }

        sendMessage("GetMicEnableHandFree",0);
        sendMessage("GetSoundSetting",0);
        sendMessage("GetSoundAdvanceSetting",0);        
        sendMessage("GetSoundCamMap",0);
        sendMessage("GetYamahaExclusionMode",0);
        sendMessage("GetZoneMapDetection",0);
        sendMessage("GetMicEnableHandFree",0);

        await delay(10);
    }
    sendMessageWithDelay();
}
function syncDeviceCount() {
	
    var tabcount; 
    if(document.getElementById("deviceCntSel"))
    {
        tabcount = document.getElementById("deviceCntSel").value;
        gMicTabCount = tabcount;
    }

    updateButtonVisibility(tabcount);
    sendMessage("SetSoundNumbers",parseInt(tabcount,10));

    document.getElementById("Select_Profile").style.display = "block";
    document.getElementById("Label_Profile").style.display = "block";

    /*Hide all tabs */
    for (x = 0; x < 24; x++) {
        $("#A_tabDevice_"+x).hide();
        //console.log("A_tabDevice"+x+".hide();");    
    }

    for (x = 0; x < tabcount; x++) {
        $("#A_tabDevice_"+x).show();
        //console.log("A_tabDevice"+x+".show();");    
    }

    gFirstInitWebTab_flag = true;
    
    async function sendMessageWithDelay() {
        function delay(ms) {
            return new Promise(resolve => setTimeout(resolve, ms));
        }

        // for(var loopindex = 1;loopindex <tabcount;loopindex ++){
        //    await delay(5);
        // }
        //sendMessage("GetSoundSetting",gDeviceIndex);
        sendMessage("GetMicEnableHandFree",gDeviceIndex);
        await delay(5);
        // console.log('~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~');  
       
        var tabs_menu = document.getElementsByClassName("mic-tabs-menu");        

        gDeviceIndex = 0;
        for (let j = 0; j < tabcount; j++) 
        {
            if(j !=gDeviceIndex)
                tabs_menu[j].className = "mic-tabs-menu mic-tabs-menu-passive-border stream-tab Font_Arial_14_bold";
            
            if(gDeviceIndex == 0)
                tabs_menu[0].className = "mic-tabs-menu mic-tabs-menu-active mic-tabs-menu-active-border stream-tab Font_Arial_14_bold";
        }
        tabs_menu[gDeviceIndex].click();
        
        await delay(10);
    }
    sendMessageWithDelay();
    //syncDeviceType();
}

function SettingModeChange(e){
	
    var SettingModeStatus;

    if(e.checked == true){
        document.getElementById("SetVoiceTrackingCheckboxInput").checked = true;
        document.getElementById("btnstreamContainer").style.display = 'none';
    }
    else{
        document.getElementById("SetVoiceTrackingCheckboxInput").checked = false;
        document.getElementById("btnstreamContainer").style.display = 'block';
    }

    SettingModeStatus = document.getElementById("SetVoiceTrackingCheckboxInput").checked ;
    sendMessage("SetVoiceTracking",SettingModeStatus);
}

let glastDeviceType = null;
let glastIsConnected = null;

function updateCameraMappingTable(deviceType, isConnected) {

    for (var k = 1; k <= gMaxMappingGroupIndex; k++) //hide all channel first 
    {
        document.getElementById("Div_cameraMapping_"+k).style.display = "none";
        if(k == gDeviceIndex)
        {
            document.getElementById("Div_cameraMapping_"+k).style.display = "block";
        }
    }
    
    //    for (var i = 1; i <= gMaxMappingGroupIndex; i++) {
    //console.log('gMaxMappingGroupIndex!!!!!',gMaxMappingGroupIndex);


    // for (var i = 1; i <= gMaxMappingGroupIndex; i++) {
    //     var divId = "Div_cameraMapping_" + i;     
    //     var displayStyle = deviceMappings == i ? "block" : "none";
    //     document.getElementById(divId).style.display = displayStyle;

    //     if( i != deviceMappings)
    //         continue;

    //     console.log('Run updateCameraMappingTable() gMaxMappingGroupIndex',gMaxMappingGroupIndex,'index',i,'deviceMappings',deviceMappings);
    //     if (deviceMappings === 1 ) {
    //         createCameraMappingArrayDiv(1, 8);
    //     } else if (deviceMappings === 2) {
    //         createCameraMappingArrayDiv(2, 4);
    //     } else if (deviceMappings === 3) {
    //         createCameraMappingArrayDiv(3, 125);
    //     } else if (deviceMappings === 4) {
    //         createCameraMappingAzimuthDiv(4, 8);
    //     } else if (deviceMappings === 5) {
    //         createCameraMappingAzimuthDiv(5, 8);
    //     } else if (deviceMappings === 6) {
    //         createCameraMappingAzimuthDiv(6, 8);
    //     } else if (deviceMappings === 7) {
    //         createCameraMappingArrayDiv(7, 8);
    //     } else if (deviceMappings === 8) {
    //         createCameraMappingArrayDiv(8, 15);
    //     } else if (deviceMappings === 9) {
    //         createCameraMappingArrayDiv(9, 8);
    //     } else if (deviceMappings === 10) {
    //         createCameraMappingArrayDiv(10, 16);
    //     } else if (deviceMappings === 11) {
    //         createCameraMappingArrayDiv(11, 1);
    //     } else if (deviceMappings === 12) {
    //         createCameraMappingAzimuthDiv(12, 128);
    //     } else if (deviceMappings === 13) {
    //         createCameraMappingArrayDiv(13, 128);
    //     } else if (deviceMappings === 14) {
    //         createCameraMappingArrayDiv(14, 128);
    //     } else if (deviceMappings === 15) {
    //         createCameraMappingArrayDiv(15, 128);
    //         // console.log('deviceMappings --> createCameraMappingArrayDiv(15,128)!!!!!!');
    //     } else if (deviceMappings === 16) {
    //         createCameraMappingArrayDiv(16, 14);
    //         // console.log('deviceMappings --> createCameraMappingArrayDiv(16, 50)!!!!!!');
    //     } else if (deviceMappings === 17) {
    //         createCameraMappingArrayDiv(17, 50);
    //         // console.log('deviceMappings --> createCameraMappingArrayDiv(17,50)!!!!!!');
    //     }
        
    // }
    
}

function transferDeviceTypeToString(typeIndex) {

    if (typeIndex >= 0 && typeIndex < Object.keys(gMicSelect_Index).length) {
        return indexToDeviceTypeMap[typeIndex] || "Shure:MXA910";
    } else {
        return "Shure:MXA910";
    }
}

function updateDevicePortStatus(deviceTypeIndex,isConnect){
    var DevicePortInput = document.getElementById("DevicePortInput_" + gDeviceIndex);
    var deviceType = Object.keys(gMicSelect_Index)[deviceTypeIndex];


    if (deviceType.includes("Nureva") || deviceType.includes("AudioTechnica"))
    {
        DevicePortInput.disabled = false;
    } 
    else 
    {
        DevicePortInput.disabled = true;
    }

    if(isConnect == true)
    {
        DevicePortInput.disabled = true;
    }    
}

function selectingDeviceType(){

    // var obj1 = {
    //     Command: "SetSoundSetting",
    //     SoundTabIndex: gDeviceIndex,
    //     SoundSetting: {
    //         SoundDeviceIndex: parseInt(document.getElementById("deviceTypeSel_" + gDeviceIndex).value, 10),
    //     },
    // };

    // sendMessage("SetSoundSetting", obj1);
    // sendMessage("GetSoundCamMap", gDeviceIndex);
    var value = document.getElementById("deviceTypeSel_"+gDeviceIndex).value;
    //setSoundSetting();

    let intervalId = setInterval(function() {      
        sendMessage("GetMicEnableHandFree",gDeviceIndex);
        sendMessage("GetSoundAdvanceSetting",gDeviceIndex);
        sendMessage("GetSoundCamMap", gDeviceIndex);
        sendMessage("GetYamahaExclusionMode",gDeviceIndex);
        sendMessage("GetMicEnableHandFree",gDeviceIndex);

        var jsonmsg = {};
        jsonmsg.Command = "GetSoundDevicePort";
        jsonmsg.SoundTabIndex = gDeviceIndex;
        jsonmsg.MicDeviceIndex = getMicDeviceIndexBySelectIndex(parseInt(value,10));
        sendMessage("GetSoundDevicePort",jsonmsg);
        SelectMicChannelOnChange();

        clearInterval(intervalId);
    }, 300)

}

function syncDeviceType() {
    var deviceTypeSel = document.getElementById("deviceTypeSel_"+gDeviceIndex);
    var micGroup = getDeviceCameraMappingIndex();
    let devicesel = document.getElementById("deviceTypeSel_"+gDeviceIndex);
    let deviceType = transferDeviceTypeToString(devicesel.value); 
    var content_Device = document.getElementById("content_Device_" + gDeviceIndex);
    var contentHeight = "174px";
    let AudioLevel = document.getElementById("audioLevel_" + gDeviceIndex);
    let showAudioLevel;
    getMicTabIsGettingUIforPage();
    //updateDevicePortStatus(deviceTypeSel.value);//default port
    //SelectMicChannelOnChange();//create default channel 
    //updateDeviceChannelStatus();//default channel 8,16,32,64,128

    for (var k = 1; k <= gMaxMappingGroupIndex; k++) //hide all channel first 
    {
        document.getElementById("Div_cameraMapping_"+k).style.display = "none";
        if(k == gDeviceIndex)
        {
            document.getElementById("Div_cameraMapping_"+k).style.display = "block";
        }
    }
    // updateCameraMappingTable(transferDeviceTypeToString(deviceTypeSel.value)); //default password+ space typesetting
    
    if(deviceType == 'Sennheiser:TCCM' || deviceType == 'Sennheiser:TCCM(Coordinate)' || 
       deviceType == 'Yamaha:RM-CG'    || deviceType == 'Yamaha:RM-CG(Coordinate)')
    {
        contentHeight = '222px';
    }
    document.getElementById("content_Device_" + gDeviceIndex).style.height = contentHeight;

    if(deviceType == 'Yamaha:RM-CG' || deviceType == 'Yamaha:RM-CG(Coordinate)')
    {
        $("#ExclusionMode_"+gDeviceIndex).show();
    }
    else
    {
        $("#ExclusionMode_"+gDeviceIndex).hide();
    }

    if(deviceType == 'Sennheiser:TCCM' || deviceType == 'Sennheiser:TCCM(Coordinate)')
    {
        $("#password_"+gDeviceIndex).show();
    }
    else
    {
        $("#password_"+gDeviceIndex).hide();
    }

    if(deviceType == 'Televic:D-Cerno AE(HTTPS)')
    {
        if(document.getElementById("APICertificate_" + gDeviceIndex))
            $("#APICertificate_"+gDeviceIndex).show();
        if(document.getElementById("APIPrivateKey_" + gDeviceIndex))
            $("#APIPrivateKey_"+gDeviceIndex).show();
        if(document.getElementById("APITokens_" + gDeviceIndex))
            $("#APITokens_"+gDeviceIndex).show();
        var connectCustomBox= document.getElementById("div_custom_box_"+gDeviceIndex);
        connectCustomBox.style.height = "148px";
    }
    else if(deviceType == 'Televic:D-Cerno AE')
    {
        if(document.getElementById("APICertificate_" + gDeviceIndex))
            $("#APICertificate_"+gDeviceIndex).hide();
        if(document.getElementById("APIPrivateKey_" + gDeviceIndex))
            $("#APIPrivateKey_"+gDeviceIndex).hide();
        if(document.getElementById("APITokens_" + gDeviceIndex))
            $("#APITokens_"+gDeviceIndex).show();
        var connectCustomBox= document.getElementById("div_custom_box_"+gDeviceIndex);
        connectCustomBox.style.height = "64px";
    }
    else
    {
        if(document.getElementById("APICertificate_" + gDeviceIndex))
            $("#APICertificate_"+gDeviceIndex).hide();
        if(document.getElementById("APIPrivateKey_" + gDeviceIndex))
            $("#APIPrivateKey_"+gDeviceIndex).hide();
        if(document.getElementById("APITokens_" + gDeviceIndex))
            $("#APITokens_"+gDeviceIndex).hide();
        var connectCustomBox = document.getElementById("div_custom_box_"+gDeviceIndex);
        connectCustomBox.style.height = "18px";
    }

    switch(deviceType)
    {
        case 'Shure:MXA910':case 'Shure:MXA920':case 'Shure:MXA710': 
        case 'Shure:MXA920(Coordinate)':
        case 'Shure:MXA310':
        case 'Shure:MXCW':
        case 'Shure:P300':
            showAudioLevel = false;
        break;

        case 'Sennheiser:TCC2':case 'Sennheiser:TCCM':case 'Sennheiser:TCC2(Coordinate)':case 'Sennheiser:TCCM(Coordinate)':
        case 'Nureva:HDL300':case 'Nureva:Dual HDL300':case 'Nureva:HDL310':case 'Nureva:HDL410':case 'Nureva:HDL410(Coordinate)':
        case 'Yamaha:RM-CG':case 'Yamaha:RM-W':case 'Yamaha:RM-CR':case 'Yamaha:RM-TT':case 'Yamaha:RM-CG(Coordinate)':                                                                                     
        case 'Audio-Technica:ATND1061':case 'Audio-Technica:ATND1061(Coordinate)':case 'Audio-Technica:ATUC-50CU':
        case 'Lumens:Virtual Mic':          
            showAudioLevel = true;
        break;    
    }
    if (showAudioLevel) 
    {
        AudioLevel.style.cssText = "display : block;"
    }
    else
    {
        AudioLevel.style.cssText = "display : none;"
    }


    var obj1 = {
        Command: "SetSoundDeviceType",
        SoundTabIndex: gDeviceIndex,
        SoundDeviceType: {
            MicDeviceIndex: getMicDeviceIndexBySelectIndex(parseInt(deviceTypeSel.value, 10)),
        },
    };
    
    sendMessage("SetSoundDeviceType", obj1);

    let timerInterval = setInterval(() => {
        clearInterval(timerInterval);
        //sendMessage("GetMicEnableHandFree",gDeviceIndex);
        sendMessage("GetSoundSetting",gDeviceIndex);
        // sendMessage("GetSoundAdvanceSetting",gDeviceIndex);
        // sendMessage("GetSoundCamMap", gDeviceIndex);
        // sendMessage("GetYamahaExclusionMode",gDeviceIndex);

        let devicesel = document.getElementById("deviceTypeSel_" + gDeviceIndex);
        let deviceTypeString = transferDeviceTypeToString(devicesel.value); 

        if(deviceTypeString === 'Yamaha:RM-CG(Coordinate)'
        //|| deviceTypeString === 'Nureva:HDL410(Coordinate)' //@Jeff Use zondmap
        || deviceTypeString === 'Audio-Technica:ATND1061(Coordinate)'
        || deviceTypeString === 'Shure:MXA920(Coordinate)'
        || deviceTypeString === 'Sennheiser:TCC2(Coordinate)'
        || deviceTypeString === 'Sennheiser:TCCM(Coordinate)')
        {
            var jsonmsg = {};
            jsonmsg.Command = "GetZoneModeConfig";
            jsonmsg.SoundTabIndex = gDeviceIndex;
            jsonmsg.GetEnableStatus = true;
            sendMessage("GetZoneModeConfig", jsonmsg);
        }

        var showTabIndex;
        showTabIndex = gDeviceIndex+1;
        document.getElementById("A_tabDevice_"+gDeviceIndex).innerText = showTabIndex+'.'+transferDeviceTypeToString(deviceTypeSel.value);
        document.getElementById("connectCheckboxInput_"+gDeviceIndex).disabled = true;
        if(document.getElementById("img_DeviceStatus_"+gDeviceIndex))
            document.getElementById("img_DeviceStatus_"+gDeviceIndex).style.display = "hidden";
        document.getElementById('ExclusionMode_connectCheckboxInput_'+gDeviceIndex).disabled = true;
        document.getElementById("BtnModelCancel_"+gDeviceIndex).disabled       = false;
        document.getElementById("BtnModelApply_"+gDeviceIndex).disabled        = false;
        document.getElementById("cameraMappingCancel_"+micGroup).disabled      = true;
        document.getElementById("cameraMappingApply_"+micGroup).disabled       = true;

        if(deviceType == 'Lumens:Virtual Mic')
        {
            document.getElementById("connectCheckboxInput_"+gDeviceIndex).disabled = true;
            if(document.getElementById("img_DeviceStatus_"+gDeviceIndex))
                document.getElementById("img_DeviceStatus_"+gDeviceIndex).style.visibility = "hidden";
            document.getElementById('ExclusionMode_connectCheckboxInput_'+gDeviceIndex).disabled = true;
            document.getElementById("BtnModelCancel_"+gDeviceIndex).disabled       = true;
            document.getElementById("BtnModelApply_"+gDeviceIndex).disabled        = true;
            document.getElementById("cameraMappingCancel_"+micGroup).disabled      = true;
            document.getElementById("cameraMappingApply_"+micGroup).disabled       = true;

        }
    }, 300);

    // var jsonmsg = {};
    // jsonmsg.Command = "GetSoundDevicePort";
    // jsonmsg.SoundTabIndex = gDeviceIndex;
    // jsonmsg.SoundDeviceIndex = parseInt(deviceTypeSel.value,10);
    // sendMessage("GetSoundDevicePort",jsonmsg);
}



//var wsUri = "ws://"+location.hostname+":9015";
//var websocket = null;


var gGetSoundMaxQtyFlags = false;
var gInitGetUpdateBC200List= false;
async function sendGetSoundMaxQtyWithRetry() {
    gGetSoundMaxQtyFlags = true;
    sendMessage("GetSoundMaxQty");//get Limit Sound Tab Max Count     sendMessage("GetSystemSetting");
    sendMessage("GetSoundNumbers");//get Now Sound Tab Count and get sound stting
    setTimeout(() => {
        if (gGetSoundMaxQtyFlags) 
        {
            getMicTabIsGettingUIforPage();
            //console.log(`No response for GetSoundSetting index ${index} after 3000ms, retrying...`);
            sendGetSoundMaxQtyWithRetry();
        }
    }, 1500);
}

function initWebSocket() {

    gFirstInitWebTab_flag = false;
    
    if (websocket && websocket.readyState == 1) {
        console.log('Already connection');
        gWebSocketErrorBlockUIPage = false;

        if(document.getElementById("Select_Profile"))
            document.getElementById("Select_Profile").style.display = "block";
        if(document.getElementById("Label_Profile"))
            document.getElementById("Label_Profile").style.display = "block"; 

        if(document.getElementById("Select_Profile").value == null)
        {
            sendMessageIndex("GetAllProfile");
            sendMessageIndex("GetCurrentProfileID");
        }

        sendMessage("GetVoiceTracking");//Check voice tracking on off
        sendMessage("GetSystemSetting");
        sendMessageVideo("GetVideoIsStartStreaming");//Check Video is output or not 
        sendMessageVideo("GetVideoOutputSwitchingMode");//sendMessage("GetSystemSetting");
        sendMessageIndex("CheckDanteActiveDataIsExport");

        tabPageStream(); //Create onclick SoundTab event

        sendGetSoundMaxQtyWithRetry();

        UnblockUIforPage();

        gInitGetUpdateSoundNumbers = false;

        gInitGetUpdateBC200List = true;
        sendMessage("GetNimbleSystemEyeSetup");
    }
    else
    {
        if(gProtocolStr == "http:")
            websocket = new WebSocket( wsUri );
        else
            websocket = new WebSocket( wssUri );
    }

    websocket.addEventListener('open', function() {
        console.log('open connection');
        gWebSocketErrorBlockUIPage = false;

        if(document.getElementById("Select_Profile"))
            document.getElementById("Select_Profile").style.display = "block";
        if(document.getElementById("Label_Profile"))
            document.getElementById("Label_Profile").style.display = "block"; 

        if(document.getElementById("Select_Profile").value == null)
        {
            sendMessageIndex("GetAllProfile");
            sendMessageIndex("GetCurrentProfileID");
        }

        sendMessage("GetVoiceTracking");//Check voice tracking on off
        sendMessage("GetSystemSetting");
        sendMessageVideo("GetVideoIsStartStreaming");//Check Video is output or not 
        sendMessageVideo("GetVideoOutputSwitchingMode");//sendMessage("GetSystemSetting");
        sendMessageIndex("CheckDanteActiveDataIsExport");

        tabPageStream(); //Create onclick SoundTab event

        sendMessage("GetSoundMaxQty");//get Limit Sound Tab Max Count     sendMessage("GetSystemSetting");
        sendMessage("GetSoundNumbers");//get Now Sound Tab Count and get sound stting

        UnblockUIforPage();

        gInitGetUpdateSoundNumbers = false;

        gInitGetUpdateBC200List = true;
        sendMessage("GetNimbleSystemEyeSetup");
    
    });

    websocket.addEventListener('error',function(evt){
        gWebSocketErrorBlockUIPage = true;
        setTimeout(showWebSocketLost,1000);//blockUIforPage();
        setLoginStatus(false);
        gHadLogin = false;
        clearLoginStatus();
    });

    websocket.addEventListener('message',function(evt){
        //console.log('Message received',evt.data);
        //console.log('Message received');
        if(evt.data instanceof Blob)
        {
            const imgLoader = document.getElementById('dmsloader_' + gDeviceIndex);
            if(imgLoader)
                createImageFromFile(imgLoader, evt.data);

            const imgZoneLoader = document.getElementById('ZoneFullMap_loader');
            if(imgZoneLoader)
                createImageFromFile(imgZoneLoader, evt.data);

        }
        else
        {
            receivedDataMicrophone(evt.data);
        }
    });

    websocket.onclose = function(evt) 
    {
        gWebSocketErrorBlockUIPage = true;
        setTimeout(showWebSocketLost,1000);//blockUIforPage();
        setLoginStatus(false);
        gHadLogin = false;
        clearLoginStatus();
    };

}

function createImageFromFile(imgElement, fileBlob) {
    return new Promise((resolve, reject) => {
        const objectURL = URL.createObjectURL(fileBlob);
        imgElement.onload = () => {
            URL.revokeObjectURL(objectURL);
            resolve(imgElement);
        };
        // imgElement.onerror = (error) => {
        //     URL.revokeObjectURL(objectURL); 
        //     reject(new Error('Failed to load image'));
        // };
        imgElement.src = objectURL;
    });
}

function receivedDataMicrophone(data) {

    var tempData = data;
    var obj = JSON.parse(tempData);
    
    //console.log('obj.Reply:',obj);

    switch (obj.Reply) {
        case "GetSoundMaxQty"://"GetSystemSetting": //reply search camera result
            //console.log('GetSoundNumbers result!!');
            updateSystemSetting(obj);
            
        break;

        case "GetSoundNumbers": //reply search camera result
            //console.log('GetSoundNumbers result!!');
            updateSoundNumbers(obj);
        break;

        case "GetSoundSetting": //reply sound setting
            //console.log('GetSoundSetting result!!',obj);
            updateSoundSetting(obj);
        break;

        case "GetSoundAdvanceSetting": //reply sound advance setting
            //console.log('GetSoundAdvanceSetting result!!');
            updateAdvanceSetting(obj);
        break;

        case "GetSoundCamMap": //reply sound camera mapping
            //console.log('GetSoundCameraMapping!!',obj);
            updateCameraMapping(obj);
        break;

        case "GetMicEnableHandFree": //reply sound camera mapping
            updateMicEnableHandFree(obj);
        break;

        case "SoundConnect":
            //console.log('SoundConnect!!');
            updateSoundDeviceConnect(obj);
        break;

        case "GetCamAISetting":
            //console.log('GetCamAISetting!!');
            updateCamAISetting(obj);
        break;

        case "GetCamConnectStatus":
            if(!gCameraDeleteBlockFlag && !gCameraDisconnectBlockFlag && !gCameraSearchBlockFlag)
            {
                UnblockUIforPage();
            }
            updateCamConnectStatus(obj);
        break;

        /*case "GetVideoResolution":
            console.log('GetVideoResolution!!');
            updateVideoResolution(obj);
        break;

        case "GetVideoFps":
            console.log('GetVideoFps!!');
            updateVideoFps(obj);
        break;*/

        case "GetSoundPos":
            //console.log('GetSoundPos!!');
            updatemicGetSoundPos(obj);
        break;

        case "GetNimbleEyePos":

        break;

        case "GetSoundSourceData":
            updateGetSoundSourceData(obj);
        break;

        case "GetVoiceTracking":
            updateGetVoiceTracking(obj);
        break;

        case "GetSoundDevicePort":
            updateSoundDevicePort(obj);
        break;

        case "GetVideoOutputSwitchingMode":            
            updatedSecondaryCameraMap(obj);
            break;

        case "GetVideoIsStartStreaming":
            updatedVideoOutputStatus(obj);
        break;

        case "GetFocusMode":
            micupdatedPTZFocusMode(obj);
        break;

        case "GetMirrorFlipType":
            micupdatedMirrorFlipType(obj);
        break;

        case "GetPanFlip":
            micupdatedPanFlip(obj);
        break;
        
        case "GetSoundMXCWSeatName":
            updatedShureMXCWSeatName(obj);
        break;

        case "GetSoundXYLocation":
            updatedSoundXYLocation(obj);
        break;

        case "SetYamahaExclusionMode":
            updatedSetYamahaExclusionMode(obj);
        break;
        case "GetYamahaExclusionMode":
            updatedGetYamahaExclusionMode(obj);
        break;

        case "GetStandByStatus":
            updatedGetStandByStatus(obj);
        break;

        case "GetSoundMaxQtyProcessStatus":
            updatedGetSoundMaxQtyProcessStatus(obj);
            break;

        case"StartVideoStreaming":
            gVideoOutputStatus=true;
            updatedStartVideoStreaming(obj,false);
        break;

        case"StopVideoStreaming":
            gVideoOutputStatus=false;
            updatedStopVideoStreaming(obj);
        break;

        case"GetZoneMapDetection":
            updatedZoneMapDetection(obj);
        break;

        case"GetSoundTabPosInfo":
            updateGetSoundTabPosInfo(obj);
        break;

        case"GetCameraList":
            updatemicGetCameraList(obj);
        break;

        case "GetCurrentProfileID":
            updatedProfileIndex(obj);
            break;

        case "LoadProfile":
            if("Status" in obj)
            {
                console.log('LoadPorfile Status:',obj.Status);
                if(obj.Status.includes("Finished"))
                {
                    sendMessage("GetCurrentProfileID");
                    UnblockUIforPage();
                }
            }
            break;

        case "SearchCamera":
            sendMessage("GetCurrentProfileID");
            UnblockUIforPage();
            break;

        case "GetMicStatus":           
            if(document.getElementById("img_DeviceStatus_"+obj.SoundTabIndex))
            {
                if(obj.IsConnect)
                    document.getElementById("img_DeviceStatus_"+obj.SoundTabIndex).src = "./images/MicConnect.png";
                else
                    document.getElementById("img_DeviceStatus_"+obj.SoundTabIndex).src = "./images/MicDisconnect.png";
            }
        break;

        case "GetZoneModeConfig":
            updatedZoneModeConfig(obj);
        break;

        case "GetGlobalBackToHomeSetting":
            updateBackToHomeSetting(obj);
        break;

        case "GetMicDebugMessageInfo":
            updatedGetMicDebugMessageInfo(obj);
        break;

        case "CheckDanteActiveDataIsExport":
            updatedCheckDanteActiveDataIsExport(obj);
        break;

        case "GetNimbleSystemEyeSetup":
            updatedZoneFullMapNimbleSystemEyeSetup(obj);
        break;
        case "GetBC200CameraCalibrationSetting":
            updatedGetZoneFullMapBC200CameraCalibrationSetting(obj);
        break;

        case "GetSystemSetting":
            updateGetSystemSetting(obj);
        break;
    }

}



function micupdatedPTZFocusMode(msg) {

    if(gIsControlByGui)
        return;

    console.log('Mode:', msg.Mode);
    if(document.getElementById("focusModeCheckboxInput_"+gDeviceIndex))
    {
        if(msg.Mode == "Auto"){
            document.getElementById("focusModeCheckboxInput_"+gDeviceIndex).checked = true;
        }
        else
            document.getElementById("focusModeCheckboxInput_"+gDeviceIndex).checked = false;
    }
}

function micupdatedMirrorFlipType(msg) {

    if(gIsControlByGui)
        return;

    //console.log('Type:', msg.Type);
    if(document.getElementById("PTZMirrorFlipType_"+gDeviceIndex))
        document.getElementById("PTZMirrorFlipType_"+gDeviceIndex).value = msg.Type;

}

function micupdatedPanFlip(msg) {

    if(gIsControlByGui)
        return;

    //console.log('IsFlip:', msg.IsFlip);
    if(document.getElementById("PTZLRDirection_"+gDeviceIndex))
        document.getElementById("PTZLRDirection_"+gDeviceIndex).checked = msg.IsFlip;
    
}


let minData = [];
let waitingData = [];
let isComparing = false;
let comparisonInterval = null;

function updateGetSoundTabPosInfo(msg) {
    console.log('Received data:', msg);
    waitingData.push(msg);

    if (!isComparing) {
        isComparing = true;
        const comparisonStart = Date.now();

        comparisonInterval = setInterval(() => {
            const now = Date.now();
            
            if (now - comparisonStart >= 1000) {
                clearInterval(comparisonInterval);
                processComparison();
                isComparing = false;
            }
        }, 10);
    }
}

function processComparison() {
    if (waitingData.length === 0) {
        console.log('No data received for comparison.');
        return;
    } else if (waitingData.length === 1) {
        console.log('Only one data received for comparison:', waitingData[0]);
    }

    const minData = waitingData.reduce((min, current) => (!min || current.SoundTriggerTime < min.SoundTriggerTime) ? current : min, waitingData[0] || {});

    console.log('Data with minimum trigger time:', minData);

    const jsonmsg = {
        Command: "SetSoundTabPosInfo",
        SoundTabIndex: parseInt(minData.SoundTabIndex, 10),
        SoundPosInt: parseInt(minData.SoundPosInt, 10),
        SoundTriggerTime: parseFloat(minData.SoundTriggerTime, 10)
    };
    
    sendMessage("SetSoundTabPosInfo", jsonmsg);
    waitingData = []; // Reset waitingData for the next comparison
}

var connectedCameras;

function updatemicGetCameraList(msg){

    gConnectedCameras = msg.CamerasArray.filter(camera => camera.IsConnect === "1");

    var Cameraselect = document.getElementById("CameraInformation_Camera_select_" + gDeviceIndex);
    if (!Cameraselect) return;

    if (!msg.CamerasArray) {
        console.error('CamerasArray is undefined');
        return;
    }

    connectedCameras = msg.CamerasArray.filter(camera => camera.IsConnect === "1");

    const selectElementId = "#CameraInformation_Camera_select_" + gDeviceIndex;
    if(selectElementId)    
        $(selectElementId).empty();

    var optionOff = $("<option />").val(-1).text("Off").prop('selected', true);
    if(selectElementId)
        $(selectElementId).append(optionOff);

    if(selectElementId)
    {
        connectedCameras.forEach(camera => {
            var option = $("<option />")
                .val(camera.IPAddress)
                .text(camera.FriendlyName + ' (' + camera.IPAddress + ')');
            $(selectElementId).append(option);
        });
        Cameraselect.addEventListener('change', function() {
            updateCameraInfoCameraselect(this);
        });
    }

}

function deepEqual(array1, array2) {
    // Ensure both parameters are arrays, treat non-arrays as empty arrays
    array1 = Array.isArray(array1) ? array1 : [];
    array2 = Array.isArray(array2) ? array2 : [];
    
    if (array1.length !== array2.length) return false;
    
    for (let i = 0; i < array1.length; i++) {
        const obj1 = array1[i];
        const obj2 = array2[i];
        if (Object.keys(obj1).length !== Object.keys(obj2).length) return false;
        for (const key in obj1) {
            if (obj1[key] !== obj2[key]) return false;
        }
    }
    return true;
}
var lastzonelayoutList = []; 
var gZoneMapprimebarX  = 0;
var gZoneMaproomSizeH  = 0;
var gZoneMaproomSizeV  = 0;
var gcameraDirection   = 0;
var gPopupDeviceType   = 0;
var gcameraAngleOffSet = 0;
var gFirstOpenWebPageZoneMap = false;

function updatedZoneMapDetection(msg){
    var micGroup = getDeviceCameraMappingIndex();
    if(!(document.getElementById("cameraMappingZoneMap_"+micGroup))){
        return;
    }
    if(msg.ZoneMap && ('CameraAngleOffSet' in msg.ZoneMap)){
       //console.log('updatedZoneMapDetection(msg)',msg);
       gcameraAngleOffSet = msg.ZoneMap.CameraAngleOffSet;
       if(document.getElementById("inputAngleOffset_"+msg.SoundTabIndex))
       {
            document.getElementById("inputAngleOffset_"+msg.SoundTabIndex).value = msg.ZoneMap.CameraAngleOffSet;
            
       }
    }
    if(msg.ZoneMap && ('IsOnOff' in msg.ZoneMap)){
        if(!msg.ZoneMap.IsOnOff){
            if(document.getElementById("mic_popup_Window_"+msg.SoundTabIndex)){
                document.getElementById("mic_popup_Window_"+msg.SoundTabIndex).style.display = 'none';
                var micGroup = getDeviceCameraMappingIndex();
                var zoommapbutton = document.getElementById('cameraMappingZoneMap_' + micGroup);
                zoommapbutton.disabled = false; 

                var backgroundWindow = document.getElementById('background_block_Window');
                backgroundWindow.style.display = 'none';
            }
        }
        else
        {
            if(!gFirstOpenWebPageZoneMap){
                gFirstOpenWebPageZoneMap = true;
                return;
            }
            if(document.getElementById("mic_popup_Window_"+msg.SoundTabIndex).style.display == 'none'){
                gPopupDeviceType = document.getElementById("deviceTypeSel_"+msg.SoundTabIndex).value;
                createPopupContent(msg.SoundTabIndex);
                var micGroup = getDeviceCameraMappingIndex();
                var zoommapbutton  = document.getElementById('cameraMappingZoneMap_' + micGroup);
                zoommapbutton.disabled = true; 

                var Refresh_Layout = document.getElementById('Refresh_Layout_button_' + msg.SoundTabIndex);
                var Zonelabel = document.getElementById('VoiceSourceDetect_Zone_label_' + msg.SoundTabIndex);
                var Zonelabelvalue = document.getElementById('VoiceSourceDetect_Zone_value_' + msg.SoundTabIndex);
                if(micGroup == 12)
                {
                    Refresh_Layout.disabled = true;
                    Zonelabel.textContent = "Angle :";
                    Zonelabelvalue.textContent = "( -180 ~ 135 )";
                }

                setupMouseCanvas();    
                sendMessage('GetCameraList'); 
                UnblockUIforPage();
                disabledLeftMenuOnPopWindowOpen();
                sendMessage("GetZoneMapDetection",gDeviceIndex);
                sendMessage("GetZoneMapDetection",gDeviceIndex);//recheck Info is Right

                var backgroundWindow = document.getElementById('background_block_Window');
                backgroundWindow.style.display = 'block';
            }
        }        
        var cameraSelect = document.getElementById("CameraInformation_Camera_select_" + msg.SoundTabIndex);
        if(cameraSelect)
        {
            var cameraSelectIndex = parseInt(cameraSelect.value,10);
            if(cameraSelectIndex == -1)
            {
                var canvas = document.getElementById('xy-canvas_camera_' + msg.SoundTabIndex);
                if (canvas) {
                    var ctx = canvas.getContext('2d');
                    ctx.clearRect(0, 0, canvas.width, canvas.height);
                }
                var miccanvas = document.getElementById('xy-canvas_microphone_' + msg.SoundTabIndex);
                if (miccanvas) {
                    var ctx = miccanvas.getContext('2d');
                    ctx.clearRect(0, 0, miccanvas.width, miccanvas.height);
                }
                var arrowheadcanvas = document.getElementById('xy-canvas_arrowheadpos_' + msg.SoundTabIndex);
                if (arrowheadcanvas) {
                    var ctx = arrowheadcanvas.getContext('2d');
                    ctx.clearRect(0, 0, arrowheadcanvas.width, arrowheadcanvas.height);
                }
            }
        }
    }
    if(msg.ZoneMap && ('anchorX' in msg.ZoneMap) && ('anchorY' in msg.ZoneMap) && ('camLocationX' in msg.ZoneMap) && ('camLocationY' in msg.ZoneMap)){
        console.log('msg.ZoneMap && (anchorX in msg.ZoneMap) && (anchorY',msg);
        if(document.getElementById("CameraInformation_Anchor_xvalue_input_"+msg.SoundTabIndex)){
            document.getElementById("CameraInformation_Anchor_xvalue_input_"+msg.SoundTabIndex).value = msg.ZoneMap.anchorX;
        }
        if(document.getElementById("CameraInformation_Anchor_yvalue_input_"+msg.SoundTabIndex)){
            document.getElementById("CameraInformation_Anchor_yvalue_input_"+msg.SoundTabIndex).value = msg.ZoneMap.anchorY;
        }
        if(document.getElementById("CameraInformation_LocationXY_xvalue_input_"+msg.SoundTabIndex)){
            document.getElementById("CameraInformation_LocationXY_xvalue_input_"+msg.SoundTabIndex).value = msg.ZoneMap.camLocationX;
        }
        if(document.getElementById("CameraInformation_LocationXY_yvalue_input_"+msg.SoundTabIndex)){
            document.getElementById("CameraInformation_LocationXY_yvalue_input_"+msg.SoundTabIndex).value = msg.ZoneMap.camLocationY;
        }
        if(document.getElementById("CameraInformation_OffsetAngle_value_"+msg.SoundTabIndex)){
            document.getElementById("CameraInformation_OffsetAngle_value_"+msg.SoundTabIndex).textContent = msg.ZoneMap.angleOffset;
        }
        if(document.getElementById("CameraInformation_OffsetAngle_input_"+msg.SoundTabIndex))
        {
            document.getElementById("CameraInformation_OffsetAngle_input_" + msg.SoundTabIndex).value = msg.ZoneMap.angleOffset;
            let OffsetAngleinput = document.getElementById("CameraInformation_OffsetAngle_input_" + msg.SoundTabIndex).value;
            let OffsetAnglevalue = document.getElementById("CameraInformation_OffsetAngle_value_"+msg.SoundTabIndex).textContent;
            if(OffsetAngleinput != OffsetAnglevalue)
            {
                OffsetAngleinput = OffsetAnglevalue;
            }
        }

        if(document.getElementById("CameraInformation_connectCheckboxInput_"+msg.SoundTabIndex)){
            document.getElementById("CameraInformation_connectCheckboxInput_"+msg.SoundTabIndex).checked = msg.ZoneMap.CameraInfoOnOff;
        }

        if(document.getElementById("CameraInformation_OffsetAngle_value_"+msg.SoundTabIndex))
        {
            gcameraCoordinateAngle = msg.ZoneMap.cameraRotationAngle;
        }

        if(document.getElementById("CameraInformation_Direction_select_"+msg.SoundTabIndex))
        {
            var cameraDirection = document.getElementById('CameraInformation_Direction_select_' + gDeviceIndex);
            cameraDirection.value = msg.ZoneMap.CameraDirection;
            gcameraDirection = cameraDirection.value;
        }

        if(msg.ZoneMap.CameraInfoOnOff){
            gClearFixedCameraIcon = 0;
            canvasupdatecameraXY();
            updateCameraDirectionArrowHead(); 
            var deviceType = document.getElementById('deviceTypeSel_' + msg.SoundTabIndex).value;
            let deviceTypeString = transferDeviceTypeToString(deviceType);         
            if(deviceTypeString !== 'Nureva:HDL410(Coordinate)')
            {
                canvasupdatemicXY();
            }
        }
        else{
            var canvas1 = document.getElementById('xy-canvas_camera_' + gDeviceIndex);
            var canvas2 = document.getElementById('xy-canvas_microphone_' + gDeviceIndex);
            var canvas3 = document.getElementById('xy-canvas_arrowheadpos_' + gDeviceIndex);
            if (canvas1) {
                var ctx = canvas1.getContext('2d');
                ctx.clearRect(0, 0, canvas1.width, canvas1.height);
            }
            if (canvas2) {
                var ctx = canvas2.getContext('2d');
                ctx.clearRect(0, 0, canvas2.width, canvas2.height);
            }
            if (canvas3) {
                var ctx = canvas3.getContext('2d');
                ctx.clearRect(0, 0, canvas3.width, canvas3.height);
            }
        }
        var cameraSelect = document.getElementById("CameraInformation_Camera_select_" + msg.SoundTabIndex);
        if(cameraSelect)
        {
            var cameraSelectIndex = parseInt(cameraSelect.value,10);
            if(cameraSelectIndex == -1)
            {
                var canvas = document.getElementById('xy-canvas_camera_' + msg.SoundTabIndex);
                if (canvas) {
                    var ctx = canvas.getContext('2d');
                    ctx.clearRect(0, 0, canvas.width, canvas.height);
                }
                var miccanvas = document.getElementById('xy-canvas_microphone_' + msg.SoundTabIndex);
                if (miccanvas) {
                    var ctx = miccanvas.getContext('2d');
                    ctx.clearRect(0, 0, miccanvas.width, miccanvas.height);
                }
                var arrowheadcanvas = document.getElementById('xy-canvas_arrowheadpos_' + msg.SoundTabIndex);
                if (arrowheadcanvas) {
                    var ctx = arrowheadcanvas.getContext('2d');
                    ctx.clearRect(0, 0, arrowheadcanvas.width, arrowheadcanvas.height);
                }
            }
        }
    }
    if(msg.ZoneMap && ('Title' in msg.ZoneMap)){
        if(document.getElementById("Environment_Layout_label_"+msg.SoundTabIndex)){
            document.getElementById("Environment_Layout_label_"+msg.SoundTabIndex).textContent = msg.ZoneMap.Title;
        }
    }
    if(msg.ZoneMap && ('roomSizeH' in msg.ZoneMap) && ('roomSizeV' in msg.ZoneMap)){
        if(document.getElementById("Room_Size_H_value_"+msg.SoundTabIndex)){
            document.getElementById("Room_Size_H_value_"+msg.SoundTabIndex).textContent = (msg.ZoneMap.roomSizeH/1000).toFixed(1);
        }
        if(document.getElementById("Room_Size_V_value_"+msg.SoundTabIndex)){
            document.getElementById("Room_Size_V_value_"+msg.SoundTabIndex).textContent = (msg.ZoneMap.roomSizeV/1000).toFixed(1);
        }
    }
    if(msg.ZoneMap && ('micName' in msg.ZoneMap) && ('micIPAddress' in msg.ZoneMap) && ('zoneQtyNum' in msg.ZoneMap)){
        if(document.getElementById("ArrayMicrophone_Microphone_value_"+msg.SoundTabIndex)){
            document.getElementById("ArrayMicrophone_Microphone_value_"+msg.SoundTabIndex).textContent = msg.ZoneMap.micName;
        }
        if(document.getElementById("ArrayMicrophone_IPAddress_value_"+msg.SoundTabIndex)){
            document.getElementById("ArrayMicrophone_IPAddress_value_"+msg.SoundTabIndex).textContent =  msg.ZoneMap.micIPAddress;
            document.getElementById("ArrayMicrophone_IPAddress_value_"+msg.SoundTabIndex).style.textAlign = "center";
        }
        if(document.getElementById("ArrayMicrophone_ZoneQty_value_"+msg.SoundTabIndex)){
            document.getElementById("ArrayMicrophone_ZoneQty_value_"+msg.SoundTabIndex).textContent = msg.ZoneMap.zoneQtyNum;
        }
    }
    if(msg.ZoneMap && (('ZoneNum' in msg.ZoneMap))){
        if(document.getElementById("VoiceSourceDetect_Zone_value_"+msg.SoundTabIndex)){
            document.getElementById("VoiceSourceDetect_Zone_value_"+msg.SoundTabIndex).textContent = msg.ZoneMap.ZoneNum;
        }
    }
    if(msg.ZoneMap && ('cameraInfo' in msg.ZoneMap)){
        if(document.getElementById("VoiceSourceDetect_Camera_value_"+msg.SoundTabIndex)){
            document.getElementById("VoiceSourceDetect_Camera_value_"+msg.SoundTabIndex).textContent = msg.ZoneMap.cameraInfo;
            document.getElementById("VoiceSourceDetect_Camera_value_"+msg.SoundTabIndex).style.textAlign = "center";
        }
    }
    if(msg.ZoneMap && ('primebarX' in msg.ZoneMap) && ('roomSizeH' in msg.ZoneMap) && ('roomSizeV' in msg.ZoneMap)){
        gZoneMapprimebarX = msg.ZoneMap.primebarX;
        gZoneMaproomSizeH = msg.ZoneMap.roomSizeH;
        gZoneMaproomSizeV = msg.ZoneMap.roomSizeV;
    }
    if(msg.ZoneMap && ('coordinateX' in msg.ZoneMap) && ('coordinateY' in msg.ZoneMap)){  
        if(document.getElementById("VoiceSourceDetect_XY_value_X_"+msg.SoundTabIndex)){
            document.getElementById("VoiceSourceDetect_XY_value_X_"+msg.SoundTabIndex).textContent = msg.ZoneMap.coordinateX;
            document.getElementById("VoiceSourceDetect_XY_value_X_"+msg.SoundTabIndex).style.textAlign = "center";
        }
        if(document.getElementById("VoiceSourceDetect_XY_value_Y_"+msg.SoundTabIndex)){
            document.getElementById("VoiceSourceDetect_XY_value_Y_"+msg.SoundTabIndex).textContent = msg.ZoneMap.coordinateY;
            document.getElementById("VoiceSourceDetect_XY_value_Y_"+msg.SoundTabIndex).style.textAlign = "center";
        }
        if(document.getElementById("CameraInformation_OffsetAngle_value_"+msg.SoundTabIndex))
        {
            gcameraCoordinateAngle   = msg.ZoneMap.cameraRotationAngle;
            gFirstGetCoordinateAngle = 1;
        }
        if(document.getElementById("VoiceSourceDetect_Zone_value_"+msg.SoundTabIndex))
        {
            var zonevalue = document.getElementById("VoiceSourceDetect_Zone_value_"+msg.SoundTabIndex);
            zonevalue.textContent = msg.ZoneMap.ZoneNum;
        }
        if(document.getElementById('CameraInformation_connectCheckboxInput_'+msg.SoundTabIndex))
        {
            var checkbox = document.getElementById('CameraInformation_connectCheckboxInput_'+msg.SoundTabIndex);
            if(checkbox.checked)
            {
                var deviceType = document.getElementById('deviceTypeSel_' + msg.SoundTabIndex).value;
                updateCameraDirectionArrowHead();  
            }
        }
        drawZonemapPos(msg);
    }
    if(msg.ZoneMap && ('zones' in msg.ZoneMap))
    {
        var zonelayoutList = Object.values(msg.ZoneMap.zones).map((zone, index) => ({
            p_1X: zone.zoneX1,
            p_1Y: zone.zoneY1,
            p_2X: zone.zoneX2,
            p_2Y: zone.zoneY2,
            num:  zone.zoneQtyNum,
        }));

        if (!deepEqual(lastzonelayoutList, zonelayoutList)) {
            lastzonelayoutList = [...zonelayoutList]; // Make a shallow copy of zonelayoutList for future comparisons
            var ZoneMapWindowIsReady = 0;
            while(!ZoneMapWindowIsReady){
                drawZoneLayout(zonelayoutList, msg.ZoneMap.primebarX, msg.ZoneMap.roomSizeH, msg.ZoneMap.roomSizeV);
                if(document.getElementById("mic_popup_Window_"+msg.SoundTabIndex))
                    ZoneMapWindowIsReady=1;
            }       
        }
        drawZoneLayout(zonelayoutList, msg.ZoneMap.primebarX, msg.ZoneMap.roomSizeH, msg.ZoneMap.roomSizeV);
    }
    if(msg.ZoneMap && (('cameraSelect' in msg.ZoneMap) || ('cameraArray' in msg.ZoneMap)))
    {
        if ('cameraSelect' in msg.ZoneMap) {
            var cameraSelect = document.getElementById("CameraInformation_Camera_select_" + msg.SoundTabIndex);
            if (cameraSelect) {
                var matchingOption = Array.from(cameraSelect.options).find(option => option.value === msg.ZoneMap.cameraSelect);
                if (matchingOption) {
                    cameraSelect.selectedIndex = matchingOption.index;
                } 
                else {
                    if (msg.ZoneMap.cameraSelect === 'Off') {
                        cameraSelect.selectedIndex = 0;

                        var canvas = document.getElementById('xy-canvas_camera_' + msg.SoundTabIndex);
                        if (canvas) {
                            var ctx = canvas.getContext('2d');
                            ctx.clearRect(0, 0, canvas.width, canvas.height);
                        }
                        var miccanvas = document.getElementById('xy-canvas_microphone_' + msg.SoundTabIndex);
                        if (miccanvas) {
                            var ctx = miccanvas.getContext('2d');
                            ctx.clearRect(0, 0, miccanvas.width, miccanvas.height);
                        }
                        var arrowheadcanvas = document.getElementById('xy-canvas_arrowheadpos_' + msg.SoundTabIndex);
                        if (arrowheadcanvas) {
                            var ctx = arrowheadcanvas.getContext('2d');
                            ctx.clearRect(0, 0, arrowheadcanvas.width, arrowheadcanvas.height);
                        }
                    }
                }
            } 
        }
        
    }
}

function updatedSetYamahaExclusionMode(msg){
    if(document.getElementById("ExclusionMode_connectCheckboxInput_"+msg.SoundTabIndex)){
        document.getElementById("ExclusionMode_connectCheckboxInput_"+msg.SoundTabIndex).checked = msg.Status;
    }
}
function updatedGetYamahaExclusionMode(msg){
    if(document.getElementById("ExclusionMode_connectCheckboxInput_"+msg.SoundTabIndex)){
        document.getElementById("ExclusionMode_connectCheckboxInput_"+msg.SoundTabIndex).checked = msg.Status;
    }
}

function updatedVideoOutputStatus(msg) {
    if (msg.IsStartStreaming == true) 
    {
        UnblockUIforPage();
        gVideoOutputStatus=true;
    }
    else 
    {
        gVideoOutputStatus=false;
    }
    updateVideoOnOffButton(gVideoOutputStatus);

}

function updateSoundDevicePort(msg) {
    $("#DevicePortInput_"+msg.SoundTabIndex).val(msg.Port);
    gNurevaPort = msg.Port;
    var connectCheck = document.getElementById("connectCheckboxInput_"+gDeviceIndex).checked;
    updateDevicePortStatus(getMicSelectIndexByDeviceIndex(msg.MicDeviceIndex),connectCheck);
}


var gVoiceTrackingStatus = false;

function updateGetVoiceTracking(msg) {
    if(msg.Status == true)
    {
        if(document.getElementById("SetVoiceTrackingCheckboxInput"))
            document.getElementById("SetVoiceTrackingCheckboxInput").checked = true;
        if(document.getElementById("btnstreamContainer"))
            document.getElementById("btnstreamContainer").style.display = 'none';

        gVoiceTrackingStatus = true;
    }
    else
    {
        if(document.getElementById("SetVoiceTrackingCheckboxInput"))
            document.getElementById("SetVoiceTrackingCheckboxInput").checked = false;
        if(document.getElementById("btnstreamContainer"))
            document.getElementById("btnstreamContainer").style.display = 'block';

        gVoiceTrackingStatus = false;
    }
}

function updatedShureMXCWSeatName(msg){
    var SoundPosIndex = msg.SoundPosIndex;
    var SourceDeviceName = msg.SourceDeviceName;
    var micTabPage = gDeviceIndex;
    var currentSoundType = document.getElementById("deviceTypeSel_"+micTabPage).value;
    var micSelect = parseInt(currentSoundType);
    var micGroup = getDeviceCameraMappingIndex();
    if(document.getElementById("cameraMappingInput"+ "_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" + (SoundPosIndex))){
        if(micSelect == 4){
            document.getElementById("cameraMappingInput"+ "_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" + (SoundPosIndex)).value = SourceDeviceName;
        }
    }
}

function updateGetSoundSourceData(msg) {

    //console.log('updateGetSoundSourceData',msg);
    var currentSoundTypeIndex = 0;
    if(document.getElementById("deviceTypeSel_"+gDeviceIndex))
    {
        currentSoundTypeIndex = document.getElementById("deviceTypeSel_"+gDeviceIndex).value;
    }
        
    var currentSoundType = gdeviceTypeSelOptions[currentSoundTypeIndex];

    if(msg.SoundTabIndex == gDeviceIndex ){

        var currentSoundTypeIndex = deviceTypeMap[currentSoundType];
        //console.log('currentSoundTypeIndex',currentSoundTypeIndex);
        if (gMicInfoDivMap.hasOwnProperty(currentSoundTypeIndex)) 
        {
            if(document.getElementById(gMicInfoDivMap[currentSoundTypeIndex]))
                document.getElementById(gMicInfoDivMap[currentSoundTypeIndex]).innerText = msg.SourceData;
            //else
            //   console.log('ajdfswge');
        }
        //else
            //console.log('gMicInfoDivMap.hasOwnProperty(currentSoundTypeIndex)',gMicInfoDivMap.hasOwnProperty(currentSoundTypeIndex));
        // if(currentSoundType.includes("Shure:MXA910") || currentSoundType.includes("Shure:MXA920") || currentSoundType.includes("Shure:MXA710")){
        //     // Shure:MXA910, Shure:MXA920, Shure:MXA710 
        //     document.getElementById("micInfo_div1").innerText = msg.SourceData;
        // } else if(currentSoundType.includes("Shure:MXA310")){
        //     // Shure:MXA310
        //     document.getElementById("micInfo_div2").innerText = msg.SourceData;
        // } else if(currentSoundType.includes("Shure:MXCW")){
        //     // Shure:MXCW
        //     document.getElementById("micInfo_div3").innerText = msg.SourceData;
        // } else if(currentSoundType.includes("Sennheiser:TCC2") || currentSoundType.includes("Sennheiser:TCCM")){
        //     // Sennheiser:TCC2, Sennheiser:TCCM
        //     document.getElementById("micInfo_div4").innerText = msg.SourceData;
        // } else if(currentSoundType.includes("Nureva:HDL300") || currentSoundType.includes("Nureva:Dual HDL300")
        //        || currentSoundType.includes("Nureva:HDL310")|| currentSoundType.includes("Nureva:HDL410")){
        //     // Nureva:HDL300, Nureva:Dual HDL300, Nureva:HDL310, Nureva:HDL410
        //     document.getElementById("micInfo_div5").innerText = msg.SourceData;
        // } else if(currentSoundType.includes("Yamaha:RM-CG")){
        //     // Yamaha:RM-CG
        //     document.getElementById("micInfo_div6").innerText = msg.SourceData;
        // } else if(currentSoundType.includes("Yamaha:RM-W")){
        //     // Yamaha:RM-W
        //     document.getElementById("micInfo_div7").innerText = msg.SourceData;
        // } else if(currentSoundType.includes("Audio-Technica:ATND1061")){
        //     // AudioTechnica:ATND1061
        //     document.getElementById("micInfo_div8").innerText = msg.SourceData;
        // }
        // if(currentSoundType.includes("Nureva:HDL410(Coordinate)")){
        //     // Nureva:HDL410(Coordinate)
        //     document.getElementById("micInfo_div9").innerText = msg.SourceData;
        // }
        // if(currentSoundType.includes("Yamaha:RM-CR")){
        //     // Nureva:HDL410(Coordinate)
        //     document.getElementById("micInfo_div10").innerText = msg.SourceData;
        // }
        // if(currentSoundType.includes("Yamaha:RM-TT")){
        //     // Nureva:HDL410(Coordinate)
        //     document.getElementById("micInfo_div11").innerText = msg.SourceData;
        // }
        // if( currentSoundType.includes("Lumens:Virtual Mic"))
        // {
        //     document.getElementById("micInfo_div1").innerText = msg.SourceData;
        // }
    }
}

function updatemicGetSoundPos(msg) {

    //console.log('updateGetSoundPos');
    var currentSoundTypeElement = document.getElementById("deviceTypeSel_"+gDeviceIndex);
    if (!currentSoundTypeElement) return;
    var currentSoundType = currentSoundTypeElement.value;
    
    var deviceTypeSel = parseInt(currentSoundType);
    var deviceMappingIndex=getDeviceCameraMappingIndex();

    var micTabPage = gDeviceIndex;
    var currentSoundType = document.getElementById("deviceTypeSel_"+micTabPage).value;
    var micSelect = parseInt(currentSoundType);
    var micGroup = getDeviceCameraMappingIndex();

    if(msg.SoundTabIndex == gDeviceIndex ){

        if(document.getElementById("Light_div"+ "_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" +msg.PosIndex)){
            if(msg.IsOn == true)
                document.getElementById("Light_div"+ "_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" +msg.PosIndex).src= "./images/Selected.png";
            else if(msg.IsCallPreset == true)
                document.getElementById("Light_div"+ "_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" +msg.PosIndex).src= "./images/SoundCallPreset.png";
            else
                document.getElementById("Light_div"+ "_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" +msg.PosIndex).src= "./images/Disable.png";
        }
        
        if(document.getElementById('ZoneModeVoiceSourceDetect_Microphone_value_'+msg.SoundTabIndex))
        {
            if(msg.IsOn == true)
                document.getElementById('ZoneModeVoiceSourceDetect_Microphone_value_'+msg.SoundTabIndex).textContent = parseInt((msg.PosIndex+1),10); 
        }

        // if(currentSoundType == "0" || currentSoundType == "1" || currentSoundType == "2"){//Shure:MXA910:0 Shure:MXA920:1 Shure:MXA710:2
        //     if(msg.IsOn == true)
        //         document.getElementById("Light_div"+ "_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" +msg.PosIndex).src= "./images/Selected.png";
        //     else
        //         document.getElementById("Light_div"+ "_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" +msg.PosIndex).src= "./images/Disable.png";

        // }else if(currentSoundType == "3"){//Shure:MXA310:3
        //     if(msg.IsOn == true)
        //         document.getElementById("Light_div"+ "_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" +msg.PosIndex).src= "./images/Selected.png";
        //     else
        //         document.getElementById("Light_div"+ "_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" +msg.PosIndex).src= "./images/Disable.png";

        // }else if(currentSoundType == "4"){//Shure:MXCW:4
        //     if(msg.IsOn == true)
        //     document.getElementById("Light_div"+ "_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" +msg.PosIndex).src= "./images/Selected.png";
        // else
        //     document.getElementById("Light_div"+ "_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" +msg.PosIndex).src= "./images/Disable.png";

        // }else if(currentSoundType == "5" || currentSoundType == "6"){//Sennheiser:TCC2:5,Sennheiser:TCCM:6
        //     if(msg.IsOn == true)
        //         document.getElementById("Light_div"+ "_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" +msg.PosIndex).src= "./images/Selected.png";
        //     else
        //         document.getElementById("Light_div"+ "_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" +msg.PosIndex).src= "./images/Disable.png";

        // }else if(currentSoundType == "7" || currentSoundType == "8" || currentSoundType == "9" || currentSoundType == "10"){
        //     //Nureva:HDL300:7,Nureva:Dual HDL300:8,Nureva:HDL310:9,Nureva:HDL410:10
        //     if(msg.IsOn == true)
        //         document.getElementById("Light_div"+ "_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" +msg.PosIndex).src= "./images/Selected.png";
        //     else
        //         document.getElementById("Light_div"+ "_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" +msg.PosIndex).src= "./images/Disable.png";

        // }else if(currentSoundType == "11"){//Yamaha:RM-CG:11
        //     if(msg.IsOn == true)
        //         document.getElementById("Light_div"+ "_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" +msg.PosIndex).src= "./images/Selected.png";
        //     else
        //         document.getElementById("Light_div"+ "_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" +msg.PosIndex).src= "./images/Disable.png";
        // }else if(currentSoundType == "12"){//Yamaha:RM-W:12
        //     if(msg.IsOn == true)
        //         document.getElementById("Light_div"+ "_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" +msg.PosIndex).src= "./images/Selected.png";
        //     else
        //         document.getElementById("Light_div"+ "_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" +msg.PosIndex).src= "./images/Disable.png";
        // }else if(currentSoundType == "13"){//AudioTechnica:ATND1061:13
        //     if(msg.IsOn == true)
        //         document.getElementById("Light_div"+ "_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" +msg.PosIndex).src= "./images/Selected.png";
        //     else
        //         document.getElementById("Light_div"+ "_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" +msg.PosIndex).src= "./images/Disable.png";
        // }
        
    }
}

function updatemicGetNimbleEyePos(msg) {
    var currentSoundTypeElement = document.getElementById("deviceTypeSel_"+gDeviceIndex);
    if (!currentSoundTypeElement) return;
    var currentSoundType = currentSoundTypeElement.value;
    var micTabPage = gDeviceIndex;
    var currentSoundType = document.getElementById("deviceTypeSel_"+micTabPage).value;
    var micSelect = parseInt(currentSoundType);
    var micGroup = getDeviceCameraMappingIndex();

    if(msg.SoundTabIndex == gDeviceIndex ){
        if(document.getElementById("NimbleEyeLight_div"+ "_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" +msg.PosIndex)){
            if(msg.IsOn == true)
                document.getElementById("NimbleEyeLight_div"+ "_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" +msg.PosIndex).src= "./images/Standing_Man_Light.png";
            else
                document.getElementById("NimbleEyeLight_div"+ "_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" +msg.PosIndex).src= "./images/Standing_Man.png";
        }
    }
}

function updateCamAISetting(msg) {

    $('#AISettingModal').modal('show');
    //console.log('msg.IPAddress:',msg.IPAddress);
    //console.log('msg.IsAI_PeopleTrackingEnable:',msg.IsAI_PeopleTrackingEnable);
    //console.log('msg.AI_PeopleTrackingMode:',msg.AI_PeopleTrackingMode);

    document.getElementById("AISettingModelIPAddress").value = msg.IPAddress;

    if(msg.IsAI_PeopleTrackingEnable == true)
        document.getElementById("AISettingModelInput").checked = true;
    else
        document.getElementById("AISettingModelInput").checked = false;

    document.getElementById("SelectAISettingModelPeopleTracking").value = msg.AI_PeopleTrackingMode;
}

function updateSoundDeviceConnect(msg) {

    //console.log('msg.SoundTabIndex:',msg.SoundTabIndex);
    //console.log('msg.Result:',msg.Result);
    
    if(msg.Result == "Success"){
        UnblockUIforPage();
        gSoundConnectReceived = true;
        gSoundRetryCount = 0;
        clearTimeout(gSoundRetryTimer);
        document.getElementById("connectCheckboxInput_"+msg.SoundTabIndex).checked = true;
        document.getElementById("connectCheckboxInput_"+msg.SoundTabIndex).disabled = false;
        document.getElementById("ExclusionMode_connectCheckboxInput_"+msg.SoundTabIndex).disabled = false;

        if(document.getElementById("img_DeviceStatus_"+msg.SoundTabIndex))
        {
            document.getElementById("img_DeviceStatus_"+msg.SoundTabIndex).style.visibility = "visible";
            document.getElementById("img_DeviceStatus_"+msg.SoundTabIndex).src = "./images/MicDisconnect.png";
        }

        document.getElementById("deviceTypeSel_"+msg.SoundTabIndex).disabled = true;
        document.getElementById("DeviceIPInput_"+msg.SoundTabIndex).disabled = true;
        document.getElementById("DevicePortInput_"+msg.SoundTabIndex).disabled = true;
        document.getElementById("PasswordInput_"+msg.SoundTabIndex).disabled = true;
        document.getElementById("DeviceAPIKeyInput_"+msg.SoundTabIndex).disabled = true;
        document.getElementById("InputModelAudioTrigger_"+msg.SoundTabIndex).disabled = true;

        setDeviceCertificateDisabled(msg.SoundTabIndex,true);
        
        if(!gIsUseGlobalBackToHomeControl)
        {
            document.getElementById("InputModelHomePosition_"+msg.SoundTabIndex).disabled = true;

            document.getElementById("SelectModelHomeTimes_"+msg.SoundTabIndex).disabled = true;
            document.getElementById("SelectModelHomeCamera_"+msg.SoundTabIndex).disabled = true;
            document.getElementById("SelectModelHomePosition_"+msg.SoundTabIndex).disabled = true;
        }        
        else
        {
            if(document.getElementById("SelectModelPreset_"+msg.SoundTabIndex))
                document.getElementById("SelectModelPreset_"+msg.SoundTabIndex).disabled = true;

            var backHomeSetting   = document.getElementById("BtnModelBackToHomeSetting_" +msg.SoundTabIndex);
            if(backHomeSetting)
            {
                backHomeSetting.disabled = true;
            }
        }

        document.getElementById("BtnModelCancel_"+msg.SoundTabIndex).disabled = true;
        document.getElementById("BtnModelApply_"+msg.SoundTabIndex).disabled = true;
    }
    else
    {
        gSoundConnectReceived = true;
        gSoundRetryCount = 0;
        clearTimeout(gSoundRetryTimer);
        UnblockUIforPage();
        //document.getElementById("connectCheckboxInput_"+msg.SoundTabIndex).checked = false;
        //alert(msg.Result);//alert('Microphone cannot be found, please check Microphone connection status and try to connect it again.');
        if(document.getElementById("img_DeviceStatus_"+msg.SoundTabIndex))
        {
            document.getElementById("img_DeviceStatus_"+msg.SoundTabIndex).style.visibility = "visible";
            document.getElementById("img_DeviceStatus_"+msg.SoundTabIndex).src = "./images/MicDisconnect.png";
        }
    }
}

function ResetCameraMappingLightIcon(){
    var micTabPage = gDeviceIndex;
    var currentSoundType = document.getElementById("deviceTypeSel_" + micTabPage).value;
    var micSelect = parseInt(currentSoundType);
    var micGroup = getDeviceCameraMappingIndex();
    var selectMicChannelIndex = parseInt(document.getElementById('selectMicChannel_' + micGroup).value);

    for (var i = 0; i < selectMicChannelIndex; i++) {
        var lightDiv = document.getElementById("Light_div_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" + i);
        if (lightDiv) {
            lightDiv.src = "./images/Disable.png";
        }
    }
}

function updatedSecondaryCameraMap(msg) {
    gVideoOutputSwichingMode = msg.SwitchingMode;

    let micTabPage = gDeviceIndex;
    var deviceTypeSel = document.getElementById("deviceTypeSel_"+micTabPage);
    
    if(!deviceTypeSel) 
    {
        return;
    }

    let micSelect = parseInt(deviceTypeSel.value);
    let deviceTypeString = transferDeviceTypeToString(deviceTypeSel.value); 
    

    let micGroup = getDeviceCameraMappingIndex();
    if(!document.getElementById("selectMicChannel_" + micGroup))
        return;

    var selectChannel = document.getElementById("selectMicChannel_" + micGroup).value;
    var micSelectChannel = parseInt(selectChannel);
    var HandFreeCheckbox=document.getElementById("HandFreeMode_connectCheckboxInput_"+gDeviceIndex);
    //console.log('HandFreeCheckbox:',HandFreeCheckbox);
    //console.log('micGroup:',micGroup);
    //console.log('micTabPage:',micTabPage);
    var isEnableHandFree = false;
    if(HandFreeCheckbox)
      isEnableHandFree = HandFreeCheckbox.checked;

    for (var arrayIndex = 0; arrayIndex < micSelectChannel; arrayIndex++) 
    {
       var cameraMappingSecondSelectItem = $("#cameraMappingSecondSeleceItem_div_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" + arrayIndex);
         
        if(gVideoOutputSwichingMode== 0) //Seamless
        {
            if(isEnableHandFree)
                cameraMappingSecondSelectItem.disabled = true;
            else
                cameraMappingSecondSelectItem.disabled = false;
            
            if(deviceTypeString.includes("Coordinate"))
            {
                var XYinputcheckboxValue = $("#cameraMappingXYinputcheckbox_div_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" + arrayIndex).prop('checked');
                if(XYinputcheckboxValue)
                {
                    cameraMappingSecondSelectItem.disabled = true;
                }
                else
                {
                    if(isEnableHandFree)
                        cameraMappingSecondSelectItem.disabled = true;
                    else
                        cameraMappingSecondSelectItem.disabled = false;
                }
            }
        }
        else //NoSwitching
        {
            cameraMappingSecondSelectItem.disabled = true;
        }
    }
   

}

function updateMicEnableHandFree(msg)
{   
    let micGroup = getDeviceCameraMappingIndex();
    //$("#HandFreeMode_connectCheckboxInput_" + msg.SoundTabIndex).prop('checked',msg.IsEnable);
    var HandFreeCheckbox=document.getElementById("HandFreeMode_connectCheckboxInput_"+msg.SoundTabIndex);
    gIsEnableHandFree =  msg.IsEnable;

    if(HandFreeCheckbox)
    {
        HandFreeCheckbox.checked = gIsEnableHandFree;
        //onChangeCameraItem();
    }

}



var glastCameraMappingCache = {};

function isCameraMappingEqual(msg1, msg2) 
{
    if (!msg1 || !msg2) return false;


    const map1 = msg1.SoundCamMap;
    const map2 = msg2.SoundCamMap;

    if (!map1 || !map2) return true;

    console.log('map1',map1,'map2',map2);
    if (map1.PresetShowNum !== map2.PresetShowNum) 
        return false;

    const mapArray1 = map1.PresetLinkMap?.MapArray || [];
    const mapArray2 = map2.PresetLinkMap?.MapArray || [];
    if (mapArray1.length !== mapArray2.length) return false;
    for (let i = 0; i < mapArray1.length; i++) {
        const item1 = mapArray1[i];
        const item2 = mapArray2[i];
        if (
            item1.PosIndex !== item2.PosIndex ||
            item1.Camera !== item2.Camera ||
            item1.SecondCamera !== item2.SecondCamera ||
            item1.Preset !== item2.Preset ||
            item1.AIPeopleTrackingMode !== item2.AIPeopleTrackingMode ||
            item1.XyMode !== item2.XyMode
        ) {
            return false;
        }
    }

    const cameraItemArray1 = map1.CameraSelectItems?.CameraItemArray || [];
    const cameraItemArray2 = map2.CameraSelectItems?.CameraItemArray || [];
    if (cameraItemArray1.length !== cameraItemArray2.length) return false;
    for (let i = 0; i < cameraItemArray1.length; i++) {
        const item1 = cameraItemArray1[i];
        const item2 = cameraItemArray2[i];
        if (item1.Camera !== item2.Camera) {
            return false;
        }
    }

    if (map1.AzimuthRange && map2.AzimuthRange) {
        const azimuthArray1 = map1.AzimuthRange.RangeArray || [];
        const azimuthArray2 = map2.AzimuthRange.RangeArray || [];
        if (azimuthArray1.length !== azimuthArray2.length) return false;
        for (let i = 0; i < azimuthArray1.length; i++) {
            const item1 = azimuthArray1[i];
            const item2 = azimuthArray2[i];
            if (item1.RangeIndex !== item2.RangeIndex || item1.From !== item2.From || item1.To !== item2.To) {
                return false;
            }
        }
    } else if (map1.AzimuthRange !== map2.AzimuthRange) {
        return false;
    }

    return true;
}

var gUpdateCameraMappingFirst = false;
let gPreviousUpdateCameraMappingMsg = null;
let gPreviousUpdateCameraMappingMsgHash = null;
let gTryAgainUpdateCameraMapping = false;
function updateCameraMapping(msg){

    const currentMsgHash = JSON.stringify(msg);
    
    if (gPreviousUpdateCameraMappingMsgHash === currentMsgHash && !gTryAgainUpdateCameraMapping) 
    {
        return;
    }

    if(gTryAgainUpdateCameraMapping)
    {
        gTryAgainUpdateCameraMapping = false;
    }

    gPreviousUpdateCameraMappingMsgHash = currentMsgHash;
    gPreviousUpdateCameraMappingMsg = JSON.parse(JSON.stringify(msg)); 

    AiDirector_updateCameraMapping(msg);//for AIDirector
    let micTabPage = gDeviceIndex;
    var deviceTypeSel = document.getElementById("deviceTypeSel_"+micTabPage);
    
    if(!deviceTypeSel) return;

    let micSelect = parseInt(deviceTypeSel.value); 
    let deviceTypeString = transferDeviceTypeToString(deviceTypeSel.value); 

    let micGroup = getDeviceCameraMappingIndex();
    let selectMicChannel = document.getElementById("selectMicChannel_"+micGroup);


    const cameraMapArray = msg.SoundCamMap.PresetLinkMap?.MapArray || [];
    const cameraItemArray = msg.SoundCamMap.CameraSelectItems?.CameraItemArray || [];

    let cameraMappingApply  = document.getElementById("cameraMappingApply_" + micGroup);
    let cameraMappingCancel = document.getElementById("cameraMappingCancel_" + micGroup);

    let AIPeopleTrackingModeMapArray = msg.SoundCamMap.PresetLinkMap.MapArray;
    let XYinputcheckboxMapArray = msg.SoundCamMap.PresetLinkMap.MapArray;

    if(!selectMicChannel) 
        return;

    selectMicChannel.value = msg.SoundCamMap.PresetShowNum;

    if(gSelectMicChannelChange == 1){
        cameraMappingApply.disabled = false;
        cameraMappingCancel.disabled = false;
    }

    if(selectMicChannel.value == cameraMapArray.length){
        cameraMappingApply.disabled = true;
        cameraMappingCancel.disabled = true;
    }
    // if(!gFirstInitWebTab_flag){
    //     syncDeviceShowTabName();
    // }

    SelectMicChannelOnChange();

    var HandFreeCheckbox=document.getElementById("HandFreeMode_connectCheckboxInput_"+gDeviceIndex);
    var isEnableHandFree = false;
    if(HandFreeCheckbox)
       isEnableHandFree = HandFreeCheckbox.checked;

    for(let micindex=0;micindex<msg.SoundCamMap.PresetShowNum;micindex++)
    {
        $("#cameraMappingAIPeopleTrackingModeSeleceItem_div_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" + micindex).val(AIPeopleTrackingModeMapArray[micindex].AIPeopleTrackingMode);
        $("#cameraMappingXYinputcheckbox_div_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" + micindex).prop('checked', XYinputcheckboxMapArray[micindex].XyMode);
   
        if(document.getElementById("cameraMappingXYinputcheckbox_div_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" + micindex))
        {
            if(isEnableHandFree)
                document.getElementById("cameraMappingXYinputcheckbox_div_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" + micindex).disabled = true;
            else
                document.getElementById("cameraMappingXYinputcheckbox_div_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" + micindex).disabled = false;
        }

        if(gVideoOutputSwichingMode== 0) //SeamlessSwitching
        {
            if(deviceTypeString.includes("Coordinate"))
            {
                if( XYinputcheckboxMapArray[micindex].XyMode)
                {
                    if(document.getElementById("cameraMappingSecondSeleceItem_div_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" + micindex))
                        document.getElementById("cameraMappingSecondSeleceItem_div_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" + micindex).disabled = true;
                }
                else
                {
                    if(document.getElementById("cameraMappingSecondSeleceItem_div_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" + micindex))
                    {
                        if(isEnableHandFree)
                            document.getElementById("cameraMappingSecondSeleceItem_div_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" + micindex).disabled = true;
                        else
                            document.getElementById("cameraMappingSecondSeleceItem_div_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" + micindex).disabled = false;
                    }
                }
            }
            else
            {
                if(document.getElementById("cameraMappingSecondSeleceItem_div_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" + micindex))
                {
                    if(isEnableHandFree)
                        document.getElementById("cameraMappingSecondSeleceItem_div_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" + micindex).disabled = true;
                    else
                        document.getElementById("cameraMappingSecondSeleceItem_div_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" + micindex).disabled = false;
                }               
            }
        }
        else
        {
            if(document.getElementById("cameraMappingSecondSeleceItem_div_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" + micindex))
                document.getElementById("cameraMappingSecondSeleceItem_div_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" + micindex).disabled = true;
        }
    }

    for(var j=0;j<cameraMapArray.length;j++)
    {
        $("#cameraMappingSeleceItem_div"+ "_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" + j+" option").remove();
        var optionOff = $("<option />");
        optionOff.val(-1).text(window.LanguageManager.getTranslatedText("Off"));
        $("#cameraMappingSeleceItem_div"+ "_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" + j).append(optionOff);  
        for(var i=0;i<cameraItemArray.length;i++){
            //var option = $("<option />");
            //option.val(cameraItemArray[i].Camera).text(msg.SoundCamMap.CameraSelectItems.CameraItemArray[i].Camera);
            //console.log("cameraItemArray[i].Camera:",cameraItemArray[i].Camera);
            var option = document.createElement("option");
            option.value = cameraItemArray[i].Camera;
            option.textContent = msg.SoundCamMap.CameraSelectItems.CameraItemArray[i].Camera;
            if(checkCamConnectStatus(cameraItemArray[i].Camera))
                option.style.color = "#000000";
            else
                option.style.color = "#b01726";

            $("#cameraMappingSeleceItem_div"+ "_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" + j).append(option);
        }

        if(parseInt(cameraMapArray[j].Camera) != -1){
            $("#cameraMappingSeleceItem_div"+ "_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" + j).val(cameraMapArray[j].Camera);
            if(document.getElementById("cameraMappingSeleceItem_div_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" + j))
            {
                if(checkCamConnectStatus(cameraMapArray[j].Camera))
                    document.getElementById("cameraMappingSeleceItem_div_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" + j).style.color = "#000000";
                else
                    document.getElementById("cameraMappingSeleceItem_div_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" + j).style.color = "#b01726";
            }

        }

        $("#cameraMappingSecondSeleceItem_div"+ "_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" + j+" option").remove();
        var secOptionOff = $("<option />");
        secOptionOff.val(-1).text(window.LanguageManager.getTranslatedText("Off"));
        $("#cameraMappingSecondSeleceItem_div"+ "_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" + j).append(secOptionOff);  
        for(var i=0;i<cameraItemArray.length;i++){
            var option = $("<option />");
            option.val(cameraItemArray[i].Camera).text(msg.SoundCamMap.CameraSelectItems.CameraItemArray[i].Camera);
            $("#cameraMappingSecondSeleceItem_div"+ "_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" + j).append(option);
        }

        if(parseInt(cameraMapArray[j].SecondCamera) != -1){
            $("#cameraMappingSecondSeleceItem_div"+ "_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" + j).val(cameraMapArray[j].SecondCamera);
        }

        $("#cameraMappingPreset_div"+ "_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" + j).val(cameraMapArray[j].Preset);
    }
    
    if(deviceIsAzimuth){
        if(msg.SoundCamMap.AzimuthRange){
            var AzimuthRangeArray = msg.SoundCamMap.AzimuthRange.RangeArray;
            if(selectMicChannel.value == AzimuthRangeArray.length){
                if(AzimuthRangeArray != undefined){      
                    for(var j=0;j<cameraMapArray.length;j++){
                        if(document.getElementById("cameraMappingAzimuth_div_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" + (j + 1) + "_1"))
                            $("#cameraMappingAzimuth_div_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" + (j + 1) + "_1").val(AzimuthRangeArray[j].From);
                        if(document.getElementById("cameraMappingAzimuth_div_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" + (j + 1) + "_2"))
                            $("#cameraMappingAzimuth_div_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" + (j + 1) + "_2").val(AzimuthRangeArray[j].To);
                    }
                }
            }
        }
    }

    ResetCameraMappingLightIcon();
    onChangecameraMappingPresetStatus('true');

    setTimeout(getMicTabIsGettingUnblockUIforPage(),1000);
    
}

//-----MIC
function createNewMicMappingTable(micArryNum){
    let devicesel = document.getElementById("deviceTypeSel_"+gDeviceIndex);
    let deviceType = transferDeviceTypeToString(devicesel.value); 
    let deviceTypeIndex = gdeviceTypeSelOptions.indexOf(deviceType);

    let micTabPage = gDeviceIndex;
    let micSelect = deviceTypeIndex;
    let micGroup = getDeviceCameraMappingIndex();
    let selectMicChannelcount = document.getElementById("selectMicChannel_"+micGroup);

    updateDeviceChannelStatus();
     
    // switch (deviceType) {
    //     case "Shure:MXA910":
    //     case "Shure:MXA920":
    //     case "Shure:MXA310":
    //       setMicChannelOptions(8, true);
    //     break;
    //     case "Shure:MXA710":
    //       setMicChannelOptions([4, 8], false);
    //     break;
    //     case "Shure:MXCW":
    //       setMicChannelOptions(125, true);
    //     break;
    //     case "Shure:P300":
    //         setMicChannelOptions(14, true);
    //     break;
    //     case "Sennheiser:TCC2":
    //     case "Sennheiser:TCCM":
    //     case "Nureva:HDL300":
    //     case "Nureva:Dual HDL300":
    //     case "Nureva:HDL310":
    //     case "Nureva:HDL410":
    //     case "Yamaha:RM-CG":
    //     case "Lumens:Virtual Mic":
    //       setMicChannelOptions([8, 16, 32, 64, 128], false);
    //     break;
    //     case "Nureva:HDL410(Coordinate)":
    //         setMicChannelOptions(8, true); 
    //     break;
    //     case "Yamaha:RM-W":
    //       setMicChannelOptions([8, 16], false);
    //     break;
    //     case "Audio-Technica:ATND1061":
    //       setMicChannelOptions(15, true);
    //     break;
    //     case "Yamaha:RM-CR":
    //         setMicChannelOptions(16, true);
    //     break;
    //     case "Yamaha:RM-TT":
    //         setMicChannelOptions(1, true);
    //     break;
    // }

    // function setMicChannelOptions(options, disabled) {
    //     selectMicChannelcount.innerHTML = "";
    
    //     if (!Array.isArray(options)) {
    //         options = [options];
    //     }
    
    //     options.forEach((option) => {
    //         const element = document.createElement("option");
    //         element.text = option.toString();
    //         element.value = option.toString();
    //         selectMicChannelcount.appendChild(element);
    //     });
    
    //     selectMicChannelcount.disabled = disabled;
    // }
    
    // const deviceTypesMatchingPos = ["Shure:MXA910", "Shure:MXA920", "Shure:MXA710", "Shure:MXA310", "Nureva:HDL410(Coordinate)", "Yamaha:RM-W", "Audio-Technica:ATND1061"];
    // const deviceTypesMatchingAzimuth = ["Sennheiser:TCC2", "Sennheiser:TCCM", "Nureva:HDL300", "Nureva:Dual HDL300", "Nureva:HDL310", "Nureva:HDL410", "Yamaha:RM-CG"];
    const mxcwSelector = 'cameraMappingInput_' + micTabPage + '_' + micSelect + '_' + micGroup + '_';

    // if (deviceTypesMatchingPos.includes(deviceType)) {
    //     console.log('deviceTypesMatchingPos == >',deviceType);
    //   generateCameraPosMappingTable(micArryNum);
    // }
    // else if (deviceTypesMatchingAzimuth.includes(deviceType)) {
    //     console.log('deviceTypesMatchingAzimuth == >',deviceType);
    //   generateCameraAzimuthMappingTable(micArryNum);
    // }

    if (deviceType.includes('Shure:MXA910') || deviceType.includes('Shure:MXA920') || deviceType.includes('Shure:MXA710') || deviceType.includes('Shure:MXA310') 
     || deviceType.includes('Nureva:HDL410(Coordinate)') || deviceType.includes('Yamaha:RM-W') || deviceType.includes('Audio-Technica:ATND1061') || deviceType.includes('Audio-Technica:ATUC-50CU')
     || deviceType.includes('Yamaha:RM-CR') || deviceType.includes('Yamaha:RM-TT') || deviceType.includes('Lumens:Virtual Mic')) {
        generateCameraPosMappingTable(micArryNum);
    }

    if (deviceType.includes('Sennheiser:TCC2') || deviceType.includes('Sennheiser:TCCM') 
     || deviceType.includes('Nureva:HDL300') || deviceType.includes('Nureva:Dual HDL300') || deviceType.includes('Nureva:HDL310') || deviceType.includes('Nureva:HDL410')
     || deviceType.includes('Yamaha:RM-CG')) {
        generateCameraAzimuthMappingTable(micArryNum);
    }

    if (deviceType.includes('Shure:MXCW')) {
        console.log('deviceTypesMatchi Shure:MXCW == >',deviceType);
        generateCameraPosMappingTable(micArryNum);
        for (let i = 0; i < micArryNum; i++) {
            const mxcwarray = document.getElementById(mxcwSelector + (i + 1));
            if (mxcwarray){
                mxcwarray.style.cssText = "border-radius:3px; width:100px;";
                mxcwarray.disabled = false;
            } 
        }
    } 

    selectMicChannelcount.value = micArryNum.toString();
}

function deviceIsAzimuth(){
    let devicesel = document.getElementById("deviceTypeSel_"+gDeviceIndex);
    let deviceType = transferDeviceTypeToString(devicesel.value); 
    switch (deviceType) {
        case "Shure:MXA910":case "Shure:MXA920":
        case "Shure:MXA310":case "Shure:MXA710":
        case "Shure:MXCW":
        case "Shure:P300":
        case "Nureva:HDL410(Coordinate)":
        case "Yamaha:RM-W":case "Yamaha:RM-CR":case "Yamaha:RM-TT":
        case "Audio-Technica:ATND1061": case "Lumens:Virtual Mic":
        case "Audio-Technica:ATND1061(Coordinate)":
        case "Audio-Technica:ATUC-50CU":
            return 0;

        case "Sennheiser:TCC2":case "Sennheiser:TCCM":
        case "Nureva:HDL300":case "Nureva:Dual HDL300":
        case "Nureva:HDL310":case "Nureva:HDL410":
        case "Yamaha:RM-CG":
            return 1;
    }
}

function deviceChannelSelectIsDisable(){
    let devicesel = document.getElementById("deviceTypeSel_"+gDeviceIndex);
    let deviceType = transferDeviceTypeToString(devicesel.value);
    switch (deviceType) {
        case "Shure:MXA910":case "Shure:MXA920":
        case "Shure:MXA310":case "Shure:MXCW":
        case "Shure:P300":
        case "Nureva:HDL410(Coordinate)":
        case "Yamaha:RM-CR":case "Yamaha:RM-TT":
        case "Audio-Technica:ATND1061":
        case "Audio-Technica:ATND1061(Coordinate)":
        case "Audio-Technica:ATUC-50CU":
            return 1; //Disable
        case "Shure:MXA710": case "Lumens:Virtual Mic":
        case "Sennheiser:TCC2":case "Sennheiser:TCCM":
        case "Nureva:HDL300":case "Nureva:Dual HDL300":
        case "Nureva:HDL310":case "Nureva:HDL410":
        case "Yamaha:RM-CG":case "Yamaha:RM-W":
            return 0;
    }
}

let soundSettingMap = [];
const lastSoundSettingCache = {};

function isSoundSettingEqual(msg1, msg2) 
{
    if (!msg1 || !msg2) return false;

    const setting1 = msg1.SoundSetting;
    const setting2 = msg2.SoundSetting;

    return (
        setting1.MicDeviceIndex === setting2.MicDeviceIndex &&
        setting1.IPAddress === setting2.IPAddress &&
        setting1.Port === setting2.Port &&
        setting1.Password === setting2.Password &&
        setting1.APIKey === setting2.APIKey &&
        setting1.isConnect === setting2.isConnect
    );
}

function setMicChannelOptions(options, disabled) 
{
    let micGroup = getDeviceCameraMappingIndex();
    let selectMicChannelcount = document.getElementById("selectMicChannel_"+micGroup);
    selectMicChannelcount.innerHTML = "";

    if (!Array.isArray(options)) {
        options = [options];
    }

    options.forEach((option) => {
        const element = document.createElement("option");
        element.text = option.toString();
        element.value = option.toString();
        selectMicChannelcount.appendChild(element);
    });

    selectMicChannelcount.disabled = disabled;
}

let gUpdateSoundSettingLastMsg = null; 

function updateSoundSetting(msg) 
{
    updateZoneFullMapMicConnection(msg);
    
    if (msg.CertificateStatus) 
    {
        const certName = msg.CertificateStatus.CertificateFileName;
        const keyName = msg.CertificateStatus.PrivateKeyFileName;
        if (certName) 
        {
            const certButton = document.getElementById("CertificateButton_" + gDeviceIndex);
            if (certButton && certButton.title !== certName) 
            {
                setSuccessStyle(certButton, certName);
            }
        }
        if (keyName) 
        {
            const keyButton = document.getElementById("PrivateKeyButton_" + gDeviceIndex);
            if (keyButton && keyButton.title !== keyName) 
            {
                setSuccessStyle(keyButton, keyName);
            }
        }
    }

    const index = msg.SoundTabIndex;
    if (gPendingSoundSettingFlags[index]) 
    {
        gPendingSoundSettingFlags[index] = false;
    }
    gTryAgainUpdateCameraMapping = true;

    // const currentMsgString = JSON.stringify(msg);
    
    // if (gUpdateSoundSettingLastMsg && gUpdateSoundSettingLastMsg === currentMsgString) {
    //     if(msg.SoundTabIndex != gDeviceIndex)
    //     {
    //         console.log('Duplicate msg detected, skipping processing.');
    //         return;
    //     }

    // }

    // gUpdateSoundSettingLastMsg = currentMsgString;

    var showTabIndex;
        showTabIndex = msg.SoundTabIndex+1;

    if(document.getElementById("A_tabDevice_"+msg.SoundTabIndex))
        document.getElementById("A_tabDevice_"+msg.SoundTabIndex).textContent = showTabIndex+'.'+transferDeviceTypeToString(getMicSelectIndexByDeviceIndex(msg.SoundSetting.MicDeviceIndex)); 

    if(msg.SoundTabIndex != gDeviceIndex)
    {
        return;
    }

    if(!soundSettingMap[msg.SoundTabIndex])
    {
        soundSettingMap[msg.SoundTabIndex] = [];
    }
    soundSettingMap[msg.SoundTabIndex] = msg.SoundSetting.isConnect;


    let deviceTypeSel               = document.getElementById("deviceTypeSel_"+msg.SoundTabIndex);
    let DeviceIPInput               = document.getElementById("DeviceIPInput_"+msg.SoundTabIndex);
    let DevicePortInput             = document.getElementById("DevicePortInput_"+msg.SoundTabIndex);
    let PasswordInput               = document.getElementById("PasswordInput_"+msg.SoundTabIndex);
    let DeviceAPIKey                = document.getElementById("DeviceAPIKeyInput_"+msg.SoundTabIndex);
    let connectCheckboxInput        = document.getElementById("connectCheckboxInput_"+msg.SoundTabIndex);
    let ExclusionModeCheckboxInput  = document.getElementById("ExclusionMode_connectCheckboxInput_"+msg.SoundTabIndex);
    let InputModelAudioTrigger      = document.getElementById("InputModelAudioTrigger_"+msg.SoundTabIndex);
    let AudioLevel                  = document.getElementById("audioLevel_" + gDeviceIndex);
    let SelectModelPreset           = document.getElementById("SelectModelPreset_"+msg.SoundTabIndex);
    let BackToHomeSetting           = document.getElementById("BtnModelBackToHomeSetting_"+msg.SoundTabIndex);

    let selectChannel;
    let deviceTypeIndex;
    let micGroup;
    let micSelectChannel;
    let deviceType;
    let showAudioLevel;

    if(!deviceTypeSel||!DeviceIPInput||!DevicePortInput||!PasswordInput||!DeviceAPIKey) return;

    // if(document.getElementById("deviceCntSel"))
    //     tabcount = document.getElementById("deviceCntSel").value; 

    gNurevaPort = msg.SoundSetting.Port

    document.getElementById("content_Device_" + gDeviceIndex).style.display = "block";
    document.getElementById("div_Advanced_" + gDeviceIndex).style.display = "block";

    deviceTypeSel.value = getMicSelectIndexByDeviceIndex(msg.SoundSetting.MicDeviceIndex);
    deviceType = transferDeviceTypeToString(deviceTypeSel.value);
    deviceTypeIndex = parseInt(deviceTypeSel.value);
    DeviceIPInput.value = msg.SoundSetting.IPAddress;
    DevicePortInput.value = msg.SoundSetting.Port;
    PasswordInput.value = msg.SoundSetting.Password;
    DeviceAPIKey.value = msg.SoundSetting.APIKey;



    let contentHeight = '174px';
    if(deviceType == 'Sennheiser:TCCM' || deviceType == 'Sennheiser:TCCM(Coordinate)' || 
       deviceType == 'Yamaha:RM-CG'    || deviceType == 'Yamaha:RM-CG(Coordinate)')
    {
        contentHeight = '222px';
    }
    document.getElementById("content_Device_" + gDeviceIndex).style.height = contentHeight;

    if(deviceType == 'Yamaha:RM-CG' || deviceType == 'Yamaha:RM-CG(Coordinate)')
    {
        $("#ExclusionMode_"+gDeviceIndex).show();
    }
    else
    {
        $("#ExclusionMode_"+gDeviceIndex).hide();
    }

    if(deviceType == 'Sennheiser:TCCM' || deviceType == 'Sennheiser:TCCM(Coordinate)')
    {
        $("#password_"+gDeviceIndex).show();
    }
    else
    {
        $("#password_"+gDeviceIndex).hide();
    }
    if(deviceType == 'Televic:D-Cerno AE(HTTPS)')
    {
        if(document.getElementById("APICertificate_" + gDeviceIndex))
            $("#APICertificate_"+gDeviceIndex).show();
        if(document.getElementById("APIPrivateKey_" + gDeviceIndex))
            $("#APIPrivateKey_"+gDeviceIndex).show();
        if(document.getElementById("APITokens_" + gDeviceIndex))
            $("#APITokens_"+gDeviceIndex).show();
        var connectCustomBox= document.getElementById("div_custom_box_"+gDeviceIndex);
        connectCustomBox.style.height = "148px";
    }
    else if(deviceType == 'Televic:D-Cerno AE')
    {
        if(document.getElementById("APICertificate_" + gDeviceIndex))
            $("#APICertificate_"+gDeviceIndex).hide();
        if(document.getElementById("APIPrivateKey_" + gDeviceIndex))
            $("#APIPrivateKey_"+gDeviceIndex).hide();
        if(document.getElementById("APITokens_" + gDeviceIndex))
            $("#APITokens_"+gDeviceIndex).show();
        var connectCustomBox= document.getElementById("div_custom_box_"+gDeviceIndex);
        connectCustomBox.style.height = "64px";
    }
    else
    {
        if(document.getElementById("APICertificate_" + gDeviceIndex))
            $("#APICertificate_"+gDeviceIndex).hide();
        if(document.getElementById("APIPrivateKey_" + gDeviceIndex))
            $("#APIPrivateKey_"+gDeviceIndex).hide();
        if(document.getElementById("APITokens_" + gDeviceIndex))
            $("#APITokens_"+gDeviceIndex).hide();
        var connectCustomBox = document.getElementById("div_custom_box_"+gDeviceIndex);
        connectCustomBox.style.height = "18px";
    }

    switch(deviceType)
    {
        case 'Shure:MXA910':case 'Shure:MXA920':case 'Shure:MXA710': 
        case 'Shure:MXA920(Coordinate)':
        case 'Shure:MXA310':
        case 'Shure:MXCW':
        case 'Shure:P300':
        case "Audio-Technica:ATUC-50CU":
            showAudioLevel = false;
        break;

        case 'Sennheiser:TCC2':case 'Sennheiser:TCCM':case 'Sennheiser:TCC2(Coordinate)':case 'Sennheiser:TCCM(Coordinate)':
        case 'Nureva:HDL300':case 'Nureva:Dual HDL300':case 'Nureva:HDL310':case 'Nureva:HDL410':case 'Nureva:HDL410(Coordinate)':
        case 'Yamaha:RM-CG':case 'Yamaha:RM-W':case 'Yamaha:RM-CR':case 'Yamaha:RM-TT':case 'Yamaha:RM-CG(Coordinate)':                                                                                     
        case 'Audio-Technica:ATND1061':case 'Audio-Technica:ATND1061(Coordinate)':
        case 'Lumens:Virtual Mic':          
            showAudioLevel = true;
        break;    
    }
    if (showAudioLevel) 
    {
        AudioLevel.style.cssText = "display : block;"
    }
    else
    {
        AudioLevel.style.cssText = "display : none;"
    }

    if(!msg.SoundSetting.isConnect)
    {
        updateDevicePortStatus(deviceTypeIndex);//change port is disabled or not
    }

    gMicDeviceIndex = msg.SoundSetting.MicDeviceIndex;

    // document.getElementById("div_Advanced_" + gDeviceIndex).style.display = "none";
    // document.getElementById("content_Device_" + gDeviceIndex).style.display = "none";

    if(msg.SoundSetting.isConnect == true)
    {
        if(connectCheckboxInput)
        {
            connectCheckboxInput.checked = true;
            connectCheckboxInput.disabled = false;
        }
        if(ExclusionModeCheckboxInput)
        {
            ExclusionModeCheckboxInput.disabled = false;
        }
            
        deviceTypeSel.disabled = true;
        DeviceIPInput.disabled = true;
        DevicePortInput.disabled = true;
        InputModelAudioTrigger.disabled = true;
        PasswordInput.disabled = true;
        DeviceAPIKey.disabled = true;
        SelectModelPreset.disabled = true;
        setDeviceCertificateDisabled(gDeviceIndex,true);
    }
    else
    {
        connectCheckboxInput.checked = false;
        deviceTypeSel.disabled = false;
        DeviceIPInput.disabled = false;

        if(deviceType.includes("Nureva:HDL300") || deviceType.includes("Nureva:Dual HDL300") || deviceType.includes("Nureva:HDL310") 
        || deviceType.includes("Nureva:HDL410")
        || deviceType == 'Audio-Technica:ATND1061' || deviceType == 'Audio-Technica:ATND1061(Coordinate)'  || deviceType == 'Audio-Technica:ATUC-50CU' )
        {
            DevicePortInput.disabled = false;
        }
        else
        {
            DevicePortInput.disabled = true;
        }

        InputModelAudioTrigger.disabled = false;
        PasswordInput.disabled = false;
        DeviceAPIKey.disabled = false;
        SelectModelPreset.disabled = false;
        setDeviceCertificateDisabled(gDeviceIndex,false);
    }

    if(deviceType == 'Lumens:Virtual Mic')
    {
        DeviceIPInput.disabled = true;
        DevicePortInput.disabled = true;
        InputModelAudioTrigger.disabled = true;
        PasswordInput.disabled = true;
        connectCheckboxInput.disabled = true;
        ExclusionModeCheckboxInput.disabled = true;
        SelectModelPreset.disabled = true;
        BackToHomeSetting.disabled = true;

    }

    if(document.getElementById("img_DeviceStatus_"+msg.SoundTabIndex))
    {
        document.getElementById("img_DeviceStatus_"+msg.SoundTabIndex).style.visibility = "hidden";
        if(msg.SoundSetting.isConnect)
            document.getElementById("img_DeviceStatus_"+msg.SoundTabIndex).style.visibility = "visible";
    }



    if(deviceType == 'Nureva:HDL410') //update deviceType first and then send cmd 
    {
        var jsonmsg = {};
        jsonmsg.Command = "SetZoneMapDetection";
        jsonmsg.SoundTabIndex = gDeviceIndex;
        jsonmsg.ZoneMap = {};
        jsonmsg.ZoneMap.IsOnOff = false;
        sendMessage("SetZoneMapDetection",jsonmsg);
    }


    micGroup = getDeviceCameraMappingIndex();

    for (var groupIndex = 0; groupIndex <= gMaxMappingGroupIndex; groupIndex++) //hide all micgroup channel first 
    {
        if(document.getElementById("Div_cameraMapping_"+groupIndex))
            document.getElementById("Div_cameraMapping_"+groupIndex).style.display = "none";
        if(micGroup == groupIndex)
        {
            //document.getElementById("Div_cameraMapping_"+micGroup).style.display = "block";
            if (micGroup === 1 ) {
                createCameraMappingArrayDiv(1, 8);
            } else if (micGroup === 2) {
                createCameraMappingArrayDiv(2, 4);
            } else if (micGroup === 3) {
                createCameraMappingArrayDiv(3, 125);
            } else if (micGroup === 4) {
                createCameraMappingAzimuthDiv(4, 8);
            } else if (micGroup === 5) {
                createCameraMappingAzimuthDiv(5, 8);
            } else if (micGroup === 6) {
                createCameraMappingAzimuthDiv(6, 8);
            } else if (micGroup === 7) {
                createCameraMappingArrayDiv(7, 8);
            } else if (micGroup === 8) {
                createCameraMappingArrayDiv(8, 15);
            } else if (micGroup === 9) {
                createCameraMappingArrayDiv(9, 8);
            } else if (micGroup === 10) {
                createCameraMappingArrayDiv(10, 16);
            } else if (micGroup === 11) {
                createCameraMappingArrayDiv(11, 1);
            } else if (micGroup === 12) {
                createCameraMappingArrayDiv(12, 128);
            } else if (micGroup === 13) {
                createCameraMappingArrayDiv(13, 128);
            } else if (micGroup === 14) {
                createCameraMappingArrayDiv(14, 128);
            } else if (micGroup === 15) {
                createCameraMappingArrayDiv(15, 128);
            } else if (micGroup === 16) {
                createCameraMappingArrayDiv(16, 14);
            } else if (micGroup === 17) {
                createCameraMappingArrayDiv(17, 50);
            } else if (micGroup === 18) {
                createCameraMappingArrayDiv(18, 150);
            }
        }
    }

    updateDeviceChannelStatus();
    
    selectChannel = document.getElementById("selectMicChannel_" + micGroup).value;
    micSelectChannel = parseInt(selectChannel);

    // $("#cameraMappingZoneMap_"+gDeviceIndex).hide();
    getMicTabIsGettingUIforPage();
    sendMessage("GetSoundAdvanceSetting",gDeviceIndex);
    sendMessage("GetSoundCamMap" ,gDeviceIndex);
    sendMessage("GetYamahaExclusionMode",gDeviceIndex);

}

function updateAdvanceSetting(msg) { 

    if(!document.getElementById("deviceTypeSel_"+msg.SoundTabIndex)) return;
    AiDirector_updateAdvanceSetting(msg);

    var deviceTypeSel= document.getElementById("deviceTypeSel_"+msg.SoundTabIndex).value;
    var devicPorteIndex = parseInt(deviceTypeSel);
    var deviceType = transferDeviceTypeToString(devicPorteIndex);
    var connectCheckboxInput = document.getElementById("connectCheckboxInput_"+msg.SoundTabIndex).checked;
    var content_Device = document.getElementById("content_Device_" + gDeviceIndex);
    var div_Advanced = document.getElementById("div_Advanced_" + gDeviceIndex);

    var audioLevel              = document.getElementById("audioLevel_" + gDeviceIndex);
    var InputModelAudioTrigger  = document.getElementById("InputModelAudioTrigger_"+msg.SoundTabIndex);
    var SelectModelPreset       = document.getElementById("SelectModelPreset_" +msg.SoundTabIndex);
   
    if(!gIsUseGlobalBackToHomeControl)
    {
        var SelectModelHomeTimes    = document.getElementById("SelectModelHomeTimes_" +msg.SoundTabIndex);
        var SelectModelHomeCamera   = document.getElementById("SelectModelHomeCamera_" +msg.SoundTabIndex);
        var SelectModelHomePosition = document.getElementById("SelectModelHomePosition_" +msg.SoundTabIndex);
        var InputModelHomePosition  = document.getElementById("InputModelHomePosition_" +msg.SoundTabIndex);
    }
    else
    {
        var backHomeSetting   = document.getElementById("BtnModelBackToHomeSetting_" +msg.SoundTabIndex);
    }

    var BtnModelCancel = document.getElementById("BtnModelCancel_"+msg.SoundTabIndex);
    var BtnModelApply  = document.getElementById("BtnModelApply_"+msg.SoundTabIndex);

    

    var contentHeight = "174px";
    var customBoxHeight = "48px";

    if(document.getElementById("img_DeviceStatus_"+msg.SoundTabIndex))
    {
        document.getElementById("img_DeviceStatus_"+msg.SoundTabIndex).style.visibility = "hidden";
        if(connectCheckboxInput)
            document.getElementById("img_DeviceStatus_"+msg.SoundTabIndex).style.visibility = "visible";
    }

    if (deviceType == 'Sennheiser:TCCM' || deviceType == 'Sennheiser:TCCM(Coordinate)'){
        contentHeight = "222px";
    } 
    if (deviceType == 'Yamaha:RM-CG' || deviceType == 'Yamaha:RM-CG(Coordinate)'){
        contentHeight = "222px";
    }
    content_Device.style.height = contentHeight;
    content_Device.style.display = "block";
    div_Advanced.style.display = "block";

    InputModelAudioTrigger.value = msg.SoundAdvanceSetting.AudioTriggerLevel;
    SelectModelPreset.value = msg.SoundAdvanceSetting.TimeToTriggerPreset;


    var ArrayID = InputModelAudioTrigger;
    var AarrayValue = parseInt(InputModelAudioTrigger.value);  
    switch(deviceType){
        case "Sennheiser:TCC2":case "Sennheiser:TCCM":
            if(AarrayValue<-90){
                ArrayID.value = -90;
            }
            if(AarrayValue>0){
                ArrayID.value = 0;
            }
        break;
        case "Nureva:HDL300":case "Nureva:Dual HDL300":
        case "Nureva:HDL310":case "Nureva:HDL410":case "Nureva:HDL410(Coordinate)":
            if(AarrayValue<0){
                ArrayID.value = 0;
            }
            if(AarrayValue>120){
                ArrayID.value = 120;
            }
        break;
        case "Yamaha:RM-CG":case "Yamaha:RM-W":case "Yamaha:RM-CR":case "Yamaha:RM-TT":
            if(AarrayValue<0){
                ArrayID.value = 0;
            }
            if(AarrayValue>126){
                ArrayID.value = 126;
            }
        break;
        case "Audio-Technica:ATND1061":
        case "Audio-Technica:ATND1061(Coordinate)":
        case "Audio-Technica:ATUC-50CU":
            if(AarrayValue<0){
                ArrayID.value = 0;
            }
            if(AarrayValue>60){
                ArrayID.value = 60;
            }
        break;
    }  

    if(!gIsUseGlobalBackToHomeControl)
    {
        SelectModelHomeTimes.value = msg.SoundAdvanceSetting.BackToHomeTime;
        SelectModelHomePosition.value = msg.SoundAdvanceSetting.BackToHomePos;
        InputModelHomePosition.value  = msg.SoundAdvanceSetting.BackToHomePreset;
    }



    if(!gIsUseGlobalBackToHomeControl)
    {
        if (SelectModelHomeCamera) {
            for (var i = 0; i < SelectModelHomeCamera.options.length; i++) {
                var option = SelectModelHomeCamera.options[i];
            }
            while (SelectModelHomeCamera.options.length > 0) {
                SelectModelHomeCamera.remove(0); 
            }
        }
        var defaultOption = document.createElement("option");
        defaultOption.text = window.LanguageManager.getTranslatedText("All_Camera");
        defaultOption.selected = true;
        SelectModelHomeCamera.append(defaultOption);

        for(var i=0; i<msg.SoundAdvanceSetting.BackToHomeCameraArray.length;i++){
            var option = $("<option />");
            option.val(msg.SoundAdvanceSetting.BackToHomeCameraArray[i].Camera).text(msg.SoundAdvanceSetting.BackToHomeCameraArray[i].Model);
            $("#SelectModelHomeCamera_"+gDeviceIndex).append(option);
        }

        if(msg.SoundAdvanceSetting.BackToHomeSwitchCamera == 'All' || msg.SoundAdvanceSetting.BackToHomeSwitchCamera == ''){}
        else{
            console.log(msg.SoundAdvanceSetting.BackToHomeSwitchCamera);
            SelectModelHomeCamera.value = msg.SoundAdvanceSetting.BackToHomeSwitchCamera;
        }

        if(SelectModelHomePosition.value == 0){
            InputModelHomePosition.disabled = true;
        }
        else{
            InputModelHomePosition.disabled = false;
        }
    }

    if(connectCheckboxInput == true)
    {
        SelectModelPreset.disabled       = true;
        
        if(!gIsUseGlobalBackToHomeControl)
        {
            SelectModelHomeTimes.disabled    = true;
            SelectModelHomeCamera.disabled   = true;
            SelectModelHomePosition.disabled = true;
            InputModelHomePosition.disabled  = true;
        }
        else
        {
            if(backHomeSetting)
                backHomeSetting.disabled = true;
        }

        BtnModelCancel.disabled = true;
        BtnModelApply.disabled  = true;
    }
    else
    {
        SelectModelPreset.disabled       = false;
        if(!gIsUseGlobalBackToHomeControl)
        {
            SelectModelHomeTimes.disabled    = false;
            SelectModelHomeCamera.disabled   = false;
            SelectModelHomePosition.disabled = false;
            InputModelHomePosition.disabled  = false;
        }
        else
        {
            if(backHomeSetting)
                backHomeSetting.disabled = false;
        }        

        if(gFirstInitWebTab_flag){
            BtnModelCancel.disabled = true;
            BtnModelApply.disabled = true;
        }
        else{
            BtnModelCancel.disabled = false;
            BtnModelApply.disabled  = false;
        }
    }

    initDeviceChannel(devicPorteIndex);

    if (deviceType == "Lumens:Virtual Mic")
    {
        SelectModelPreset.disabled       = true;
        if(!gIsUseGlobalBackToHomeControl)
        {
            SelectModelHomeTimes.disabled    = true;
            SelectModelHomeCamera.disabled   = true;
            SelectModelHomePosition.disabled = true;
            InputModelHomePosition.disabled  = true;
        }
        else
        {
            backHomeSetting.disabled = true;
        }        
        
        BtnModelCancel.disabled = true;
        BtnModelApply.disabled  = true;
    }
   
}

function updateSoundNumbers(msg) {

    updateButtonVisibility(msg.SoundNumbers);//if tab > 6 , tab will show scroll Left Button;

    let tabcount; 
    if(document.getElementById("deviceCntSel"))
    {
        document.getElementById("deviceCntSel").value = msg.SoundNumbers;
        tabcount = document.getElementById("deviceCntSel").value;
        gMicTabCount = tabcount;
    }

    for (x = 0; x < 24; x++) {
        $("#A_tabDevice_"+x).hide(); 
    }

    for (x = 0; x < tabcount; x++) {
        $("#A_tabDevice_"+x).show();    
    }

    //sendMessage("SetSoundNumbers",parseInt(tabcount,10));

}
var gPendingSoundSettingFlags = new Array(gMicTabCount).fill(false);
async function sendSoundSettingWithRetry(index) {
    gPendingSoundSettingFlags[index] = true;
    sendMessage("GetSoundSetting", index);

    setTimeout(() => {
        if (gPendingSoundSettingFlags[index]) 
        {
            //console.log(`No response for GetSoundSetting index ${index} after 3000ms, retrying...`);
            sendSoundSettingWithRetry(index);
        }
    }, 1500);
}

async function InitSoundTabPage() 
{
    function delay(ms) 
    {
        return new Promise(resolve => setTimeout(resolve, ms));
    }

    gPendingSoundSettingFlags = new Array(gMicTabCount).fill(false);

    for(var loopindex = 0;loopindex < gMicTabCount;loopindex ++)
    {
        await sendSoundSettingWithRetry(loopindex);
        await delay(5);
    }
}

function updateSystemSetting(msg)
{
    //Get Sound Tab Count Max
    if("Status" in msg)
    {
        isGetSoundMaxQty = false;
        isProcessingMaxSoundQty = true;
        return;
    }
    
    if("SoundMaxQty" in msg)
    {
        isGetSoundMaxQty = true;
        isProcessingMaxSoundQty = false;
    }

    var tabcount = 0;
    if(document.getElementById("deviceCntSel"))
    {
        tabcount = document.getElementById("deviceCntSel").value; 
    }

    gGetSoundMaxQtyFlags = false;

    
    if(tabcount > msg.SoundMaxQty)
        $("#deviceCntSel").val(msg.SoundMaxQty);

    $(document).ready(function() {
        $("#deviceCntSel option").each(function() {
            if (parseInt($(this).val()) > msg.SoundMaxQty) {
                $(this).hide();
            }
        });
    });

}

/*function DisableResolutonAndFps(status) {

    document.getElementById("selectResolution").disabled = status;
    document.getElementById("selectFPS").disabled = status;
}*/

/*function CameraConnClick(rowIndex){

    var index  = rowIndex;
    var ip     = document.getElementById("cameraIP_"+(index-1)).innerText;
    var status = document.getElementById("cameraStatus_"+(index-1)).innerText;


    if(status == "Connect") 
    {
        if(gCameraConnCnt<4)//max camera count is "4"
        {
            sendMessage("CameraConnect",ip);
            blockUIforPage();
        }
    }
    else
    {
        sendMessage("CameraDisconnect",ip);
        document.getElementById("cameraStatus_"+(index-1)).innerText = "Connect";
        document.getElementById("cameraStatus_"+(index-1)).style.backgroundColor = "#000000";//black
        gCameraConnCnt--;

        if(gCameraConnCnt > 0)
            DisableResolutonAndFps(true);
        else
            DisableResolutonAndFps(false);
        sendMessage("GetSoundCamMap" ,gDeviceIndex);
    }
}*/

function AISettingClick(rowIndex){

    var index = rowIndex;
    var ip = document.getElementById("cameraIP_"+(index-1)).innerText;

    if(document.getElementById("cameraStatus_"+(index-1)).innerText == "Disonnect")
    {
        sendMessage("GetCamAISetting",ip); // get AI Setting infor
    }
}

function micGetPTZInfo(CameraIP) {

    var jsonmsg = {};

    jsonmsg.Command = "GetFocusMode";
    jsonmsg.IPAddress = CameraIP;
    sendMessage("GetFocusMode",jsonmsg);

    jsonmsg.Command = "GetMirrorFlipType";
    jsonmsg.IPAddress = CameraIP;
    sendMessage("GetMirrorFlipType",jsonmsg);

    jsonmsg.Command = "GetPanFlip";
    jsonmsg.IPAddress = CameraIP;
    sendMessage("GetPanFlip",jsonmsg);
}

function micPTZControl(){


    var url = 'http://'+ document.getElementById('CameraInformation_Camera_select_' + gDeviceIndex).value;


    var cameraIP = document.getElementById('CameraInformation_Camera_select_' + gDeviceIndex).value;

    var ch = '.';
    var count = cameraIP.split(ch).length - 1;
    console.log(count);

    // if(document.getElementById("cameraStatus_"+(gTableRowIndex-1)).innerText == "Disonnect")
    // {    
        // if(count == 3){//ip camera
        //     window.open(url);
        // }
        // else{// USB camera

        //     if (gPTZTimerId != null) {
        //         clearInterval(gPTZTimerId);
        //         gPTZTimerId = null;
        //     }

        //     $('#PTZModal').modal('show');
        //     gPTZTimerId = setInterval("imgSrcChange()", 1000);
        //     GetPTZInfo(cameraIP);
        // }
    //}

}

/*function imgSrcChange() {

    dmsimg = document.getElementById("imgloader");
 
    var imgsrc = dmsimg.src;
    var result = imgsrc.indexOf("_A");


    if(result == -1)
        dmsimg.src ="http://"+location.hostname+"/dms_video0_A.jpg";
    else
        dmsimg.src ="http://"+location.hostname+"/dms_video0_B.jpg";

}*/

function sendMessage(cmd,data) {

    var msg = cmd;


    if ( websocket != null )
    {
        //document.getElementById("inputText").value = "";
        //websocket.send( msg );
        var jsonmsg = {};

        jsonmsg.Command = msg;

        if(msg == "AddCamera"){
            jsonmsg.IPAddress = data; //AddCamera
        }     
        else if(msg == "GetSoundAdvanceSetting"){
            jsonmsg.SoundTabIndex = data;
        } 
        else if(msg == "GetSoundSetting"){
            jsonmsg.SoundTabIndex = data;
        } 
        else if(msg == "GetSoundCamMap"){
            jsonmsg.SoundTabIndex = data;
        }
        else if(msg == "GetMicEnableHandFree"){
            jsonmsg.SoundTabIndex = data;
        }
        else if(msg == "GetYamahaExclusionMode"){
            jsonmsg.SoundTabIndex = data;
        }
        else if(msg == "GetCamAISetting"){
            jsonmsg.IPAddress = data;
        }
        else if(msg == "SetSoundNumbers"){
            jsonmsg.SoundNumbers = data;
        }
        else if(msg == "SetSoundAdvanceSetting" || msg == "SetSoundSetting" || msg == "SetSoundDeviceType"){
            jsonmsg = data;
        }
        else if(msg == "SoundConnect" || msg == "SoundDisconnect"){
            jsonmsg.SoundTabIndex = data;
        }
        else if(msg == "SetSoundCamMap"){
            jsonmsg = data;
        }
        else if(msg == "SetCamAISetting"){
            jsonmsg = data;
        }
        else if(msg == "CameraConnect"){
            jsonmsg.IPAddress = data;
        }
        else if(msg == "CameraDisconnect"){
            jsonmsg.IPAddress = data;
        }
        else if(msg == "SetVideoResolution"){
            jsonmsg.VideoResolution = data;
        }
        else if(msg == "SetVideoFps"){
            jsonmsg.VideoFps = data;
        }
        else if(msg == "SetVoiceTracking"){
            jsonmsg.Status = data;
        }
        else if(msg == "GetSoundDevicePort"){
            jsonmsg = data;
        }
        else if(msg == "GetFocusMode" || msg == "GetMirrorFlipType" || msg == "GetPanFlip"){
            jsonmsg = data;
        }
        else if(msg == "SetPanTiltStart" || msg == "SetPanTiltStop" || msg == "SetPanTiltHome"){
            jsonmsg = data;
        }
        else if(msg == "SetFocusStop" || msg == "SetFocusStart"){
            jsonmsg = data;
        }
        else if(msg == "SetZoomStop" || msg == "SetZoomStart"){
            jsonmsg = data;
        }
        else if(msg == "SetMirrorFlip" || msg == "SetPanFlip" || msg == "SetFocusMode"){
            jsonmsg = data;
        }
        else if(msg == "SetToCallPreset" || msg == "SetToSavePreset"){
            jsonmsg = data;
        }
        else if(msg == 'SetYamahaExclusionMode'){
            jsonmsg = data;
        }
        else if(msg == 'SetZoneMapDetection'){
            jsonmsg = data;
        }
        else if(msg == 'GetZoneMapDetection'){
            jsonmsg.SoundTabIndex = data;
            return;//@Jeff Nureva does not need calibration, so return
        }
        else if(msg =='SetWebPreview'){
            jsonmsg = data;
        }
        else if(msg == 'SetSoundTabPosInfo'){
            jsonmsg = data;
        }
        else if(msg == 'SetSoundTabNum'){
            jsonmsg = data;    
        }
        else if(msg == 'SetMicEnableHandFree'){
            jsonmsg = data;    
        }
        else if(msg == 'GetZoneModeConfig'){
            jsonmsg = data;
        }
        else if(msg == 'SetZoneModeConfig'){
            jsonmsg = data;
        }
        else if(msg == "SetGlobalBackToHomeSetting"){
            jsonmsg = data;
        }
        //var jsonmsg = {
        //   Command : msg
            //ws_msg : msg//"49.138077,-122.857472"
        //};
        if (websocket.readyState == 1) {
            websocket.send( JSON.stringify(jsonmsg) );
        }
        else {
            //do something
            console.log( "websocket.readyState :", websocket.readyState );
            if(websocket.readyState == 3)
            {
                gWebSocketErrorBlockUIPage = true;
                blockUIforPage();
                setLoginStatus(false);
                gHadLogin = false;
                clearLoginStatus();
            }
        }
    }
}

/*function onAddCamera() {

    var data = document.getElementById("CameraIPInput").value ;//get camera IP

    sendMessage("AddCamera",data);
}*/

function initAdvancedContent() {

    var index = 0;

    for(index=0; index<24; index++){

        $( "#advancedButton_"+index ).click(function() {
            GetSoundAdvanceInfo();
        });
    }

}

function initCameraMappingContent(){
	
	var micTabPage = gDeviceIndex;
    var currentSoundType;
    if(document.getElementById("deviceTypeSel_" + micTabPage))
        currentSoundType = document.getElementById("deviceTypeSel_" + micTabPage).value;
    var micSelect = parseInt(currentSoundType);
    var micGroup = getDeviceCameraMappingIndex();
    
    var initMaxDivIndex = 8;
    var initMaxCnt = 8;
    
    for (var i = 1; i <= initMaxDivIndex; i++) {
        var selectors = ["cameraMappingSeleceItem_div","cameraMappingSecondSeleceItem_div", "cameraMappingPreset_div", "cameraMappingAzimuthFrom_div", "cameraMappingAzimuthTo_div"];
        
        var eventType = i;
    
        switch (i) {
            case 1:case 4:case 5:case 6:
                initMaxCnt = 8; eventType = 1;
            break;
            case 2:
                initMaxCnt = 4; eventType = 2;
            break;
            case 3:
                initMaxCnt = 125; eventType = 3;
            break;
            case 7:
                initMaxCnt = 16; eventType = 7;
            break;
            case 8:
                initMaxCnt = 6;eventType = 8;
            break;
            default:
                initMaxCnt = 0;
            break;
        }
    
        if (initMaxCnt > 0) {
            for (var j = 0; j < initMaxCnt; j++) {
                selectors.forEach(function (selector) {
                    var element = document.getElementById(selector + "_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" + j);
                    if (element) {
                        element.onchange = function () {
                            onChangeCameraMappingApplyStatus(eventType);
                        };
                    }
                });
            }
        }
    }
}

function micsendStorePresetCmd(strSet) {

    var jsonmsg = {};
    var cameraIP = document.getElementById('CameraInformation_Camera_select_' + gDeviceIndex).value;
    jsonmsg.Command   = "SetToSavePreset";
    jsonmsg.IPAddress = cameraIP;
    jsonmsg.Preset    = parseInt(strSet,10);
    sendMessage("SetToSavePreset",jsonmsg);

}

function micsendRecallPresetCmd(strSet) {

    var jsonmsg = {};
    var cameraIP = document.getElementById('CameraInformation_Camera_select_' + gDeviceIndex).value;
    jsonmsg.Command   = "SetToCallPreset";
    jsonmsg.IPAddress = cameraIP;
    jsonmsg.Preset    = parseInt(strSet,10);
    sendMessage("SetToCallPreset",jsonmsg);

}

function micpresetTextAction(strSet) {
    var strVal = $("#presetInput_"+gDeviceIndex).val();
    switch (strVal.length) {
        case 0:
            strVal = strVal.concat(strSet);
            break;
        case 1:
            if (strVal == "0") {
                strVal = strSet;
            } else {
                strVal = strVal.concat(strSet);
            }
            break;
        case 2:
            if (strSet < "6") {
                if (strVal <= "25") {
                    strVal = strVal.concat(strSet);
                }
                //else do nothing
            } else {
                if (strVal <= "24") {
                    strVal = strVal.concat(strSet);
                }
            }
            break;
        case 3:
            //do nothing
            break;
        case 4:
            strVal = "";
            break;
    }
    $("#presetInput_"+gDeviceIndex).val(strVal);
}

function micPTZMirrorFlipTypeChange(){

    var jsonmsg = {};
    var value = document.getElementById("PTZMirrorFlipType_"+gDeviceIndex).value;
    var cameraIP = document.getElementById('CameraInformation_Camera_select_' + gDeviceIndex).value;
    if(!cameraIP) return;

    jsonmsg.Command   = "SetMirrorFlip";
    jsonmsg.IPAddress = cameraIP;
    jsonmsg.Type      = parseInt(value,10);
    sendMessage("SetMirrorFlip",jsonmsg);

}

function micfocusModeChange(e){

    var jsonmsg  = {};
    var cameraIP = document.getElementById('CameraInformation_Camera_select_' + gDeviceIndex).value;
    var focusMode;

    if(e.checked == false){
        focusMode = "Manual";
    }else{
        focusMode = "Auto";
    }

    jsonmsg.Command   = "SetFocusMode";
    jsonmsg.IPAddress = cameraIP;
    jsonmsg.Mode      = focusMode;
    sendMessage("SetFocusMode",jsonmsg);

}

/*var ptCmdRun = false;
var focusCmdRun = false;
var zoomCmdRun = false;*/

// PanTilt control
function micsendPanTiltCmd(dir) {

    var ptzcmd;
    var jsonmsg = {};
    var cameraIP = document.getElementById('CameraInformation_Camera_select_' + gDeviceIndex).value; 
    if (dir == 'stop') {
        ptzcmd = "SetPanTiltStop";
    } else if(dir == 'home') {
        ptzcmd = "SetPanTiltHome";
    } else {
        ptzcmd = "SetPanTiltStart";
        jsonmsg.Direction = dir;
    }

    jsonmsg.Command   = ptzcmd;
    jsonmsg.IPAddress = cameraIP;
    sendMessage(ptzcmd,jsonmsg);
}



function micstopPanTiltMoving() {
    if (ptCmdRun == false)
        return;
    ptCmdRun = false;
    clearTimeout($(this).data('timer'));
    dir = 'stop';
    setTimeout(function () {
        micsendPanTiltCmd(dir);
    }, 500);
}

function micPanTiltElement() {

    var dir;
    $('#ptDownLeftButton_'+gDeviceIndex).on({
        mousedown: function (e) {
            dir = 'LeftDown';
            ptCmdRun = true;
            setTimeout(function () {
                micsendPanTiltCmd(dir);
            }, 100);
        },
        mouseup: function () {
            micstopPanTiltMoving();
        },
        mouseleave: function () {
            micstopPanTiltMoving();
        }
    });
    $('#ptDownButton_'+gDeviceIndex).on({
        mousedown: function (e) {
            dir = 'Down';
            ptCmdRun = true;
            setTimeout(function () {
                micsendPanTiltCmd(dir);
            }, 100);
        },
        mouseup: function () {
            micstopPanTiltMoving();
        },
        mouseleave: function () {
            micstopPanTiltMoving();
        }
    });
    $('#ptDownRightButton_'+gDeviceIndex).on({
        mousedown: function (e) {
            dir = 'RightDown';
            ptCmdRun = true;
            setTimeout(function () {
                micsendPanTiltCmd(dir);
            }, 100);
        },
        mouseup: function () {
            micstopPanTiltMoving();
        },
        mouseleave: function () {
            micstopPanTiltMoving();
        }
    });
    $('#ptLeftButton_'+gDeviceIndex).on({
        mousedown: function (e) {
            dir = 'Left';
            ptCmdRun = true;
            setTimeout(function () {
                micsendPanTiltCmd(dir);
            }, 100);
        },
        mouseup: function () {
            micstopPanTiltMoving();
        },
        mouseleave: function () {
            micstopPanTiltMoving();
        }
    });

    $('#HomeButton_'+gDeviceIndex).on({
        mousedown: function (e) {
            dir = 'home';
            micsendPanTiltCmd(dir);
        }
    });

    $('#ptRightButton_'+gDeviceIndex).on({
        mousedown: function (e) {
            dir = 'Right';
            ptCmdRun = true;
            setTimeout(function () {
                micsendPanTiltCmd(dir);
            }, 100);
        },
        mouseup: function () {
            micstopPanTiltMoving();
        },
        mouseleave: function () {
            micstopPanTiltMoving();
        }
    });
    $('#ptUpLeftButton_'+gDeviceIndex).on({
        mousedown: function (e) {
            dir = 'LeftUp';
            ptCmdRun = true;
            setTimeout(function () {
                micsendPanTiltCmd(dir);
            }, 100);
        },
        mouseup: function () {
            micstopPanTiltMoving();
        },
        mouseleave: function () {
            micstopPanTiltMoving();
        }
    });
    $('#ptUpButton_'+gDeviceIndex).on({
        mousedown: function (e) {
            dir = 'Up';
            ptCmdRun = true;
            setTimeout(function () {
                micsendPanTiltCmd(dir);
            }, 100);
        },
        mouseup: function () {
            micstopPanTiltMoving();
        },
        mouseleave: function () {
            micstopPanTiltMoving();
        }
    });
    $('#ptUpRightButton_'+gDeviceIndex).on({
        mousedown: function (e) {
            dir = 'RightUp';
            ptCmdRun = true;
            setTimeout(function () {
                micsendPanTiltCmd(dir);
            }, 100);
        },
        mouseup: function () {
            micstopPanTiltMoving();
        },
        mouseleave: function () {
            micstopPanTiltMoving();
        }
    });
}

//Focus control
function micsendManualFocusCmd(dir) {

    var focuscmd;
    var jsonmsg = {};
    var cameraIP = document.getElementById('CameraInformation_Camera_select_' + gDeviceIndex).value;

    if (dir == 'stop') {
        focuscmd = "SetFocusStop";
    } else {
        focuscmd = "SetFocusStart";
        jsonmsg.Direction = dir;
    }

    jsonmsg.Command   = focuscmd;
    jsonmsg.IPAddress = cameraIP;
    sendMessage(focuscmd,jsonmsg);

}

function micstopFocusMoving() {

    if (focusCmdRun == false)
        return;
    focusCmdRun = false;
    clearTimeout($(this).data('timer'));

    setTimeout(function () {
        micsendManualFocusCmd('stop');
    }, 500);


}

function micManualFocusControl() {

    $('#focusNearButton_'+gDeviceIndex).on({
        mousedown: function (e) {
            focusCmdRun = true;
            setTimeout(function () {
                micsendManualFocusCmd('Near');
            }, 100);
        },
        mouseup: function () {
            micstopFocusMoving();
        },
        mouseleave: function () {
            micstopFocusMoving();
        }
    });

    $('#focusFarButton_'+gDeviceIndex).on({
        mousedown: function (e) {
            focusCmdRun = true;
            setTimeout(function () {
                micsendManualFocusCmd('Far');
            }, 100);
        },
        mouseup: function () {
            micstopFocusMoving();
        },
        mouseleave: function () {
            micstopFocusMoving();
        }
    });
}

//Zoom control
function micsendZoomStopCmd() {
    if (zoomCmdRun == false)
        return;
    zoomCmdRun = false;
    clearTimeout($(this).data('timer'));

    setTimeout(function () {
        micsendZoomCmd('Stop');
    }, 500);
}

function micsendZoomCmd(telewide) {

    var zoomcmd;
    var jsonmsg = {};
    var cameraIP = document.getElementById('CameraInformation_Camera_select_' + gDeviceIndex).value;

    if (telewide == 'Stop') {
        zoomcmd = "SetZoomStop";
    } else {
        zoomcmd = "SetZoomStart";
        jsonmsg.Direction = telewide;
    }

    jsonmsg.Command   = zoomcmd;
    jsonmsg.IPAddress = cameraIP;
    sendMessage(zoomcmd,jsonmsg);

}

function micZoomBtnElements() {

    $('#zoomWideButton_'+gDeviceIndex).on({
        mousedown: function (e) {
            zoomCmdRun = true;
            setTimeout(function () {
                micsendZoomCmd('Out');
            }, 100);
        },
        mouseup: function () {
            micsendZoomStopCmd();
        },
        mouseleave: function () {
            micsendZoomStopCmd();
        }
    });

    $('#zoomTeleButton_'+gDeviceIndex).on({
        mousedown: function (e) {
            zoomCmdRun = true;
            setTimeout(function () {
                micsendZoomCmd('In');
            }, 100);
        },
        mouseup: function () {
            micsendZoomStopCmd();
        },
        mouseleave: function () {
            micsendZoomStopCmd();
        }
    });
}

var isGetSoundMaxQty = false;
var retryGetSoundMaxQtyCount = 0;
var gMicrophoneTryGetData = {}; 


function openMicrophone() {

    $("#DivMainPage").load("./page/microphone.html", function () 
    {
        window.LanguageManager.InitLanguageOfPage();
        if(!isAuthenticated && !isViewerLogin)
            return;

        getMicTabIsGettingUIforPage();

        InitDebugModeOfPage();
        window.LanguageManager.InitLanguageOfPage();

        if(isViewerLogin)
        {
            hideViewerBlock(false); 
        }
        else
        {
            hideViewerBlock(true); 
        }

        if (cameraSettings.ModelName == "CV420e") {
            $(".tabPageDiv").removeClass("tabPageDiv");
            $(".mic-tabNavDiv").hide();
            $(".tabs-content").removeClass("tabs-content").removeClass("content_H702");
            $("#Div_StreamType").removeClass("tabs-panel").removeClass("panel_H702");
        } else {
            //tabPage();
            //tabPageStream();
        }

        $("#presetInput_"+gDeviceIndex).change(function () {
            filterNumberInRange(this, 0, 255);
        });

        $("#presetRecallButton_"+gDeviceIndex).on('click', function () {
            //sendSingleCGICmd("presetposition", "PresetCall", $("#presetInput").val());
            micsendRecallPresetCmd($("#presetInput_"+gDeviceIndex).val());
            $("#presetInput_"+gDeviceIndex).val("");
        });

        $("#presetStoreButton_"+gDeviceIndex).on('click', function () {
            //sendSingleCGICmd("presetposition", "PresetSet", $("#presetInput").val());
            micsendStorePresetCmd($("#presetInput_"+gDeviceIndex).val());
            $("#presetInput_"+gDeviceIndex).val("");
        });

        initWebSocket();
        initAdvancedContent(); //advanced window init
        initCameraMappingContent();

        setTimeout(() => {
        // console.log('isStandByStatus',isStandByStatus);
        // console.log('isProcessingMaxSoundQty',isProcessingMaxSoundQty);

        if(isGetSoundMaxQty)
        {
            UnblockUIforPage();

            var tabs_menu = document.getElementsByClassName("mic-tabs-menu");
            if(tabs_menu.length > 0)
            {
                tabs_menu[0].click();
            }
            retryGetSoundMaxQtyCount = 0;
        }
        else
        {                
            if(!isStandByStatus && !isProcessingMaxSoundQty)
            {
                //blockUIforPage();
                processLastCommand();
                if(retryGetSoundMaxQtyCount < 5)
                {
                    retryGetSoundMaxQtyCount ++;
                    setTimeout(() => {
                    // document.location.reload();
                    //console.log('if(!isStandByStatus && !isProcessingMaxSoundQty) if(retryGetSoundMaxQtyCount < 5)');
                    openMicrophone();//
                    //sendMessage("GetSoundMaxQty");
                    },100);
               }                     
            }
            else 
            {
                if(isStandByStatus && !isProcessingMaxSoundQty)
                {
                    document.getElementById("powerBtn").removeClass = "PowerOff_Btn";
                    document.getElementById("powerBtn").className = "PowerStandby_Btn";
                    $(".LeftMenuDiv").addClass("disabled").prop("disabled", true).off('click');
                    $(".Btn_onoffvideo_style").addClass("disabled").prop("disabled", true).off('click');
                    $("#DivMainPage *").prop("disabled", true);
                    openPowerOff();
                    lastPowerStatus = "off";
                }
                else if(isProcessingMaxSoundQty)
                {
                    //blockUIforPage();
                    processLastCommand();
                    if(retryGetSoundMaxQtyCount < 5)
                    {
                        retryGetSoundMaxQtyCount ++;
                        setTimeout(() => {
                        // document.location.reload();
                        console.log('else if(isProcessingMaxSoundQty)');
                        openMicrophone();//
                        //sendMessage("GetSoundMaxQty");
                        },100);
                    }                      
                }
            }
        }
        }, 300);

        micPanTiltElement();
    });
}

function GetSoundAdvanceInfo() {

      sendMessage("GetSoundAdvanceSetting",gDeviceIndex);

}

function onShowHidePassword(){

    var passwordType = document.getElementById("PasswordInput_"+gDeviceIndex).type;

    if(passwordType == "password"){
        document.getElementById("PasswordInput_"+gDeviceIndex).type="text";
        document.getElementById("PasswordIcon_"+gDeviceIndex).src="../imagesaibox/Open.png"
    }else{
        document.getElementById("PasswordInput_"+gDeviceIndex).type="password";
        document.getElementById("PasswordIcon_"+gDeviceIndex).src="../imagesaibox/Close.png"
    }
    

}

function tabPageStream(){
    var tabs_menu = document.getElementsByClassName("mic-tabs-menu");
    for (var k = 0; k < tabs_menu.length; k++) {
        tabs_menu[k].onclick = tabsStream;
    }
};

function tabsStream() {
    var tabs_menu = document.getElementsByClassName("mic-tabs-menu");
    var tab_id = this.getAttribute("data-target");
    var tabs_panel = document.getElementsByClassName("tabs-panel");
   
    for (var i = 0; i < tabs_panel.length; i++) {
        tabs_panel[i].style.display = "none";
    }

    for (var k = 1; k <= gMaxMappingGroupIndex; k++){
        document.getElementById("Div_cameraMapping_"+k).style.display = "none";
    }
    
    var tabcount = document.getElementById("deviceCntSel").value; 

    for (var j = 0; j < tabcount; j++) {
        tabs_menu[j].className = tabs_menu[j].className.replace("mic-tabs-menu-active", "");
        tabs_menu[j].className = tabs_menu[j].className.replace("mic-tabs-menu-active-border", "");
        tabs_menu[j].className = tabs_menu[j].className.replace("mic-tabs-menu-passive-border", "");
    }

    this.className = "mic-tabs-menu stream-tab Font_Arial_14_bold mic-tabs-menu-active mic-tabs-menu-active-border";
    document.getElementById(tab_id).style.display = "block";
    var showTabIndex;

    for (var searchIndex = 0; searchIndex < tabcount; searchIndex++) 
    {
        if(tabs_menu[searchIndex].className.indexOf("mic-tabs-menu-active") != -1)
        {
            gDeviceIndex = searchIndex;

            for (let j = 0; j < tabcount; j++) 
            {
                if(j != gDeviceIndex)
                    tabs_menu[j].className = "mic-tabs-menu mic-tabs-menu-passive-border stream-tab Font_Arial_14_bold";
                
                if(j == gDeviceIndex)
                    tabs_menu[j].className = "mic-tabs-menu mic-tabs-menu-active mic-tabs-menu-active-border stream-tab Font_Arial_14_bold";
            }

            if(searchIndex == gDeviceIndex)
            {                
                InitSoundTabPage();
                gTryAgainUpdateCameraMapping = true;
                getMicTabIsGettingUIforPage();
                setTimeout(getMicTabIsGettingUnblockUIforPage,2000);
            }

            break;
        }
    }
    
    var deviceTypeIndex = document.getElementById("deviceTypeSel_"+gDeviceIndex).value;
    var deviceIndex = parseInt(deviceTypeIndex);
    updateDevicePortStatus(deviceIndex);// just update not create
    return false;
    
}

function getDeviceCameraMappingIndex(){
    if(!document.getElementById("deviceTypeSel_"+gDeviceIndex)) return;

    var deviceTypeIndex = document.getElementById("deviceTypeSel_"+gDeviceIndex).value;
    var deviceIndex = parseInt(deviceTypeIndex);
    var deviceMappingIndex = 0;

    let devicesel = document.getElementById("deviceTypeSel_"+gDeviceIndex);
    let deviceType = transferDeviceTypeToString(devicesel.value); 

    //console.log("getDeviceCameraMappingIndex deviceType:",deviceType);

    switch(deviceType)
    {
        case 'Shure:MXA910':case 'Shure:MXA920':case 'Shure:MXA710': 
            deviceMappingIndex = 1;
        break;
        case 'Shure:MXA920(Coordinate)':
            deviceMappingIndex = 15;
        break;
        case 'Shure:MXA310':
            deviceMappingIndex = 2;
        break;
        case 'Shure:MXCW':
            deviceMappingIndex = 3;
        break;
        case 'Shure:P300':
            deviceMappingIndex = 16;
        break;
        case 'Sennheiser:TCC2':case 'Sennheiser:TCCM':
            deviceMappingIndex = 4;
        break;
        case 'Sennheiser:TCC2(Coordinate)':case 'Sennheiser:TCCM(Coordinate)':
            deviceMappingIndex = 14;
        break;    
        case 'Nureva:HDL300':case 'Nureva:Dual HDL300':case 'Nureva:HDL310':case 'Nureva:HDL410':
            deviceMappingIndex = 5;
        break;
        case 'Yamaha:RM-CG':
            deviceMappingIndex = 6;
        break;
        case 'Yamaha:RM-W':
            deviceMappingIndex = 7;
        break;
        case 'Audio-Technica:ATND1061':
            deviceMappingIndex = 8;
        break;
        case 'Audio-Technica:ATND1061(Coordinate)':
            deviceMappingIndex = 13;
        break;
        case 'Audio-Technica:ATUC-50CU':
            deviceMappingIndex = 18;
        break;
        case 'Nureva:HDL410(Coordinate)':
            deviceMappingIndex = 9;
        break;
        case 'Yamaha:RM-CR':
            deviceMappingIndex = 10;
        break;
        case 'Yamaha:RM-TT':
            deviceMappingIndex = 11;
        break;
        case 'Lumens:Virtual Mic':
            deviceMappingIndex = 1;
        break;
        case 'Yamaha:RM-CG(Coordinate)':
            deviceMappingIndex = 12;
        break;
        case 'Televic:D-Cerno AE':
        case 'Televic:D-Cerno AE(HTTPS)':
            deviceMappingIndex = 17;
        break;
    }  

    return deviceMappingIndex;

}

function SelectModelHomeCameraOnChange(){
    document.getElementById("BtnModelCancel_"+gDeviceIndex).disabled = false;
    document.getElementById("BtnModelApply_"+gDeviceIndex).disabled = false;
}

function SelectingMicChannel(){
    console.log('SelectMicChannelOnChange()--->SelectMicChannelOnChange');
    SelectMicChannelOnChange();
    gSelectMicChannelChange = 1;

    var micGroup = getDeviceCameraMappingIndex();
    if(!document.getElementById("selectMicChannel_" + micGroup))
        return;

    var selectChannel = document.getElementById("selectMicChannel_" + micGroup).value;
    var micSelectChannel = parseInt(selectChannel);
    var obj1 = {
        Command: "SetSoundCamMap",
        SoundTabIndex: gDeviceIndex,
        SoundCamMap: {
            PresetShowNum: micSelectChannel,
        },
    };
    sendMessage("SetSoundCamMap", obj1);

    blockUIforPage();
    let intervalId = setInterval(function() {
        UnblockUIforPage();
        sendMessage("GetMicEnableHandFree",gDeviceIndex);
        sendMessage("GetSoundCamMap", gDeviceIndex);
        sendMessage("GetMicEnableHandFree",gDeviceIndex);
        clearInterval(intervalId);
    }, 1000);
}

function SelectMicChannelOnChange(){
    updateButtonVisibility();

    var deviceselIndex = document.getElementById("deviceTypeSel_"+gDeviceIndex).value;
    var deviceType = gdeviceTypeSelOptions[deviceselIndex];
   // console.log('deviceType',deviceType);

    var deviceMappingIndex = getDeviceCameraMappingIndex();
    if(!document.getElementById("selectMicChannel_"+deviceMappingIndex))
        return;
    var selectChannel = document.getElementById("selectMicChannel_"+deviceMappingIndex).value;
    
    var micTabPage = gDeviceIndex;
    var currentSoundType = document.getElementById("deviceTypeSel_"+micTabPage).value;
    var micSelect = parseInt(currentSoundType);
    var micGroup = getDeviceCameraMappingIndex();
    var micArryNum = selectChannel; 

    document.getElementById("cameraMappingCancel_"+micGroup).disabled = true;
    document.getElementById("cameraMappingApply_"+micGroup).disabled = true;
    document.getElementById("Div_cameraMapping_"+micGroup).style.display = "none";
    
    if(deviceType.includes("Shure:MXA910") || deviceType.includes("Shure:MXA920") || deviceType == ('Shure:MXA920(Coordinate)'))
    {
        if(deviceType == ('Shure:MXA920(Coordinate)'))
        {
            micGroup = getDeviceCameraMappingIndex();
            createCameraMappingArrayDiv(micGroup,128);
            micArryNum = 128;
            generateCameraPosMappingTable(micArryNum);

            var micGroup = getDeviceCameraMappingIndex();
            var deviceMappingIndex = getDeviceCameraMappingIndex();

            const selectMicChannel = document.getElementById("selectMicChannel_"+deviceMappingIndex);
            selectMicChannel.innerHTML = '';
    
            const Option1 = document.createElement("option");
            Option1.text = "128";
            Option1.value = "128";
            selectMicChannel.appendChild(Option1);
    
            document.getElementById("selectMicChannel_"+deviceMappingIndex).value = 128;
            document.getElementById("selectMicChannel_"+deviceMappingIndex).disabled = true;
        

            if(document.getElementById('ZoneMode_connectCheckboxInput_' + micGroup))
                document.getElementById('ZoneMode_connectCheckboxInput_' + micGroup).checked = true;
            if(document.getElementById('zoneModeSetting_' + micGroup))
                document.getElementById('zoneModeSetting_' + micGroup).disabled = false;
            //let handFreeMode = document.getElementById('HandFreeMode_connectCheckboxInput_' + gDeviceIndex)
            //if(handFreeMode)
            //{
              //  changeHandFreeModeStatus(handFreeMode);
            //}

        }
        else
        {
            generateCameraPosMappingTable(micArryNum);
        }
    }
    else if(deviceType.includes("Shure:MXA710")){
        generateCameraPosMappingTable(micArryNum);
    }
    else if(deviceType.includes("Shure:MXA310")){
        micArryNum = 4;
        generateCameraPosMappingTable(micArryNum);
    }
    else if(deviceType.includes("Shure:MXCW")){
        micArryNum = 125;
        generateCameraPosMappingTable(micArryNum);
        for (var i = 0; i < micArryNum; i++) {
            let mxcwarray = document.getElementById("cameraMappingInput"+ "_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" + (i+1));
            if(mxcwarray)
                mxcwarray.style.cssText ="border-radius:3px; width:100px;"
        }    
    }
    else if(deviceType.includes("Shure:P300")){
        micArryNum = 14;
        generateCameraPosMappingTable(micArryNum);
    }
    else if(deviceType == ("Sennheiser:TCC2") || deviceType == ("Sennheiser:TCCM")
         || deviceType == ('Sennheiser:TCC2(Coordinate)') || deviceType == ('Sennheiser:TCCM(Coordinate)'))
    {
        if(( deviceType == ('Sennheiser:TCC2(Coordinate)')
        || deviceType == ('Sennheiser:TCCM(Coordinate)') ))
        {
            micGroup = getDeviceCameraMappingIndex();
            createCameraMappingArrayDiv(micGroup,128);
            micArryNum = 128;
            generateCameraPosMappingTable(micArryNum);

            var micGroup = getDeviceCameraMappingIndex();
            var deviceMappingIndex = getDeviceCameraMappingIndex();

            const selectMicChannel = document.getElementById("selectMicChannel_"+deviceMappingIndex);
            selectMicChannel.innerHTML = '';
    
            const Option1 = document.createElement("option");
            Option1.text = "128";
            Option1.value = "128";
            selectMicChannel.appendChild(Option1);
    
            document.getElementById("selectMicChannel_"+deviceMappingIndex).value = 128;
            document.getElementById("selectMicChannel_"+deviceMappingIndex).disabled = true;
        

            if(document.getElementById('ZoneMode_connectCheckboxInput_' + micGroup))
                document.getElementById('ZoneMode_connectCheckboxInput_' + micGroup).checked = true;
            if(document.getElementById('zoneModeSetting_' + micGroup))
                document.getElementById('zoneModeSetting_' + micGroup).disabled = false;
            //let handFreeMode = document.getElementById('HandFreeMode_connectCheckboxInput_' + gDeviceIndex)
            //if(handFreeMode)
            //{
              //  changeHandFreeModeStatus(handFreeMode);
            //}

        }
        else
        {
            generateCameraAzimuthMappingTable(micArryNum);
        } 

    }
    else if(deviceType.includes("Nureva:HDL300") || deviceType.includes("Nureva:Dual HDL300") || deviceType.includes("Nureva:HDL310") 
         || deviceType.includes("Nureva:HDL410")){
        generateCameraAzimuthMappingTable(micArryNum);
    }
    else if(deviceType == ("Yamaha:RM-CG")){
        generateCameraAzimuthMappingTable(micArryNum);
    }
    else if(deviceType == ("Yamaha:RM-CG(Coordinate)")){

        var micGroup = getDeviceCameraMappingIndex();
        createCameraMappingArrayDiv(micGroup,128);

        const selectMicChannel = document.getElementById("selectMicChannel_"+micGroup);
        selectMicChannel.innerHTML = '';

        const Option1 = document.createElement("option");
        Option1.text = "128";
        Option1.value = "128";
        selectMicChannel.appendChild(Option1);

        document.getElementById("selectMicChannel_"+micGroup).value = 128;
        document.getElementById("selectMicChannel_"+micGroup).disabled = true;
    

        if(document.getElementById('ZoneMode_connectCheckboxInput_' + micGroup))
            document.getElementById('ZoneMode_connectCheckboxInput_' + micGroup).checked = true;
            //console.log('ZoneMode_connectCheckboxInput ---> .checked = true;');
        if(document.getElementById('zoneModeSetting_' + micGroup))
            document.getElementById('zoneModeSetting_' + micGroup).disabled = false;
        let handFreeMode = document.getElementById('HandFreeMode_connectCheckboxInput_' + gDeviceIndex)
        if(handFreeMode)
        {
            changeHandFreeModeStatus(handFreeMode);
        }
    }
    else if(deviceType.includes("Yamaha:RM-W")){
        generateCameraPosMappingTable(micArryNum);
    }
    else if(deviceType.includes("Audio-Technica:ATND1061"))
    {
        if(deviceType == ("Audio-Technica:ATND1061(Coordinate)"))
        {
            micGroup = getDeviceCameraMappingIndex();
            createCameraMappingArrayDiv(micGroup,128);
            micArryNum = 128;
            generateCameraPosMappingTable(micArryNum);

            var micGroup = getDeviceCameraMappingIndex();
            var deviceMappingIndex = getDeviceCameraMappingIndex();

            const selectMicChannel = document.getElementById("selectMicChannel_"+deviceMappingIndex);
            selectMicChannel.innerHTML = '';
    
            const Option1 = document.createElement("option");
            Option1.text = "128";
            Option1.value = "128";
            selectMicChannel.appendChild(Option1);
    
            document.getElementById("selectMicChannel_"+deviceMappingIndex).value = 128;
            document.getElementById("selectMicChannel_"+deviceMappingIndex).disabled = true;
        

            if(document.getElementById('ZoneMode_connectCheckboxInput_' + micGroup))
                document.getElementById('ZoneMode_connectCheckboxInput_' + micGroup).checked = true;
                //console.log('ZoneMode_connectCheckboxInput ---> .checked = true;');
            if(document.getElementById('zoneModeSetting_' + micGroup))
                document.getElementById('zoneModeSetting_' + micGroup).disabled = false;
            //let handFreeMode = document.getElementById('HandFreeMode_connectCheckboxInput_' + gDeviceIndex)
            //if(handFreeMode)
            //{
              //  changeHandFreeModeStatus(handFreeMode);
            //}

        }
        else
        {
            micArryNum = 15;
            generateCameraPosMappingTable(micArryNum);
        }        
    }
    else if(deviceType.includes("Audio-Technica:ATUC-50CU"))
    {
        micGroup = getDeviceCameraMappingIndex();
        createCameraMappingArrayDiv(micGroup,150);
        micArryNum = 150;
        generateCameraPosMappingTable(micArryNum);

        var micGroup = getDeviceCameraMappingIndex();
        var deviceMappingIndex = getDeviceCameraMappingIndex();

        const selectMicChannel = document.getElementById("selectMicChannel_"+deviceMappingIndex);
        selectMicChannel.innerHTML = '';

        const Option1 = document.createElement("option");
        Option1.text = "150";
        Option1.value = "150";
        selectMicChannel.appendChild(Option1);

        document.getElementById("selectMicChannel_"+deviceMappingIndex).value = 150;
        document.getElementById("selectMicChannel_"+deviceMappingIndex).disabled = true;

    }
    else if(deviceType.includes("Lumens:Virtual Mic")){
         generateCameraPosMappingTable(micArryNum);
    }

    if(deviceType == ("Nureva:HDL410(Coordinate)")){
        {
            micArryNum = 8;          
            generateCameraPosMappingTable(micArryNum);
        }
    }
    if(deviceType.includes("Yamaha:RM-CR")){
        micArryNum = 16;
        generateCameraPosMappingTable(micArryNum);
    }

    if(deviceType.includes("Yamaha:RM-TT")){
        micArryNum = 1;
        generateCameraPosMappingTable(micArryNum);
    }
    else if(deviceType.includes("Televic:D")){
        micArryNum = 50;
        generateCameraPosMappingTable(micArryNum);   
    }


    document.getElementById("Div_cameraMapping_"+micGroup).style.display = "block";

    if(gVideoOutputStatus == true)
    {
       //updateMicrophonePageStatus(gVideoOutputStatus);
    }
    else{
        const deviceIndex = gDeviceIndex;
        const micGroup = getDeviceCameraMappingIndex();
        const currentSoundType = document.getElementById("deviceTypeSel_" + deviceIndex).value;
        //const micSelectChannel = parseInt(document.getElementById("selectMicChannel_" + micGroup).value);
        for (let i = 0; i < micArryNum; i++) {
            updateCameraMappingElements(deviceIndex, currentSoundType, micGroup,i, false);
        }
    }
    
}

var lastInitDeviceChanneldeviceTypeIndex = null;
function initDeviceChannel(deviceTypeIndex){

    lastInitDeviceChanneldeviceTypeIndex = deviceTypeIndex;

    var connectCheckboxInput = document.getElementById("connectCheckboxInput_"+gDeviceIndex);
    var ExclusionModeCheckboxInput = document.getElementById("ExclusionMode_connectCheckboxInput_"+gDeviceIndex);
    var BtnModelCancel = document.getElementById("BtnModelCancel_"+gDeviceIndex);
    var BtnModelApply  = document.getElementById("BtnModelApply_"+gDeviceIndex);
    connectCheckboxInput.disabled = false;
    if(document.getElementById("img_DeviceStatus_"+gDeviceIndex))
    {
        if(connectCheckboxInput.checked)
            document.getElementById("img_DeviceStatus_"+gDeviceIndex).style.visibility = "visible";
        else
            document.getElementById("img_DeviceStatus_"+gDeviceIndex).style.visibility = "hidden";
    }
    ExclusionModeCheckboxInput.disabled = false;
    BtnModelCancel.disabled = true;
    BtnModelApply.disabled  = true;
    //updateDeviceChannelStatus();
    onChangecameraMappingPresetStatus('true');
}

function updateDeviceChannelStatus(){

    let devicesel = document.getElementById("deviceTypeSel_"+gDeviceIndex);
    let deviceType = transferDeviceTypeToString(devicesel.value); 
    var deviceMappingIndex = getDeviceCameraMappingIndex();
    
    if(deviceType ==   'Shure:MXA920(Coordinate)'   || 
       deviceType ==   'Sennheiser:TCC2(Coordinate)' || 
       deviceType ==   'Sennheiser:TCCM(Coordinate)' || 
       deviceType ==   'Yamaha:RM-CG(Coordinate)'    || 
       deviceType ==   'Audio-Technica:ATND1061(Coordinate)')
    {
        const selectMicChannel = document.getElementById("selectMicChannel_"+deviceMappingIndex);
        if(!selectMicChannel) return;
        selectMicChannel.innerHTML = '';

        const Option1 = document.createElement("option");
        Option1.text = "128";
        Option1.value = "128";
        selectMicChannel.appendChild(Option1);

        document.getElementById("selectMicChannel_"+deviceMappingIndex).value = 128;
        document.getElementById("selectMicChannel_"+deviceMappingIndex).disabled = true;
    }

    else if(deviceType == 'Shure:MXA910' || deviceType == 'Shure:MXA920')
    {
        const selectMicChannel = document.getElementById("selectMicChannel_"+deviceMappingIndex);
        selectMicChannel.innerHTML = '';

        const Option1 = document.createElement("option");
        Option1.text = "8";
        Option1.value = "8";
        selectMicChannel.appendChild(Option1);

        document.getElementById("selectMicChannel_"+deviceMappingIndex).value = 8;
        document.getElementById("selectMicChannel_"+deviceMappingIndex).disabled = true;
    }
    else if(deviceType == 'Shure:MXA710')
    {
        const selectMicChannel = document.getElementById("selectMicChannel_"+deviceMappingIndex);
        selectMicChannel.innerHTML = '';

        const Option1 = document.createElement("option");
        Option1.text = "4";
        Option1.value = "4";
        selectMicChannel.appendChild(Option1);

        const Option2 = document.createElement("option");
        Option2.text = "8";
        Option2.value = "8";
        selectMicChannel.appendChild(Option2);

        document.getElementById("selectMicChannel_"+deviceMappingIndex).value = 8;
        document.getElementById("selectMicChannel_"+deviceMappingIndex).disabled = false;
    }
    else if(deviceType == 'Shure:MXA310')
    {
        const selectMicChannel = document.getElementById("selectMicChannel_"+deviceMappingIndex);
        selectMicChannel.innerHTML = '';

        const Option1 = document.createElement("option");
        Option1.text = "4";
        Option1.value = "4";
        selectMicChannel.appendChild(Option1);
        document.getElementById("selectMicChannel_"+deviceMappingIndex).value = 4;
        document.getElementById("selectMicChannel_"+deviceMappingIndex).disabled = true;
    }
    else if(deviceType == 'Shure:MXCW')
    {
        const selectMicChannel = document.getElementById("selectMicChannel_"+deviceMappingIndex);
        selectMicChannel.innerHTML = '';

        const Option1 = document.createElement("option");
        Option1.text = "125";
        Option1.value = "125";
        selectMicChannel.appendChild(Option1);

        document.getElementById("selectMicChannel_"+deviceMappingIndex).value = 125;
        document.getElementById("selectMicChannel_"+deviceMappingIndex).disabled = true;
    }
    else if(deviceType == 'Shure:P300')
    {
        const selectMicChannel = document.getElementById("selectMicChannel_"+deviceMappingIndex);
        selectMicChannel.innerHTML = '';

        const Option1 = document.createElement("option");
        Option1.text = "14";
        Option1.value = "14";
        selectMicChannel.appendChild(Option1);

        document.getElementById("selectMicChannel_"+deviceMappingIndex).value = 14;
        document.getElementById("selectMicChannel_"+deviceMappingIndex).disabled = true;
    }
    else if(deviceType == 'Sennheiser:TCC2' || deviceType == 'Sennheiser:TCCM'
         || deviceType == 'Nureva:HDL300'   || deviceType == 'Nureva:Dual HDL300' ||deviceType == 'Nureva:HDL310' || deviceType == 'Nureva:HDL410'
         || deviceType == 'Yamaha:RM-CG' || deviceType =='Lumens:Virtual Mic')
    {
        const selectMicChannel = document.getElementById("selectMicChannel_"+deviceMappingIndex);
        selectMicChannel.innerHTML = '';

        const Option1 = document.createElement("option");
        Option1.text = "8";
        Option1.value = "8";
        selectMicChannel.appendChild(Option1);

        const Option2 = document.createElement("option");
        Option2.text = "16";
        Option2.value = "16";
        selectMicChannel.appendChild(Option2);

        const Option3 = document.createElement("option");
        Option3.text = "32";
        Option3.value = "32";
        selectMicChannel.appendChild(Option3);

        const Option4 = document.createElement("option");
        Option4.text = "64";
        Option4.value = "64";
        selectMicChannel.appendChild(Option4);

        const Option5 = document.createElement("option");
        Option5.text = "128";
        Option5.value = "128";
        selectMicChannel.appendChild(Option5);

        document.getElementById("selectMicChannel_"+deviceMappingIndex).value = 8;
        document.getElementById("selectMicChannel_"+deviceMappingIndex).disabled = false;
    }
    else if(deviceType == 'Nureva:HDL410(Coordinate)')
    {
        const selectMicChannel = document.getElementById("selectMicChannel_"+deviceMappingIndex);
        selectMicChannel.innerHTML = '';

        const Option1 = document.createElement("option");
        Option1.text = "8";
        Option1.value = "8";
        selectMicChannel.appendChild(Option1);

        document.getElementById("selectMicChannel_"+deviceMappingIndex).value = 8;
        document.getElementById("selectMicChannel_"+deviceMappingIndex).disabled = true;
    }
    else if(deviceType == 'Yamaha:RM-W')
    {
        const selectMicChannel = document.getElementById("selectMicChannel_"+deviceMappingIndex);
        selectMicChannel.innerHTML = '';

        const Option1 = document.createElement("option");
        Option1.text = "8";
        Option1.value = "8";
        selectMicChannel.appendChild(Option1);

        const Option2 = document.createElement("option");
        Option2.text = "16";
        Option2.value = "16";
        selectMicChannel.appendChild(Option2);

        document.getElementById("selectMicChannel_"+deviceMappingIndex).value = 8;
        document.getElementById("selectMicChannel_"+deviceMappingIndex).disabled = false;
    }
    else if(deviceType == 'Audio-Technica:ATND1061')
    {
        const selectMicChannel = document.getElementById("selectMicChannel_"+deviceMappingIndex);
        selectMicChannel.innerHTML = '';

        const Option1 = document.createElement("option");
        Option1.text = "15";
        Option1.value = "15";
        selectMicChannel.appendChild(Option1);

        document.getElementById("selectMicChannel_"+deviceMappingIndex).value = 15;
        document.getElementById("selectMicChannel_"+deviceMappingIndex).disabled = true;
    }
    else if(deviceType == 'Audio-Technica:ATUC-50CU')
    {
        const selectMicChannel = document.getElementById("selectMicChannel_"+deviceMappingIndex);
        selectMicChannel.innerHTML = '';

        const Option1 = document.createElement("option");
        Option1.text = "150";
        Option1.value = "150";
        selectMicChannel.appendChild(Option1);

        document.getElementById("selectMicChannel_"+deviceMappingIndex).value = 150;
        document.getElementById("selectMicChannel_"+deviceMappingIndex).disabled = true;
    }
    else if(deviceType.includes('Yamaha:RM-CR'))
    {
        const selectMicChannel = document.getElementById("selectMicChannel_"+deviceMappingIndex);
        selectMicChannel.innerHTML = '';

        const Option1 = document.createElement("option");
        Option1.text = "16";
        Option1.value = "16";
        selectMicChannel.appendChild(Option1);

        document.getElementById("selectMicChannel_"+deviceMappingIndex).value = 16;
        document.getElementById("selectMicChannel_"+deviceMappingIndex).disabled = true;
    }
    else if(deviceType.includes('Yamaha:RM-TT'))
    {
        const selectMicChannel = document.getElementById("selectMicChannel_"+deviceMappingIndex);
        selectMicChannel.innerHTML = '';

        const Option1 = document.createElement("option");
        Option1.text = "1";
        Option1.value = "1";
        selectMicChannel.appendChild(Option1);

        document.getElementById("selectMicChannel_"+deviceMappingIndex).value = 1;
        document.getElementById("selectMicChannel_"+deviceMappingIndex).disabled = true;
    }
    else if(deviceType.includes('Televic:D-Cerno AE') || deviceType.includes('Televic:D-Cerno AE(HTTPS)'))
    {
        const selectMicChannel = document.getElementById("selectMicChannel_"+deviceMappingIndex);
        selectMicChannel.innerHTML = '';

        const Option1 = document.createElement("option");
        Option1.text = "50";
        Option1.value = "50";
        selectMicChannel.appendChild(Option1);

        document.getElementById("selectMicChannel_"+deviceMappingIndex).value = 50;
        document.getElementById("selectMicChannel_"+deviceMappingIndex).disabled = true;
    }
}

function getFileUploadText() {
    return window.LanguageManager.getTranslatedText("Browse_or_drop_a_file_here");
}

function setSuccessStyle(button, fileName) {
    const maxLength = 20;
    const displayName = fileName.length > maxLength ? 
        fileName.substring(0, maxLength) + '...' : fileName;
    
    button.innerText = displayName;
    button.style.color = '#333';
    button.style.borderColor = '#28a745';
    button.style.backgroundColor = '#f8fff9';
    button.title = fileName;
}

function resetStyle(button) {
    button.innerText = getFileUploadText();
    button.style.color = '#666';
    button.style.borderColor = '#ccc';
    button.style.backgroundColor = 'white';
    button.title = '';
}

function createDeviceContent(index) {
        var div_content_Device = document.createElement("div");
        div_content_Device.id = "content_Device_" + index;
        div_content_Device.className = "div_content_Device";
        div_content_Device.style.cssText = "display:none; height:174px;"; 

            var table_Device = document.createElement("table");
            table_Device.className = "margin-left-64px";
            table_Device.style.cssText = "marginTop:28px;"

                var tr_Device = document.createElement("tr");
                tr_Device.className = "stream_tr2";

                var td_Device = document.createElement("td");
                td_Device.className = "td_Device";
                    var tr_DeviceType = document.createElement("tr"); 
                    tr_DeviceType.className = "stream_tr2 Font_Arial_14";
                        var td_DeviceType = document.createElement("td"); 
                            var label_DeviceType = document.createElement("label");
                            label_DeviceType.id= "Label_Microphone_DeviceType";
                            label_DeviceType.className = "label_DeviceType Font_Arial_14 label_tr"; 
                            label_DeviceType.innerText = window.LanguageManager.getTranslatedText("Device");

                            var select_deviceTypeSel = document.createElement("select");
                            select_deviceTypeSel.id = "deviceTypeSel_" + index;
                            select_deviceTypeSel.className = "select_deviceTypeSel";
                            select_deviceTypeSel.setAttribute("onchange", "syncDeviceType()");
                            
                                Object.keys(gMicSelect_Index).forEach((key) => {
                                    const index = gMicSelect_Index[key];
                                    const deviceTypeSeloption = document.createElement("option");
                                    deviceTypeSeloption.className = "Font_Arial_14_black";
                                    deviceTypeSeloption.value = index;
                                    deviceTypeSeloption.innerText = gdeviceTypeSelOptions[index];
                                    if (index === gMicSelect_Index.Shure_MXA310) {
                                        deviceTypeSeloption.selected = true;
                                    }
                                    select_deviceTypeSel.appendChild(deviceTypeSeloption);
                                });
                        td_DeviceType.appendChild(label_DeviceType);       
                        td_DeviceType.appendChild(select_deviceTypeSel);

                    tr_DeviceType.append(td_DeviceType);
                    
                    var tr_DeviceIP_DeviceIP = document.createElement("tr");
                    tr_DeviceIP_DeviceIP.className = "stream_tr2 Font_Arial_14";

                        var td_DeviceIP = document.createElement("td"); 
                            var label_DeviceIP = document.createElement("label");
                            label_DeviceIP.className = "label_DeviceIP Font_Arial_14 label_tr";   
                            label_DeviceIP.innerText = window.LanguageManager.getTranslatedText("Device_IP");
                            label_DeviceIP.id= "Label_Microphone_DeviceIP";

                            if(!document.getElementById("GobalSelectLanguage").value == 0)
                            {
                                label_DeviceIP.style.cssText = "width:70px;margin-right: 145px";
                            }

                            var input_DeviceIPInput = document.createElement("input");
                            input_DeviceIPInput.id = "DeviceIPInput_"+index;
                            input_DeviceIPInput.style.cssText  = "width:184px; height:32px; Font_Arial_14; margin-right: 24px;"
                            input_DeviceIPInput.type = "text";
                            input_DeviceIPInput.maxLength = "256";
                            input_DeviceIPInput.setAttribute("onchange", "onChangeSoundDeviceApplyStatus()");

                        td_DeviceIP.appendChild(label_DeviceIP);
                        td_DeviceIP.appendChild(input_DeviceIPInput);

                    tr_DeviceIP_DeviceIP.append(td_DeviceIP);

                    var tr_DeviceIP_DevicePort = document.createElement("tr");
                    tr_DeviceIP_DevicePort.className = "stream_tr2 Font_Arial_14";

                        var td_DeviceIP_DevicePort = document.createElement("td");
                            var label_DevicePort = document.createElement("label");
                            label_DevicePort.className = "label_DevicePort Font_Arial_14 label_tr";   
                            label_DevicePort.innerText = "Port";
                            label_DevicePort.id= "Label_DevicePort";                            

                            var input_DevicePortInput = document.createElement("input");
                            input_DevicePortInput.id = "DevicePortInput_"+index;
                            input_DevicePortInput.style.cssText  = "width:88px; height:32px; Font_Arial_14;";
                            input_DevicePortInput.type = "text";
                            input_DevicePortInput.maxLength = "256";
                            input_DevicePortInput.setAttribute("onchange", "onChangeSoundDeviceApplyStatus()");

                        td_DeviceIP_DevicePort.appendChild(label_DevicePort);
                        td_DeviceIP_DevicePort.appendChild(input_DevicePortInput);

                    tr_DeviceIP_DevicePort.append(td_DeviceIP_DevicePort);
                                    
                    var tr_Password = document.createElement("tr");
                    tr_Password.id = "password_"+index;
                    tr_Password.className = "stream_tr2 Font_Arial_14";
                        var td_Password = document.createElement("td");   
                            var label_Password = document.createElement("label");
                            label_Password.id = "Label_Password_"+index;
                            label_Password.className = "label_Password Font_Arial_14 label_tr";   
                            label_Password.innerText = window.LanguageManager.getTranslatedText("Password"); 

                            var input_PasswordInput = document.createElement("input");
                            input_PasswordInput.id = "PasswordInput_" + index;
                            input_PasswordInput.style.cssText = "width:184px;height:32px;";
                            input_PasswordInput.type = "password";
                            input_PasswordInput.maxLength = "256";
                            input_PasswordInput.setAttribute("autocomplete", "current-password");
                            input_PasswordInput.setAttribute("onchange", "onChangeSoundDeviceApplyStatus()");
     
                            var img_PasswordIcon = document.createElement("img");
                            img_PasswordIcon.id = "PasswordIcon_"+index;
                            img_PasswordIcon.style.cssText  = "height: 25px;"
                            img_PasswordIcon.src = "../imagesaibox/Close.png";
                            img_PasswordIcon.setAttribute("onclick", "onShowHidePassword()");
                            
                        td_Password.appendChild(label_Password);
                        td_Password.appendChild(input_PasswordInput);
                        td_Password.appendChild(img_PasswordIcon);
                    tr_Password.append(td_Password);  
                        
                    var tr_ExclusionMode = document.createElement("tr");
                    tr_ExclusionMode.id = 'ExclusionMode_'+index;
                    tr_ExclusionMode.className = "stream_tr2 Font_Arial_14";
                        var td_ExclusionMode = document.createElement("td"); 
                            var label_ExclusionMode = document.createElement("label");
                            label_ExclusionMode.id = "Label_ExclusionMode";
                            label_ExclusionMode.className = "label_ExclusionMode Font_Arial_14";   
                            label_ExclusionMode.innerText = window.LanguageManager.getTranslatedText("Exclusion_Mode");

                            var label_ExclusionMode_switch_onoff = document.createElement("label");
                            label_ExclusionMode_switch_onoff.id = "ExclusionMode_switch_onoff";
                            label_ExclusionMode_switch_onoff.className = "switch_onoff";
                                var input_ExclusionMode_connectCheckboxInput = document.createElement("input");
                                input_ExclusionMode_connectCheckboxInput.id = "ExclusionMode_connectCheckboxInput_"+index;
                                input_ExclusionMode_connectCheckboxInput.type = "checkbox";
                                input_ExclusionMode_connectCheckboxInput.setAttribute("onchange", "changeExclusionModeStatus(this)");
                                
                                var span_class = document.createElement("span");
                                span_class.className = "slider_onoff";
                            label_ExclusionMode_switch_onoff.appendChild(input_ExclusionMode_connectCheckboxInput);   
                            label_ExclusionMode_switch_onoff.appendChild(span_class);   
                            
                        td_ExclusionMode.appendChild(label_ExclusionMode);
                        td_ExclusionMode.appendChild(label_ExclusionMode_switch_onoff);
                    tr_ExclusionMode.append(td_ExclusionMode);

                    var tr_DeviceAPICertificate = document.createElement("tr");
                    tr_DeviceAPICertificate.className = "stream_tr2 Font_Arial_14";
                    tr_DeviceAPICertificate.id = 'APICertificate_'+index;
                        var td_DeviceAPICertificate = document.createElement("td");
                            var Label_DeviceAPICertificate  = document.createElement("label");
                            Label_DeviceAPICertificate.className = "Label_DeviceAPICertificate Font_Arial_14 label_tr";
                            Label_DeviceAPICertificate.id = "Label_DeviceAPICertificate";
                            Label_DeviceAPICertificate.style.cssText  = "width:100px; height:16px; Font_Arial_14;";
                            Label_DeviceAPICertificate.innerText = window.LanguageManager.getTranslatedText("DeviceAPICertificate");                           
                            if(document.getElementById("GobalSelectLanguage").value == 0)
                            {
                                Label_DeviceAPICertificate.style.width  = "150px";
                                Label_DeviceAPICertificate.style.marginRight  = "65px";
                            }
                            else
                            {
                                Label_DeviceAPICertificate.style.width  = "100px";
                                Label_DeviceAPICertificate.style.marginRight  = "115px";
                            }

                            var fileUploadWrapper_Certificate = document.createElement("div");
                            fileUploadWrapper_Certificate.style.cssText = "position: relative; display: inline-block; width: 184px; height: 32px;";

                            var input_DeviceAPICertificateInput = document.createElement("input");
                            input_DeviceAPICertificateInput.id = "DeviceAPICertificateInput_"+index;
                            input_DeviceAPICertificateInput.type = "file";
                            input_DeviceAPICertificateInput.accept = ".crt";
                            input_DeviceAPICertificateInput.style.cssText = "display:none;";
                            input_DeviceAPICertificateInput.setAttribute("onchange", "onChangeAPICertificate()");

                            var customButton_Certificate = document.createElement("div");
                            customButton_Certificate.id = "CertificateButton_"+index;
                            customButton_Certificate.style.cssText = "width: 100%; height: 32px; border: 1px solid #ccc; background: white; display: flex; align-items: center; justify-content: center; cursor: pointer; font-family: Arial; font-size: 14px; color: #666; border-radius: 3px; position: relative; z-index: 1; user-select: none; -webkit-user-select: none; -moz-user-select: none; -ms-user-select: none;";

                            customButton_Certificate.innerText = getFileUploadText();

                            input_DeviceAPICertificateInput.addEventListener('change', function() {
                                if (this.files && this.files.length > 0) 
                                {
                                    const fileName = this.files[0].name;
                                    const file = this.files[0];
                                    
                                    setSuccessStyle(customButton_Certificate, fileName);
                                    
                                    const reader = new FileReader();
                                    reader.onload = function(e) {
                                        const content = e.target.result;
                                        if (content.includes('-----BEGIN CERTIFICATE-----')) {
                                            storeCertificateToCache(index, content, fileName);
                                            console.log('Certificate auto-cached:', fileName);
                                        } else {
                                            console.error('Invalid certificate format');
                                            alert(window.LanguageManager.getTranslatedText("Invalid_certificate_format") || 
                                                  'Invalid certificate format');
                                            resetStyle(customButton_Certificate);
                                            this.value = '';
                                        }
                                    };
                                    reader.onerror = function() {
                                        console.error('Failed to read certificate file');
                                        resetStyle(customButton_Certificate);
                                    };
                                    reader.readAsText(file);
                                } 
                                else 
                                {
                                    resetStyle(customButton_Certificate);
                                    clearCertificateFromCache(index);
                                }
                            });

                            customButton_Certificate.addEventListener('mouseenter', function() {
                                if (!input_DeviceAPICertificateInput.files || input_DeviceAPICertificateInput.files.length === 0) {
                                    this.style.borderColor = '#89CFD8';
                                    this.style.backgroundColor = '#f8f9fa';
                                }
                            });
                            
                            customButton_Certificate.addEventListener('mouseleave', function() {
                                if (!input_DeviceAPICertificateInput.files || input_DeviceAPICertificateInput.files.length === 0) {
                                    this.style.borderColor = '#ccc';
                                    this.style.backgroundColor = 'white';
                                }
                            });

                            customButton_Certificate.addEventListener('click', function() {
                                input_DeviceAPICertificateInput.click();
                            });

                            customButton_Certificate.addEventListener('dragenter', function(e) {
                                e.preventDefault();
                                e.stopPropagation();
                                console.log('Certificate: File drag enter');
                                this.style.borderColor = '#007bff';
                                this.style.backgroundColor = '#e3f2fd';
                                this.style.transform = 'scale(1.02)';
                            });

                            customButton_Certificate.addEventListener('dragover', function(e) {
                                e.preventDefault();
                                e.stopPropagation();
                                console.log('Certificate: File drag over');
                                this.style.borderColor = '#007bff';
                                this.style.backgroundColor = '#e3f2fd';
                                this.style.borderStyle = 'dashed';
                            });

                            customButton_Certificate.addEventListener('dragleave', function(e) {
                                e.preventDefault();
                                e.stopPropagation();
                                console.log('Certificate: File drag leave');
                                
                                if (!this.contains(e.relatedTarget)) {
                                    if (!input_DeviceAPICertificateInput.files || input_DeviceAPICertificateInput.files.length === 0) {
                                        this.style.borderColor = '#ccc';
                                        this.style.backgroundColor = 'white';
                                    } else {
                                        this.style.borderColor = '#28a745';
                                        this.style.backgroundColor = '#f8fff9';
                                    }
                                    this.style.borderStyle = 'solid';
                                    this.style.transform = 'scale(1)';
                                }
                            });

                            customButton_Certificate.addEventListener('drop', function(e) {
                                e.preventDefault();
                                e.stopPropagation();
                                console.log('Certificate: File dropped');
                                
                                const files = e.dataTransfer.files;
                                console.log('Certificate: Dropped files count:', files.length);
                                
                                if (files.length > 0) {
                                    const file = files[0];
                                    console.log('Certificate: File name:', file.name);
                                    console.log('Certificate: File type:', file.type);
                                    console.log('Certificate: File size:', file.size);
                                    
                                    const allowedExtensions = ['.crt'];
                                    const fileName = file.name.toLowerCase();
                                    const isValidFile = allowedExtensions.some(ext => fileName.endsWith(ext));
                                    
                                    if (isValidFile) {
                                        const dataTransfer = new DataTransfer();
                                        dataTransfer.items.add(file);
                                        input_DeviceAPICertificateInput.files = dataTransfer.files;
                                        

                                        const changeEvent = new Event('change', { bubbles: true });
                                        input_DeviceAPICertificateInput.dispatchEvent(changeEvent);
                                        
                                        console.log('Certificate: File successfully uploaded');
                                    } else {
                                        alert(window.LanguageManager.getTranslatedText("Please_select_a_valid_certificate"));
                                        console.log('Certificate: Invalid file type');
                                    }
                                }
                                

                                this.style.borderStyle = 'solid';
                                this.style.transform = 'scale(1)';
                            });

                            fileUploadWrapper_Certificate.appendChild(input_DeviceAPICertificateInput);
                            fileUploadWrapper_Certificate.appendChild(customButton_Certificate);

                        td_DeviceAPICertificate.appendChild(Label_DeviceAPICertificate);
                        td_DeviceAPICertificate.appendChild(fileUploadWrapper_Certificate);
                    tr_DeviceAPICertificate.appendChild(td_DeviceAPICertificate);

                    var tr_DeviceAPIPrivateKey = document.createElement("tr");
                    tr_DeviceAPIPrivateKey.className = "stream_tr2 Font_Arial_14";
                    tr_DeviceAPIPrivateKey.id = 'APIPrivateKey_'+index;
                        var td_DeviceAPIPrivateKey = document.createElement("td");
                            var Label_DeviceAPIPrivateKey  = document.createElement("label");
                            Label_DeviceAPIPrivateKey.className = "Label_DeviceAPIPrivateKey Font_Arial_14 label_tr";
                            Label_DeviceAPIPrivateKey.id = "Label_DeviceAPIPrivateKey";
                            Label_DeviceAPIPrivateKey.style.cssText  = "width:150px; height:16px; Font_Arial_14;";
                            Label_DeviceAPIPrivateKey.innerText = window.LanguageManager.getTranslatedText("DeviceAPIPrivateKey");
                            if(document.getElementById("GobalSelectLanguage").value == 0)
                            {
                                Label_DeviceAPIPrivateKey.style.width  = "150px";
                                Label_DeviceAPIPrivateKey.style.marginRight  = "65px";
                            }
                            else
                            {
                                Label_DeviceAPIPrivateKey.style.width  = "100px";
                                Label_DeviceAPIPrivateKey.style.marginRight  = "115px";
                            }


                            var fileUploadWrapper_PrivateKey = document.createElement("div");
                            fileUploadWrapper_PrivateKey.style.cssText = "position: relative; display: inline-block; width: 184px; height: 32px;";

                            var input_DeviceAPIPrivateKey = document.createElement("input");
                            input_DeviceAPIPrivateKey.id = "DeviceAPIPrivateKeyInput_"+index;
                            input_DeviceAPIPrivateKey.style.cssText = "display:none;";
                            input_DeviceAPIPrivateKey.type = "file";
                            input_DeviceAPIPrivateKey.accept = ".key";
                            input_DeviceAPIPrivateKey.setAttribute("onchange", "onChangeSoundDeviceApplyStatus()");

                            var customButton_PrivateKey = document.createElement("div");
                            customButton_PrivateKey.id = "PrivateKeyButton_"+index;
                            customButton_PrivateKey.style.cssText = "width: 100%; height: 32px; border: 1px solid #ccc; background: white; display: flex; align-items: center; justify-content: center; cursor: pointer; font-family: Arial; font-size: 14px; color: #666; border-radius: 3px; position: relative; z-index: 1; user-select: none; -webkit-user-select: none; -moz-user-select: none; -ms-user-select: none;";
                            customButton_PrivateKey.innerText = getFileUploadText();

                            input_DeviceAPIPrivateKey.addEventListener('change', function() {
                                if (this.files && this.files.length > 0) 
                                {
                                    const fileName = this.files[0].name;
                                    const file = this.files[0];
                                    
                                    setSuccessStyle(customButton_PrivateKey, fileName);
                                    
                                    const reader = new FileReader();
                                    reader.onload = function(e) {
                                        const content = e.target.result;
                                        if (content.includes('-----BEGIN PRIVATE KEY-----') || 
                                            content.includes('-----BEGIN RSA PRIVATE KEY-----')) {
                                            storePrivateKeyToCache(index, content, fileName);
                                            console.log('Private key auto-cached:', fileName);
                                        } else {
                                            console.error('Invalid private key format');
                                            alert(window.LanguageManager.getTranslatedText("Invalid_private_key_format") || 
                                                  'Invalid private key format');
                                            resetStyle(customButton_PrivateKey);
                                            this.value = '';
                                        }
                                    };
                                    reader.onerror = function() {
                                        console.error('Failed to read private key file');
                                        resetStyle(customButton_PrivateKey);
                                    };
                                    reader.readAsText(file);
                                } 
                                else 
                                {
                                    resetStyle(customButton_PrivateKey);
                                    clearPrivateKeyFromCache(index);
                                }
                            });

                            customButton_PrivateKey.addEventListener('mouseenter', function() {
                                if (!input_DeviceAPIPrivateKey.files || input_DeviceAPIPrivateKey.files.length === 0) {
                                    this.style.borderColor = '#89CFD8';
                                    this.style.backgroundColor = '#f8f9fa';
                                }
                            });
                            
                            customButton_PrivateKey.addEventListener('mouseleave', function() {
                                if (!input_DeviceAPIPrivateKey.files || input_DeviceAPIPrivateKey.files.length === 0) {
                                    this.style.borderColor = '#ccc';
                                    this.style.backgroundColor = 'white';
                                }
                            });

                            customButton_PrivateKey.addEventListener('click', function() {
                                input_DeviceAPIPrivateKey.click();
                            });

                            customButton_PrivateKey.addEventListener('dragenter', function(e) {
                                e.preventDefault();
                                e.stopPropagation();
                                console.log('PrivateKey: File drag enter');
                                this.style.borderColor = '#007bff';
                                this.style.backgroundColor = '#e3f2fd';
                                this.style.transform = 'scale(1.02)';
                            });

                            customButton_PrivateKey.addEventListener('dragover', function(e) {
                                e.preventDefault();
                                e.stopPropagation();
                                console.log('PrivateKey: File drag over');
                                this.style.borderColor = '#007bff';
                                this.style.backgroundColor = '#e3f2fd';
                                this.style.borderStyle = 'dashed';
                            });
                    
                            customButton_PrivateKey.addEventListener('dragleave', function(e) {
                                e.preventDefault();
                                e.stopPropagation();
                                console.log('PrivateKey: File drag leave');
                                
                                if (!this.contains(e.relatedTarget)) {
                                    if (!input_DeviceAPIPrivateKey.files || input_DeviceAPIPrivateKey.files.length === 0) {
                                        this.style.borderColor = '#ccc';
                                        this.style.backgroundColor = 'white';
                                    } else {
                                        this.style.borderColor = '#28a745';
                                        this.style.backgroundColor = '#f8fff9';
                                    }
                                    this.style.borderStyle = 'solid';
                                    this.style.transform = 'scale(1)';
                                }
                            });
                    
                            customButton_PrivateKey.addEventListener('drop', function(e) {
                                e.preventDefault();
                                e.stopPropagation();
                                console.log('PrivateKey: File dropped');
                                
                                const files = e.dataTransfer.files;
                                console.log('PrivateKey: Dropped files count:', files.length);
                                
                                if (files.length > 0) {
                                    const file = files[0];
                                    console.log('PrivateKey: File name:', file.name);
                                    console.log('PrivateKey: File type:', file.type);
                                    console.log('PrivateKey: File size:', file.size);
                                    
                                    const allowedExtensions = ['.key'];
                                    const fileName = file.name.toLowerCase();
                                    const isValidFile = allowedExtensions.some(ext => fileName.endsWith(ext));
                                    
                                    if (isValidFile) {
                                        const dataTransfer = new DataTransfer();
                                        dataTransfer.items.add(file);
                                        input_DeviceAPIPrivateKey.files = dataTransfer.files;
                                        
                                        const changeEvent = new Event('change', { bubbles: true });
                                        input_DeviceAPIPrivateKey.dispatchEvent(changeEvent);
                                        
                                        console.log('PrivateKey: File successfully uploaded');
                                    } else {
                                        alert(window.LanguageManager.getTranslatedText("Please_select_a_valid_private_key"));
                                        console.log('PrivateKey: Invalid file type');
                                    }
                                }
                                
                                this.style.borderStyle = 'solid';
                                this.style.transform = 'scale(1)';
                            });
                    

                            fileUploadWrapper_PrivateKey.appendChild(input_DeviceAPIPrivateKey);
                            fileUploadWrapper_PrivateKey.appendChild(customButton_PrivateKey);

                        td_DeviceAPIPrivateKey.appendChild(Label_DeviceAPIPrivateKey);
                        td_DeviceAPIPrivateKey.appendChild(fileUploadWrapper_PrivateKey);

                    tr_DeviceAPIPrivateKey.append(td_DeviceAPIPrivateKey);

                    var tr_DeviceAPITokens = document.createElement("tr");
                    tr_DeviceAPITokens.className = "stream_tr2 Font_Arial_14";
                    tr_DeviceAPITokens.id = 'APITokens_'+index;
                        var td_DeviceAPITokens = document.createElement("td");
                            var Label_DeviceAPITokens  = document.createElement("label");
                            Label_DeviceAPITokens.className = "label_DeviceAPITokens Font_Arial_14 label_tr";
                            Label_DeviceAPITokens.id = "label_DeviceAPITokens";
                            Label_DeviceAPITokens.style.cssText  = "width:100px; height:16px; Font_Arial_14;";
                            Label_DeviceAPITokens.innerText = window.LanguageManager.getTranslatedText("DeviceAPITokens");    
                            if(document.getElementById("GobalSelectLanguage").value == 0)
                            {
                                Label_DeviceAPITokens.style.width  = "200px";
                                Label_DeviceAPITokens.style.marginRight  = "15px";
                            }
                            else
                            {
                                Label_DeviceAPITokens.style.width  = "200px";
                                Label_DeviceAPITokens.style.marginRight  = "15px";
                            }                       

                            var input_DeviceAPIKeyInput = document.createElement("input");
                            input_DeviceAPIKeyInput.id = "DeviceAPIKeyInput_"+index;
                            input_DeviceAPIKeyInput.style.cssText  = "width:184px; height:32px; Font_Arial_14;";
                            input_DeviceAPIKeyInput.type = "text";
                            input_DeviceAPIKeyInput.maxLength = "256";
                            input_DeviceAPIKeyInput.setAttribute("onchange", "onChangeAPIKey()");

                        td_DeviceAPITokens.appendChild(Label_DeviceAPITokens);
                        td_DeviceAPITokens.appendChild(input_DeviceAPIKeyInput);

                    tr_DeviceAPITokens.append(td_DeviceAPITokens);

                    var tr_DeviceConnect = document.createElement("tr");
                    tr_DeviceConnect.className = "stream_tr2 Font_Arial_14";
                        var td_DeviceConnect = document.createElement("td"); 
                            var label_DeviceConnect = document.createElement("label");
                            label_DeviceConnect.id = "Label_DeviceConnect";
                            label_DeviceConnect.className = "label_DeviceConnect Font_Arial_14";   
                            label_DeviceConnect.innerText = "Connect";

                            var label_switch_onoff = document.createElement("label");
                            label_switch_onoff.className = "switch_onoff";
                                var input_connectCheckboxInput = document.createElement("input");
                                input_connectCheckboxInput.id = "connectCheckboxInput_"+index;
                                input_connectCheckboxInput.type = "checkbox";
                                input_connectCheckboxInput.setAttribute("onchange", "changeConnectStatus(this)");
                                
                                var span_class = document.createElement("span");
                                span_class.className = "slider_onoff";
                            label_switch_onoff.appendChild(input_connectCheckboxInput);   
                            label_switch_onoff.appendChild(span_class);   

                            var img_DeviceStatus = document.createElement("img");
                            img_DeviceStatus.id = "img_DeviceStatus_"+ index;
                            img_DeviceStatus.className = "MicStatus_Img";
                            img_DeviceStatus.src = "./images/MicDisconnect.png";

                            var button_deviceApply = document.createElement("button");
                            button_deviceApply.id = "deviceApply_" + index;
                            button_deviceApply.type = "button";
                            button_deviceApply.style = "width: 0px; margin-left: 0px; display: none;";
                            //button_deviceApply.className = "Btn_style";
                            button_deviceApply.innerText = "Apply";
                            button_deviceApply.setAttribute("onchange", "onChangeSoundDeviceSettingApply()");
                            
                        td_DeviceConnect.appendChild(label_DeviceConnect);
                        td_DeviceConnect.appendChild(label_switch_onoff);
                        td_DeviceConnect.appendChild(img_DeviceStatus); 
                        td_DeviceConnect.appendChild(button_deviceApply);
                    tr_DeviceConnect.append(td_DeviceConnect);

                td_Device.appendChild(tr_DeviceType);
                td_Device.appendChild(tr_DeviceIP_DeviceIP);
                td_Device.appendChild(tr_DeviceIP_DevicePort);
                td_Device.appendChild(tr_Password);
                td_Device.appendChild(tr_ExclusionMode);
                td_Device.appendChild(tr_DeviceAPICertificate);
                td_Device.appendChild(tr_DeviceAPIPrivateKey);
                td_Device.appendChild(tr_DeviceAPITokens);
                td_Device.appendChild(tr_DeviceConnect);

            table_Device.appendChild(tr_Device);
            table_Device.appendChild(td_Device);
        
        div_content_Device.appendChild(table_Device);
        
        //--------------------
        var div_custom_box = document.createElement("div");
        div_custom_box.id="div_custom_box_" + index;
        div_custom_box.style.cssText ="height : 64px;"
        //------------------

        var div_Advanced = document.createElement("div");
        div_Advanced.id = "div_Advanced_" + index;
        div_Advanced.className="content_H340";
        div_Advanced.style.cssText ="display:none;"

            var label_Advanced = document.createElement("label");
            label_Advanced.id = "";
            label_Advanced.className = "Font_Arial_16_bold margin-left-24px margin-top-10px";
            label_Advanced.style.cssText ="width : 180px;"
            //label_Advanced.innerText = "Advanced";

            var table_Advanced = document.createElement("table");
            table_Advanced.className = "margin-left-64px";
            table_Advanced.style.cssText = "marginTop:28px;"

                var tr_AudioTrigger = document.createElement("tr");
                tr_AudioTrigger.className="stream_tr2 Font_Arial_14";
                tr_AudioTrigger.id = "audioLevel_" + index;
                    var td_AudioTrigger = document.createElement("td");
                        var label_AudioTrigger = document.createElement("label");
                        label_AudioTrigger.className = "Font_Arial_14";
                        label_AudioTrigger.style.cssText = "width : 152px;"
                        label_AudioTrigger.id = "AudioTriggerLevel_" + index;
                        label_AudioTrigger.innerText = "Audio Trigger Level (dB)";

                        var input_AudioTrigger = document.createElement("input");
                        input_AudioTrigger.id = "InputModelAudioTrigger_" + index;
                        input_AudioTrigger.type = "text";
                        input_AudioTrigger.maxLength = "5";
                        input_AudioTrigger.style.cssText = "width :184px; height : 32px; margin-left : 63px;"
                        input_AudioTrigger.value = "-50";
                        input_AudioTrigger.addEventListener("change",handleArrayRangechange);
                        
                    td_AudioTrigger.appendChild(label_AudioTrigger);
                    td_AudioTrigger.appendChild(input_AudioTrigger);
                tr_AudioTrigger.appendChild(td_AudioTrigger);

                var tr_Preset = document.createElement("tr");
                tr_Preset.className="stream_tr2 Font_Arial_14";
                    var td_Preset = document.createElement("td");
                        var label_TimetoTriggerPreset = document.createElement("label");
                        label_TimetoTriggerPreset.id = "TimetoTriggerPreset_" + index;
                        label_TimetoTriggerPreset.className = "Font_Arial_14";
                        if(document.getElementById("GobalSelectLanguage").value == 0)
                        {
                            label_TimetoTriggerPreset.style.cssText  = "width : 145px;"
                        }
                        else
                        {
                            label_TimetoTriggerPreset.style.cssText  = "width : 145px;"
                        }
                        label_TimetoTriggerPreset.innerText = "Time to Trigger Preset";

                        var select_SelectModelPreset = document.createElement("select");
                        select_SelectModelPreset.id = "SelectModelPreset_" + index;
                        select_SelectModelPreset.className = "selectH32 selectW184";
                        if(document.getElementById("GobalSelectLanguage").value == 0)
                        {
                            select_SelectModelPreset.style.cssText = "margin-left : 70px;"
                        }
                        else
                        {
                            select_SelectModelPreset.style.cssText = "margin-left : 70px;"
                        }
                        select_SelectModelPreset.setAttribute("onchange", "SelectModelApplyStatusChange()");

                            for (let i = 0; i < gSelectModelPresetOptions[document.getElementById("GobalSelectLanguage").value].length; i++) {
                                var SelectModelPresetoption = document.createElement("option");
                                SelectModelPresetoption.value = i;
                                SelectModelPresetoption.innerText = gSelectModelPresetOptions[document.getElementById("GobalSelectLanguage").value][i];
                                select_SelectModelPreset.appendChild(SelectModelPresetoption);
                            }
                    td_Preset.appendChild(label_TimetoTriggerPreset);
                    td_Preset.appendChild(select_SelectModelPreset);
                tr_Preset.appendChild(td_Preset); 

                if(gIsUseGlobalBackToHomeControl)
                {
                    var tr_HomeSetting = document.createElement("tr");
                    tr_HomeSetting.className="stream_tr2 Font_Arial_14";
                        var td_HomeSetting = document.createElement("td");

                            var label_BackToHomeSetting = document.createElement("label");
                            label_BackToHomeSetting.id = "BackToHomeSetting_" + index;
                            label_BackToHomeSetting.className = "Font_Arial_14 label_tr";
                            label_BackToHomeSetting.style.cssText = "width : 123px; "
                            label_BackToHomeSetting.innerText =  window.LanguageManager.getTranslatedText("Back_to_Home");//"Back to Home";   
                                                               
                            var homeSettingButton = document.createElement("button");
                            homeSettingButton.id = "BtnModelBackToHomeSetting_" + index;
                            homeSettingButton.type = "button";
                            homeSettingButton.className = "Btn_style applyButton";
                            homeSettingButton.style.cssText ="margin-left : 92px;"
                            //homeSettingButton.disabled = true;
                            homeSettingButton.innerText = "Set";
                            homeSettingButton.setAttribute("onclick", "onBackToHomeSettingClick()");
                            
                            td_HomeSetting.appendChild(label_BackToHomeSetting);
                            td_HomeSetting.appendChild(homeSettingButton);
                    tr_HomeSetting.appendChild(td_HomeSetting);
                }

                var tr_HomeTime = document.createElement("tr");
                tr_HomeTime.className="stream_tr2 Font_Arial_14";
                    var td_HomeTime = document.createElement("td");

                        var label_BackToHometime = document.createElement("label");
                        label_BackToHometime.id = "BackToHometime_" + index;
                        label_BackToHometime.className = "Font_Arial_14 label_tr";
                        label_BackToHometime.style.cssText = "width : 123px; "
                        label_BackToHometime.innerText = window.LanguageManager.getTranslatedText("Back_to_Home_Time");

                        var select_SelectModelHomeTimes = document.createElement("select");
                        select_SelectModelHomeTimes.id = "SelectModelHomeTimes_" + index;
                        select_SelectModelHomeTimes.className = "selectH32 selectW184";
                        select_SelectModelHomeTimes.style.cssText ="margin-left : 92px;"
                        select_SelectModelHomeTimes.setAttribute("onchange", "SelectModelApplyStatusChange()");

                            for (let i = 0; i < gSelectModelHomeTimesOptions[document.getElementById("GobalSelectLanguage").value].length; i++) {
                                var SelectModelHomeTimesoption = document.createElement("option");
                                SelectModelHomeTimesoption.value = i;
                                SelectModelHomeTimesoption.innerText = gSelectModelHomeTimesOptions[document.getElementById("GobalSelectLanguage").value][i];
                                select_SelectModelHomeTimes.appendChild(SelectModelHomeTimesoption);
                            }

                    td_HomeTime.appendChild(label_BackToHometime);
                    td_HomeTime.appendChild(select_SelectModelHomeTimes);
                tr_HomeTime.appendChild(td_HomeTime);

                var tr_HomeCamera = document.createElement("tr");
                tr_HomeCamera.className="stream_tr2 Font_Arial_14";
                    var td_HomeCamera = document.createElement("td");

                        var label_BackHomeCamera = document.createElement("label");
                        label_BackHomeCamera.id = "BackHomeCamera_" + index;
                        label_BackHomeCamera.className = "Font_Arial_14 label_tr";
                        label_BackHomeCamera.style.cssText = "width : 152px;"
                        label_BackHomeCamera.innerText = window.LanguageManager.getTranslatedText("Back_to_Home_Camera");

                        var select_SelectModelHomeCamera= document.createElement("select");
                        select_SelectModelHomeCamera.id = "SelectModelHomeCamera_" + index;
                        select_SelectModelHomeCamera.className = "selectH32 selectW184"; 
                        select_SelectModelHomeCamera.style.cssText = "margin-left : 63px;"  
                        select_SelectModelHomeCamera.setAttribute("onchange", "SelectModelHomeCameraOnChange()");

                            var option_All = document.createElement("option");
                            option_All.value = 0;
                            option_All.text = window.LanguageManager.getTranslatedText("All_Camera");
                            option_All.selected = true;
                        select_SelectModelHomeCamera.appendChild(option_All);

                    td_HomeCamera.appendChild(label_BackHomeCamera);
                    td_HomeCamera.appendChild(select_SelectModelHomeCamera);
                tr_HomeCamera.appendChild(td_HomeCamera);

                var tr_HomePosition = document.createElement("tr");
                tr_HomePosition.className="stream_tr2 Font_Arial_14";
                    var td_HomePosition = document.createElement("td");
                        var label_HomePosition = document.createElement("label");
                        label_HomePosition.className = "Font_Arial_14 label_tr";
                        label_HomePosition.style.cssText = "width : 152px; "
                        label_HomePosition.className = "label_tr";
                        label_HomePosition.id = "BackToHomePosition_" + index;
                        label_HomePosition.innerText = "Back To Home Position";

                        var select_HomePosition = document.createElement("select");
                        select_HomePosition.id = "SelectModelHomePosition_" + index;
                        select_HomePosition.className = "selectH32";
                        select_HomePosition.style.cssText ="margin-left : 63px; width : 96px;"
                        select_HomePosition.setAttribute("onchange", "SelectModelHomePositionOnChange()");
                        select_HomePosition.addEventListener("change", SelectModelHomePositionOnChange);
                            var option_Home = document.createElement("option");
                            option_Home.value = 0;
                            option_Home.text = "Home";
                            var option_Preset = document.createElement("option");
                            option_Preset.value = 1;
                            option_Preset.text = "Preset";
                        select_HomePosition.appendChild(option_Home);
                        select_HomePosition.appendChild(option_Preset);

                        var input_HomePosition = document.createElement("input");
                        input_HomePosition.id =  "InputModelHomePosition_" + index;
                        input_HomePosition.style.cssText = "margin-left : 8px; height :32px; width : 80px;"
 		                input_HomePosition.type = "number";
                        input_HomePosition.min = "0";
                        input_HomePosition.max = "255";
                        input_HomePosition.addEventListener("change", InputModelHomePositionOnChange);

                    td_HomePosition.appendChild(label_HomePosition);
                    td_HomePosition.appendChild(select_HomePosition);
                    td_HomePosition.appendChild(input_HomePosition);
                tr_HomePosition.appendChild(td_HomePosition);
            
            table_Advanced.appendChild(tr_AudioTrigger);
            table_Advanced.appendChild(tr_Preset);
            if(!gIsUseGlobalBackToHomeControl)
            {
                table_Advanced.appendChild(tr_HomeTime);
                table_Advanced.appendChild(tr_HomeCamera);
                table_Advanced.appendChild(tr_HomePosition);
            }
            else
            {
                table_Advanced.appendChild(tr_HomeSetting);
            }

            var tr_custombox = document.createElement("tr");
            tr_custombox.style.cssText ="height : 24px";

            var applyButton = document.createElement("button");
            applyButton.id = "BtnModelApply_" + index;
            applyButton.type = "button";
            applyButton.className = "Btn_style applyButton";
            applyButton.disabled = true;
            applyButton.innerText = "Apply";
            applyButton.setAttribute("onclick", "onAdvanceApplyClick()");

            var cancelButton = document.createElement("button");
            cancelButton.id = "BtnModelCancel_" + index;
            cancelButton.type = "button";
            cancelButton.className = "Btn_style margin-top-10px";
            cancelButton.disabled = true;
            cancelButton.innerText = "Cancel";
            cancelButton.setAttribute("onclick", "onAdvanceCancelClick()");

        div_Advanced.appendChild(table_Advanced);
        div_Advanced.appendChild(tr_custombox);
        div_Advanced.appendChild(applyButton);
        div_Advanced.appendChild(cancelButton);
    
    var Div_Device_Container = document.getElementById("Div_Device_"+index);
    if(Div_Device_Container)
    {
        Div_Device_Container.innerHTML = "";
        Div_Device_Container.appendChild(div_content_Device); 
        Div_Device_Container.appendChild(div_custom_box);
        Div_Device_Container.appendChild(div_Advanced);
    }
}

function setDeviceCertificateDisabled(index, isDisabled) 
{
    const certInput = document.getElementById('DeviceAPICertificateInput_' + index);
    const certButton = document.getElementById('CertificateButton_' + index);
    const keyInput = document.getElementById('DeviceAPIPrivateKeyInput_' + index);
    const keyButton = document.getElementById('PrivateKeyButton_' + index);
    
    if (isDisabled) 
    {
        if (certInput) certInput.disabled = true;
        if (keyInput) keyInput.disabled = true;
        
        if (certButton) 
        {
            if (!certButton.hasAttribute('data-original-color')) {
                certButton.setAttribute('data-original-color', certButton.style.color || '#666');
            }
            
            certButton.style.backgroundColor = '#d0d0d0';
            certButton.style.color = '#a0a0a0';
            certButton.style.borderColor = '#d0d0d0';
            certButton.style.cursor = 'not-allowed';
            certButton.style.pointerEvents = 'none';
            certButton.style.opacity = '0.6';
        }
        
        if (keyButton) 
        {
            if (!keyButton.hasAttribute('data-original-color')) {
                keyButton.setAttribute('data-original-color', keyButton.style.color || '#666');
            }
            
            keyButton.style.backgroundColor = '#d0d0d0';
            keyButton.style.color = '#a0a0a0';
            keyButton.style.borderColor = '#d0d0d0';
            keyButton.style.cursor = 'not-allowed';
            keyButton.style.pointerEvents = 'none';
            keyButton.style.opacity = '0.6';
        }
        
    } 
    else 
    {
        if (certInput) certInput.disabled = false;
        if (keyInput) keyInput.disabled = false;
        
        if (certButton) 
        {

            certButton.style.backgroundColor = 'white';
            certButton.style.color = '#666';
            certButton.style.borderColor = '#ccc';
            certButton.style.cursor = 'pointer';
            certButton.style.pointerEvents = 'auto';
            certButton.style.opacity = '1';
            
            if (certInput && certInput.files && certInput.files.length > 0) 
            {
                certButton.style.color = '#333';
                certButton.style.borderColor = '#28a745';
                certButton.style.backgroundColor = '#f8fff9';
            }
        }
        
        if (keyButton) 
        {
            keyButton.style.backgroundColor = 'white';
            keyButton.style.color = '#666';
            keyButton.style.borderColor = '#ccc';
            keyButton.style.cursor = 'pointer';
            keyButton.style.pointerEvents = 'auto';
            keyButton.style.opacity = '1';
            
            if (keyInput && keyInput.files && keyInput.files.length > 0) 
            {
                keyButton.style.color = '#333';
                keyButton.style.borderColor = '#28a745';
                keyButton.style.backgroundColor = '#f8fff9';
            }
        }
    }

    setTimeout(() => {
        saveCurrentFileState(index);
    }, 50);
}

var uploadedFilesCache = {};
var deviceStateBackup = {};


function saveCurrentFileState(deviceIndex) {
    const cache = getCachedData(deviceIndex);
    const certificateInput = document.getElementById("DeviceAPICertificateInput_" + deviceIndex);
    const privateKeyInput = document.getElementById("DeviceAPIPrivateKeyInput_" + deviceIndex);
    const certificateButton = document.getElementById("CertificateButton_" + deviceIndex);
    const privateKeyButton = document.getElementById("PrivateKeyButton_" + deviceIndex);
    
    function captureFileState(input, button) {
        const hasFile = input && input.files && input.files.length > 0;
        return {
            hasFile: hasFile,
            fileName: hasFile ? input.files[0].name : null,
            buttonText: button ? button.innerText : null,
            buttonStyle: button ? {
                color: button.style.color,
                borderColor: button.style.borderColor,
                backgroundColor: button.style.backgroundColor,
                title: button.title
            } : null
        };
    }
    
    deviceStateBackup[deviceIndex] = {
        certificate: {
            ...captureFileState(certificateInput, certificateButton),
            cachedData: cache.certificate ? {...cache.certificate} : null
        },
        privateKey: {
            ...captureFileState(privateKeyInput, privateKeyButton),
            cachedData: cache.privateKey ? {...cache.privateKey} : null
        },
        timestamp: new Date().getTime()
    };
}

function restoreFileState(deviceIndex) {
    const backup = deviceStateBackup[deviceIndex];
    if (!backup) {
        return false;
    }
    
    const certificateInput = document.getElementById("DeviceAPICertificateInput_" + deviceIndex);
    const privateKeyInput = document.getElementById("DeviceAPIPrivateKeyInput_" + deviceIndex);
    const certificateButton = document.getElementById("CertificateButton_" + deviceIndex);
    const privateKeyButton = document.getElementById("PrivateKeyButton_" + deviceIndex);
    
    function restoreFileType(input, button, backupData, fileType, clearFunc, storeFunc, resetFunc) {
        if (!input || !button) {
            return false;
        }
        
        input.value = '';
        clearFunc(deviceIndex);
        
        if (backupData.hasFile && backupData.cachedData) {
            storeFunc(deviceIndex, backupData.cachedData.content, backupData.cachedData.fileName);
            
            if (backupData.buttonStyle) {
                button.style.color = backupData.buttonStyle.color;
                button.style.borderColor = backupData.buttonStyle.borderColor;
                button.style.backgroundColor = backupData.buttonStyle.backgroundColor;
                button.title = backupData.buttonStyle.title;
                button.innerText = backupData.buttonText;
            }
            
            return true;
        } else {
            resetFunc(button);
            return true;
        }
    }
    
    const certificateRestored = restoreFileType(
        certificateInput, certificateButton, backup.certificate, 
        'Certificate', clearCertificateFromCache, storeCertificateToCache, resetStyle
    );
    
    const privateKeyRestored = restoreFileType(
        privateKeyInput, privateKeyButton, backup.privateKey, 
        'Private Key', clearPrivateKeyFromCache, storePrivateKeyToCache, resetPrivateKeyStyle
    );
    
    if (certificateRestored || privateKeyRestored) {
        const backupAge = new Date().getTime() - backup.timestamp;
        console.log(`State restoration completed for device ${deviceIndex} (backup age: ${backupAge}ms)`);
        return true;
    }
    
    return false;
}


function resetPrivateKeyStyle(button) {
    resetStyle(button);
}



function initDeviceCache(deviceIndex) {
    if (!uploadedFilesCache[deviceIndex]) {
        uploadedFilesCache[deviceIndex] = {
            certificate: null,
            privateKey: null,
            uploadTime: null
        };
    }
}

function storeCertificateToCache(deviceIndex, content, fileName) {
    if (!content || !fileName) {
        return false;
    }
    
    initDeviceCache(deviceIndex);
    uploadedFilesCache[deviceIndex].certificate = {
        content: content,
        fileName: fileName,
        size: content.length,
        uploadTime: new Date().getTime()
    };
    return true;
}

function storePrivateKeyToCache(deviceIndex, content, fileName) {
    if (!content || !fileName) {
        return false;
    }
    
    initDeviceCache(deviceIndex);
    uploadedFilesCache[deviceIndex].privateKey = {
        content: content,
        fileName: fileName,
        size: content.length,
        uploadTime: new Date().getTime()
    };
    return true;
}

function getCachedData(deviceIndex) {
    initDeviceCache(deviceIndex);
    return uploadedFilesCache[deviceIndex];
}

function clearCachedData(deviceIndex) {
    if (uploadedFilesCache[deviceIndex]) {
        uploadedFilesCache[deviceIndex] = {
            certificate: null,
            privateKey: null,
            uploadTime: null
        };
        return true;
    }
    return false;
}

function clearCertificateFromCache(deviceIndex) {
    initDeviceCache(deviceIndex);
    const hadCertificate = !!uploadedFilesCache[deviceIndex].certificate;
    uploadedFilesCache[deviceIndex].certificate = null;
    
    if (hadCertificate) {
        console.log('Certificate cache cleared for device:', deviceIndex);
    }
    return hadCertificate;
}

function clearPrivateKeyFromCache(deviceIndex) {
    initDeviceCache(deviceIndex);
    const hadPrivateKey = !!uploadedFilesCache[deviceIndex].privateKey;
    uploadedFilesCache[deviceIndex].privateKey = null;
    
    if (hadPrivateKey) {
        console.log('Private key cache cleared for device:', deviceIndex);
    }
    return hadPrivateKey;
}

function isCacheReady(deviceIndex) {
    const cache = getCachedData(deviceIndex);
    return !!(cache.certificate && cache.privateKey);
}

function checkCacheStatus(deviceIndex) {
    const cache = getCachedData(deviceIndex);
    const status = {
        hasCertificate: !!cache.certificate,
        hasPrivateKey: !!cache.privateKey,
        isReady: !!(cache.certificate || cache.privateKey),
        bothReady: !!(cache.certificate && cache.privateKey),
        certificateFileName: cache.certificate?.fileName || null,
        privateKeyFileName: cache.privateKey?.fileName || null,
        lastUploadTime: cache.certificate?.uploadTime || cache.privateKey?.uploadTime || null
    };
    
    return status;
}

function getUploadStatus(deviceIndex) {
    const cache = getCachedData(deviceIndex);
    const lastTime = cache.certificate?.uploadTime || cache.privateKey?.uploadTime;
    
    return {
        hasCertificate: !!cache.certificate,
        hasPrivateKey: !!cache.privateKey,
        certificateFileName: cache.certificate?.fileName || null,
        privateKeyFileName: cache.privateKey?.fileName || null,
        uploadTime: lastTime ? new Date(lastTime).toLocaleString() : null,
        certificateSize: cache.certificate?.size || 0,
        privateKeySize: cache.privateKey?.size || 0
    };
}

function uploadFromCache(deviceIndex) {
    const cache = getCachedData(deviceIndex);
    
    if (!cache.certificate && !cache.privateKey) {
        return false;
    }
    
    const uploadData = {
        Command: "SetSoundAdvanceSetting",
        SoundTabIndex: deviceIndex,
        CertificateAndKeyUpload: {}
    };
    
    let itemsToUpload = [];
    
    if (cache.certificate) {
        uploadData.CertificateAndKeyUpload.Certificate = {
            content: cache.certificate.content,
            fileName: cache.certificate.fileName,
            size: cache.certificate.size
        };
        itemsToUpload.push(`Certificate: ${cache.certificate.fileName}`);
    }
    
    if (cache.privateKey) {
        uploadData.CertificateAndKeyUpload.PrivateKey = {
            content: cache.privateKey.content,
            fileName: cache.privateKey.fileName,
            size: cache.privateKey.size
        };
        itemsToUpload.push(`Private Key: ${cache.privateKey.fileName}`);
    }
    
    try {
        sendMessage("SetSoundAdvanceSetting", uploadData);
        return true;
    } catch (error) {
        return false;
    }
}

function retryUploadFromCache(deviceIndex) {
    const cache = getCachedData(deviceIndex);
    if (cache.certificate || cache.privateKey) {
        return uploadFromCache(deviceIndex);
    } 
    else 
    {
        return false;
    }
}

function onChangeAPICertificate() 
{
    if (typeof SelectModelApplyStatusChange === 'function') 
    {
        SelectModelApplyStatusChange();
    }
}

function onChangeAPIKey() 
{
    if (typeof SelectModelApplyStatusChange === 'function') 
    {
        SelectModelApplyStatusChange();
    }
}


function generateCameraAzimuthMappingTable(micArryNum) {
    var micTabPage = gDeviceIndex;
    var currentSoundType = document.getElementById("deviceTypeSel_"+micTabPage).value;
    var micSelect = parseInt(currentSoundType);
    var micGroup = getDeviceCameraMappingIndex();
    
    var selectChannel;
    if(document.getElementById("selectMicChannel_"+micGroup))
        selectChannel = document.getElementById("selectMicChannel_"+micGroup).value
    var micselectChannel = parseInt(selectChannel);

    let deviceTypeString = transferDeviceTypeToString(currentSoundType);
    //console.log("generateCameraPosMappingTable deviceTypeString:",deviceTypeString);

    // "+ "_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" + selectMicChannel

    //----------------------

    var tableBody = document.getElementById("cameraMappingTableBody" + micGroup);
    tableBody.innerHTML = "";

    var  initangle = 0;
    var  changeangle = 45;

    switch(micGroup)
    {
        case 4:
            initangle = 0;
            changeangle = 360/micArryNum;
        break;
        case 5:
            initangle  = -70;
            changeangle = 140/micArryNum;
        break; 
        case 6:
            initangle  = -180;
            changeangle = 360/micArryNum;
        break; 
    }

    for (var i = 0; i < micArryNum; i++) {
        var rowWrapper = document.createElement("div");
        rowWrapper.style.marginBottom = "2px";
            var table = document.createElement("table");

                var row = document.createElement("tr");
                    var cell0 = document.createElement("div");
                    cell0.style.cssText="margin-left:73px;"
                    
                    var cell1 = document.createElement("td");
                    cell1.style.paddingTop = "12px";
                        var img = document.createElement("img");
                        img.id = "Light_div"+ "_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" + i;
                        img.className = "light_Img";
                        img.src = "./images/Disable.png";
                    cell1.appendChild(img);
                
                    var cell2_1 = document.createElement("td");
                    cell2_1.style.paddingTop = "10px";
                    cell2_1.style.paddingLeft = "30px";
                        var input1 = document.createElement("input");
                        input1.id = "cameraMappingAzimuth_div"+ "_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" + (i+1) + "_1";
                        input1.className = "AzimuthcameraMappingInput";
                        input1.style.cssText ="font-family: Arial; font-size: 14px;"
                        input1.value = Math.floor(initangle + i * changeangle);
                        input1.addEventListener("change", handleAzimuthRangechange);
                    cell2_1.appendChild(input1);

                    var cell2_2 = document.createElement("td");
                    cell2_2.style.paddingTop = "10px";
                        var label1 = document.createElement("label");
                        label1.className = "Font_Arial_14";
                        label1.innerText  = "~";
                    cell2_2.appendChild(label1);

                    var cell2_3 = document.createElement("td");
                    cell2_3.style.paddingTop = "10px";
                        var input3 = document.createElement("input");
                        input3.id = "cameraMappingAzimuth_div"+ "_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" + (i+1) + "_2";
                        input3.className = "AzimuthcameraMappingInput";
                        input3.style.cssText ="font-family: Arial; font-size: 14px;"
                        input3.value = Math.floor(initangle + (i+1) * changeangle);
                        input3.addEventListener("change", handleAzimuthRangechange);
                    cell2_3.appendChild(input3);
                
                    var cell3 = document.createElement("td");
                    cell3.style.paddingTop = "8px";
                    cell3.style.paddingLeft = "16px";
                        var select1 = document.createElement("select");
                        select1.id = "cameraMappingSeleceItem_div"+ "_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" + (i);
                        select1.className = "selectH32 selectW270";
                        //select1.setAttribute("onchange", "onChangecameraMappingPresetStatus('false')");
                        select1.addEventListener("mouseout", onMouseoutCameraItem);
                        select1.addEventListener("mouseover", onMouseoverCameraItem);
                        select1.addEventListener("change",onChangePrimaryCameraItem);
                            var option1 = document.createElement("option");
                            option1.value = -1;
                            option1.textContent = "Off";
                        select1.appendChild(option1);
                    cell3.appendChild(select1);

                    var cell4 = document.createElement("td");
                    cell4.style.paddingTop = "8px";
                    cell4.style.paddingLeft = "24px";
                        var select2 = document.createElement("select");
                        select2.id = "cameraMappingSecondSeleceItem_div"+ "_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" + (i);
                        select2.className = "selectH32 selectW270";
                        //select1.setAttribute("onchange", "onChangecameraMappingPresetStatus('false')");
                        select2.addEventListener("mouseout", onMouseoutCameraItem);
                        select2.addEventListener("mouseover", onMouseoverCameraItem);
                        select2.addEventListener("change", onChangeSecondaryCameraItem);
                            var option2 = document.createElement("option");
                            option2.value = -1;
                            option2.textContent = "Off";
                        select2.appendChild(option2);
                    cell4.appendChild(select2);
                
                    var cell5 = document.createElement("td");
                    cell5.style.paddingTop = "10px";
                    cell5.style.paddingLeft = "24px";
                        var input = document.createElement("input");
                        input.id = "cameraMappingPreset_div"+ "_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" + (i);
                        input.type = "number";
                        input.style.cssText = "width:80px; height:32px; font-family: Arial;font-size: 14px;"
                        input.value = i + 1;
                        input.placeholder = "0~255";
                        input.min = 0;
                        input.max = 9999;
                        input.disabled = false;
                        input.addEventListener("change", handleInputChange);//,onChangecameraMappingPresetStatus('false')
                    cell5.appendChild(input);

                    var cell6 = document.createElement("td");
                    cell6.style.paddingTop = "8px";
                    cell6.style.paddingLeft = "16px";
                        var select3 = document.createElement("select");
                        select3.id = "cameraMappingAIPeopleTrackingModeSeleceItem_div"+ "_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" + (i);
                        select3.className = "selectH32 selectW160";
                        select3.addEventListener("change",onChangeCameraItem);
                            var option3 = document.createElement("option");
                            option3.value = -1;
                            option3.textContent = window.LanguageManager.getTranslatedText("Off");
                            var option4 = document.createElement("option");
                            option4.value = 0;
                            option4.textContent = window.LanguageManager.getTranslatedText("Center_Stage");
                            var option5 = document.createElement("option");
                            option5.value = 1;
                            option5.textContent = window.LanguageManager.getTranslatedText("Continue_Tracking");
                        select3.appendChild(option3);
                        select3.appendChild(option4);
                        select3.appendChild(option5);
                    cell6.appendChild(select3);

                    var cell7 = document.createElement("td");
                    cell7.style.paddingTop = "12px";
                    cell7.style.paddingLeft = "16px";
                    cell7.style.height = "32px";
                        var inputCheckbox = document.createElement("input");
                        inputCheckbox.type = "checkbox";
                        inputCheckbox.id = "cameraMappingXYinputcheckbox_div" + "_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" + i;
                        inputCheckbox.className = "mic-xy-checkbox"; // Apply the custom class for styling
                        inputCheckbox.checked = false;
                        inputCheckbox.addEventListener("change", onChangeCameraItem);
                    cell7.appendChild(inputCheckbox);
                    if(deviceTypeString == "Audio-Technica:ATND1061(Coordinate)"
                    || deviceTypeString === 'Shure:MXA920(Coordinate)'
                    || deviceTypeString === 'Sennheiser:TCC2(Coordinate)'
                    || deviceTypeString === 'Sennheiser:TCCM(Coordinate)')
                        inputCheckbox.style.visibility = "hidden";

                row.appendChild(cell0);       
                row.appendChild(cell1);
                row.appendChild(cell2_1);
                row.appendChild(cell2_2);
                row.appendChild(cell2_3);
                row.appendChild(cell3);
                row.appendChild(cell4);
                row.appendChild(cell5);
                row.appendChild(cell6);

                // if( deviceTypeString === 'Sennheiser:TCC2' || deviceTypeString === 'Sennheiser:TCCM'  || deviceTypeString === 'Yamaha:RM-CG' )
                // {
                //     row.appendChild(cell8);
                // }
                //row.appendChild(tooltipDiv);

            table.appendChild(row);
        rowWrapper.appendChild(table);
        tableBody.appendChild(rowWrapper);
    }
}


function createCameraMappingAzimuthDiv(micGroup, micArryNum) {
    //console.log('createCameraMappingAzimuthDiv micGroup-->',micGroup,'micArryNum-->',micArryNum);
    let micTabPage = gDeviceIndex;
    var deviceTypeSel = document.getElementById("deviceTypeSel_"+micTabPage);
    
    if(!deviceTypeSel) return;

    let micSelect = parseInt(deviceTypeSel.value); 
    let deviceTypeString = transferDeviceTypeToString(deviceTypeSel.value);    
    var div = document.getElementById("Div_cameraMapping_" + micGroup);
    div.innerHTML = "";

        var azimuthQtyContainer = document.createElement("div");
        azimuthQtyContainer.className = "azimuthQty-container";

            var qtyLabel = document.createElement("label");
            qtyLabel.className = "Font_Arial_14 margin-qtyLabel";
            qtyLabel.id = "Label_Azimuth_Qty_" + micGroup;
            qtyLabel.innerText = window.LanguageManager.getTranslatedText("Mapping_Qty");

            var selectMicChannel = document.createElement("select");
            selectMicChannel.id = "selectMicChannel_" + micGroup;
            selectMicChannel.className = "selectH32 selectW150 margin-right";
            selectMicChannel.setAttribute("onchange", "SelectingMicChannel()");
            selectMicChannel.disabled = false;

        var micInfoLabel = document.createElement("label");
        micInfoLabel.className = "Font_Arial_14 margin-micInfoLabel";
        micInfoLabel.id = "micInfo_div" + micGroup;

        var td_ZoneMode = document.createElement("td");
            var space_EnableZone = document.createElement("label");
            space_EnableZone.id = "Space_EnableZone"; 
            space_EnableZone.style.cssText = "margin-left : 640px; margin-top: 5px; margin-right : 10px;"

            var label_ZoneMode = document.createElement("label");
            label_ZoneMode.id = "Label_EnableZone";
            label_ZoneMode.className = "label_ZoneMode Font_Arial_14_bold";   
            label_ZoneMode.innerText = "Enable Zone";
            label_ZoneMode.style.cssText = "margin-top: 5px; margin-right : 16px;"

            var label_ZoneMode_switch_onoff = document.createElement("label");
            label_ZoneMode_switch_onoff.id = "EnableZoneMode_switch_onoff";
            label_ZoneMode_switch_onoff.className = "switch_onoff";
            label_ZoneMode_switch_onoff.style.cssText = "margin-right : 16px;"
                var input_ZoneMode_connectCheckboxInput = document.createElement("input");
                input_ZoneMode_connectCheckboxInput.id = "ZoneMode_connectCheckboxInput_"+micGroup;
                input_ZoneMode_connectCheckboxInput.type = "checkbox";
                input_ZoneMode_connectCheckboxInput.setAttribute("onchange", "changeZoneModeStatus(this)");
                var span_class = document.createElement("span");
                span_class.className = "slider_onoff";
            label_ZoneMode_switch_onoff.appendChild(input_ZoneMode_connectCheckboxInput);   
            label_ZoneMode_switch_onoff.appendChild(span_class);

            // if(deviceTypeString === "Audio-Technica:ATND1061(Coordinate)" 
            // || deviceTypeString === '(Beta)Shure:MXA920(Coordinate)'
            // || deviceTypeString === 'Sennheiser:TCC2(Coordinate)'
            // || deviceTypeString === 'Sennheiser:TCCM(Coordinate)')
            // {
            //     input_ZoneMode_connectCheckboxInput.disabled =true;
            // }

            // || deviceTypeString === 'Sennheiser:TCC2(Coordinate)'
            // || deviceTypeString === 'Sennheiser:TCCM(Coordinate)'
            
        td_ZoneMode.appendChild(space_EnableZone);
        //td_ZoneMode.appendChild(label_ZoneMode); //@Jeff Alwayse Enable For XY, So Hide
        //td_ZoneMode.appendChild(label_ZoneMode_switch_onoff);//@Jeff Alwayse Enable For XY, So Hide
        var ZoneSettingButton = document.createElement("button");
        ZoneSettingButton.id = "zoneModeSetting_" + micGroup;
        ZoneSettingButton.type = "button";
        ZoneSettingButton.className = "ZoneSetting_Btn_style";
        ZoneSettingButton.disabled = true;
        ZoneSettingButton.innerText = window.LanguageManager.getTranslatedText("Zone_Setting");
        ZoneSettingButton.setAttribute("onclick", "onMicZoneMode(this)");

        if(deviceTypeString === "Audio-Technica:ATND1061(Coordinate)" 
        || deviceTypeString === 'Shure:MXA920(Coordinate)'
        || deviceTypeString === 'Sennheiser:TCC2(Coordinate)'
        || deviceTypeString === 'Sennheiser:TCCM(Coordinate)')
        {
            ZoneSettingButton.disabled = false;
        }

         var ZoneMapButton = document.createElement("button");
         ZoneMapButton.id = "cameraMappingZoneMap_" + micGroup;
         ZoneMapButton.type = "button";
         ZoneMapButton.className = "ZoneMap_Btn_style";
         ZoneMapButton.style.cssText = "margin-left : 16px;"
         ZoneMapButton.disabled = false;
         ZoneMapButton.innerText = "Zone Map";
         ZoneMapButton.setAttribute("onclick", "onCameraMappingZoneMap(this)");

        azimuthQtyContainer.appendChild(qtyLabel);
        azimuthQtyContainer.appendChild(selectMicChannel);
        //azimuthQtyContainer.appendChild(micInfoLabel);

        var td_HandFreeMode = document.createElement("td"); 
            var label_HandFreeMode = document.createElement("label");
            label_HandFreeMode.id = "Label_HandFreeMode";
            label_HandFreeMode.className = "label_ZoneMode Font_Arial_14_bold";   
            label_HandFreeMode.innerText = "All XY Mode";
            label_HandFreeMode.style.cssText = "width: 85px; margin-left : 16px; margin-top: 5px; margin-right : 16px;"

            var label_HandFreeMode_switch_onoff = document.createElement("label");
            label_HandFreeMode_switch_onoff.id = "HandFreeMode_switch_onoff";
            label_HandFreeMode_switch_onoff.className = "switch_onoff";
            label_HandFreeMode_switch_onoff.style.cssText = "margin-right : 16px;"
                var input_HandFreeModeMode_connectCheckboxInput = document.createElement("input");
                input_HandFreeModeMode_connectCheckboxInput.id = "HandFreeMode_connectCheckboxInput_"+gDeviceIndex;
                input_HandFreeModeMode_connectCheckboxInput.type = "checkbox";
                if(gIsEnableHandFree)
                    input_HandFreeModeMode_connectCheckboxInput.checked = true;
                else
                    input_HandFreeModeMode_connectCheckboxInput.checked = false;
                input_HandFreeModeMode_connectCheckboxInput.setAttribute("onchange", "changeHandFreeModeStatus(this)");
                var span_class = document.createElement("span");
                span_class.className = "slider_onoff";
            label_HandFreeMode_switch_onoff.appendChild(input_HandFreeModeMode_connectCheckboxInput);   
            label_HandFreeMode_switch_onoff.appendChild(span_class);
            
        td_HandFreeMode.appendChild(label_HandFreeMode);
        // if(deviceTypeString !== 'Audio-Technica:ATND1061(Coordinate)' 
        // && deviceTypeString !== '(Beta)Shure:MXA920(Coordinate)'
        // && deviceTypeString !== 'Sennheiser:TCC2(Coordinate)'
        // && deviceTypeString !== 'Sennheiser:TCCM(Coordinate)')
        // {
        //     td_HandFreeMode.appendChild(label_HandFreeMode_switch_onoff);
        // }

        var table = document.createElement("table");
        table.className = "margin-left-60px margin-top-10px";

            var row = document.createElement("tr");

                var cell1 = document.createElement("td");
                if( document.createElement("GobalSelectLanguage"))
                {
                    if(document.getElementById("GobalSelectLanguage").value == 0)
                        cell1.style.cssText = "padding-left:60px;"
                    else
                        cell1.style.cssText = "padding-left:90px;"
                }
                var cell2 = document.createElement("td");
                    var label1 = document.createElement("label");
                    label1.className = "Font_Arial_14_bold cameraMappingFiledTitle";
                    label1.id = "azimuthLabel";
                    label1.innerText = window.LanguageManager.getTranslatedText("Auzimuth_Angle");
                cell2.appendChild(label1);

                var cell3 = document.createElement("td");
                if(micGroup == 3)//MXCW
                {
                    cell3.style.cssText = "padding-left : 130px;"
                    if( document.createElement("GobalSelectLanguage"))
                    {
                        if(document.getElementById("GobalSelectLanguage").value == 0)
                            cell3.style.cssText = "padding-left : 130px;"
                        else
                            cell3.style.cssText = "padding-left : 150px;"
                    }
                }
                else
                {
                    cell3.style.cssText = "padding-left : 90px;"
                    if( document.createElement("GobalSelectLanguage"))
                    {
                        if(document.getElementById("GobalSelectLanguage").value == 0)
                            cell3.style.cssText = "padding-left : 90px;"
                        else
                            cell3.style.cssText = "padding-left : 130px;"
                    }
                }
                    var label2 = document.createElement("label");
                    label2.className = "Font_Arial_14_bold cameraMappingFiledTitle";
                    label2.innerText =  window.LanguageManager.getTranslatedText("Primary_Camera");
                cell3.appendChild(label2);

                var cell4 = document.createElement("td");
                if(micGroup == 3)//MXCW
                {

                }
                else
                {
                    cell4.style.cssText = "padding-left : 180px;"
                    if( document.createElement("GobalSelectLanguage"))
                    {
                        if(document.getElementById("GobalSelectLanguage").value == 0)
                            cell4.style.cssText = "padding-left : 180px;"
                        else
                            cell4.style.cssText = "padding-left : 240px;"
                    }
                }
                    var label3 = document.createElement("label");
                    label3.className = "Font_Arial_14_bold cameraMappingFiledTitle";
                    label3.innerText = window.LanguageManager.getTranslatedText("Secondary_Camera");
                cell4.appendChild(label3);

                var cell5 = document.createElement("td");
                if(micGroup == 3)//MXCW
                {

                }
                else
                {
                    cell5.style.cssText = "padding-left : 110px;"
                    if( document.createElement("GobalSelectLanguage"))
                    {
                        if(document.getElementById("GobalSelectLanguage").value == 0)
                            cell5.style.cssText = "padding-left : 110px;"
                        else
                            cell5.style.cssText = "padding-left : 130px;"
                    }
                }
                    var label4 = document.createElement("label");
                    label4.className = "Font_Arial_14_bold cameraMappingFiledTitle";
                    label4.innerText = window.LanguageManager.getTranslatedText("Preset_No");
                cell5.appendChild(label4);

                var cell6 = document.createElement("td");
                cell6.style.paddingRight = "10px";
                cell6.style.cssText = "padding-left: 55px; padding-right: 65px;"
                    var label5 = document.createElement("label");
                    label5.className = "Font_Arial_14_bold cameraMappingFiledTitle";
                    label5.innerText =  window.LanguageManager.getTranslatedText("AI_Setting");
                cell6.appendChild(label5);

                // var cell7 = document.createElement("td"); 
                // cell7.style.cssText = "padding-left : 10px;"
                //     var label6 = document.createElement("label");
                //     label6.className = "Font_Arial_14_bold cameraMappingFiledTitle";
                //     label6.innerText = "XY";
                // cell7.appendChild(label6);

            row.appendChild(cell1);
            row.appendChild(cell2);
            row.appendChild(cell3);
            row.appendChild(cell4);
            row.appendChild(cell5);
            row.appendChild(cell6);

        table.appendChild(row);

        var AzimuthtableContainer = document.createElement("div");
        AzimuthtableContainer.id = 'AzimuthtableContainer_' + micGroup;
        AzimuthtableContainer.style.maxHeight = "65%";
        AzimuthtableContainer.style.maxWidth  = "150%";
        AzimuthtableContainer.style.marginRight ="6%";
        AzimuthtableContainer.style.overflow  = "auto";
        AzimuthtableContainer.style.width = "97%";

            var table2 = document.createElement("table");
            table2.style.tableLayout = "fixed";
            table2.style.width = "80%";
            table2.style.height = "80%";

                var colgroup = document.createElement("colgroup");
                    var col1 = document.createElement("col");
                    col1.style.width = "25%";
                    var col2 = document.createElement("col");
                    col2.style.width = "25%";
                colgroup.appendChild(col1);
                colgroup.appendChild(col2);

                var tbody = document.createElement("tbody");
                tbody.id = "cameraMappingTableBody" + micGroup;
                    var script = document.createElement("script");
                    script.text = `
                        var micArryNum = ${micArryNum};
                        generateCameraAzimuthMappingTable(micArryNum);
                    `;

                tbody.appendChild(script);            
            table2.appendChild(colgroup);
            table2.appendChild(tbody);
        AzimuthtableContainer.appendChild(table2);

        var tr_custombox = document.createElement("tr");
        tr_custombox.style.cssText ="height : 24px";
        tr_custombox.style.height  = "100%";

        var applyButton = document.createElement("button");
        applyButton.id = "cameraMappingApply_" + micGroup;
        applyButton.type = "button";
        applyButton.className = "Btn_style disabled";
        applyButton.style.cssText = "margin-left : 910px;"
        applyButton.disabled = true;
        applyButton.innerText = window.LanguageManager.getTranslatedText("Apply");
        applyButton.setAttribute("onclick", "onCameraMappingApply(this)");

        var cancelButton = document.createElement("button");
        cancelButton.id = "cameraMappingCancel_" + micGroup;
        cancelButton.type = "button";
        cancelButton.className = "Btn_style cameraMapping-azimuth-margin-left cameraMapping-azimuth-margin-right margin-top-10px disabled";
        cancelButton.disabled = true;
        cancelButton.innerText = window.LanguageManager.getTranslatedText("Cancel");
        cancelButton.setAttribute("onclick", "cameraMappingCancelClick()");

    div.appendChild(azimuthQtyContainer);
    div.appendChild(micInfoLabel);

    // let tr_ZoneMode = document.createElement("tr");
    // tr_ZoneMode.id = 'ZoneMode_'+micGroup;
    // tr_ZoneMode.className = "stream_tr2 Font_Arial_14";
    //     let td_ZoneSettingButton = document.createElement("td");  
    //     td_ZoneSettingButton.appendChild(ZoneSettingButton);
    //     let td_ZoneMapButton = document.createElement("td");
    //     td_ZoneMapButton.appendChild(ZoneMapButton);


    // if(deviceTypeString == 'Yamaha:RM-CG(Coordinate)'
    // || deviceTypeString == 'Nureva:HDL410(Coordinate)'
    // || deviceTypeString == 'Audio-Technica:ATND1061(Coordinate)' 
    // || deviceTypeString == '(Beta)Shure:MXA920(Coordinate)'
    // || deviceTypeString == 'Sennheiser:TCC2(Coordinate)'
    // || deviceTypeString == 'Sennheiser:TCCM(Coordinate)')
    // {
    //     tr_ZoneMode.appendChild(td_ZoneMode);
    //     tr_ZoneMode.appendChild(td_ZoneSettingButton);    
    //     tr_ZoneMode.appendChild(td_ZoneMapButton);
    //     tr_ZoneMode.appendChild(td_HandFreeMode);
    // }

    //div.appendChild(tr_ZoneMode);
    div.appendChild(table);
    div.appendChild(AzimuthtableContainer);
    div.appendChild(tr_custombox);
    div.appendChild(applyButton);
    div.appendChild(cancelButton);

}

function generateCameraPosMappingTable(micArryNum) {
    var micTabPage = gDeviceIndex;
    var currentSoundType = document.getElementById("deviceTypeSel_"+micTabPage).value;
    var micSelect = parseInt(currentSoundType);
    var micGroup = getDeviceCameraMappingIndex();
    
    let deviceTypeString = transferDeviceTypeToString(currentSoundType); 
  
    // console.log("generateCameraPosMappingTable currentSoundType :",currentSoundType);
    // console.log("generateCameraPosMappingTable deviceTypeString:",deviceTypeString);
    // console.log("generateCameraPosMappingTable micArryNum:",micArryNum);

    var tableBody = document.getElementById("cameraMappingTableBody"+micGroup);

    if(!tableBody) 
    {
        // console.log('!tableBody is null');
        return;
    }

    tableBody.innerHTML = "";

    for (var i = 0; i < micArryNum; i++) {
        var rowWrapper = document.createElement("div");
        rowWrapper.style.marginBottom = "2px";

        var row = document.createElement("tr");
            var cell0 = document.createElement("div");
            cell0.style.cssText="margin-left:50px;"

            var cell1 = document.createElement("td");
            cell1.style.paddingTop = "12px";
            cell1.style.paddingRight = "20px";
            cell1.style.paddingLeft = "5px";
                var img = document.createElement("img");
                img.id = "Light_div"+ "_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" + i;
                img.className = "light_Img";
                img.src = "./images/Disable.png";
            cell1.appendChild(img);
        
            var cell2 = document.createElement("td");
            // cell2.style.paddingTop = "5px";
            cell2.style.paddingLeft = "10px";
            cell2.style.height = "32px";
                var input = document.createElement("input");
                input.id = "cameraMappingInput"+ "_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" + (i+1);
                input.className = "mxcw_cameraMappingInput";
                input.style.cssText ="border-radius:3px; width:60px;"
                input.value = i + 1;        
                input.readOnly = true;
            cell2.appendChild(input);
        

            var cell3 = document.createElement("td");
            cell3.style.paddingTop = "8px";
            cell3.style.paddingLeft = "24px";
                var select1 = document.createElement("select");
                select1.id = "cameraMappingSeleceItem_div"+ "_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" + (i);
                select1.className = "selectH32 selectW270";
                if(gInstallmode && g14mode)
                {
                    select1.style.width = '180px';
                }
                //select1.setAttribute("onchange", "onChangecameraMappingPresetStatus('false')");
                select1.addEventListener("mouseout", onMouseoutCameraItem);
                select1.addEventListener("mouseover", onMouseoverCameraItem);
                select1.addEventListener("change", onChangePrimaryCameraItem);
                    var option = document.createElement("option");
                    option.value = -1;
                    option.textContent = "Off";
                select1.appendChild(option);
            cell3.appendChild(select1);

            var cell4 = document.createElement("td");
            cell4.style.paddingTop = "8px";
            cell4.style.paddingLeft = "24px";
                var select2 = document.createElement("select");
                select2.id = "cameraMappingSecondSeleceItem_div"+ "_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" + (i);
                select2.className = "selectH32 selectW270";
                if(gInstallmode && g14mode)
                {
                    select2.style.width = '180px';
                }
                //select1.setAttribute("onchange", "onChangecameraMappingPresetStatus('false')");
                select2.addEventListener("mouseout", onMouseoutCameraItem);
                select2.addEventListener("mouseover", onMouseoverCameraItem);
                select2.addEventListener("change", onChangeSecondaryCameraItem);
                    var option1 = document.createElement("option");
                    option1.value = -1;
                    option1.textContent = "Off";
                select2.appendChild(option1);
            cell4.appendChild(select2);

            if(gInstallmode && g14mode)
            {
                var cell8 = document.createElement("td");
                cell8.style.paddingTop = "8px";
                cell8.style.paddingLeft = "24px";
                    var select8 = document.createElement("select");
                    select8.id = "cameraMappingAuxiliarySeleceItem_div"+ "_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" + (i);
                    select8.className = "selectH32 selectW270";
                    if(gInstallmode)
                    {
                        select8.style.width = '180px';
                    }
                    //select1.setAttribute("onchange", "onChangecameraMappingPresetStatus('false')");
                    select8.addEventListener("mouseout", onMouseoutCameraItem);
                    select8.addEventListener("mouseover", onMouseoverCameraItem);
                    select8.addEventListener("change", onChangeSecondaryCameraItem);
                        var option1 = document.createElement("option");
                        option1.value = -1;
                        option1.textContent = "Off";
                    select8.appendChild(option1);
                cell8.appendChild(select8);
            }

            var cell5 = document.createElement("td");
            cell5.style.paddingTop = "8px";
            cell5.style.paddingLeft = "24px";
                var input_cameraMappingPreset_div = document.createElement("input");
                input_cameraMappingPreset_div.id = "cameraMappingPreset_div_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" + (i);
                input_cameraMappingPreset_div.type = "number";
                input_cameraMappingPreset_div.style.cssText = "width:80px; height:32px; border-radius:3px;font-family: Arial;font-size: 14px;"
                input_cameraMappingPreset_div.value = i + 1;
                input_cameraMappingPreset_div.disabled = false;
                input_cameraMappingPreset_div.placeholder = "0~255";
                input_cameraMappingPreset_div.min = 0;
                input_cameraMappingPreset_div.max = 255;
                input_cameraMappingPreset_div.addEventListener("change", handleInputChange);
            cell5.appendChild(input_cameraMappingPreset_div);

            var cell6 = document.createElement("td");
            cell6.style.paddingTop = "8px";
            cell6.style.paddingLeft = "16px";
                var select3 = document.createElement("select");
                select3.id = "cameraMappingAIPeopleTrackingModeSeleceItem_div"+ "_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" + (i);
                select3.className = "selectH32 selectW160";
                select3.addEventListener("change",onChangeCameraItem);
                    var option2 = document.createElement("option");
                    option2.value = -1;
                    option2.textContent = window.LanguageManager.getTranslatedText("Off");
                    var option3 = document.createElement("option");
                    option3.value = 0;
                    option3.textContent = window.LanguageManager.getTranslatedText("Center_Stage");
                    var option4 = document.createElement("option");
                    option4.value = 1;
                    option4.textContent = window.LanguageManager.getTranslatedText("Continue_Tracking");
                select3.appendChild(option2);
                select3.appendChild(option3);
                select3.appendChild(option4);
            cell6.appendChild(select3);

        row.appendChild(cell0);
        row.appendChild(cell1);
        row.appendChild(cell2);
        row.appendChild(cell3);
        row.appendChild(cell4);
        if(gInstallmode && g14mode)
        {
            row.appendChild(cell8); 
        }
        row.appendChild(cell5);
        row.appendChild(cell6);

        rowWrapper.appendChild(row);
        tableBody.appendChild(rowWrapper);
    }
}



function createZoneMapCameraSetting(index) {
    var ZoneMapCameraSettingWindow = document.getElementById('ZoneMap_CameraSetting_PTZWindows_' + index);
    ZoneMapCameraSettingWindow.innerHTML = '';
        var modalPTZ = document.createElement('div');
        modalPTZ.className = 'CameraSettingtitlemodalPTZ';
        modalPTZ.style.backgroundColor = 'black';
        modalPTZ.style.display = 'block';
        modalPTZ.id = 'PTZModal_'+index;
            var modalDialog = document.createElement('div');
                var modalContent = document.createElement('div');
                    var titleRow = document.createElement('tr');
                        var titleBarRowCell = document.createElement('td');
                        titleBarRowCell.className = 'CameraSettingtitleBarRow';

                            var logoCell = document.createElement('td');
                            logoCell.className = 'title-bar-cell logo-cell';
                                var logoImage = document.createElement('img');
                                logoImage.id = 'logo_image';
                                logoImage.className = 'mic-popup-Window-logo-Image';
                                logoImage.src = '../imagesaibox/CamConnect.png';
                            logoCell.appendChild(logoImage);

                            var titleCell = document.createElement('td');
                            titleCell.className = 'title-bar-cell title-cell';
                            titleCell.style.margin = '10px';
                                var titleLabel = document.createElement('label');
                                titleLabel.className = 'Font_Arial_18_bold mic-xy-title';
                                titleLabel.textContent = 'CamConnect Processor';
                                
                            titleCell.appendChild(titleLabel);

                            var closeButtonCell = document.createElement('td');
                            closeButtonCell.className = 'title-bar-cell close-button-cell';
                                var closeButton = document.createElement('button');
                                closeButton.id = 'close_CameraSetting_Window_'+index;
                                closeButton.className = 'close-popup-btn';
                                closeButton.setAttribute("onclick", "closeZoneMapCameraSettingWindow(this)");
                            closeButtonCell.appendChild(closeButton);

                        titleBarRowCell.appendChild(logoCell);
                        titleBarRowCell.appendChild(titleCell);
                        titleBarRowCell.appendChild(closeButtonCell);
                        
                    titleRow.appendChild(titleBarRowCell);

                    var modalPTZBody = document.createElement('div');
                    modalPTZBody.className = 'modalPTZ-body';
                        
                        var imgContents = document.createElement('div');
                        imgContents.id = 'imgcontents_'+index;
                        imgContents.style.position = 'relative';
                        
                            var imgLoader = document.createElement('img');
                            imgLoader.id = 'dmsloader_'+index;
                            imgLoader.className = 'CameraSettingimgloader';
                                                        
                            var overlayText = document.createElement('div');
                            overlayText.textContent = '+'; // The text to display
                            overlayText.style.position = 'absolute';
                            overlayText.style.top = '50%';
                            overlayText.style.left = '53%';
                            overlayText.style.transform = 'translate(-50%, -50%)'; // Center the text
                            overlayText.style.fontSize = '35px';
                            overlayText.style.color = 'red'; // Adjust color as necessary
    
                        imgContents.appendChild(imgLoader);
                        imgContents.appendChild(overlayText); // Add the overlay text to the image container
                    modalPTZBody.appendChild(imgContents);

                    var directionMirrorDiv = document.createElement('div');
                    directionMirrorDiv.className = 'CameraSettingDirectionMirrorDiv';
                        // var labelLR = document.createElement('label');
                        // labelLR.className = 'Font_Arial_14_bold CameraSetting_LR_Direction_label';
                        // labelLR.textContent = 'L/R Direction';

                        // var switchOnOff = document.createElement('label');
                        // switchOnOff.className = 'switch_onoff';
                        //     var inputLR = document.createElement('input');
                        //     inputLR.type = 'checkbox';
                        //     inputLR.id = 'PTZLRDirection_'+index;
                        //     inputLR.name = 'LRDirection';
                        //     inputLR.setAttribute('onchange', 'onchangePanFlip(this)'); 
                        //     var spanSlider = document.createElement('span');
                        //     spanSlider.className = 'slider_onoff';
                        // switchOnOff.appendChild(inputLR);
                        // switchOnOff.appendChild(spanSlider);

                        var labelMirrorFlip = document.createElement('label');
                        labelMirrorFlip.className = 'Font_Arial_14_bold CameraSetting_MirrorFlip_label';
                        labelMirrorFlip.textContent = 'Mirror / Flip';

                        var selectMirrorFlip = document.createElement('select');
                        selectMirrorFlip.id = 'PTZMirrorFlipType_'+index;
                        selectMirrorFlip.className = 'selectH24 selectW100';
                        selectMirrorFlip.setAttribute('onchange', 'micPTZMirrorFlipTypeChange(this)'); 
                        ['OFF', 'Mirror', 'Flip', 'Mirror+Flip'].forEach((value, index) => {
                            var option = document.createElement('option');
                            option.value = index;
                            option.textContent = value;
                            selectMirrorFlip.appendChild(option);
                        });

                        var labelAngleOffset = document.createElement('label');
                        labelAngleOffset.className = 'Font_Arial_14_bold';
                        labelAngleOffset.textContent = 'Angle Offset';
                        labelAngleOffset.style.marginLeft  = '50px';
                        labelAngleOffset.style.marginRight = '8px';
                        
                        var inputAngleOffset = document.createElement('input');
                        inputAngleOffset.type = 'text';
                        inputAngleOffset.id = 'inputAngleOffset_'+index;
                        inputAngleOffset.className = 'CameraSetting_inputAngleOffset';
                        inputAngleOffset.value = '0';
                       
                        var buttonAngleOffset = document.createElement('button');
                        buttonAngleOffset.className = 'CameraSetting_presetBtn';
                            var buttonAngleOffset_span = document.createElement('span');
                            buttonAngleOffset_span.className = 'presetBtnText';
                            buttonAngleOffset_span.textContent = 'Set';
                        buttonAngleOffset.setAttribute('onclick', 'CameraSettingGetAngleOffset(this)'); 
                        buttonAngleOffset.appendChild(buttonAngleOffset_span);
                    //directionMirrorDiv.appendChild(labelLR);
                    //directionMirrorDiv.appendChild(switchOnOff);
                    directionMirrorDiv.appendChild(labelMirrorFlip);
                    directionMirrorDiv.appendChild(selectMirrorFlip);
                    directionMirrorDiv.appendChild(labelAngleOffset);
                    directionMirrorDiv.appendChild(inputAngleOffset);
                    directionMirrorDiv.appendChild(buttonAngleOffset);

                    var divPanTiltZone = document.createElement('div');
                    divPanTiltZone.id = 'Div_PanTiltZone';
                    divPanTiltZone.className = 'PanTiltZoneDiv';
                    
                        var panTiltBtnGrid = document.createElement('ul');
                        panTiltBtnGrid.className = 'CameraSetting_PanTiltBtnGrid';
            
                        var buttons = [
                            { id: 'ptUpLeftButton_'+index,     className: 'PT_UpLeft_Btn',      },
                            { id: 'ptUpButton_'+index,         className: 'PT_Up_Btn PT_Up_img',},
                            { id: 'ptUpRightButton_'+index,    className: 'PT_UpRight_Btn',     },
                            { id: 'ptLeftButton_'+index,       className: 'PT_Left_Btn',        },
                            { id: 'HomeButton_'+index,         className: 'PT_Home_Btn',        },
                            { id: 'ptRightButton_'+index,      className: 'PT_Right_Btn',       },
                            { id: 'ptDownLeftButton_'+index,   className: 'PT_DownLeft_Btn',    },
                            { id: 'ptDownButton_'+index,       className: 'PT_Down_Btn',        },
                            { id: 'ptDownRightButton_'+index,  className: 'PT_DownRight_Btn',   },
                        ];
                        
                        buttons.forEach(function(button) {
                            var li = document.createElement('li');
                            var btn = document.createElement('button');
                            btn.id = button.id;
                            btn.className = button.className;
                            //btn.setAttribute("onclick", "micPanTiltElement(this)");
                            btn.addEventListener('mousedown', function() {                                
                                var dir = 'LeftDown';
                                if(btn.id == 'ptUpLeftButton_'+index)
                                    dir = 'LeftUp';
                                else if(btn.id == 'ptUpButton_'+index)
                                    dir = 'Up';
                                else if(btn.id == 'ptUpRightButton_'+index)
                                    dir = 'RightUp';
                                else if(btn.id == 'ptLeftButton_'+index)
                                    dir = 'Left';
                                else if(btn.id == 'HomeButton_'+index)
                                    dir = 'home';
                                else if(btn.id == 'ptRightButton_'+index)
                                    dir = 'Right';
                                else if(btn.id == 'ptDownLeftButton_'+index)
                                    dir = 'LeftDown';
                                else if(btn.id == 'ptDownButton_'+index)
                                    dir = 'Down';
                                else if(btn.id == 'ptDownRightButton_'+index)
                                    dir = 'RightDown';
                                ptCmdRun = true;
                                setTimeout(function () {
                                    micsendPanTiltCmd(dir);
                                }, 100);
                            });

                            if(btn.id != 'HomeButton_'+index)
                            {
                                btn.addEventListener('mouseup', function() {                                
                                    micstopPanTiltMoving();
                                });
                                btn.addEventListener('mouseleave', function() {                                
                                    micstopPanTiltMoving();
                                });
                            }
                            li.appendChild(btn);
                            panTiltBtnGrid.appendChild(li);
                        });
                    
                    divPanTiltZone.appendChild(panTiltBtnGrid);
                    var divPresetZone = document.createElement('div');
                    divPresetZone.id = 'Div_presetZone';
                    divPresetZone.className = 'presetZoneDiv';
                        
                        var labelPreset = document.createElement('label');
                        labelPreset.className = 'CameraSetting_presetLabel Font_Arial_14_bold';
                        labelPreset.textContent = window.LanguageManager.getTranslatedText("Preset");
                        var inputPreset = document.createElement('input');
                        inputPreset.type = 'text';
                        inputPreset.id = 'presetInput_'+index;
                        inputPreset.className = 'presetInput';
                        inputPreset.oninput = function() { this.value = this.value.replace(/[^\d]/g, ''); };
                        var ulPresetBtnGrid = document.createElement('ul');
                        ulPresetBtnGrid.className = 'CameraSetting_presetBtnGrid';

                        function micstoreButtonfunc() {
                                var presetValue = document.getElementById('presetInput_' + index).value;
                                micsendStorePresetCmd(presetValue);
                                document.getElementById('presetInput_' + index).value = "";
                        }

                        function micrecallButtonfunc() {
                                var presetValue = document.getElementById('presetInput_' + index).value;
                                micsendRecallPresetCmd(presetValue);
                                document.getElementById('presetInput_' + index).value = "";
                        }

                        var presetButtons = [
                            { id: 'presetNum1Button_'+index,   class: 'presetBtn',      text: '1'  ,   action: function() { micpresetTextAction("1"); } },
                            { id: 'presetNum2Button_'+index,   class: 'presetBtn',      text: '2'  ,   action: function() { micpresetTextAction("2"); } },
                            { id: 'presetNum3Button_'+index,   class: 'presetBtn',      text: '3'  ,   action: function() { micpresetTextAction("3"); } },
                            { id: 'presetNum4Button_'+index,   class: 'presetBtn',      text: '4'  ,   action: function() { micpresetTextAction("4"); } },
                            { id: 'presetNum5Button_'+index,   class: 'presetBtn',      text: '5'  ,   action: function() { micpresetTextAction("5"); } },
                            { id: 'presetNum6Button_'+index,   class: 'presetBtn',      text: '6'  ,   action: function() { micpresetTextAction("6"); } },
                            { id: 'presetNum7Button_'+index,   class: 'presetBtn',      text: '7'  ,   action: function() { micpresetTextAction("7"); } },
                            { id: 'presetNum8Button_'+index,   class: 'presetBtn',      text: '8'  ,   action: function() { micpresetTextAction("8"); } },
                            { id: 'presetNum9Button_'+index,   class: 'presetBtn',      text: '9'  ,   action: function() { micpresetTextAction("9"); } },
                            { id: 'presetStoreButton_'+index,  class: 'presetBtn',      text: 'Store', action: function() { micstoreButtonfunc();} },
                            { id: 'presetNum0Button_'+index,   class: 'presetBtn',      text: '0'  ,   action: function() { micpresetTextAction("0"); } },
                            { id: 'presetRecallButton_'+index, class: 'presetClearBtn', text: ''   ,   action: function() { micrecallButtonfunc(); } },
                        ];

                        presetButtons.forEach(function(button) {
                            var li = document.createElement('li');
                            var btn = document.createElement('button');
                            btn.id = button.id;
                            btn.className =  button.class;
                            if (button.text) {
                                var span = document.createElement('span');
                                span.className = 'presetBtnText';
                                span.textContent = button.text;
                                btn.appendChild(span);
                            }
                            if (button.action) {
                                btn.addEventListener('click', button.action);
                            }
                            li.appendChild(btn);
                            ulPresetBtnGrid.appendChild(li);
                        });
                        
                    divPresetZone.appendChild(labelPreset);
                    divPresetZone.appendChild(inputPreset);
                    divPresetZone.appendChild(ulPresetBtnGrid);

                    var divAFcousZone = document.createElement('div');
                    divAFcousZone.id = 'Div_AFcousZone_'+index;
                    divAFcousZone.className = 'CameraSetting_AFcousZoneDiv';
                        var table = document.createElement('table');
                        table.style.borderCollapse = 'separate';
                        table.style.borderSpacing = '15px 15px';
                        
                            var tr1 = document.createElement('tr');
                            tr1.className = 'align-Td';
                                var td1 = document.createElement('td');
                                    var td1div = document.createElement('div');
                                        td1div.style.marginTop = "-15px";
                                        var label1 = document.createElement('label');
                                        label1.className = 'switch_afmf';
                                            var input = document.createElement('input');
                                            input.type = 'checkbox';
                                            input.id = 'focusModeCheckboxInput_'+index;
                                            input.setAttribute('onchange', 'micfocusModeChange(this)');
                                            var span = document.createElement('span');
                                            span.className = 'slider_afmf';
                                        label1.appendChild(input);
                                        label1.appendChild(span);
                                    td1div.appendChild(label1);
                                td1.appendChild(td1div);
                                var td2 = document.createElement('td');
                                    var td2div = document.createElement('div');
                                    td2div.style.marginTop = "-15px";
                                        var buttonNear = document.createElement('button');
                                        buttonNear.id = 'focusNearButton_'+index;
                                        buttonNear.className = 'FocusPlus_Btn';
                                        //buttonNear.setAttribute('onclick', 'micManualFocusControl()');
                                        buttonNear.addEventListener('mousedown', function() {                                
                                            focusCmdRun = true;
                                            setTimeout(function () {
                                                micsendManualFocusCmd('Near');
                                            }, 100);
                                        });
            
                                        buttonNear.addEventListener('mouseup', function() {                                
                                            micstopFocusMoving();
                                        });
                                        buttonNear.addEventListener('mouseleave', function() {                                
                                            micstopFocusMoving();
                                        });
                                    td2div.appendChild(buttonNear);
                                td2.appendChild(td2div);
                                var td3 = document.createElement('td');
                                    var td3div = document.createElement('div');
                                    td3div.style.marginTop = "-15px";
                                        var buttonFar = document.createElement('button');
                                        buttonFar.id = 'focusFarButton_'+index;
                                        buttonFar.className = 'FocusMinus_Btn';
                                        //buttonFar.setAttribute('onclick', 'micManualFocusControl()');
                                        buttonFar.addEventListener('mousedown', function() {                                
                                            focusCmdRun = true;
                                            setTimeout(function () {
                                                micsendManualFocusCmd('Far');
                                            }, 100);
                                        });
            
                                        buttonFar.addEventListener('mouseup', function() {                                
                                            micstopFocusMoving();
                                        });
                                        buttonFar.addEventListener('mouseleave', function() {                                
                                            micstopFocusMoving();
                                        });
                                    td3div.appendChild(buttonFar);
                                td3.appendChild(td3div);
                            tr1.appendChild(td1);
                            tr1.appendChild(td2);
                            tr1.appendChild(td3);

                            var tr2 = document.createElement('tr');
                            tr2.className = 'align-Td';
                                var tr2td1 = document.createElement('td');
                                    var tr2td1div = document.createElement('div');
                                    tr2td1div.style.marginTop = "-10px";
                                        var tr2td1label1 = document.createElement('label');
                                        tr2td1label1.className = 'AFMF_label Font_Arial_14_bold';
                                        tr2td1label1.textContent = 'AF/MF';
                                        tr2td1label1.id = 'Label_AFMF';
                                    tr2td1div.appendChild(tr2td1label1);
                                tr2td1.appendChild(tr2td1div);
                                var tr2td2 = document.createElement('td');
                                    var tr2td2div = document.createElement('div');
                                    tr2td2div.style.marginTop = "-10px";
                                        var tr2td2label1 = document.createElement('label');
                                        tr2td2label1.className = 'AFMF_label Font_Arial_14_bold';
                                        tr2td2label1.textContent = window.LanguageManager.getTranslatedText("Label_FocusPlus");
                                        tr2td2label1.id = 'Label_FocusPlus';
                                    tr2td2div.appendChild(tr2td2label1);
                                tr2td2.appendChild(tr2td2div);
                                var tr2td3 = document.createElement('td');
                                    var tr2td3div = document.createElement('div');
                                    tr2td3div.style.marginTop = "-10px";
                                        var tr2td3label1 = document.createElement('label');
                                        tr2td3label1.className = 'AFMF_label Font_Arial_14_bold';
                                        tr2td3label1.textContent = window.LanguageManager.getTranslatedText("Label_FocusMinus");
                                        tr2td3label1.id = 'Label_FocusMinus';
                                    tr2td3div.appendChild(tr2td3label1);
                                tr2td3.appendChild(tr2td3div);
                            tr2.appendChild(tr2td1);
                            tr2.appendChild(tr2td2);
                            tr2.appendChild(tr2td3);

                            var tr3 = document.createElement('tr');
                            tr3.className = 'align-Td';
                                var td4 = document.createElement('td');
                                    var td4div = document.createElement('div');
                                    td4div.style.marginTop = "10px";
                                        var labelZoom = document.createElement('label');
                                        labelZoom.className = 'AFMF_label Font_Arial_14_bold';
                                        labelZoom.id = 'Label_FocusMinus_'+index;
                                        labelZoom.textContent = 'Zoom';
                                    td4div.append(labelZoom);
                                td4.appendChild(td4div);
                                var td5 = document.createElement('td');
                                    var td5div = document.createElement('div');
                                    td5div.style.marginTop = "15px";
                                        var zoomTeleButton = document.createElement('button');
                                        zoomTeleButton.id = 'zoomTeleButton_'+index;
                                        zoomTeleButton.className = 'ZoomPlus_Btn';
                                        //zoomTeleButton.setAttribute('onclick', 'micZoomBtnElements()');
                                        zoomTeleButton.addEventListener('mousedown', function() {                                
                                            zoomCmdRun = true;
                                            setTimeout(function () {
                                                micsendZoomCmd('In');
                                            }, 100);
                                        });
            
                                        zoomTeleButton.addEventListener('mouseup', function() {                                
                                            micsendZoomStopCmd();
                                        });
                                        zoomTeleButton.addEventListener('mouseleave', function() {                                
                                            micsendZoomStopCmd();
                                        });
                                    td5div.append(zoomTeleButton);
                                td5.appendChild(td5div);
                                var td6 = document.createElement('td');
                                    var td6div = document.createElement('div');
                                    td6div.style.marginTop = "15px";
                                        var zoomWideButton = document.createElement('button');
                                            zoomWideButton.id = 'zoomWideButton_'+index;
                                            zoomWideButton.className = 'ZoomMinus_Btn';
                                            //zoomWideButton.setAttribute('onclick', 'micZoomBtnElements()');
                                            zoomWideButton.addEventListener('mousedown', function() {                                
                                                zoomCmdRun = true;
                                                setTimeout(function () {
                                                    micsendZoomCmd('Out');
                                                }, 100);
                                            });
                
                                            zoomWideButton.addEventListener('mouseup', function() {                                
                                                micsendZoomStopCmd();
                                            });
                                            zoomWideButton.addEventListener('mouseleave', function() {                                
                                                micsendZoomStopCmd();
                                            });
                                        td6div.append(zoomWideButton)
                                td6.appendChild(td6div);
                                
                            tr3.appendChild(td4);
                            tr3.appendChild(td5);
                            tr3.appendChild(td6);
                            
                        table.appendChild(tr1);
                        table.appendChild(tr2);
                        table.appendChild(tr3);
                    divAFcousZone.appendChild(table);
                    var modalFooter = document.createElement('div');
                    modalFooter.className = 'modal-footer';
                    modalFooter.style.backgroundColor = 'black';
                    modalFooter.style.marginTop = '8px';

            modalContent.appendChild(titleRow);
            modalContent.appendChild(modalPTZBody);
            modalContent.appendChild(directionMirrorDiv);
            modalContent.appendChild(divPanTiltZone);
            modalContent.appendChild(divPresetZone);
            modalContent.appendChild(divAFcousZone);
            modalContent.appendChild(modalFooter);
            

            modalDialog.appendChild(modalContent);
        modalPTZ.appendChild(modalDialog);
    ZoneMapCameraSettingWindow.appendChild(modalPTZ);
}




function createPopupContent(index) {   
    var popupWindow = document.getElementById('mic_popup_Window_'+index);
    popupWindow.innerHTML = '';

        var titleBar = document.createElement('tr');            
            var titleBarRow = document.createElement("td");
            titleBarRow.className = 'titleBarRow';

                var cell1 = document.createElement("td");
                cell1.className = "title-bar-cell logo-cell";
                    var logoImage = document.createElement('img');
                        logoImage.id = 'logo_image';
                        logoImage.className = 'mic-popup-Window-logo-Image';
                        logoImage.src = '../imagesaibox/CamConnect.png';
                cell1.appendChild(logoImage);
        
                var cell2 = document.createElement("td");
                cell2.className = "title-bar-cell title-cell";
                    var mic_xy_title = document.createElement('label');
                    mic_xy_title.className = 'Font_Arial_18_bold mic-xy-title';
                    mic_xy_title.textContent = 'Zone Map & Detection';
                cell2.appendChild(mic_xy_title);

                var cell3 = document.createElement("td");
                cell3.className = "title-bar-cell close-button-cell";
                    var closeButton = document.createElement('button');
                    closeButton.id = 'close_mic_Popup_'+index;
                    closeButton.className = 'close-popup-btn';
                    closeButton.setAttribute("onclick", "closeZoneMapWindow(this)");
                cell3.appendChild(closeButton);

            titleBarRow.appendChild(cell1);
            titleBarRow.appendChild(cell2);
            titleBarRow.appendChild(cell3);

        titleBar.appendChild(titleBarRow);

        var RoomSizeSections_tr = document.createElement('tr');
            var RoomSizeSections_td = document.createElement('td');
            RoomSizeSections_td.className = "RoomSizeSections_td";
                var Room_Size_label = document.createElement('label');
                Room_Size_label.id = 'Room_Size_label';
                Room_Size_label.className = 'Room_Size_label  Font_Arial_16_bold';
                Room_Size_label.textContent = "Room Size: ";

                var Room_Size_value = document.createElement('label');
                Room_Size_value.id = 'Room_Size_value'+ index;
                    var Room_Size_H_value = document.createElement('label');
                    Room_Size_H_value.id = 'Room_Size_H_value_' + index;
                    Room_Size_H_value.className = 'Room_Size_value Font_Arial_16_bold';
                    Room_Size_H_value.textContent = "10";

                    var Room_Size_H_value_label = document.createElement('label');
                    Room_Size_H_value_label.className = 'Room_Size_value Font_Arial_16_bold';
                    Room_Size_H_value_label.textContent = "(H)";

                    var Room_Size_HV_value_center_label = document.createElement('label');
                    Room_Size_HV_value_center_label.className = 'Room_Size_value Font_Arial_16_bold';
                    Room_Size_HV_value_center_label.textContent = ",";

                    var Room_Size_V_value = document.createElement('label');
                    Room_Size_V_value.id = 'Room_Size_V_value_' + index;
                    Room_Size_V_value.className = 'Room_Size_value Font_Arial_16_bold';
                    Room_Size_V_value.textContent = "10";

                    var Room_Size_V_value_label = document.createElement('label');
                    Room_Size_V_value_label.className = 'Room_Size_value Font_Arial_16_bold';
                    Room_Size_V_value_label.textContent = "(V)";

                Room_Size_value.appendChild(Room_Size_H_value);
                Room_Size_value.appendChild(Room_Size_H_value_label);
                Room_Size_value.appendChild(Room_Size_HV_value_center_label);
                Room_Size_value.appendChild(Room_Size_V_value);
                Room_Size_value.appendChild(Room_Size_V_value_label);

                var Room_Size_button = document.createElement('button');
                Room_Size_button.id          = "Refresh_Layout_button_" + index;
                Room_Size_button.className   = "Refresh_Layout_button Refresh_Layout_button_style";
                Room_Size_button.setAttribute("onclick", "updateRefreshZoneMapLayout(this)");
                Room_Size_button.innerText = "Refresh Layout";
                Room_Size_button.type = "button";
                
            RoomSizeSections_td.appendChild(Room_Size_label);
            RoomSizeSections_td.appendChild(Room_Size_value);
            RoomSizeSections_td.appendChild(Room_Size_button);

        RoomSizeSections_tr.appendChild(RoomSizeSections_td);


        var InfoSections_canvasContainer_td = document.createElement('td');
        InfoSections_canvasContainer_td.id = 'InfoSections_canvasContainer_td_' + index;
        InfoSections_canvasContainer_td.className = 'InfoSections_canvasContainer_td';

            var InfoSections = document.createElement('td');
            InfoSections.className = 'InfoSections';

                var ArrayMicrophoneSection = document.createElement('tr');
                ArrayMicrophoneSection.id =  'ArrayMicrophoneSection_' + index;
                ArrayMicrophoneSection.className = 'ArrayMicrophoneSection';
                    
                    var ArrayMicrophonemicTitle_td = document.createElement('td');
                    ArrayMicrophonemicTitle_td.id = 'ArrayMicrophonemicTitle_td';
                    ArrayMicrophonemicTitle_td.className = 'ArrayMicrophonemicTitle_td';
                        var ArrayMicrophonemicTitle = document.createElement('label');
                        ArrayMicrophonemicTitle.id          = "ArrayMicrophonemicTitle_" + index;
                        ArrayMicrophonemicTitle.className = 'ArrayMicrophonemicTitle Font_Arial_16_bold';
                        ArrayMicrophonemicTitle.textContent = "Array Microphone";
                    ArrayMicrophonemicTitle_td.appendChild(ArrayMicrophonemicTitle);


                    var ArrayMicrophone_Microphone_td = document.createElement('td');
                    ArrayMicrophone_Microphone_td.id          = "ArrayMicrophone_Microphone_td_" + index;
                    ArrayMicrophone_Microphone_td.className    = "ArrayMicrophone_Microphone_td";
                        var ArrayMicrophone_Microphone_label = document.createElement('label');
                        ArrayMicrophone_Microphone_label.id          = "ArrayMicrophone_Microphone_label_" + index;
                        ArrayMicrophone_Microphone_label.className      = "ArrayMicrophone_Microphone_label  Font_Arial_14_bold";
                        ArrayMicrophone_Microphone_label.textContent = "Microphone : ";
                        var ArrayMicrophone_Microphone_value = document.createElement('label');
                        ArrayMicrophone_Microphone_value.id          = "ArrayMicrophone_Microphone_value_" + index;
                        ArrayMicrophone_Microphone_value.className      = "ArrayMicrophone_Microphone_value  Font_Arial_14_bold";
                        ArrayMicrophone_Microphone_value.textContent = "Nureva HDL410";
                    ArrayMicrophone_Microphone_td.appendChild(ArrayMicrophone_Microphone_label);
                    ArrayMicrophone_Microphone_td.appendChild(ArrayMicrophone_Microphone_value);
                    
                    var ArrayMicrophone_IPAddress_td = document.createElement('td');
                    ArrayMicrophone_IPAddress_td.id          = "ArrayMicrophone_Microphone_td_" + index;
                    ArrayMicrophone_IPAddress_td.className   = "ArrayMicrophone_Microphone_td";
                        var ArrayMicrophone_IPAddress_label = document.createElement('label');
                        ArrayMicrophone_IPAddress_label.id          = "ArrayMicrophone_IPAddress_label_" + index;
                        ArrayMicrophone_IPAddress_label.className   = "ArrayMicrophone_IPAddress_label  Font_Arial_14_bold";
                        ArrayMicrophone_IPAddress_label.textContent = "IP Address : ";
                        var ArrayMicrophone_IPAddress_value = document.createElement('label');
                        ArrayMicrophone_IPAddress_value.id          = "ArrayMicrophone_IPAddress_value_" + index;
                        ArrayMicrophone_IPAddress_value.className   = "ArrayMicrophone_IPAddress_value  Font_Arial_14_bold";
                        ArrayMicrophone_IPAddress_value.textContent = "192.168.4.222";
                    ArrayMicrophone_IPAddress_td.appendChild(ArrayMicrophone_IPAddress_label);
                    ArrayMicrophone_IPAddress_td.appendChild(ArrayMicrophone_IPAddress_value);

                    var ArrayMicrophone_ZoneQty_td = document.createElement('td');
                    ArrayMicrophone_ZoneQty_td.id          = "ArrayMicrophone_ZoneQty_td_" + index;
                    ArrayMicrophone_ZoneQty_td.className   = "ArrayMicrophone_ZoneQty_td";
                        var ArrayMicrophone_ZoneQty_label = document.createElement('label');
                        ArrayMicrophone_ZoneQty_label.id          = "ArrayMicrophone_ZoneQty_label_" + index;
                        ArrayMicrophone_ZoneQty_label.className   = "ArrayMicrophone_ZoneQty_label  Font_Arial_14_bold";
                        ArrayMicrophone_ZoneQty_label.textContent = "Zone Qty. : ";
                        var ArrayMicrophone_ZoneQty_value = document.createElement('label');
                        ArrayMicrophone_ZoneQty_value.id          = "ArrayMicrophone_ZoneQty_value_" + index;
                        ArrayMicrophone_ZoneQty_value.className   = "ArrayMicrophone_ZoneQty_value  Font_Arial_14_bold";
                        ArrayMicrophone_ZoneQty_value.textContent = "8";
                    ArrayMicrophone_ZoneQty_td.appendChild(ArrayMicrophone_ZoneQty_label);
                    ArrayMicrophone_ZoneQty_td.appendChild(ArrayMicrophone_ZoneQty_value);
                    
                ArrayMicrophoneSection.appendChild(ArrayMicrophonemicTitle_td);
                ArrayMicrophoneSection.appendChild(ArrayMicrophone_Microphone_td);
                ArrayMicrophoneSection.appendChild(ArrayMicrophone_IPAddress_td);
                ArrayMicrophoneSection.appendChild(ArrayMicrophone_ZoneQty_td);
                //------------------
                var VoiceSourceDetectSection = document.createElement('tr');
                VoiceSourceDetectSection.id =  'VoiceSourceDetectSection_' + index;
                VoiceSourceDetectSection.className = 'VoiceSourceDetectSection';

                    var VoiceSourceDetectTitle_td = document.createElement('td');
                    VoiceSourceDetectTitle_td.id = 'VoiceSourceDetectTitle_td';
                    VoiceSourceDetectTitle_td.className = 'VoiceSourceDetectTitle_td';
                        var VoiceSourceDetectTitle = document.createElement('label');
                        VoiceSourceDetectTitle.id          = "VoiceSourceDetectTitle_" + index;
                        VoiceSourceDetectTitle.className   = "VoiceSourceDetectTitle  Font_Arial_16_bold";
                        VoiceSourceDetectTitle.textContent = window.LanguageManager.getTranslatedText("Voice_Source_Detect");
                    VoiceSourceDetectTitle_td.appendChild(VoiceSourceDetectTitle);   

                    var VoiceSourceDetect_Zone_td = document.createElement('td');
                    VoiceSourceDetect_Zone_td.id          = "VoiceSourceDetect_Zone_td_" + index;
                    VoiceSourceDetect_Zone_td.className   = "VoiceSourceDetect_Zone_td";
                        var VoiceSourceDetect_Zone_label = document.createElement('label');
                        VoiceSourceDetect_Zone_label.id          = "VoiceSourceDetect_Zone_label_" + index;
                        VoiceSourceDetect_Zone_label.className   = "VoiceSourceDetect_Zone_label  Font_Arial_14_bold";
                        VoiceSourceDetect_Zone_label.textContent = "Zone : ";
                        var VoiceSourceDetect_Zone_value = document.createElement('label');
                        VoiceSourceDetect_Zone_value.id          = "VoiceSourceDetect_Zone_value_" + index;
                        VoiceSourceDetect_Zone_value.className   = "VoiceSourceDetect_Zone_value  Font_Arial_14_bold";
                        VoiceSourceDetect_Zone_value.textContent = "Zone 0";
                    VoiceSourceDetect_Zone_td.appendChild(VoiceSourceDetect_Zone_label);
                    VoiceSourceDetect_Zone_td.appendChild(VoiceSourceDetect_Zone_value);
                    
                    var VoiceSourceDetect_XY_td = document.createElement('td');
                    VoiceSourceDetect_XY_td.id          = "VoiceSourceDetect_XY_td_" + index;
                    VoiceSourceDetect_XY_td.className   = "VoiceSourceDetect_XY_td";


                        var VoiceSourceDetect_XY_label = document.createElement('label');
                        VoiceSourceDetect_XY_label.id          = "VoiceSourceDetect_XY_label_" + index;
                        VoiceSourceDetect_XY_label.className   = "VoiceSourceDetect_XY_label Font_Arial_14_bold";
                        VoiceSourceDetect_XY_label.textContent = "( X, Y ) : ";

                        var VoiceSourceDetect_XY_value_td = document.createElement('td');
                        VoiceSourceDetect_XY_value_td.className = 'VoiceSourceDetect_XY_label_td';


                            var VoiceSourceDetect_XY_value_left = document.createElement('label');
                            VoiceSourceDetect_XY_value_left.id          = "VoiceSourceDetect_XY_value_left_" + index;
                            VoiceSourceDetect_XY_value_left.className   = "VoiceSourceDetect_XY_value_left Font_Arial_14_bold";
                            VoiceSourceDetect_XY_value_left.textContent = "(";

                            var VoiceSourceDetect_XY_value_X = document.createElement('label');
                            VoiceSourceDetect_XY_value_X.id          = "VoiceSourceDetect_XY_value_X_" + index;
                            VoiceSourceDetect_XY_value_X.className   = "VoiceSourceDetect_XY_value_X Font_Arial_14_bold";
                            VoiceSourceDetect_XY_value_X.textContent = "0";
                            VoiceSourceDetect_XY_value_X.style.textAlign = "center";

                            var VoiceSourceDetect_XY_value_center = document.createElement('label');
                            VoiceSourceDetect_XY_value_center.id          = "VoiceSourceDetect_XY_value_center_" + index;
                            VoiceSourceDetect_XY_value_center.className   = "VoiceSourceDetect_XY_value_center Font_Arial_14_bold";
                            VoiceSourceDetect_XY_value_center.textContent = ",";

                            var VoiceSourceDetect_XY_value_Y = document.createElement('label');
                            VoiceSourceDetect_XY_value_Y.id          = "VoiceSourceDetect_XY_value_Y_" + index;
                            VoiceSourceDetect_XY_value_Y.className   = "VoiceSourceDetect_XY_value_Y Font_Arial_14_bold";
                            VoiceSourceDetect_XY_value_Y.textContent = "0";
                            VoiceSourceDetect_XY_value_Y.style.textAlign = "center";

                            var VoiceSourceDetect_XY_value_right = document.createElement('label');
                            VoiceSourceDetect_XY_value_right.id          = "VoiceSourceDetect_XY_value_right_" + index;
                            VoiceSourceDetect_XY_value_right.className   = "VoiceSourceDetect_XY_value_right Font_Arial_14_bold";
                            VoiceSourceDetect_XY_value_right.textContent = ')';

                        VoiceSourceDetect_XY_value_td.appendChild(VoiceSourceDetect_XY_value_left);
                        VoiceSourceDetect_XY_value_td.appendChild(VoiceSourceDetect_XY_value_X);
                        VoiceSourceDetect_XY_value_td.appendChild(VoiceSourceDetect_XY_value_center);
                        VoiceSourceDetect_XY_value_td.appendChild(VoiceSourceDetect_XY_value_Y);
                        VoiceSourceDetect_XY_value_td.appendChild(VoiceSourceDetect_XY_value_right);
                        
                        
                    VoiceSourceDetect_XY_td.appendChild(VoiceSourceDetect_XY_label);
                    VoiceSourceDetect_XY_td.appendChild(VoiceSourceDetect_XY_value_td);

                    var VoiceSourceDetect_Camera_td = document.createElement('td');
                    VoiceSourceDetect_Camera_td.id          = "VoiceSourceDetect_Camera_td_" + index;
                    VoiceSourceDetect_Camera_td.className   = "VoiceSourceDetect_Camera_td";
                        var VoiceSourceDetect_Camera_label = document.createElement('label');
                        VoiceSourceDetect_Camera_label.id          = "VoiceSourceDetect_Camera_label_" + index;
                        VoiceSourceDetect_Camera_label.className   = "VoiceSourceDetect_Camera_label Font_Arial_14_bold";
                        VoiceSourceDetect_Camera_label.textContent = "Camera : ";
                        var VoiceSourceDetect_Camera_value = document.createElement('label');
                        VoiceSourceDetect_Camera_value.id          = "VoiceSourceDetect_Camera_value_" + index;
                        VoiceSourceDetect_Camera_value.className   = "VoiceSourceDetect_Camera_value Font_Arial_14_bold";
                        VoiceSourceDetect_Camera_value.textContent = "NULL(NULL)";
                        VoiceSourceDetect_Camera_value.style.textAlign = "center";
                    VoiceSourceDetect_Camera_td.appendChild(VoiceSourceDetect_Camera_label);
                    VoiceSourceDetect_Camera_td.appendChild(VoiceSourceDetect_Camera_value);
                    
                VoiceSourceDetectSection.appendChild(VoiceSourceDetectTitle_td);
                VoiceSourceDetectSection.appendChild(VoiceSourceDetect_Zone_td);
                VoiceSourceDetectSection.appendChild(VoiceSourceDetect_XY_td);
                VoiceSourceDetectSection.appendChild(VoiceSourceDetect_Camera_td);    
                //------------------
                var CameraInformationSection = document.createElement('div');
                CameraInformationSection.id =  'CameraInformationSection_' + index;
                CameraInformationSection.className = 'CameraInformationSection';

                    var CameraInformationTitle_td = document.createElement('td');
                    CameraInformationTitle_td.id = 'CameraInformationTitle_td';
                    CameraInformationTitle_td.className = 'CameraInformationTitle_td';
                        var CameraInformationTitle = document.createElement('label');
                        CameraInformationTitle.id          = "CameraInformationTitle_" + index;
                        CameraInformationTitle.className   = "CameraInformationTitle   Font_Arial_16_bold";
                        CameraInformationTitle.textContent = "Camera Information";
                    CameraInformationTitle_td.appendChild(CameraInformationTitle);

                    var CameraInformation_Camera_td = document.createElement('td');
                    CameraInformation_Camera_td.id          = "CameraInformation_Camera_td_" + index;
                    CameraInformation_Camera_td.className   = "CameraInformation_Camera_td";
                        var CameraInformation_Camera_label = document.createElement('label');
                        CameraInformation_Camera_label.id          = "CameraInformation_Camera_label_" + index;
                        CameraInformation_Camera_label.className   = "CameraInformation_Camera_label Font_Arial_14_bold";
                        CameraInformation_Camera_label.textContent = "Camera : ";
                        
                        var CameraInformation_Camera_select = document.createElement("select");
                        CameraInformation_Camera_select.id          = "CameraInformation_Camera_select_" + index;
                        CameraInformation_Camera_select.className   = "CameraInformation_Camera_select Font_Arial_14 selectH32";
                        CameraInformation_Camera_select.style.textAlign = "center";
                            var option_All = document.createElement("option");
                                option_All.id = "CameraInformation_Camera_select_option_" + index;
                                option_All.value = -1;
                                option_All.text = "Off";
                                option_All.style.textAlign = "center";
                                option_All.selected = true;
                        CameraInformation_Camera_select.appendChild(option_All);

                        var label_CameraInformation_switch_onoff = document.createElement("label");
                        label_CameraInformation_switch_onoff.id = "CameraInformation_switch_onoff_"+index;
                        label_CameraInformation_switch_onoff.className = "switch_onoff";
                        label_CameraInformation_switch_onoff.style.marginTop = '10px';
                        label_CameraInformation_switch_onoff.style.marginLeft = '10px';
                        label_CameraInformation_switch_onoff.style.marginRight = '5px';
                            var input_CameraInformation_connectCheckboxInput = document.createElement("input");
                            input_CameraInformation_connectCheckboxInput.id = "CameraInformation_connectCheckboxInput_"+index;
                            input_CameraInformation_connectCheckboxInput.type = "checkbox";
                            input_CameraInformation_connectCheckboxInput.setAttribute("onchange", "changeCameraInformationStatus(this)");
                            var span_class = document.createElement("span");
                            span_class.className = "slider_onoff";
                        label_CameraInformation_switch_onoff.appendChild(input_CameraInformation_connectCheckboxInput);   
                        label_CameraInformation_switch_onoff.appendChild(span_class);   

                    CameraInformation_Camera_td.appendChild(CameraInformation_Camera_label);
                    CameraInformation_Camera_td.appendChild(CameraInformation_Camera_select);
                    CameraInformation_Camera_td.appendChild(label_CameraInformation_switch_onoff);
                    
                    var CameraInformation_Direction_td = document.createElement('td');
                    CameraInformation_Direction_td.id          = "CameraInformation_Direction_td_" + index;
                    CameraInformation_Direction_td.className   = "CameraInformation_Direction_td";
                        var CameraInformation_Direction_label = document.createElement('label');
                        CameraInformation_Direction_label.id          = "CameraInformation_Direction_label_" + index;
                        CameraInformation_Direction_label.className   = "CameraInformation_Direction_label Font_Arial_14_bold";
                        CameraInformation_Direction_label.textContent = "Camera Pos.:  ";

                        var CameraInformation_Direction_select = document.createElement("select");
                        CameraInformation_Direction_select.id = "CameraInformation_Direction_select_" + index;
                        CameraInformation_Direction_select.className = "CameraInformation_CameraDirection_select selectH32 Font_Arial_14"; 
                        CameraInformation_Direction_select.style.textAlignLast = "center";
                        // CameraInformation_Direction_select.style.cssText = "margin-left : 63px;"  
                        CameraInformation_Direction_select.setAttribute("onchange", "XYMdoeCameraDirectionSelectOnChange(this)");

                            var option_Forward = document.createElement("option");
                            option_Forward.value = 0;
                            option_Forward.text = "Down";
                            option_Forward.selected = true;

                            var option_Right = document.createElement("option");
                            option_Right.value = 1;
                            option_Right.text = "Left";

                            var option_Backward = document.createElement("option");
                            option_Backward.value = 2;
                            option_Backward.text = "Up";

                            var option_Left= document.createElement("option");
                            option_Left.value = 3;
                            option_Left.text = "Right";

                        CameraInformation_Direction_select.appendChild(option_Forward);
                        CameraInformation_Direction_select.appendChild(option_Right);
                        CameraInformation_Direction_select.appendChild(option_Backward);
                        CameraInformation_Direction_select.appendChild(option_Left);

                    CameraInformation_Direction_td.appendChild(CameraInformation_Direction_label);
                    CameraInformation_Direction_td.appendChild(CameraInformation_Direction_select);


                    var CameraInformation_OffsetAngle_td = document.createElement('td');
                    CameraInformation_OffsetAngle_td.id          = "CameraInformation_OffsetAngle_td_" + index;
                    CameraInformation_OffsetAngle_td.className   = "CameraInformation_OffsetAngle_td";
                        var CameraInformation_OffsetAngle_label = document.createElement('label');
                        CameraInformation_OffsetAngle_label.id          = "CameraInformation_OffsetAngle_label_" + index;
                        CameraInformation_OffsetAngle_label.className   = "CameraInformation_OffsetAngle_label Font_Arial_14_bold";
                        CameraInformation_OffsetAngle_label.textContent = "Offset Angle :  ";
                        var CameraInformation_OffsetAngle_value = document.createElement('label');
                        CameraInformation_OffsetAngle_value.id          = "CameraInformation_OffsetAngle_value_" + index;
                        CameraInformation_OffsetAngle_value.className   = "CameraInformation_OffsetAngle_value Font_Arial_14_bold";
                        CameraInformation_OffsetAngle_value.textContent = "0";
                        CameraInformation_OffsetAngle_value.style.display = "none";

                        var CameraInformation_OffsetAngle_input = document.createElement("input");
                        CameraInformation_OffsetAngle_input.id='CameraInformation_OffsetAngle_input_'+index;
                        CameraInformation_OffsetAngle_input.className = 'CameraInformation_OffsetAngle_input';
                        CameraInformation_OffsetAngle_input.type = "number";
                        CameraInformation_OffsetAngle_input.value = 0;
                        CameraInformation_OffsetAngle_input.min = -360;
                        CameraInformation_OffsetAngle_input.max = 360;
                        CameraInformation_OffsetAngle_input .setAttribute("onchange", "updateOffsetAngleLineEditInput(this)");
                        CameraInformation_OffsetAngle_input.style.textAlign = "center";

                        var CameraInformation_OffsetAngle_button = document.createElement('button');
                        CameraInformation_OffsetAngle_button.id          = "CameraInformation_OffsetAngle_button_" + index;
                        CameraInformation_OffsetAngle_button.className   = "CameraInformation_OffsetAngle_button CameraInformation_OffsetAngle_button_style";
                        CameraInformation_OffsetAngle_button.innerText = "Camera Set";
                        CameraInformation_OffsetAngle_button.setAttribute("onclick", "updateCameraInfoCameraSetting(this)");
                        CameraInformation_OffsetAngle_button.type = "button";
                        CameraInformation_OffsetAngle_button.style.display ='none';

                    CameraInformation_OffsetAngle_td.appendChild(CameraInformation_OffsetAngle_label);
                    CameraInformation_OffsetAngle_td.appendChild(CameraInformation_OffsetAngle_value);
                    CameraInformation_OffsetAngle_td.appendChild(CameraInformation_OffsetAngle_input);
                    CameraInformation_OffsetAngle_td.appendChild(CameraInformation_OffsetAngle_button);

                    var CameraInformation_Anchor_td = document.createElement('div');
                    CameraInformation_Anchor_td.id          = "CameraInformation_Anchor_td_" + index;
                    CameraInformation_Anchor_td.className   = "CameraInformation_Anchor_td";
                        var CameraInformation_Anchor_label = document.createElement('label');
                        CameraInformation_Anchor_label.id          = "CameraInformation_Anchor_label_" + index;
                        CameraInformation_Anchor_label.className   = "CameraInformation_Anchor_label Font_Arial_14_bold";
                        CameraInformation_Anchor_label.textContent = "Anchor (X,Y) : ";
                                                
                        var CameraInformation_Anchor_xvalue_input = document.createElement("input");
                        CameraInformation_Anchor_xvalue_input.id='CameraInformation_Anchor_xvalue_input_'+index;
                        CameraInformation_Anchor_xvalue_input.className = 'CameraInformation_Anchor_xvalue_input';
                        CameraInformation_Anchor_xvalue_input.type = "number";
                        CameraInformation_Anchor_xvalue_input.value = 0;
                        CameraInformation_Anchor_xvalue_input.style.textAlign = "center";

                        var CameraInformation_Anchor_value_center = document.createElement('label'); 
                        CameraInformation_Anchor_value_center.className = 'CameraInformation_Anchor_value_center';

                        var CameraInformation_Anchor_yvalue_input = document.createElement("input");
                        CameraInformation_Anchor_yvalue_input.id='CameraInformation_Anchor_yvalue_input_'+index;
                        CameraInformation_Anchor_yvalue_input.className = 'CameraInformation_Anchor_yvalue_input';
                        CameraInformation_Anchor_yvalue_input.type = "number";
                        CameraInformation_Anchor_yvalue_input.value = 0;
                        CameraInformation_Anchor_yvalue_input.style.textAlign = "center";
       
                    CameraInformation_Anchor_td.appendChild(CameraInformation_Anchor_label);
                    CameraInformation_Anchor_td.appendChild(CameraInformation_Anchor_xvalue_input);
                    CameraInformation_Anchor_td.appendChild(CameraInformation_Anchor_value_center);
                    CameraInformation_Anchor_td.appendChild(CameraInformation_Anchor_yvalue_input);


                    var CameraInformation_LocationXY_td = document.createElement('div');
                    CameraInformation_LocationXY_td.id          = "CameraInformation_LocationXY_td_" + index;
                    CameraInformation_LocationXY_td.className   = "CameraInformation_LocationXY_td";
                        var CameraInformation_LocationXY_label = document.createElement('label');
                        CameraInformation_LocationXY_label.id          = "CameraInformation_LocationXY_label_" + index;
                        CameraInformation_LocationXY_label.className   = "CameraInformation_LocationXY_label Font_Arial_14_bold";
                        CameraInformation_LocationXY_label.textContent = "Location (X,Y) : ";
                                                
                        var CameraInformation_LocationXY_value_left = document.createElement('label');
                        CameraInformation_LocationXY_value_left.className = 'CameraInformation_LocationXY_value_left Font_Arial_14_bold';
                        CameraInformation_LocationXY_value_left.textContent = '(';
                        
                        var CameraInformation_LocationXY_xvalue_input = document.createElement("input");
                        CameraInformation_LocationXY_xvalue_input.id = 'CameraInformation_LocationXY_xvalue_input_'+index;
                        CameraInformation_LocationXY_xvalue_input.className = 'CameraInformation_LocationXY_xvalue_input';
                        CameraInformation_LocationXY_xvalue_input.type = "number";
                        CameraInformation_LocationXY_xvalue_input.value = 0;
                        CameraInformation_LocationXY_xvalue_input.style.textAlign = "center";
                        CameraInformation_LocationXY_xvalue_input.setAttribute("onchange", "updateCameraInformationLocationX(this)");

                        var CameraInformation_LocationXY_value_center = document.createElement('label'); 
                        CameraInformation_LocationXY_value_center.className = 'CameraInformation_LocationXY_value_center Font_Arial_14_bold';
                        CameraInformation_LocationXY_value_center.textContent = ',';

                        var CameraInformation_LocationXY_yvalue_input = document.createElement("input");
                        CameraInformation_LocationXY_yvalue_input.id = 'CameraInformation_LocationXY_yvalue_input_'+index;
                        CameraInformation_LocationXY_yvalue_input.className = 'CameraInformation_LocationXY_yvalue_input';
                        CameraInformation_LocationXY_yvalue_input.type = "number";
                        CameraInformation_LocationXY_yvalue_input.value = 0;
                        CameraInformation_LocationXY_yvalue_input.style.textAlign = "center";
                        CameraInformation_LocationXY_yvalue_input.setAttribute("onchange", "updateCameraInformationLocationY(this)");

                        var CameraInformation_LocationXY_value_right = document.createElement('label');  
                        CameraInformation_LocationXY_value_right.className = 'CameraInformation_LocationXY_value_right Font_Arial_14_bold';
                        CameraInformation_LocationXY_value_right.textContent = ')';
       
                    CameraInformation_LocationXY_td.appendChild(CameraInformation_LocationXY_label);
                    CameraInformation_LocationXY_td.appendChild(CameraInformation_LocationXY_value_left);
                    CameraInformation_LocationXY_td.appendChild(CameraInformation_LocationXY_xvalue_input);
                    CameraInformation_LocationXY_td.appendChild(CameraInformation_LocationXY_value_center);
                    CameraInformation_LocationXY_td.appendChild(CameraInformation_LocationXY_yvalue_input);
                    CameraInformation_LocationXY_td.appendChild(CameraInformation_LocationXY_value_right);

                    var ZonemapapplyButton = document.createElement('button');
                    ZonemapapplyButton.id = 'ZonemapapplyButton_' + index;
                    ZonemapapplyButton.className = 'ZonemapapplyButton ZonemapapplyButton_style';
                    ZonemapapplyButton.innerText = "Apply";
                    ZonemapapplyButton.setAttribute("onclick", "updateCameraInfoCameraApply(this)");
                    ZonemapapplyButton.type = "button";


                CameraInformationSection.appendChild(CameraInformationTitle);
                CameraInformationSection.appendChild(CameraInformation_Camera_td);
                CameraInformationSection.appendChild(CameraInformation_Direction_td);
                CameraInformationSection.appendChild(CameraInformation_OffsetAngle_td);
                CameraInformationSection.appendChild(CameraInformation_Anchor_td);
                CameraInformationSection.appendChild(CameraInformation_LocationXY_td);
                CameraInformationSection.appendChild(ZonemapapplyButton);   
                //------------------

            InfoSections.appendChild(ArrayMicrophoneSection);
            InfoSections.appendChild(VoiceSourceDetectSection);
            //InfoSections.appendChild(CameraInformationSection);//@Jeff Remove 
            //------------------

            var canvasContainer_td = document.createElement('td');
            canvasContainer_td.id = 'canvasContainer_' + index;
            canvasContainer_td.className = 'canvasContainer_td';
            canvasContainer_td.style.position = 'relative'; 


                var Environment_Layout_td = document.createElement('td');
                Environment_Layout_td.className = 'Environment_Layout_td';
                    var Environment_Layout_label = document.createElement('label');
                    Environment_Layout_label.id = 'Environment_Layout_label_'+index;
                    Environment_Layout_label.className = 'Environment_Layout_label Font_Arial_14_bold';
                    Environment_Layout_label.innerText = 'Nureva HDL410 Environment Layout';
                Environment_Layout_td.appendChild(Environment_Layout_label);

                var canvas_td = document.createElement('td');
                canvas_td.className = 'canvas_td';
                    var canvas_y_td = document.createElement('td');

                    canvas_y_td.className = 'canvas_y_td';
                        var canvas_y_label = document.createElement('label');
                        canvas_y_label.className = 'canvas_y_label Font_Arial_14_bold';
                        canvas_y_label.innerText = 'Y';
                    canvas_y_td.appendChild(canvas_y_label);  

                    var canvas = document.createElement('canvas');
                    canvas.id = 'xy-canvas_' + index;
                    canvas.className = 'xycanvas';

                    var rectanglesCanvas = document.createElement('canvas');
                    rectanglesCanvas.id = 'xy-canvas_rectangles_' + index;
                    rectanglesCanvas.className = 'xycanvas';
                    rectanglesCanvas.style.position = 'absolute';
                    rectanglesCanvas.style.left = '25px'; 
                    rectanglesCanvas.style.top = '60px';
                    rectanglesCanvas.style.zIndex = '1';

                    var graphicCanvas = document.createElement('canvas');
                    graphicCanvas.id = 'xy-canvas_graphic_' + index;
                    graphicCanvas.className = 'xycanvas';
                    graphicCanvas.style.position = 'absolute';
                    graphicCanvas.style.left = '25px';
                    graphicCanvas.style.top = '60px';
                    graphicCanvas.style.zIndex = '2';

                    var rectCanvas = document.createElement('canvas');
                    rectCanvas.id = 'xy-canvas_rect_' + index;
                    rectCanvas.className = 'xycanvas xycanvas_border';
                    rectCanvas.style.position = 'absolute';
                    rectCanvas.style.left = '25px'; 
                    rectCanvas.style.top  = '60px';
                    rectCanvas.style.zIndex = '3';

                    var microphoneCanvas = document.createElement('canvas');
                    microphoneCanvas.id = 'xy-canvas_microphone_' + index;
                    microphoneCanvas.className = 'xycanvas xycanvas_border';
                    microphoneCanvas.style.position = 'absolute';
                    microphoneCanvas.style.left = '25px'; 
                    microphoneCanvas.style.top  = '60px';
                    microphoneCanvas.style.zIndex = '4';

                    var arrowheadposCanvas = document.createElement('canvas');
                    arrowheadposCanvas.id = 'xy-canvas_arrowheadpos_' + index;
                    arrowheadposCanvas.className = 'xycanvas xycanvas_border';
                    arrowheadposCanvas.style.position = 'absolute';
                    arrowheadposCanvas.style.left = '25px'; 
                    arrowheadposCanvas.style.top  = '60px';
                    arrowheadposCanvas.style.zIndex = '5';

                    var cameraCanvas = document.createElement('canvas');
                    cameraCanvas.id = 'xy-canvas_camera_' + index;
                    cameraCanvas.className = 'xycanvas xycanvas_border';
                    cameraCanvas.style.position = 'absolute';
                    cameraCanvas.style.left = '25px'; 
                    cameraCanvas.style.top  = '60px';
                    cameraCanvas.style.zIndex = '6';
                    
                    var pointsCanvas = document.createElement('canvas');
                    pointsCanvas.id = 'xy-canvas_points_' + index;
                    pointsCanvas.className = 'xycanvas';
                    pointsCanvas.style.position = 'absolute';
                    pointsCanvas.style.left = '25px';
                    pointsCanvas.style.top = '60px';
                    pointsCanvas.style.zIndex = '7';

                    var mouseCanvas = document.createElement('canvas');
                    mouseCanvas.id = 'xy-canvas_mouse_' + index;
                    mouseCanvas.className = 'xycanvas xycanvas_border';
                    mouseCanvas.style.position = 'absolute';
                    mouseCanvas.style.left = '25px'; 
                    mouseCanvas.style.top  = '60px';
                    mouseCanvas.style.zIndex = '8';
                    mouseCanvas.width = 650;
                    mouseCanvas.height = 480;

                    var canvas_x_td = document.createElement('td');
                    canvas_x_td.className = 'canvas_x_td';
                        var canvas_x_label = document.createElement('label');
                        canvas_x_label.className = 'canvas_x_label Font_Arial_14_bold';
                        canvas_x_label.innerText = 'X';
                    canvas_x_td.appendChild(canvas_x_label);  

                canvas_td.appendChild(canvas_y_td);
                canvas_td.appendChild(rectCanvas);
                canvas_td.appendChild(rectanglesCanvas);
                canvas_td.appendChild(graphicCanvas);
                canvas_td.appendChild(pointsCanvas);
                canvas_td.appendChild(cameraCanvas);
                canvas_td.appendChild(mouseCanvas);
                canvas_td.appendChild(arrowheadposCanvas);
                canvas_td.appendChild(microphoneCanvas);
                canvas_td.appendChild(canvas_x_td);

                var Environment_Port_td = document.createElement('td');
                    Environment_Port_td.className = 'Environment_Port_td';
                    var Environment_Port_label = document.createElement('label');
                    Environment_Port_label.className = 'Environment_Port_label Font_Arial_14_bold';
                    Environment_Port_label.innerText = 'Port1';
                Environment_Port_td.appendChild(Environment_Port_label);  


            canvasContainer_td.appendChild(Environment_Layout_td);
            canvasContainer_td.appendChild(canvas_td);
            //canvasContainer_td.appendChild(Environment_Port_td);

        InfoSections_canvasContainer_td.appendChild(InfoSections);
        InfoSections_canvasContainer_td.appendChild(canvasContainer_td);

    popupWindow.appendChild(titleBar);
    popupWindow.appendChild(RoomSizeSections_tr);
    popupWindow.appendChild(InfoSections_canvasContainer_td);

    popupWindow.style.display = 'block';
}

function createCameraMappingArrayDiv(micGroup, micArryNum) 
{
    let micTabPage = gDeviceIndex;
    var deviceTypeSel = document.getElementById("deviceTypeSel_"+micTabPage);
    
    if(!deviceTypeSel) return;
    
    let deviceTypeString = transferDeviceTypeToString(deviceTypeSel.value);

    var div = document.getElementById("Div_cameraMapping_" + micGroup);
    div.innerHTML = "";

        var azimuthQtyContainer = document.createElement("div");
        azimuthQtyContainer.className = "azimuthQty-container";

            var qtyLabel = document.createElement("label");
            qtyLabel.className = "Font_Arial_14 margin-qtyLabel";
            qtyLabel.id = "Label_Azimuth_Qty_" + micGroup;
            qtyLabel.innerText = window.LanguageManager.getTranslatedText("Mapping_Qty");

            var selectMicChannel = document.createElement("select");
            selectMicChannel.id = "selectMicChannel_" + micGroup;
            selectMicChannel.className = "selectH32 selectW150 margin-right";
            selectMicChannel.setAttribute("onchange", "SelectingMicChannel()");
            selectMicChannel.disabled = false;

        var micInfoLabel = document.createElement("label");
        micInfoLabel.className = "Font_Arial_14 margin-micInfoLabel";
        micInfoLabel.id = "micInfo_div" + micGroup;

        var td_ZoneMode = document.createElement("td");
            var space_EnableZone = document.createElement("label");
            space_EnableZone.id = "Space_EnableZone"; 
            space_EnableZone.style.cssText = "margin-left : 740px; margin-top: 5px; margin-right : 10px;"

            var label_ZoneMode = document.createElement("label");
            label_ZoneMode.id = "Label_EnableZone";
            label_ZoneMode.className = "label_ZoneMode Font_Arial_14_bold";   
            label_ZoneMode.innerText = "Enable Zone";
            label_ZoneMode.style.cssText = "margin-top: 5px; margin-right : 10px;"

            var label_ZoneMode_switch_onoff = document.createElement("label");
            label_ZoneMode_switch_onoff.id = "EnableZoneMode_switch_onoff";
            label_ZoneMode_switch_onoff.className = "switch_onoff";
            label_ZoneMode_switch_onoff.style.cssText = "margin-right : 16px;"
                var input_ZoneMode_connectCheckboxInput = document.createElement("input");
                input_ZoneMode_connectCheckboxInput.id = "ZoneMode_connectCheckboxInput_"+micGroup;
                input_ZoneMode_connectCheckboxInput.type = "checkbox";
                input_ZoneMode_connectCheckboxInput.setAttribute("onchange", "changeZoneModeStatus(this)");
                var span_class = document.createElement("span");
                span_class.className = "slider_onoff";
            label_ZoneMode_switch_onoff.appendChild(input_ZoneMode_connectCheckboxInput);   
            label_ZoneMode_switch_onoff.appendChild(span_class);

            /*if(deviceTypeString === 'Audio-Technica:ATND1061(Coordinate)' 
            || deviceTypeString === 'Shure:MXA920(Coordinate)'
            || deviceTypeString === 'Sennheiser:TCC2(Coordinate)'
            || deviceTypeString === 'Sennheiser:TCCM(Coordinate)' 
            )*/ //All Coordinate
            {
                input_ZoneMode_connectCheckboxInput.disabled = true;
            }          

        if(deviceTypeString === 'Yamaha:RM-CG(Coordinate)' 
        //|| deviceTypeString === 'Nureva:HDL410(Coordinate)' 
        || deviceTypeString === 'Audio-Technica:ATND1061(Coordinate)'
        || deviceTypeString === 'Shure:MXA920(Coordinate)'
        || deviceTypeString === 'Sennheiser:TCC2(Coordinate)'
        || deviceTypeString === 'Sennheiser:TCCM(Coordinate)')
        {
            if(deviceTypeString === 'Yamaha:RM-CG(Coordinate)' 
            || deviceTypeString === 'Audio-Technica:ATND1061(Coordinate)'
            || deviceTypeString === 'Shure:MXA920(Coordinate)'
            || deviceTypeString === 'Sennheiser:TCC2(Coordinate)'
            || deviceTypeString === 'Sennheiser:TCCM(Coordinate)')
            {
                if(gInstallmode && g14mode)
                {
                    space_EnableZone.style.cssText = "margin-left : 740px; margin-top: 5px; margin-right : 10px;"
                }
                else if(gInstallmode && !g14mode)
                {
                    space_EnableZone.style.cssText = "margin-left : 675px; margin-top: 5px; margin-right : 10px;"
                }
                else
                {
                    space_EnableZone.style.cssText = "margin-left : 860px; margin-top: 5px; margin-right : 10px;"
                }
            }
            td_ZoneMode.appendChild(space_EnableZone);
        }

        //td_ZoneMode.appendChild(label_ZoneMode);//@Jeff Alwayse Enable For XY, So Hide
        //td_ZoneMode.appendChild(label_ZoneMode_switch_onoff);//@Jeff Alwayse Enable For XY, So Hide

        var ZoneFullMapButton = document.createElement("button");
        ZoneFullMapButton.id = "ZoneFullMap";
        ZoneFullMapButton.type = "button";
        ZoneFullMapButton.className = "ZoneFullMap_Btn_style";
        ZoneFullMapButton.disabled = true;
        ZoneFullMapButton.innerText = window.LanguageManager.getTranslatedText("Zone_Full_Map");
        ZoneFullMapButton.setAttribute("onclick", "onZoneFullMapMode(this)");
        if(deviceTypeString === 'Yamaha:RM-CG(Coordinate)' 
        || deviceTypeString === 'Audio-Technica:ATND1061(Coordinate)'
        || deviceTypeString === 'Shure:MXA920(Coordinate)'
        || deviceTypeString === 'Sennheiser:TCC2(Coordinate)'
        || deviceTypeString === 'Sennheiser:TCCM(Coordinate)' )
        {
           ZoneFullMapButton.disabled = false;
        }

        var ZoneSettingButton = document.createElement("button");
        ZoneSettingButton.id = "zoneModeSetting_" + micGroup;
        ZoneSettingButton.type = "button";
        ZoneSettingButton.className = "ZoneSetting_Btn_style";
        ZoneSettingButton.disabled = true;
        ZoneSettingButton.innerText = window.LanguageManager.getTranslatedText("Zone_Setting");
        ZoneSettingButton.setAttribute("onclick", "onMicZoneMode(this)");

        if(deviceTypeString === 'Yamaha:RM-CG(Coordinate)' 
        || deviceTypeString === 'Audio-Technica:ATND1061(Coordinate)'
        || deviceTypeString === 'Shure:MXA920(Coordinate)'
        || deviceTypeString === 'Sennheiser:TCC2(Coordinate)'
        || deviceTypeString === 'Sennheiser:TCCM(Coordinate)' )
        {
            ZoneSettingButton.disabled = false;
        }

        var space_ZoneMap = document.createElement("label");
        space_ZoneMap.id = "Space_ZoneMap"; 
        space_ZoneMap.style.cssText = "margin-left : 750px; margin-top: 5px; margin-right : 10px;"

         var ZoneMapButton = document.createElement("button");
         ZoneMapButton.id = "cameraMappingZoneMap_" + micGroup;
         ZoneMapButton.type = "button";
         ZoneMapButton.className = "ZoneMap_Btn_style";
         ZoneMapButton.style.cssText = "margin-left : 16px;"
         ZoneMapButton.disabled = false;
         ZoneMapButton.innerText = "Zone Map";
         ZoneMapButton.setAttribute("onclick", "onCameraMappingZoneMap(this)");

        azimuthQtyContainer.appendChild(qtyLabel);
        azimuthQtyContainer.appendChild(selectMicChannel);

        //var td_HandFreeMode = document.createElement("td"); 
            var label_HandFreeMode = document.createElement("label");
            label_HandFreeMode.id = "Label_HandFreeMode";
            label_HandFreeMode.className = "label_ZoneMode Font_Arial_14_bold";   
            label_HandFreeMode.innerText = "All XY Mode";
            label_HandFreeMode.style.cssText = "width: 85px;margin-left : 16px; margin-top: 5px; margin-right : 16px;"

            var label_HandFreeMode_switch_onoff = document.createElement("label");
            label_HandFreeMode_switch_onoff.id = "HandFreeMode_switch_onoff";
            label_HandFreeMode_switch_onoff.className = "switch_onoff";
            label_HandFreeMode_switch_onoff.style.cssText = "margin-right : 16px;"
                var input_HandFreeModeMode_connectCheckboxInput = document.createElement("input");
                input_HandFreeModeMode_connectCheckboxInput.id = "HandFreeMode_connectCheckboxInput_"+gDeviceIndex;
                input_HandFreeModeMode_connectCheckboxInput.type = "checkbox";
                if(gIsEnableHandFree)
                    input_HandFreeModeMode_connectCheckboxInput.checked = true;
                else
                    input_HandFreeModeMode_connectCheckboxInput.checked = false;
                input_HandFreeModeMode_connectCheckboxInput.setAttribute("onchange", "changeHandFreeModeStatus(this)");
                var span_class = document.createElement("span");
                span_class.className = "slider_onoff";
            label_HandFreeMode_switch_onoff.appendChild(input_HandFreeModeMode_connectCheckboxInput);   
            label_HandFreeMode_switch_onoff.appendChild(span_class);
            
        //td_HandFreeMode.appendChild(label_HandFreeMode);
        //td_HandFreeMode.appendChild(label_HandFreeMode_switch_onoff);

        var table = document.createElement("table");
        table.className = "margin-top-10px";

            var row = document.createElement("tr");

                var cell1 = document.createElement("td");
                //cell1.style.cssText = "padding-left:110px;"

                var cell2 = document.createElement("td");
                
                if( document.createElement("GobalSelectLanguage"))
                {
                    cell2.style.cssText = "padding-left : 110px;"
                    if(document.getElementById("GobalSelectLanguage").value == 0)
                    {
                        cell2.style.cssText = "padding-left : 110px;"
                    }
                    else
                    {
                        cell2.style.cssText = "padding-left : 110px;"
                        if(deviceTypeString === 'Shure:MXA910' ||
                        deviceTypeString === 'Shure:MXA920' ||
                        deviceTypeString === 'Shure:MXA710' ||
                        deviceTypeString === 'Shure:MXA310')
                        {
                            cell2.style.cssText = "padding-left : 105px;"
                        }
                        if(deviceTypeString === 'Shure:MXCW' )
                        {
                            cell2.style.cssText = "padding-left : 120px;"
                        }
                    }
                }
                    var label1 = document.createElement("label");
                    label1.className = "Font_Arial_14_bold cameraMappingFiledTitle";
                    if(deviceTypeString === 'Yamaha:RM-CG(Coordinate)' 
                        || deviceTypeString === 'Nureva:HDL410(Coordinate)' 
                        || deviceTypeString === 'Audio-Technica:ATND1061(Coordinate)'
                        || deviceTypeString === 'Shure:MXA920(Coordinate)'
                        || deviceTypeString === 'Sennheiser:TCC2(Coordinate)'
                        || deviceTypeString === 'Sennheiser:TCCM(Coordinate)')
                        label1.innerText = window.LanguageManager.getTranslatedText("Zone_No");
                    else if(deviceTypeString === 'Nureva:HDL410(Coordinate)' )
                        label1.innerText = window.LanguageManager.getTranslatedText("Zone_No");
                    else
                        label1.innerText =  window.LanguageManager.getTranslatedText("Array_No");

                    if(gInstallmode)
                    {
                        label1.style.width = '60px'; 
                    }

                cell2.appendChild(label1);

                var cell3 = document.createElement("td");
                    if(micGroup == 3)//MXCW
                        cell3.style.cssText = "padding-left : 130px;"
                    else
                    {
                        if(gInstallmode && g14mode)
                        {
                            cell3.style.cssText = "padding-left : 40px;"
                        }
                        else
                        {
                            if( document.createElement("GobalSelectLanguage"))
                            {
                                if(document.getElementById("GobalSelectLanguage").value == 0)
                                    cell3.style.cssText = "padding-left : 90px;"
                                else if(document.getElementById("GobalSelectLanguage").value == 1)
                                    cell3.style.cssText = "padding-left : 100px";
                                else
                                    cell3.style.cssText = "padding-left : 120px";
                            }

                        }
                    }

                
                    var label2 = document.createElement("label");
                    label2.className = "Font_Arial_14_bold cameraMappingFiledTitle";
                    label2.innerText = window.LanguageManager.getTranslatedText("Primary_Camera");

                    if(gInstallmode && g14mode)
                    {
                        label2.style.width = '120px'; 
                    }

                cell3.appendChild(label2);

                var cell4 = document.createElement("td");
                if( document.createElement("GobalSelectLanguage"))
                {
                    if(document.getElementById("GobalSelectLanguage").value == 0)
                        cell4.style.cssText = "padding-left : 180px;"
                    else
                        cell4.style.cssText = "padding-left : 240px;"

                    if(gInstallmode && g14mode)
                    {
                        cell4.style.cssText = "padding-left : 80px;"
                    }
                }
                    var label3 = document.createElement("label");
                    label3.className = "Font_Arial_14_bold cameraMappingFiledTitle";
                    label3.innerText = window.LanguageManager.getTranslatedText("Secondary_Camera");
                    if(gInstallmode && g14mode)
                    {
                        label3.style.width = '130px'; 
                    }
                cell4.appendChild(label3);

                if(gInstallmode)
                {
                    var cell8 = document.createElement("td");
                    if(micGroup == 3)//MXCW
                    {
    
                    }
                    else
                    {
                        cell8.style.cssText = "padding-left : 180px;"
                        if( document.createElement("GobalSelectLanguage"))
                        {
                            if(document.getElementById("GobalSelectLanguage").value == 0)
                                cell8.style.cssText = "padding-left : 120px;"
                            else
                                cell8.style.cssText = "padding-left : 180px;"

                            if(gInstallmode && g14mode)
                            {
                                cell8.style.cssText = "padding-left : 80px;"
                            }   
                        }
                    }
                        var label8 = document.createElement("label");
                        label8.className = "Font_Arial_14_bold cameraMappingFiledTitle";
                        label8.innerText = window.LanguageManager.getTranslatedText("Auxiliary_Camera");
                        if(gInstallmode && g14mode)
                        {
                            label8.style.width = '120px'; 
                        }
                    cell8.appendChild(label8);
                }

                var cell5 = document.createElement("td");
                if( document.createElement("GobalSelectLanguage"))
                {
                    if(document.getElementById("GobalSelectLanguage").value == 0)
                    {
                        cell5.style.cssText = "padding-left : 110px;"

                        if(gInstallmode && g14mode)
                        {
                            cell5.style.cssText = "padding-left : 70px;"
                        }

                    }
                    else
                    {
                        cell5.style.cssText = "padding-left : 140px";

                            if(deviceTypeString === 'Shure:MXA910' ||
                           deviceTypeString === 'Shure:MXA920' ||
                           deviceTypeString === 'Shure:MXA710' ||
                           deviceTypeString === 'Shure:MXA310')
                        {
                            cell5.style.cssText = "padding-left : 135px";
                        }
                        if(deviceTypeString === 'Shure:MXCW' )
                        {
                            cell5.style.cssText = "padding-left : 125px";
                        }

                        if(gInstallmode && g14mode)
                        {
                            cell5.style.cssText = "padding-left : 65px";
                        }
                    }
                } 
                    var label4 = document.createElement("label");
                    label4.className = "Font_Arial_14_bold cameraMappingFiledTitle";
                    label4.innerText = window.LanguageManager.getTranslatedText("Preset_No");

                    if(gInstallmode && g14mode)
                    {
                        label4.style.width = '80px'; 
                    }

                cell5.appendChild(label4);

                var cell6 = document.createElement("td");
                cell6.style.cssText = "padding-left : 55px";

                    if(gInstallmode && g14mode)
                    {
                        cell6.style.cssText = "padding-left : 50px";
                    }

                    var label5 = document.createElement("label");
                    label5.className = "Font_Arial_14_bold cameraMappingFiledTitle";
                    label5.innerText = window.LanguageManager.getTranslatedText("AI_Setting");
                    if(gInstallmode && g14mode)
                    {
                        label5.style.width = '70px'; 
                    }
                cell6.appendChild(label5);

                var cell7 = document.createElement("td"); 
                cell7.style.cssText = "padding-left : 80px;"
                    var label6 = document.createElement("label");
                    label6.className = "Font_Arial_14_bold cameraMappingFiledTitle";
                    label6.innerText = "XY";
                cell7.appendChild(label6);

            row.appendChild(cell1);
            row.appendChild(cell2);
            row.appendChild(cell3);
            row.appendChild(cell4);
            if(gInstallmode && g14mode)
            {
                row.appendChild(cell8);
            }
            row.appendChild(cell5);
            row.appendChild(cell6);
            
        table.appendChild(row);

        var ArraytableContainer = document.createElement("div");
        ArraytableContainer.id = 'ArraytableContainer_' + micGroup;
        ArraytableContainer.style.maxHeight = "63.5%";
        ArraytableContainer.style.maxWidth = "100%";
        ArraytableContainer.style.marginLeft ="15px";
        ArraytableContainer.style.marginRight ="30px";
        ArraytableContainer.style.overflow = "auto";

            var table2 = document.createElement("table");
            table2.style.tableLayout = "fixed";
            table2.style.width = "80%";
            table2.style.height = "80%";

                var colgroup = document.createElement("colgroup");
                    var col1 = document.createElement("col");
                    col1.style.width = "25%";
                    var col2 = document.createElement("col");
                    col2.style.width = "25%";
                colgroup.appendChild(col1);
                colgroup.appendChild(col2);
                
                var tbody = document.createElement("tbody");
                tbody.id = "cameraMappingTableBody" + micGroup;
                        var script = document.createElement("script");
                    script.text = `
                        var micArryNum = ${micArryNum};
                        generateCameraPosMappingTable(micArryNum);
                    `;
                tbody.appendChild(script);

            table2.appendChild(colgroup);
            table2.appendChild(tbody);
        ArraytableContainer.appendChild(table2);


        var tr_custombox = document.createElement("tr");
        tr_custombox.style.cssText ="height : 24px";

        var applyButton = document.createElement("button");
        applyButton.id = "cameraMappingApply_" + micGroup;
        applyButton.type = "button";
        applyButton.className = "Btn_style disabled";
        applyButton.style.cssText = "margin-left : 890px;"
        applyButton.disabled = true;
        applyButton.innerText = window.LanguageManager.getTranslatedText("Apply");
        applyButton.setAttribute("onclick", "onCameraMappingApply(this)");

        var cancelButton = document.createElement("button");
        cancelButton.id = "cameraMappingCancel_" + micGroup;
        cancelButton.type = "button";
        cancelButton.className = "Btn_style cameraMapping-array-margin-left cameraMapping-array-margin-right margin-top-10px disabled";
        cancelButton.disabled = true;
        cancelButton.innerText = window.LanguageManager.getTranslatedText("Cancel");
        cancelButton.setAttribute("onclick", "cameraMappingCancelClick()");

    div.appendChild(azimuthQtyContainer);
    div.appendChild(micInfoLabel);

    let zoneControls = document.createElement("div");
    zoneControls.className = "zone-controls-row";

    if((/*deviceTypeString === 'Nureva:HDL410(Coordinate)' 
     ||*/
      deviceTypeString === 'Yamaha:RM-CG(Coordinate)' 
     || deviceTypeString === 'Audio-Technica:ATND1061(Coordinate)'
     || deviceTypeString === 'Shure:MXA920(Coordinate)'
     || deviceTypeString === 'Sennheiser:TCC2(Coordinate)'
     || deviceTypeString === 'Sennheiser:TCCM(Coordinate)'))
    {
        zoneControls.appendChild(td_ZoneMode);
        if(gInstallmode)
        {
            zoneControls.appendChild(ZoneFullMapButton);
        }
        zoneControls.appendChild(ZoneSettingButton);
    }
    if(deviceTypeString === 'Nureva:HDL410(Coordinate)' )
    {
        zoneControls.appendChild(space_ZoneMap);
        //zoneControls.appendChild(ZoneMapButton);//@Jeff Nureva does not need calibration, so hide
    }

    div.appendChild(zoneControls);
    div.appendChild(table);
    div.appendChild(ArraytableContainer);
    div.appendChild(tr_custombox);
    div.appendChild(applyButton);
    div.appendChild(cancelButton);
}

function onChangecameraMappingCameraStatus(state){
}

function handleArrayRangechange(ArrayRange) {
    SelectModelApplyStatusChange();

    var ArrayID = ArrayRange.target.id;
    var AarrayValue = parseInt(ArrayRange.target.value);  

    var micTabPage = gDeviceIndex;
    var currentSoundType = document.getElementById("deviceTypeSel_"+micTabPage).value;
    var micSelect = parseInt(currentSoundType);

    let devicesel = document.getElementById("deviceTypeSel_"+gDeviceIndex);
    let deviceType = transferDeviceTypeToString(devicesel.value); 

    switch(deviceType)
    {
        case 'Sennheiser:TCC2':case 'Sennheiser:TCCM':
            if(AarrayValue<-90){
                document.getElementById(ArrayID).value = -90;
            }
            if(AarrayValue>0){
                document.getElementById(ArrayID).value = 0;
            }
        break;
        case 'Nureva:HDL300':case 'Nureva:Dual HDL300' :case 'Nureva:HDL310':case 'Nureva:HDL410':case 'Nureva:HDL410(Coordinate)':
            if(AarrayValue<0){
                document.getElementById(ArrayID).value = 0;
            }
            if(AarrayValue>120){
                document.getElementById(ArrayID).value = 120;
            }
        break;
        case 'Yamaha:RM-CG':case 'Yamaha:RM-W': case 'Yamaha:RM-CR': case 'Yamaha:RM-TT':
            if(AarrayValue<0){
                document.getElementById(ArrayID).value = 0;
            }
            if(AarrayValue>126){
                document.getElementById(ArrayID).value = 126;
            }
        break;
        case 'Audio-Technica:ATND1061':
        case 'Audio-Technica:ATND1061(Coordinate)':
        case 'Audio-Technica:ATUC-50CU':
            if(AarrayValue<0){
                document.getElementById(ArrayID).value = 0;
            }
            if(AarrayValue>60){
                document.getElementById(ArrayID).value = 60;
            }
        break;
        case 'Lumens:Virtual Mic' :
            document.getElementById(ArrayID).disabled = true;
        break;
    }  
}

function handleAzimuthRangechange(AzimuthRange) {
    onChangecameraMappingPresetStatus('false');

    var AzimuthID = AzimuthRange.target.id;
    var AzimuthValue = parseInt(AzimuthRange.target.value);  
    
    var micTabPage = gDeviceIndex;
    var currentSoundType = document.getElementById("deviceTypeSel_"+micTabPage).value;
    var micSelect = parseInt(currentSoundType);
    var micGroup = getDeviceCameraMappingIndex();
    var selectChannel = document.getElementById("selectMicChannel_"+micGroup).value;
    var micselectChannel = parseInt(selectChannel);

    var devicesel = document.getElementById("deviceTypeSel_"+gDeviceIndex);
    var deviceType = transferDeviceTypeToString(devicesel.value); 

    var matches = AzimuthID.match(/_(\d+)_(\d+)_(\d+)_(\d+)_(\d+)$/);
    var match = {};

    var AzimuthValue_previous_value = 0;
    var AzimuthValue_next_value = 0;
    var startAngle = 0;
    var endAngle = 0;

    if (matches) {
        match.micTabPage = parseInt(matches[1]);
        match.micSelect = parseInt(matches[2]);
        match.micGroup = parseInt(matches[3]);
        match.micIndex  = parseInt(matches[4]);
        match.micStartEnd = parseInt(matches[5]);
        //console.log(match.micIndex,match.micStartEnd,micselectChannel);
    } 
    else {
        //console.log("not match");
    }

    switch (deviceType) {
        case 'Sennheiser:TCC2':case 'Sennheiser:TCCM':
          startAngle = 0;
          endAngle = 360;
        break;
        case "Nureva:HDL300":case "Nureva:Dual HDL300":
        case "Nureva:HDL310":case "Nureva:HDL410":
          startAngle = -70;
          endAngle = 70;
        break;
        case "Yamaha:RM-CG":case "Yamaha:RM-CG(Coordinate)":
          startAngle = -180;
          endAngle = 180;
        break;
    }
      
    if (match.micIndex == 1 && match.micStartEnd == 1) {
        AzimuthValue_next_value = parseInt(document.getElementById(`cameraMappingAzimuth_div_${micTabPage}_${micSelect}_${micGroup}_${match.micIndex}_2`).value);
        if (AzimuthValue < startAngle || AzimuthValue > AzimuthValue_next_value) {
            AzimuthRange.target.value = startAngle;
        }
    }

    if (match.micIndex == 1 && match.micStartEnd == 2) {
        AzimuthValue_next_value = parseInt(document.getElementById(`cameraMappingAzimuth_div_${micTabPage}_${micSelect}_${micGroup}_${match.micIndex+1}_1`).value);
        // if (AzimuthValue < startAngle || AzimuthValue > AzimuthValue_next_value) {
        //     AzimuthRange.target.value = AzimuthValue_next_value;
        // }
    }

    if (match.micIndex == micselectChannel && match.micStartEnd == 1) {
        AzimuthValue_previous_value = parseInt(document.getElementById(`cameraMappingAzimuth_div_${micTabPage}_${micSelect}_${micGroup}_${match.micIndex-1}_2`).value);
        // if (AzimuthValue > endAngle || AzimuthValue < AzimuthValue_previous_value) {
        //   AzimuthRange.target.value = AzimuthValue_previous_value;
        // }
    }

    if (match.micIndex == micselectChannel && match.micStartEnd == 2) {
        AzimuthValue_previous_value = parseInt(document.getElementById(`cameraMappingAzimuth_div_${micTabPage}_${micSelect}_${micGroup}_${match.micIndex}_1`).value);
        if (AzimuthValue > endAngle || AzimuthValue < AzimuthValue_previous_value) {
          AzimuthRange.target.value = endAngle;
        }
    }

    if (match.micIndex != 1 && match.micIndex != micselectChannel) {
        // console.log('match.micIndex',match.micIndex,micselectChannel);
      if (match.micStartEnd == 1) {
        AzimuthValue_previous_value = parseInt(document.getElementById(`cameraMappingAzimuth_div_${micTabPage}_${micSelect}_${micGroup}_${match.micIndex - 1}_2`).value);
        AzimuthValue_next_value = parseInt(document.getElementById(`cameraMappingAzimuth_div_${micTabPage}_${micSelect}_${micGroup}_${match.micIndex}_2`).value);
      } 
      else{
        AzimuthValue_previous_value = parseInt(document.getElementById(`cameraMappingAzimuth_div_${micTabPage}_${micSelect}_${micGroup}_${match.micIndex}_1`).value);
        AzimuthValue_next_value = parseInt(document.getElementById(`cameraMappingAzimuth_div_${micTabPage}_${micSelect}_${micGroup}_${match.micIndex + 1}_1`).value);
      }
    //   if (AzimuthValue > AzimuthValue_next_value || AzimuthValue < AzimuthValue_previous_value) {
    //     AzimuthRange.target.value = (match.micStartEnd == 1)? AzimuthValue_previous_value:AzimuthValue_next_value;
    //   }
    }

    if (match.micIndex == 1 && match.micStartEnd == 1) {
        AzimuthValue_next_value = parseInt(document.getElementById(`cameraMappingAzimuth_div_${micTabPage}_${micSelect}_${micGroup}_${match.micIndex}_2`).value);
        if (AzimuthValue < startAngle || AzimuthValue > AzimuthValue_next_value) {
            AzimuthRange.target.value = startAngle;
        }
    }
    if (match.micIndex == 1 && match.micStartEnd == 2) {
        AzimuthValue_next_value = parseInt(document.getElementById(`cameraMappingAzimuth_div_${micTabPage}_${micSelect}_${micGroup}_${match.micIndex+1}_1`).value);
        // if (AzimuthValue < startAngle || AzimuthValue > AzimuthValue_next_value) {
        //     AzimuthRange.target.value = AzimuthValue_next_value;
        // }
    }
    if (AzimuthValue < startAngle) {
      AzimuthRange.target.value = startAngle;
    }
    if (AzimuthValue > endAngle ) {
        AzimuthRange.target.value = endAngle;
    }
      
}

function handleInputChange(event) 
{
    onChangecameraMappingPresetStatus('false');
    
    var value = parseInt(event.target.value);  

    if (value < 0) {
      event.target.value = 0;
    }

    if (value > 9999) {
      event.target.value = 9999;
    }
}

function onChangecameraMappingPresetStatus(state){
    
    var micGroup = getDeviceCameraMappingIndex();

    if(state == 'true'){
        if(document.getElementById("cameraMappingApply_"+micGroup))
            document.getElementById("cameraMappingApply_"+micGroup).disabled = true;
        if(document.getElementById("cameraMappingCancel_"+micGroup))
            document.getElementById("cameraMappingCancel_"+micGroup).disabled = true; 
    }
    else{
        if(document.getElementById("cameraMappingApply_"+micGroup))
            document.getElementById("cameraMappingApply_"+micGroup).disabled = false;
        if(document.getElementById("cameraMappingCancel_"+micGroup))
            document.getElementById("cameraMappingCancel_"+micGroup).disabled = false;
    }
}

function onChangePrimaryCameraItem()
{
    onChangeCameraItem();
    checkCameraItemIsTheSame("Primary");
}

function onChangeSecondaryCameraItem()
{
    onChangeCameraItem();
    checkCameraItemIsTheSame("Secondary");
}

function checkCameraItemIsTheSame(changeCameraType)
{
    var micGroup = getDeviceCameraMappingIndex();
    var micTabPage = gDeviceIndex;
    var currentSoundType = document.getElementById("deviceTypeSel_" + micTabPage).value;

    var micSelect = parseInt(currentSoundType);
    if(!document.getElementById("selectMicChannel_" + micGroup))
        return;

    var selectChannel = document.getElementById("selectMicChannel_" + micGroup).value;
    var micSelectChannel = parseInt(selectChannel);

    for (var arrayIndex = 0; arrayIndex < micSelectChannel; arrayIndex++) 
    {
        var cameraMappingSelectItem = $("#cameraMappingSeleceItem_div_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" + arrayIndex);
        var cameraMappingSecondSelectItem = $("#cameraMappingSecondSeleceItem_div_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" + arrayIndex);
       
        var primaryCamera = cameraMappingSelectItem.val();
        var secondaryCamera = cameraMappingSecondSelectItem.val();
        
        if(primaryCamera == secondaryCamera)
        {
            if(changeCameraType == "Primary")
            {
                cameraMappingSecondSelectItem.val(-1);
            }
            else if(changeCameraType == "Secondary")
            {
                cameraMappingSelectItem.val(-1);
            }
        }
    }    
}

function onChangeCameraItem(){
    var micGroup = getDeviceCameraMappingIndex();
    document.getElementById("cameraMappingApply_"+micGroup).disabled = false;
    document.getElementById("cameraMappingCancel_"+micGroup).disabled = false;

    var micTabPage = gDeviceIndex;
    var currentSoundType = document.getElementById("deviceTypeSel_" + micTabPage).value;

    let deviceTypeString = transferDeviceTypeToString(currentSoundType); 

    var micSelect = parseInt(currentSoundType);
    if(!document.getElementById("selectMicChannel_" + micGroup))
        return;
   var selectChannel = document.getElementById("selectMicChannel_" + micGroup).value;
    var micSelectChannel = parseInt(selectChannel);

    var HandFreeCheckbox=document.getElementById("HandFreeMode_connectCheckboxInput_"+gDeviceIndex);
    var isEnableHandFree = false;
    if(HandFreeCheckbox) isEnableHandFree =HandFreeCheckbox.checked;

    for (var arrayIndex = 0; arrayIndex < micSelectChannel; arrayIndex++) 
    {
        
        if(gVideoOutputSwichingMode== 0) //Seamless
        {
            var XYinputcheckboxValue = $("#cameraMappingXYinputcheckbox_div_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" + arrayIndex).prop('checked');
            
            if(deviceTypeString.includes("Coordinate"))
            {
                if(XYinputcheckboxValue)
                {
                    document.getElementById("cameraMappingSecondSeleceItem_div_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" + arrayIndex).disabled = true;
                }
                else
                {
                    if(isEnableHandFree)
                        document.getElementById("cameraMappingSecondSeleceItem_div_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" + arrayIndex).disabled = true;
                    else
                        document.getElementById("cameraMappingSecondSeleceItem_div_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" + arrayIndex).disabled = false;
                }

            }
            else
            {
                if(isEnableHandFree)
                    document.getElementById("cameraMappingSecondSeleceItem_div_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" + arrayIndex).disabled = true;
                else
                    document.getElementById("cameraMappingSecondSeleceItem_div_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" + arrayIndex).disabled = false;
            }
        }
        else
        {
            document.getElementById("cameraMappingSecondSeleceItem_div_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" + arrayIndex).disabled = true;
        }        
    }
}

function onChangeAIPeopleTracking(){
    var micGroup = getDeviceCameraMappingIndex();
    document.getElementById("cameraMappingApply_"+micGroup).disabled = false;
    document.getElementById("cameraMappingCancel_"+micGroup).disabled = false;
}

function onMouseoverCameraItem (eventCameraName){
    var selectElement = eventCameraName.target;
    var tooltip = document.getElementById('tooltip');
    if(selectElement.id == "gBackToHomeSelectModelHomeCamera")
    {
        tooltip = document.getElementById('gBackToHomeSelectModelHomeCameraHint');
    }
        
    //console.log("selectElement.id ",selectElement.id );
    //console.log("tooltip.id ",tooltip.id );

    var selectedIndex = selectElement.selectedIndex;
    var selectedOption = selectElement.options[selectedIndex];
    var selectedText = selectedOption.textContent;
    var selectedValue = selectedOption.value;
    //selectElement.classList.add('cameraSelectHovered');
    if(selectedText != 'Off' && selectedText != window.LanguageManager.getTranslatedText("Off") && selectedText != window.LanguageManager.getTranslatedText("Off"))
    {
        var charWidth = 10; 
        var tooltipWidth = selectedText.length * charWidth;
        var maxWidth = 200;
        tooltip.style.width = Math.min(tooltipWidth, maxWidth) + 'px';  
        tooltip.style.height = 32+'px';
        let isConnectStatus = checkCamConnectStatus(selectedText);

        if(isConnectStatus)
            tooltip.textContent = selectedText;
        else
        {
            tooltip.textContent = selectedText+"\n"+window.LanguageManager.getTranslatedText("Cam_ConnectError_Hint");
            //maxWidth = 800;
            //tooltipWidth = (selectedText.length+window.LanguageManager.getTranslatedText("Cam_ConnectError_Hint").length) * charWidth;
            tooltip.style.width = 320+'px'; 
            tooltip.style.height = 72+'px';
        }

        //console.log("eventCameraName.clientX ",eventCameraName.clientX );
        //console.log("eventCameraName.clientY ",eventCameraName.clientY );
        if(selectElement.id == "gBackToHomeSelectModelHomeCamera")
        {
            if(isConnectStatus)
            {
                tooltip.style.left = 240+'px';//eventCameraName.clientX+10+window.scrollX + 'px';
                tooltip.style.top = 130+'px';//eventCameraName.clientY+window.scrollY + 'px';
            }
            else
            {
                tooltip.style.left = 150+'px';//eventCameraName.clientX+10+window.scrollX + 'px';
                tooltip.style.top = 130+'px';//eventCameraName.clientY+window.scrollY + 'px';
            }
        }
        else
        {
            tooltip.style.left = eventCameraName.clientX+10+window.scrollX + 'px';
            tooltip.style.top = eventCameraName.clientY+window.scrollY + 'px';
        }
        
        tooltip.style.display = 'block';
        
    }
}


function onMouseoutCameraItem(eventCameraName) {
    var selectElement = eventCameraName.target;
    //selectElement.classList.remove('cameraSelectHovered');
    var tooltip = document.getElementById('tooltip');
    if(selectElement.id == "gBackToHomeSelectModelHomeCamera")
    {
        tooltip = document.getElementById('gBackToHomeSelectModelHomeCameraHint');
    }
    tooltip.style.display = 'none';
}



function tableftBtnClick() {
    var tabNavDiv = document.querySelector('.mic-tabNavDiv');
    tabNavDiv.scrollLeft -= 1100;

    updateButtonVisibility();
    //console.log("tab-left-btn clicked");
}

function tabrightBtnClick() {
    var tabNavDiv = document.querySelector('.mic-tabNavDiv');
    var tabNavDiv_scrollLeft = tabNavDiv.scrollLeft;
    var tabNavDiv_clientWidth = tabNavDiv.clientWidth;
    var tabNavDiv_scrollWidth = tabNavDiv.scrollWidth;

    var targetScrollLeft = tabNavDiv_scrollLeft + 1100;
    if (targetScrollLeft + tabNavDiv_clientWidth > tabNavDiv_scrollWidth) {
        targetScrollLeft = tabNavDiv_scrollWidth - tabNavDiv_clientWidth;
    }

    tabNavDiv.scrollLeft = targetScrollLeft;

    updateButtonVisibility();
    //console.log("tab-right-btn clicked");
}

function updateButtonVisibility(SoundNumbers) 
{
    //if tab > 6 , tab will show scroll Left Button;
    var tabNavDiv;
    var tabNavDiv_scrollLeft;
    var tabNavDiv_scrollWidth;
    var tabNavDiv_clientWidth;

    var tabNavDiv = document.querySelector('.mic-tabNavDiv');

    if(tabNavDiv)
    {
        tabNavDiv_scrollLeft = tabNavDiv.scrollLeft;
        tabNavDiv_scrollWidth = tabNavDiv.scrollWidth;
        tabNavDiv_clientWidth = tabNavDiv.clientWidth;
    }

    var totalchannel = SoundNumbers;
    
    if(totalchannel == undefined){
        totalchannel = tabNavDiv_scrollWidth/220;
    }
    if((document.getElementById('tab-right-btn'))&&(document.getElementById('tab-left-btn')))
    {
        if(totalchannel <= 6){
            if(document.getElementById('tab-right-btn').className.indexOf('right-btn-none')==-1){
                document.getElementById('tab-right-btn').className='scroll-btn right-btn-none';
            }
            if(document.getElementById('tab-left-btn').className.indexOf('left-btn-none')==-1){
                document.getElementById('tab-left-btn').className='scroll-btn left-btn-none';
            }
        }
        if(tabNavDiv_scrollLeft == 0 && totalchannel > 6){
            if(document.getElementById('tab-right-btn').className.indexOf('right-btn-block')==-1){
                document.getElementById('tab-right-btn').className = 'scroll-btn right-btn-block';
            }
            if(document.getElementById('tab-left-btn').className.indexOf('left-btn-none')==-1){
                document.getElementById('tab-left-btn').className='scroll-btn left-btn-none';
            }
        }
        if(tabNavDiv_scrollLeft > 0){
            if(document.getElementById('tab-right-btn').className.indexOf('right-btn-block')==-1){
                document.getElementById('tab-right-btn').className='scroll-btn right-btn-block';
            }
            if(document.getElementById('tab-left-btn').className.indexOf('left-btn-block')==-1){
                document.getElementById('tab-left-btn').className='scroll-btn left-btn-block';
            }
        }
        if((tabNavDiv_scrollLeft+tabNavDiv_clientWidth) == tabNavDiv_scrollWidth){
            if(document.getElementById('tab-right-btn').className.indexOf('right-btn-none')==-1 && tabNavDiv_scrollLeft != 0){
                document.getElementById('tab-right-btn').className='scroll-btn right-btn-none';
            }
    
        }
    }
}

function updateMicrophonePageStatus(status) {
    const deviceIndex = gDeviceIndex;
    const micGroup = getDeviceCameraMappingIndex();
    const currentSoundType = document.getElementById("deviceTypeSel_" + deviceIndex).value;
    const micSelectChannel = parseInt(document.getElementById("selectMicChannel_" + micGroup).value);
    document.getElementById("SetVoiceTrackingCheckboxInput").disabled = status;
    let devicesel = document.getElementById("deviceTypeSel_"+gDeviceIndex);
    let deviceType = transferDeviceTypeToString(devicesel.value); 


    if(gIsUseGlobalBackToHomeControl)
    {
        toggleElementStatus([
            "deviceCntSel", "connectCheckboxInput_" + deviceIndex,"ExclusionMode_connectCheckboxInput_" + deviceIndex, "DeviceIPInput_" + deviceIndex,
            "deviceTypeSel_" + deviceIndex, "PasswordInput_" + deviceIndex, "InputModelAudioTrigger_" + deviceIndex,
            "SelectModelPreset_" + deviceIndex, "BtnModelCancel_" + deviceIndex, "BtnModelApply_" + deviceIndex,
            "cameraMappingCancel_" + micGroup, "cameraMappingApply_" + micGroup, "selectMicChannel_" + micGroup,
            "BtnModelBackToHomeSetting_"+deviceIndex
        ], status,deviceType);
    }
    else
    {
        toggleElementStatus([
            "deviceCntSel", "connectCheckboxInput_" + deviceIndex,"ExclusionMode_connectCheckboxInput_" + deviceIndex, "DeviceIPInput_" + deviceIndex,
            "deviceTypeSel_" + deviceIndex, "PasswordInput_" + deviceIndex, "InputModelAudioTrigger_" + deviceIndex,
            "SelectModelPreset_" + deviceIndex, "SelectModelHomeTimes_" + deviceIndex, "SelectModelHomeCamera_" + deviceIndex,
            "SelectModelHomePosition_" + deviceIndex, "BtnModelCancel_" + deviceIndex, "BtnModelApply_" + deviceIndex,
            "cameraMappingCancel_" + micGroup, "cameraMappingApply_" + micGroup, "selectMicChannel_" + micGroup
        ], status,deviceType);
    }

    const mappingType = deviceMappings[deviceType];
    const micArryNum = getMicArrayNum(mappingType, micSelectChannel);
    for (let i = 0; i < micArryNum; i++) {
        updateCameraMappingElements(deviceIndex, currentSoundType, micGroup,i, status);
    }
}

function toggleElementStatus(ids, status,deviceType) {
    
    /*if(deviceType =="Lumens:Virtual Mic")
    {
        ids.forEach(id => {
            const element = document.getElementById(id);
            if (element) {
                element.disabled = true;
            }
        });
    }
    else*/
    {
        console.log('2 deviceType:',deviceType);
        console.log('2 status:',status);
        var connectCheck = document.getElementById("connectCheckboxInput_"+gDeviceIndex).checked;
        if(document.getElementById("img_DeviceStatus_"+gDeviceIndex))
        {
            if(connectCheck)
                document.getElementById("img_DeviceStatus_"+gDeviceIndex).style.visibility = "visible";
            else
                document.getElementById("img_DeviceStatus_"+gDeviceIndex).style.visibility = "hidden";
        }

        if(gVideoOutputStatus == false && connectCheck == true && deviceType !="Lumens:Virtual Mic")
        {
            document.getElementById("connectCheckboxInput_"+gDeviceIndex).disabled = false;
            return;
        }
        ids.forEach(id => {
            const element = document.getElementById(id);
            if (element) {
                if(deviceType !="Lumens:Virtual Mic")
                    element.disabled = status;
                else
                    element.disabled = true;
            }
        });
    }
}

function updateCameraMappingElements(deviceIndex, soundType, micGroup, i, status) {
    const suffixes = [
        `Input_${deviceIndex}_${soundType}_${micGroup}_${i + 1}`,
        `SeleceItem_div_${deviceIndex}_${soundType}_${micGroup}_${i}`,
        `Preset_div_${deviceIndex}_${soundType}_${micGroup}_${i}`,
        `Azimuth_div_${deviceIndex}_${soundType}_${micGroup}_${i + 1}_1`,
        `Azimuth_div_${deviceIndex}_${soundType}_${micGroup}_${i + 1}_2`,
        `AIPeopleTrackingModeSeleceItem_div_${deviceIndex}_${soundType}_${micGroup}_${i}`,
        `XYinputcheckbox_div_${deviceIndex}_${soundType}_${micGroup}_${i}`,
    ];

    suffixes.forEach(suffix => {
        const elementId = `cameraMapping${suffix}`;
        const element = document.getElementById(elementId);
        if (element) {
            element.disabled = status;
        }
    });
}

function getMicArrayNum(mappingType, micSelectChannel) {
    switch (mappingType) {
        case 2: return 4;
        case 3: return 125;
        case 8: return 15;
        default: return micSelectChannel;
    }
}

var gSoundXYData = {};

const PointAnimationSystem = {
    initAnimation(ctx, points, scaleWidth, scaleHeight) {
        let animationFrameId = null;
        const fadeDelay = 3000;
        const fadeSpeed = 0.005;
        function draw() {
            ctx.clearRect(0, 0, ctx.canvas.width, ctx.canvas.height);
            const currentTime = Date.now();
            
            points.forEach((point) => 
            {
                if (!point.timestamp) {
                    point.timestamp = currentTime;
                }
                
                const canvasPosX = (ctx.canvas.width / scaleWidth) * (point.x + scaleWidth / 2);
                const canvasPosY = (ctx.canvas.height / scaleHeight) * (scaleHeight / 2 - point.y);

                ctx.beginPath();
                ctx.arc(canvasPosX, canvasPosY, 5, 0, 2 * Math.PI, false);
                const alpha = Math.max(0, point.opacity);
                ctx.fillStyle = `rgba(255,0,0,${alpha})`;
                ctx.fill();
                ctx.closePath();
                
                if (currentTime - point.timestamp > fadeDelay) 
                {
                    point.opacity -= fadeSpeed;
                }
            });

            for (let i = points.length - 1; i >= 0; i--) 
            {
                if (points[i].opacity <= 0) 
                {
                    points.splice(i, 1);
                }
            }

            if (points.length > 0) 
            {
                animationFrameId = requestAnimationFrame(draw);
            }
        }

        if (animationFrameId) {
            cancelAnimationFrame(animationFrameId);
        }
        animationFrameId = requestAnimationFrame(draw);
    }
};

function updatedSoundXYLocation(msg) {
    const ZoneFullMapCanvas = document.getElementById("ZoneFullMap_xy_canvas_soundPoint");
    if (ZoneFullMapCanvas && ZoneFullMapCanvas.offsetParent !== null)
    {
        ZoneFullMap_queueSoundPoint(msg);
    }
    
    var deviceselIndex;
    if(document.getElementById("deviceTypeSel_"+gDeviceIndex))
        deviceselIndex = document.getElementById("deviceTypeSel_"+gDeviceIndex).value;
    var deviceType = gdeviceTypeSelOptions[deviceselIndex];
    if(!gZoneModeIsOpen && deviceType == 'Yamaha:RM-CG(Coordinate)')
    {
        var connectCheck;
        if(document.getElementById("connectCheckboxInput_"+gDeviceIndex))
            connectCheck = document.getElementById("connectCheckboxInput_"+gDeviceIndex).checked;
        if(!connectCheck) return;
    
        var canvas = document.getElementById('ZoneMode_xy_canvas_soundPoint_' + msg.SoundTabIndex);
        if(!canvas) return;
    
        if(document.getElementById('VoiceSourceDetect_XY_value_X_' + msg.SoundTabIndex))
            var XY_value_X =  document.getElementById('VoiceSourceDetect_XY_value_X_' + msg.SoundTabIndex);
        if(document.getElementById('VoiceSourceDetect_XY_value_Y_' + msg.SoundTabIndex))
            var XY_value_Y =  document.getElementById('VoiceSourceDetect_XY_value_Y_' + msg.SoundTabIndex);

        if (!gSoundXYData[msg.SoundTabIndex]) 
        {
            gSoundXYData[msg.SoundTabIndex] = { points: [] };
        }
    
        if (canvas) {
            var ctx = canvas.getContext('2d');
    
            const rect = canvas.getBoundingClientRect();
            if (canvas.width !== rect.width || canvas.height !== rect.height) {
                canvas.width = rect.width;
                canvas.height = rect.height;
            }
    
            ctx.clearRect(0, 0, canvas.width, canvas.height);
    
            var scaleWidth;
            if(canvas)
                scaleWidth = canvas.width; 
            var scaleHeight;
            if(canvas)
                scaleHeight = canvas.height;

            var SoundPosX = msg.SoundLocationX * 100; // cm -> mm
            var SoundPosY = msg.SoundLocationY * 100; // cm -> mm
            
            if (XY_value_X) XY_value_X.innerText = SoundPosX.toFixed(0);
            if (XY_value_Y) XY_value_Y.innerText = (SoundPosY + 4000).toFixed(0);

            var canvasPosX = (scaleWidth / 2) + (SoundPosX / 4000) * (scaleWidth / 2);
            var canvasPosY = (scaleHeight / 2) - (SoundPosY / 4000) * (scaleHeight / 2);

            gSoundXYData[msg.SoundTabIndex].points.push({ 
                x: canvasPosX,
                y: canvasPosY, 
                opacity: 1 
            });
    
            if (gSoundXYData[msg.SoundTabIndex].points.length > 10) {
                gSoundXYData[msg.SoundTabIndex].points.shift();
            }

            let animationFrameId = null;
            const fadeDelay = 3000;
            const fadeSpeed = 0.005;

            function draw() {
                ctx.clearRect(0, 0, ctx.canvas.width, ctx.canvas.height);
                const currentTime = Date.now();

                gSoundXYData[msg.SoundTabIndex].points.forEach((point) => {
                    if (!point.timestamp) {
                        point.timestamp = currentTime;
                    }

                    ctx.beginPath();
                    ctx.arc(point.x, point.y, 5, 0, 2 * Math.PI, false);
                    const alpha = Math.max(0, point.opacity);
                    ctx.fillStyle = `rgba(255,0,0,${alpha})`;
                    ctx.fill();
                    ctx.closePath();

                    if (currentTime - point.timestamp > fadeDelay) {
                        point.opacity -= fadeSpeed;
                    }
                });

                gSoundXYData[msg.SoundTabIndex].points = gSoundXYData[msg.SoundTabIndex].points.filter(point => point.opacity > 0);

                if (gSoundXYData[msg.SoundTabIndex].points.length > 0) {
                    animationFrameId = requestAnimationFrame(draw);
                }
            }

            if (animationFrameId) {
                cancelAnimationFrame(animationFrameId);
            }

            animationFrameId = requestAnimationFrame(draw);
    
        } 
        else 
        {
            return;
        }
    }
    else if(!gZoneModeIsOpen && deviceType == 'Nureva:HDL410(Coordinate)')
    {
        var connectCheck;
        if(document.getElementById("connectCheckboxInput_"+gDeviceIndex))
            connectCheck = document.getElementById("connectCheckboxInput_"+gDeviceIndex).checked;
        if(!connectCheck) return;
    
        var canvas = document.getElementById('ZoneMode_xy_canvas_soundPoint_' + msg.SoundTabIndex);
        if(!canvas) return;
    
        if(document.getElementById('VoiceSourceDetect_XY_value_X_' + msg.SoundTabIndex))
            var XY_value_X =  document.getElementById('VoiceSourceDetect_XY_value_X_' + msg.SoundTabIndex);
        if(document.getElementById('VoiceSourceDetect_XY_value_Y_' + msg.SoundTabIndex))
            var XY_value_Y =  document.getElementById('VoiceSourceDetect_XY_value_Y_' + msg.SoundTabIndex);

        let RoomSizeH = 10,RoomSizeV=10;
        if(document.getElementById('Room_Size_H_value_' + msg.SoundTabIndex))
            RoomSizeH = document.getElementById('Room_Size_H_value_' + msg.SoundTabIndex).value;
        if(document.getElementById('Room_Size_V_value_' + msg.SoundTabIndex))
            RoomSizeV = document.getElementById('Room_Size_V_value_' + msg.SoundTabIndex).value;

        var RoomSizeH_mm = RoomSizeH * 1000;  // Convert from meters to millimeters
        var RoomSizeV_mm = RoomSizeV * 1000;  // Convert from meters to millimeters

        if (!gSoundXYData[msg.SoundTabIndex]) 
        {
            gSoundXYData[msg.SoundTabIndex] = { points: [] };
        }
    
        if (canvas) {
            var ctx = canvas.getContext('2d');
    
            const rect = canvas.getBoundingClientRect();
            if (canvas.width !== rect.width || canvas.height !== rect.height) {
                canvas.width = rect.width;
                canvas.height = rect.height;
            }
    
            ctx.clearRect(0, 0, canvas.width, canvas.height);
    
            var scaleWidth;
            if(canvas)
                scaleWidth = canvas.width;
            var scaleHeight;
            if(canvas)
                scaleHeight = canvas.height;

            var SoundPosX = msg.SoundLocationX; // cm -> mm
            var SoundPosY = msg.SoundLocationY; // cm -> mm
            
            if (XY_value_X) XY_value_X.innerText = SoundPosX.toFixed(0);
            if (XY_value_Y) XY_value_Y.innerText = SoundPosY.toFixed(0);

            var canvasPosX = (scaleWidth / 2) + (SoundPosX / RoomSizeH_mm) * (scaleWidth / 2);
            var canvasPosY = (scaleHeight / 2) - (SoundPosY / RoomSizeV_mm) * (scaleHeight / 2);

            gSoundXYData[msg.SoundTabIndex].points.push({ 
                x: canvasPosX,
                y: canvasPosY, 
                opacity: 1 
            });
    
            if (gSoundXYData[msg.SoundTabIndex].points.length > 10) {
                gSoundXYData[msg.SoundTabIndex].points.shift();
            }

            let animationFrameId = null;
            const fadeDelay = 3000;
            const fadeSpeed = 0.005;

            function draw() {
                ctx.clearRect(0, 0, ctx.canvas.width, ctx.canvas.height);
                const currentTime = Date.now();

                gSoundXYData[msg.SoundTabIndex].points.forEach((point) => {
                    if (!point.timestamp) {
                        point.timestamp = currentTime;
                    }

                    ctx.beginPath();
                    ctx.arc(point.x, point.y, 5, 0, 2 * Math.PI, false);
                    const alpha = Math.max(0, point.opacity);
                    ctx.fillStyle = `rgba(255,0,0,${alpha})`;
                    ctx.fill();
                    ctx.closePath();

                    if (currentTime - point.timestamp > fadeDelay) {
                        point.opacity -= fadeSpeed;
                    }
                });

                gSoundXYData[msg.SoundTabIndex].points = gSoundXYData[msg.SoundTabIndex].points.filter(point => point.opacity > 0);

                if (gSoundXYData[msg.SoundTabIndex].points.length > 0) {
                    animationFrameId = requestAnimationFrame(draw);
                }
            }

            if (animationFrameId) {
                cancelAnimationFrame(animationFrameId);
            }

            animationFrameId = requestAnimationFrame(draw);
    
        } 
        else 
        {
            return;
        }
    }
    else
    {
        let devicesel = document.getElementById("deviceTypeSel_" + gDeviceIndex);
        let deviceTypeString;
        if(devicesel)
        {
            deviceTypeString = transferDeviceTypeToString(devicesel.value);
        }

        var canvas = document.getElementById('ZoneMode_xy_canvas_soundPoint_' + msg.SoundTabIndex);
        if(!canvas) return;
        var voiceSourceX = document.getElementById('ZoneModeVoiceSourceDetect_XY_value_X_' + msg.SoundTabIndex);
        var voiceSourceY = document.getElementById('ZoneModeVoiceSourceDetect_XY_value_Y_' + msg.SoundTabIndex);

        let micUnit = 10.0;
        var SoundPosX = msg.SoundLocationX * micUnit * (750/800);
        var SoundPosY = msg.SoundLocationY * micUnit * (750/800);

        if(voiceSourceX)
            voiceSourceX.textContent = ((msg.SoundLocationX+400)/100).toFixed(2);
        if(voiceSourceY)
            voiceSourceY.textContent = ((msg.SoundLocationY+400)/100).toFixed(2);

        if (deviceTypeString === 'Yamaha:RM-CG(Coordinate)') 
        {
            SoundPosX = msg.SoundLocationX * micUnit * (750/800);
            SoundPosY = msg.SoundLocationY * micUnit * (750/800);

            if(voiceSourceX)
                voiceSourceX.textContent = ((msg.SoundLocationX * micUnit+400)/100).toFixed(2);
            if(voiceSourceY)
                voiceSourceY.textContent = ((msg.SoundLocationY * micUnit+400)/100).toFixed(2);
        }
        if (deviceTypeString === 'Nureva:HDL410(Coordinate)') 
        {
            SoundPosX = (msg.SoundLocationX / 10) * (750/800);
            SoundPosY = (msg.SoundLocationY / 10 - 500) * (750/800);
            if(voiceSourceX)
                voiceSourceX.textContent = ((msg.SoundLocationX)/1000).toFixed(2);
            if(voiceSourceY)
                voiceSourceY.textContent = ((msg.SoundLocationY)/1000).toFixed(2);
        }
        if (deviceTypeString === 'Audio-Technica:ATND1061(Coordinate)'
         || deviceTypeString === 'Shure:MXA920(Coordinate)'        
         || deviceTypeString === 'Sennheiser:TCC2(Coordinate)'
         || deviceTypeString === 'Sennheiser:TCCM(Coordinate)') 
        {
            micUnit = 1.0;
            SoundPosX = msg.SoundLocationX * micUnit * (750/800);
            SoundPosY = msg.SoundLocationY * micUnit * (750/800);

            if(voiceSourceX)
                voiceSourceX.textContent = ((msg.SoundLocationX+400)/100).toFixed(2);
            if(voiceSourceY)
                voiceSourceY.textContent = ((msg.SoundLocationY+400)/100).toFixed(2);
        }
        var scaleWidth;
        if(canvas)
            scaleWidth = canvas.width;
        var scaleHeight;
        if(canvas)
            scaleHeight = canvas.height;

        if (!gZoneModeSoundXYData[msg.SoundTabIndex]) gZoneModeSoundXYData[msg.SoundTabIndex] = { points: [], timers: [] };

        gZoneModeSoundXYData[msg.SoundTabIndex].points.push({ x: SoundPosX, y: SoundPosY, opacity: 1 });
    
        if (gZoneModeSoundXYData[msg.SoundTabIndex].points.length > 10) 
        {
            gZoneModeSoundXYData[msg.SoundTabIndex].points.shift();
        }

        if (canvas) 
        {
            var ctx = canvas.getContext('2d');
            const rect = canvas.getBoundingClientRect();
            if (canvas.width !== rect.width || canvas.height !== rect.height) 
            {
                canvas.width = rect.width;
                canvas.height = rect.height;
            }

            ctx.clearRect(0, 0, canvas.width, canvas.height);
            
            PointAnimationSystem.initAnimation(
                ctx,
                gZoneModeSoundXYData[msg.SoundTabIndex].points,
                scaleWidth,
                scaleHeight
            );
        }
        else 
        {
            return;
        }
    }
}

function drawZoneLayout(zonelayoutList, primebar_X,room_H,room_V) {
    var canvas = document.getElementById('xy-canvas_graphic_' + gDeviceIndex);
    if (canvas) {
        var ctx = canvas.getContext('2d');
        const rect = canvas.getBoundingClientRect();
        if (canvas.width !== rect.width || canvas.height !== rect.height) {
            canvas.width = rect.width;
            canvas.height = rect.height;
        }
        ctx.clearRect(0, 0, canvas.width, canvas.height);
        
        let x_scale = room_H / canvas.width;
        let y_scale = room_V / canvas.height;
        if (x_scale < 1) x_scale = 1;
        if (y_scale < 1) y_scale = 1;
        let zoneindex = 0;
        zonelayoutList.forEach(function(zone, i) {
            zoneindex++;
            let w = (zone.p_2X - zone.p_1X) / x_scale;
            let h = (zone.p_2Y - zone.p_1Y) / y_scale;
            if (w < 0) w = -w;
            if (h < 0) h = -h;

            let graphicX = zone.p_1X / x_scale;
            let graphicY = (room_V - zone.p_2Y) / y_scale;

            if (graphicX < 0) graphicX = 0;
            if (graphicX + w > canvas.width) w = canvas.width - graphicX;
            if (graphicY < 0) graphicY = 0;
            if (graphicY + h > canvas.height) h = canvas.height - graphicY;

            ctx.fillStyle = 'rgb(130, 247, 211)';
            ctx.fillRect(graphicX, graphicY, w, h);

            ctx.fillStyle = 'black'; 
            ctx.textAlign = 'center';
            ctx.fillText("Zone " + (zone.num), graphicX+w/2, graphicY+h/15);
        });

        ctx.font = '16px Arial bold';
        ctx.fillStyle = '#8C8C8C';
        let graphicBarX = (primebar_X) / x_scale-50;
        ctx.fillRect(graphicBarX, canvas.height-10, 100, 10);
    }
}

var gSoundXYData = {};

function drawZonemapPos(msg) {
    var canvas = document.getElementById('xy-canvas_points_' + gDeviceIndex);

    var XY_value_X = document.getElementById('VoiceSourceDetect_XY_value_X_' + msg.SoundTabIndex);
    var XY_value_Y = document.getElementById('VoiceSourceDetect_XY_value_Y_' + msg.SoundTabIndex);
    if (!XY_value_X) return;
    XY_value_X.innerText = msg.ZoneMap.coordinateX;
    XY_value_Y.innerText = msg.ZoneMap.coordinateY;

    if (!gSoundXYData[msg.SoundTabIndex]) gSoundXYData[msg.SoundTabIndex] = { points: [] };

    if (canvas) {
        var ctx = canvas.getContext('2d');
        const rect = canvas.getBoundingClientRect();
        if (canvas.width !== rect.width || canvas.height !== rect.height) {
            canvas.width = rect.width;
            canvas.height = rect.height;
        }

        ctx.clearRect(0, 0, canvas.width, canvas.height);

        var x_scale = gZoneMaproomSizeH / canvas.width;
        var y_scale = gZoneMaproomSizeV / canvas.height;
        if (x_scale < 1) x_scale = 1;
        if (y_scale < 1) y_scale = 1;
        var SoundPosX = (msg.ZoneMap.coordinateX + gZoneMapprimebarX) / x_scale;
        var SoundPosY = (gZoneMaproomSizeV - msg.ZoneMap.coordinateY) / y_scale;

        var pointId = new Date().getTime();
        gSoundXYData[msg.SoundTabIndex].points.push({ id: pointId, x: SoundPosX, y: SoundPosY, opacity: 1 });

        if (gSoundXYData[msg.SoundTabIndex].points.length > 10) {
            gSoundXYData[msg.SoundTabIndex].points.shift();
        }

        function updateCanvas() {
            ctx.clearRect(0, 0, canvas.width, canvas.height);
            gSoundXYData[msg.SoundTabIndex].points.forEach((point) => {
                var canvasPosX = point.x;
                var canvasPosY = point.y;
                ctx.beginPath();
                ctx.arc(canvasPosX, canvasPosY, 5, 0, 2 * Math.PI, false);
                var alpha = point.opacity < 0 ? 0 : point.opacity;
                ctx.fillStyle = `rgba(255,0,0,${alpha})`;
                ctx.strokeStyle = `rgba(0,0,0,${alpha})`;
                ctx.lineWidth = 2;
                ctx.stroke();
                ctx.fill();
                ctx.closePath();
            });
        }
        updateCanvas();

        gSoundXYData[msg.SoundTabIndex].points.forEach((point, index) => {
            setTimeout(() => {
                var fadeOutRate = 0.2;
                var fadeInterval = setInterval(() => {
                    point.opacity -= fadeOutRate;
                    if (point.opacity <= 0) {
                        clearInterval(fadeInterval);
                        gSoundXYData[msg.SoundTabIndex].points = gSoundXYData[msg.SoundTabIndex].points.filter(p => p.id !== point.id);
                        updateCanvas();
                    }
                }, 100);
            }, index+1 * 500);
        });
    } else {
        return;
    }
}

function closeZoneMapWindow(){
    var micGroup = getDeviceCameraMappingIndex();
    var zoommapbutton = document.getElementById('cameraMappingZoneMap_' + micGroup);
    zoommapbutton.disabled = false; 

    var popupWindow =  document.getElementById('mic_popup_Window_' + gDeviceIndex);
    popupWindow.style.display = 'none';
    var jsonmsg = {};
    jsonmsg.Command = "SetZoneMapDetection";
    jsonmsg.SoundTabIndex = gDeviceIndex;
    jsonmsg.ZoneMap = {};
    jsonmsg.ZoneMap.IsOnOff = false;
    sendMessage("SetZoneMapDetection",jsonmsg);
    enabledLeftMenuOnPopWindowClose();

    var backgroundWindow = document.getElementById('background_block_Window');
    backgroundWindow.style.display = 'none';
}

function closeZoneModeWindow(){
    gZoneModeIsOpen = false;
    var backgroundWindow = document.getElementById('background_zonemode_block_Window');
    backgroundWindow.style.display = 'none';

    var popupWindow =  document.getElementById('mic_zonemode_popup_Window_' + gDeviceIndex);
    popupWindow.style.display = 'none';

    
    var backgroundmodelNameLabel = document.getElementById('modelNameLabel');
    backgroundmodelNameLabel.style.display = 'block';
    var backgroundpowerBtn = document.getElementById('powerBtn');
    backgroundpowerBtn.style.display = 'block';
    var backgroundlogoutBtn = document.getElementById('logoutBtn');
    backgroundlogoutBtn.style.display = 'block';
    var backgroundLabelProfile = document.getElementById('Label_Profile');
    backgroundLabelProfile.style.display = 'block';
    var backgroundSelectProfile = document.getElementById('Select_Profile');
    backgroundSelectProfile.style.display = 'block';
    var backgrounDirectorProfile = document.getElementById('DirectorBtn');
    if(backgrounDirectorProfile)
        backgrounDirectorProfile.style.display = 'block';
    
}

var ZonemapSeletedIndex=0;
function onCameraMappingZoneMap(button) {
    var micGroup = getDeviceCameraMappingIndex();
    var zoommapbutton = document.getElementById('cameraMappingZoneMap_' + micGroup);
    zoommapbutton.disabled = true; 

    var backgroundWindow = document.getElementById('background_block_Window');
    backgroundWindow.style.display = 'block';

    if(gDeviceIndex != 0){
        if(ZonemapSeletedIndex != gDeviceIndex){
            ZonemapSeletedIndex = gDeviceIndex;
            var jsonmsg = {};
            jsonmsg.Command = "SetSoundTabNum";
            jsonmsg.SoundTabIndex = gDeviceIndex;
            sendMessage("SetSoundTabNum",jsonmsg);
        }
    }

    blockUIforPage();

    let intervalId = setInterval(function() {

        var jsonmsg = {};
        jsonmsg.Command = "SetZoneMapDetection";
        jsonmsg.SoundTabIndex = gDeviceIndex;
        jsonmsg.ZoneMap = {}; 
        jsonmsg.ZoneMap.IsOnOff = true;
        sendMessage("SetZoneMapDetection",jsonmsg);

        jsonmsg.Command = "SetZoneMapDetection";
        jsonmsg.SoundTabIndex = gDeviceIndex;
        jsonmsg.ZoneMap = {}; 
        jsonmsg.ZoneMap.RefreshLayout = true;
        sendMessage("SetZoneMapDetection",jsonmsg);
        sendMessage("SetZoneMapDetection",jsonmsg);

        sendMessage("GetZoneMapDetection",gDeviceIndex);
        sendMessage("GetZoneMapDetection",gDeviceIndex);

        clearInterval(intervalId);
    }, 100);

    //setInterval(simulateSoundLocationData, 5000);

}

function simulateSoundLocationData() {
    let soundTabIndex = 0;
    let soundLocationX = Math.random() * 80 - 40;  // X 座標範圍：-4000 到 4000
    let soundLocationY = Math.random() * 80 - 40;  // Y 座標範圍：-4000 到 4000
    let simulatedMsg = {
        Reply: "GetSoundXYLocation",
        SoundTabIndex: soundTabIndex,
        SoundLocationX: soundLocationX,
        SoundLocationY: soundLocationY
    };

    updatedSoundXYLocation(simulatedMsg);

}


var cameraDisplayInterval;

function updateCameraInfoCameraselect(element){
    var jsonmsg = {};
    jsonmsg.Command = "SetZoneMapDetection";
    jsonmsg.SoundTabIndex = gDeviceIndex;
    jsonmsg.ZoneMap = {};
    jsonmsg.ZoneMap.CameraIP = element.value;
    sendMessage("SetZoneMapDetection",jsonmsg);
    var canvas = document.getElementById('xy-canvas_camera_' + gDeviceIndex);
    var canvasArrowHeadpos = document.getElementById('xy-canvas_arrowheadpos_' + gDeviceIndex);
    if (canvas) 
    {
        var ctx = canvas.getContext('2d');
        ctx.clearRect(0, 0, canvas.width, canvas.height);
    }
    if(canvasArrowHeadpos)
    {
        var ctx = canvasArrowHeadpos.getContext('2d');
        ctx.clearRect(0, 0, canvasArrowHeadpos.width, canvasArrowHeadpos.height);
    }
}

function CameraSettingGetAngleOffset(){
    var cameraIP = document.getElementById('CameraInformation_Camera_select_' + gDeviceIndex).value;
    var jsonmsg = {};
    jsonmsg.Command = "SetZoneMapDetection";
    jsonmsg.SoundTabIndex = gDeviceIndex;
    jsonmsg.ZoneMap = {}; 
    jsonmsg.ZoneMap.GetAngleOffSet = true;
    jsonmsg.ZoneMap.CameraIP = cameraIP;
    sendMessage("SetZoneMapDetection",jsonmsg);
}

function updateCameraInfoCameraSetting() {
    var cameraIP = document.getElementById('CameraInformation_Camera_select_' + gDeviceIndex).value;
    var cameraIPOffsetAnglebutton = document.getElementById('CameraInformation_OffsetAngle_button_' + gDeviceIndex);
    
    if(cameraIP == "-1")return;

    var jsonmsg = {};
    jsonmsg.Command = "SetWebPreview";
    jsonmsg.IPAddress = cameraIP;
    jsonmsg.IsPreview = true;
    sendMessage(jsonmsg.Command,jsonmsg);
    
    micGetPTZInfo(cameraIP);

    var ZoneMap = document.getElementById('mic_popup_Window_' + gDeviceIndex);
    var CameraSetting = document.getElementById('ZoneMap_CameraSetting_PTZWindows_' + gDeviceIndex);

    ZoneMap.style.position = 'fixed';
    CameraSetting.style.position = 'fixed';
    CameraSetting.style.display = 'block';
    CameraSetting.style.zIndex = '1000';
    ZoneMap.style.zIndex = '500';

    var backgroundWindow = document.getElementById('background_block_cameraSet_Window');
    backgroundWindow.style.display = 'block';
}

function closeZoneMapCameraSettingWindow(){
    var cameraSettingWindow =  document.getElementById('ZoneMap_CameraSetting_PTZWindows_' + gDeviceIndex);
    cameraSettingWindow.style.display = 'none';
    var backgroundWindow = document.getElementById('background_block_cameraSet_Window');
    backgroundWindow.style.display = 'none';
    var cameraIP = document.getElementById('CameraInformation_Camera_select_'+gDeviceIndex);
    clearInterval(cameraDisplayInterval);
    var jsonmsg = {};
    jsonmsg.Command = "SetWebPreview";
    jsonmsg.IPAddress = cameraIP.value;
    jsonmsg.IsPreview = false;
    sendMessage(jsonmsg.Command,jsonmsg);
}

function updateCameraInfoCameraApply()
{
    var AngleOffSet = document.getElementById('CameraInformation_OffsetAngle_value_' + gDeviceIndex);
    var anchorX = document.getElementById('CameraInformation_Anchor_xvalue_input_' + gDeviceIndex);
    var anchorY = document.getElementById('CameraInformation_Anchor_yvalue_input_' + gDeviceIndex);
    var camLocationX = document.getElementById('CameraInformation_LocationXY_xvalue_input_' + gDeviceIndex);
    var camLocationY = document.getElementById('CameraInformation_LocationXY_yvalue_input_' + gDeviceIndex);
    var cameraSelect = document.getElementById('CameraInformation_Camera_select_' + gDeviceIndex);
    var cameraDirectionSelect = document.getElementById('CameraInformation_Direction_select_' + gDeviceIndex);
    var selectedOption = cameraSelect.options[cameraSelect.selectedIndex];
    var cameraIP = selectedOption.value;
    var CameraDirectionValue;
    if(cameraDirectionSelect)
    {
        CameraDirectionValue = cameraDirectionSelect.value;
    }
    
    var cameraFriendlyName = selectedOption.text.split(' ')[0];

    //console.log('updateCameraInfoCameraApply',cameraIP);
    var jsonmsg = {};
    jsonmsg.Command = "SetZoneMapDetection";
    jsonmsg.SoundTabIndex = gDeviceIndex;
    jsonmsg.ZoneMap = {};
    jsonmsg.ZoneMap.CameraFriendlyName = cameraFriendlyName;
    jsonmsg.ZoneMap.CameraIP = cameraIP;
    if(cameraDirectionSelect)
    {
        jsonmsg.ZoneMap.CameraDirection = parseInt(CameraDirectionValue,10);
    }
    jsonmsg.ZoneMap.AngleOffset =  parseInt(AngleOffSet.textContent,10);
    jsonmsg.ZoneMap.AnchorX =  parseInt(anchorX.value,10);
    jsonmsg.ZoneMap.AnchorY =  parseInt(anchorY.value,10); 
    jsonmsg.ZoneMap.CamLocationX = parseInt(camLocationX.value,10);
    jsonmsg.ZoneMap.CamLocationY = parseInt(camLocationY.value,10);
    jsonmsg.ZoneMap.CameraInfoCameraApply = true;
    sendMessage("SetZoneMapDetection",jsonmsg);
}

function updateRefreshZoneMapLayout(e)
{
    var jsonmsg = {};
    jsonmsg.Command = "SetZoneMapDetection";
    jsonmsg.SoundTabIndex = gDeviceIndex;
    jsonmsg.ZoneMap = {}; 
    jsonmsg.ZoneMap.RefreshLayout = true;
    sendMessage("SetZoneMapDetection",jsonmsg);
    sendMessage("SetZoneMapDetection",jsonmsg);

    sendMessage("GetZoneMapDetection",gDeviceIndex);
}

function setupMouseCanvas() {
    var deviceType = document.getElementById('deviceTypeSel_' + gDeviceIndex).value;
    if(deviceType == 11)
    {
        return;
    }
    var canvasRectangles = document.getElementById('xy-canvas_rectangles_' + gDeviceIndex);
    const ctx = canvasRectangles.getContext('2d');
    var scaleWidth = canvasRectangles.offsetWidth;
    var scaleHeight = canvasRectangles.offsetHeight;

    var canvasrect = document.getElementById('xy-canvas_rect_' + gDeviceIndex);
    
    var canvasMouse = document.getElementById('xy-canvas_mouse_' + gDeviceIndex);
    var canvasCamera = document.getElementById('xy-canvas_camera_' + gDeviceIndex);
    var pointx = document.getElementById('CameraInformation_LocationXY_xvalue_input_' + gDeviceIndex);
    var pointy = document.getElementById('CameraInformation_LocationXY_yvalue_input_' + gDeviceIndex);    
    var anchorx = document.getElementById('CameraInformation_Anchor_xvalue_input_' + gDeviceIndex);
    var anchory = document.getElementById('CameraInformation_Anchor_yvalue_input_' + gDeviceIndex);   
    var directionSelect = document.getElementById('CameraInformation_Direction_select_' + gDeviceIndex);  
    var isDragging = false;
    var img = new Image();
    var cameraimgSize = 32;
    img.src = '../images/icon_Camera.png';
    img.onload = function () {
        canvasMouse.addEventListener('mousemove',  onMouseMove);
        canvasMouse.addEventListener('mousedown',  onMouseDown);
        canvasMouse.addEventListener('mouseup',    onMouseUp);
        canvasMouse.addEventListener('mouseleave', onMouseLeave);
        // canvasMouse.addEventListener('contextmenu', onMousecontextmenu);
        // canvasMouse.addEventListener('click', onMousecontextmenuclick);
    };
    var ctx1 = canvasCamera.getContext('2d');
    var ctx2 = canvasMouse.getContext('2d');
    ctx1.clearRect(0, 0, canvasCamera.width, canvasCamera.height);
    ctx2.clearRect(0, 0, canvasMouse.width, canvasMouse.height);
    
    if (!canvasRectangles || !canvasMouse) {
        return;
    }

    canvasRectangles.width  = canvasRectangles.offsetWidth;
    canvasRectangles.height = canvasRectangles.offsetHeight;

    // canvasMouse.addEventListener('mousedown', onMouseDown); //in FW v2.0
    // canvasMouse.addEventListener('mousemove', onMouseMove); //in FW v2.0
    // canvasMouse.addEventListener('mouseup', onMouseUp);     //in FW v2.0
    function onMousecontextmenu(e){
        e.preventDefault();

        const mouseX = e.offsetX;
        const mouseY = e.offsetY;
    
        const rectIndex = grectangles.findIndex(rectObj => isPointInRect(mouseX, mouseY, rectObj.rect));
    
        if (rectIndex !== -1) {
            showContextMenu(e.pageX, e.pageY, rectIndex);
        }
    
        return false;
    }
    
    function onMousecontextmenuclick(e){
        if (contextMenu) {
            contextMenu.remove();
        }
    }

    function onMouseUp(e) {
        isDragging = false;
    }
    
    function onMouseLeave(e) {
        isDragging = false;
    }   

    function onMouseDown(e) {
        
        const bounds = canvasCamera.getBoundingClientRect();
        const mouseX = e.clientX - bounds.left;
        const mouseY = e.clientY - bounds.top;
        var x_scale = gZoneMaproomSizeH / canvasCamera.width;
        var y_scale = gZoneMaproomSizeV / canvasCamera.height;
        if (x_scale < 1) x_scale = 1;
        if (y_scale < 1) y_scale = 1;

        var canvasPosX = (parseInt(pointx.value, 10) + gZoneMapprimebarX) / x_scale;
        var canvasPosY = (gZoneMaproomSizeV - parseInt(pointy.value, 10)) / y_scale;

        if (mouseX > canvasPosX - (cameraimgSize / 2) && mouseX < canvasPosX + (cameraimgSize / 2) &&
            mouseY > canvasPosY - (cameraimgSize / 2) && mouseY < canvasPosY + (cameraimgSize / 2)) {
            isDragging = true;
            console.log('in icon range!!');
        }
    }

    function onMouseMove(e) {
        if (!isDragging) return;
        var canvasCamera = document.getElementById('xy-canvas_mouse_' + gDeviceIndex);
        if(canvasCamera)
        {
            console.log(canvasCamera.height,canvasCamera.width);
        }

        const bounds = canvasCamera.getBoundingClientRect();
        const mouseX = e.clientX - bounds.left;
        const mouseY = e.clientY - bounds.top;

        var x_scale = gZoneMaproomSizeH / canvasCamera.width;
        var y_scale = gZoneMaproomSizeV / canvasCamera.height;
        if (x_scale < 1) x_scale = 1;
        if (y_scale < 1) y_scale = 1;

        var canvasPosX = mouseX * x_scale - gZoneMapprimebarX;
        var canvasPosY = gZoneMaproomSizeV - (mouseY * y_scale);

        pointx.value = Math.round(canvasPosX);
        pointy.value = Math.round(canvasPosY);
        console.log('directionSelect-->',directionSelect.value);
        switch(parseInt(directionSelect.value,10))
        {
            case 0:
                anchorx.value = Math.round(parseInt(pointx.value,10));
                if((parseInt(pointy.value,10)+500)>gZoneMaproomSizeV)
                {
                    anchory.value = Math.round(parseInt(pointy.value,10) - 500);
                }
                else
                {
                    anchory.value = Math.round(parseInt(pointy.value,10) + 500);
                }
                break;
            case 1:
                anchory.value = Math.round(parseInt(pointy.value,10));
                if((parseInt(pointx.value,10)+500)>gZoneMaproomSizeH)
                {
                    anchorx.value = Math.round(parseInt(pointx.value,10) - 500);
                }
                else
                {
                    anchorx.value = Math.round(parseInt(pointx.value,10) + 500);
                }
                break;
            case 2:
                anchorx.value = Math.round(parseInt(pointx.value,10));
                if((parseInt(pointy.value,10)+500)>gZoneMaproomSizeV)
                {
                    anchory.value = Math.round(parseInt(pointy.value,10) - 500);
                }
                else
                {
                    anchory.value = Math.round(parseInt(pointy.value,10) + 500);
                }
                break;
            case 3:
                anchory.value = Math.round(parseInt(pointy.value,10));
                if((parseInt(pointx.value,10)+500)>gZoneMaproomSizeH)
                {
                    anchorx.value = Math.round(parseInt(pointx.value,10) - 500);
                }
                else
                {
                    anchorx.value = Math.round(parseInt(pointx.value,10) + 500);
                }
                break;
        }
        // anchorx.value
        // anchory.value
    
        requestAnimationFrame(updateCameraDirectionArrowHead);
        requestAnimationFrame(updateMoveCameraCanvas);

        //------rect mode-----
        // if (gisRectDrawing) {
        //     const currentX = e.offsetX;
        //     const currentY = e.offsetY;
    
        //     gcurrentRect.rect.width = Math.max(gminRectSize, Math.abs(currentX - gstartX));
        //     gcurrentRect.rect.height = Math.max(gminRectSize, Math.abs(currentY - gstartY));
    
        //     if (currentX < gstartX) {
        //         gcurrentRect.rect.x = gstartX - gcurrentRect.rect.width;
        //     }
        //     if (currentY < gstartY) {
        //         gcurrentRect.rect.y = gstartY - gcurrentRect.rect.height;
        //     }
    
    
        //     ensureRectWithinBounds(gcurrentRect.rect);
    
        //     ctx.fillStyle = 'rgb(130, 247, 211)';
        //     ctx.fillRect(gcurrentRect.rect.x, gcurrentRect.rect.y, gcurrentRect.rect.width, gcurrentRect.rect.height);
        
        //     ctx.strokeStyle = 'black';
        //     ctx.setLineDash([6]);
        //     ctx.strokeRect(gcurrentRect.rect.x, gcurrentRect.rect.y, gcurrentRect.rect.width, gcurrentRect.rect.height);
        //     ctx.setLineDash([]);
        // } else if (gselectedRect) {
    
        //     gselectedRect.rect.x = e.offsetX - gstartX;
        //     gselectedRect.rect.y = e.offsetY - gstartY;
    
        //     ensureRectWithinBounds(gselectedRect.rect);
    
    
        // }
        // clearCanvas();
        // drawRectangles();
        //------rect mode-----
    }

    function updateMoveCameraCanvas() {
        canvasupdatecameraXY();

        var pointXValue = parseInt(pointx.value, 10);
        var pointYValue = parseInt(pointy.value, 10);
        var x_scale = gZoneMaproomSizeH / canvasCamera.width;
        var y_scale = gZoneMaproomSizeV / canvasCamera.height;

        gClearFixedCameraIcon = 1;

        ctx1.clearRect(0, 0, canvasCamera.width, canvasCamera.height);
    
        if (x_scale < 1) x_scale = 1;
        if (y_scale < 1) y_scale = 1;

        var canvasPosX = (pointXValue + gZoneMapprimebarX) / x_scale;
        var canvasPosY = (gZoneMaproomSizeV - pointYValue) / y_scale;

        ctx1.drawImage(img, canvasPosX - (cameraimgSize / 2), canvasPosY - (cameraimgSize / 2), cameraimgSize, cameraimgSize);

    }

    function drawRectangles() {
        const minFontSize = 10;
        const maxFontSize = 18;
    
        grectangles.forEach((rectObj) => {
            const rect = rectObj.rect;
            ctx.fillStyle = 'rgb(130, 247, 211)';
            ctx.fillRect(rect.x, rect.y, rect.width, rect.height);
    
            ctx.strokeStyle = 'black';
            ctx.strokeRect(rect.x, rect.y, rect.width, rect.height);
    
            const fontSize = Math.max(minFontSize, Math.min(maxFontSize, Math.min(rect.width / 8, rect.height / 2)));
            ctx.font = `${fontSize}px Arial`;
    
            ctx.fillStyle = 'black';
            const text = `ZONE${rectObj.id}`;
            const textWidth = ctx.measureText(text).width;
            const textX = rect.x + (rect.width - textWidth) / 2;
            const textY = rect.y + (rect.height + fontSize / 2) / 2;
    
            ctx.fillText(text, textX, textY);
        });
    }

    function clearCanvas() {
        ctx.clearRect(0, 0, canvas.width, canvas.height);
    }

    function showContextMenu(x, y, rectIndex) {
        if (contextMenu) {
            contextMenu.remove();
        }
    
        contextMenu = document.createElement('div');
        contextMenu.style.position = 'absolute';
        contextMenu.style.left = `${x}px`;
        contextMenu.style.top = `${y}px`;
        contextMenu.style.backgroundColor = '#ffffff';
        contextMenu.style.border = '1px solid #ccc';
        contextMenu.style.zIndex = 1000;
        contextMenu.style.padding = '5px';
        contextMenu.style.boxShadow = '2px 2px 5px rgba(0, 0, 0, 0.2)';
    
        const deleteOption = document.createElement('div');
        deleteOption.innerText = 'Delete';
        deleteOption.style.cursor = 'pointer';
        deleteOption.onclick = function() {
            grectangles.splice(rectIndex, 1);
            clearCanvas();
            draw();
            contextMenu.remove();
        };
    
        const cancelOption = document.createElement('div');
        cancelOption.innerText = 'Cancel';
        cancelOption.style.cursor = 'pointer';
        cancelOption.onclick = function() {
            contextMenu.remove();
        };
    
        contextMenu.appendChild(deleteOption);
        contextMenu.appendChild(cancelOption);
        document.body.appendChild(contextMenu);
    }

    function ensureRectWithinBounds(rect) {
        if (rect.x < 0) {
            rect.x = 0;
        }
        if (rect.y < 0) {
            rect.y = 0;
        }
        if (rect.x + rect.width > canvasMouse.width) {
            rect.x = canvasMouse.width - rect.width;
        }
        if (rect.y + rect.height > canvasMouse.height) {
            rect.y = canvasMouse.height - rect.height;
        }
    }

    function adjustRectForOverlap(rect, gisRectDrawing) {
        const adjustment = 5;
        const rectMinSize = gminRectSize;
    
        let overlapDetected = false;
    
        grectangles.forEach(existingRectObj => {
            const existingRect = existingRectObj.rect;
            if (
                rect !== existingRect &&
                rect.x < existingRect.x + existingRect.width &&
                rect.x + rect.width > existingRect.x &&
                rect.y < existingRect.y + existingRect.height &&
                rect.y + rect.height > existingRect.y
            ) {
                overlapDetected = true;
    
                if (gisRectDrawing) {
                    if (rect.x < existingRect.x && rect.x + rect.width > existingRect.x) {
                        let newRight = existingRect.x - adjustment;
                        if (newRight - rect.x >= rectMinSize) {
                            rect.width = newRight - rect.x;
                        }
                    } else if (rect.x + rect.width > existingRect.x + existingRect.width && rect.x < existingRect.x + existingRect.width) {
                        let newLeft = existingRect.x + existingRect.width + adjustment;
                        if (rect.x + rect.width - newLeft >= rectMinSize) {
                            rect.x = newLeft;
                        }
                    }
    
                    if (rect.y < existingRect.y && rect.y + rect.height > existingRect.y) {
                        let newBottom = existingRect.y - adjustment;
                        if (newBottom - rect.y >= rectMinSize) {
                            rect.height = newBottom - rect.y;
                        }
                    } else if (rect.y + rect.height > existingRect.y + existingRect.height && rect.y < existingRect.y + existingRect.height) {
                        let newTop = existingRect.y + existingRect.height + adjustment;
                        if (rect.y + rect.height - newTop >= rectMinSize) {
                            rect.y = newTop;
                        }
                    }
                } else {
                    overlapDetected = true;
                }
            }
        });
    
        if (!gisRectDrawing && overlapDetected) {
            rect.x = ginitialRectPosition.x;
            rect.y = ginitialRectPosition.y;
        }
    }

    function getNextAvailableZoneId() {
        const usedIds = grectangles.map(rectObj => rectObj.id);
        for (let i = 1; i <= gmaxZones; i++) {
            if (!usedIds.includes(i)) {
                return i;
            }
        }
        return gmaxZones + 1;
    }
    
    function isPointInRect(x, y, rect) {
        return x > rect.x && x < rect.x + rect.width && y > rect.y && y < rect.y + rect.height;
    }
    
    function checkForOverlap(rect) {
        return grectangles.some(existingRectObj => {
            const existingRect = existingRectObj.rect;
            if (existingRect === rect) return false;
            return (
                rect.x < existingRect.x + existingRect.width &&
                rect.x + rect.width > existingRect.x &&
                rect.y < existingRect.y + existingRect.height &&
                rect.y + rect.height > existingRect.y
            );
        });
    }

    function redrawCanvas() {
        ctx.clearRect(0, 0, scaleWidth, scaleHeight);
        drawRectangles();
    }

}

function isPointInCorner(pointX, pointY, cornerX, cornerY, radius) {
    const dx = pointX - cornerX;
    const dy = pointY - cornerY;
    return dx * dx + dy * dy <= radius * radius;
}

function micActivateManualFocusControl() {
    $('#focusNearButton_'+gDeviceIndex).on('mousedown', function () {
        nearRunning = 1;
        micsendManualFocusCmd('near%2C0');
    }).on('mouseup', function (e) {
        e.stopPropagation();
        nearRunning = 0;
        micsendManualFocusCmd('stop%2Cfocus');
    });

    $('#focusFarButton_'+gDeviceIndex).on('mousedown', function () {
        farRunning = 1;
        micsendManualFocusCmd('far%2C0');
    }).on('mouseup', function (e) {
        e.stopPropagation();
        farRunning = 0;
        micsendManualFocusCmd('stop%2Cfocus');
    });
}

function onchangePanFlip(element) {

    var cameraIP = document.getElementById('CameraInformation_Camera_select_' + gDeviceIndex).value;
    var jsonmsg = {};
    jsonmsg.Command = "SetPanFlip";
    jsonmsg.IPAddress = cameraIP; 
    
    if(element.checked){
        console.log('PanFlip is checked');
        jsonmsg.IsFlip = true;
    }
    else{
        console.log('PanFlip is not checked');
        jsonmsg.IsFlip = false;
    }
    sendMessage("SetPanFlip",jsonmsg);

}

function updateOffsetAngleLineEditInput(element) {
    let value = parseInt(element.value, 10);
    if (value < -360) {
        value = -360;
    } else if (value > 360) {
        value = 360;
    }

    element.value = value;
    
    var cameraOffsetAngle = document.getElementById('CameraInformation_OffsetAngle_value_' + gDeviceIndex);
    if(cameraOffsetAngle)
    {
        cameraOffsetAngle.textContent = element.value;
    }

    var CameraInfoCheckbox = document.getElementById('CameraInformation_connectCheckboxInput_' + gDeviceIndex);
    if(CameraInfoCheckbox.checked)
    {
        updateCameraDirectionArrowHead();
    }

}

var gFirstGetCoordinateAngle = 0;

function updateCameraDirectionArrowHead() {
    const CameraInformationCheckbox = document.getElementById('CameraInformation_connectCheckboxInput_' + gDeviceIndex);
    const arrowheadCanvas = document.getElementById('xy-canvas_arrowheadpos_' + gDeviceIndex);
    const pointX = document.getElementById('CameraInformation_LocationXY_xvalue_input_' + gDeviceIndex);
    const pointY = document.getElementById('CameraInformation_LocationXY_yvalue_input_' + gDeviceIndex);
    const offsetAngle = document.getElementById('CameraInformation_OffsetAngle_input_' + gDeviceIndex);

    if(CameraInformationCheckbox)
    {
        if(!CameraInformationCheckbox.checked)
            return;
    }

    if (arrowheadCanvas) {
        const directionAngleMap = {
            0: 270,
            1: 0,  
            2: 90, 
            3: 180   
        };

        let Angleoffset = document.getElementById("CameraInformation_OffsetAngle_value_"+gDeviceIndex).textContent;
        Angleoffset = parseInt(Angleoffset,10);
        let cameraCoordinateAngle;
        
        if(gFirstGetCoordinateAngle)
        {
            cameraCoordinateAngle = (gcameraCoordinateAngle + directionAngleMap[gcameraDirection]) % 360;    
        }
        else
        {
            cameraCoordinateAngle = (directionAngleMap[gcameraDirection]) % 360;    
        }
        console.log('gcameraCoordinateAngle : ',gcameraCoordinateAngle,'directionAngleMap : ',directionAngleMap[gcameraDirection],'cameraCoordinateAngle : ',cameraCoordinateAngle,'Angleoffset : ',Angleoffset);

        const rect = arrowheadCanvas.getBoundingClientRect();
        if (arrowheadCanvas.width !== rect.width || arrowheadCanvas.height !== rect.height) {
            arrowheadCanvas.width = rect.width;
            arrowheadCanvas.height = rect.height;
        }

        const ctx = arrowheadCanvas.getContext('2d');
        ctx.clearRect(0, 0, arrowheadCanvas.width, arrowheadCanvas.height);

        const xScale = Math.max(gZoneMaproomSizeH / arrowheadCanvas.width, 1);
        const yScale = Math.max(gZoneMaproomSizeV / arrowheadCanvas.height, 1);

        const displayCameraX = parseInt(pointX.value, 10);
        const displayCameraY = parseInt(pointY.value, 10);

        const graphicX = (displayCameraX + gZoneMapprimebarX) / xScale;
        const graphicY = (gZoneMaproomSizeV - displayCameraY) / yScale;

        const midPoint = { x: graphicX, y: graphicY };
        const lineLength = Math.min(arrowheadCanvas.height, arrowheadCanvas.width) / 10;

        const fixedRadians = directionAngleMap[gcameraDirection] * (Math.PI / 180);
        const fixedEndX = midPoint.x + lineLength * Math.cos(fixedRadians);
        const fixedEndY = midPoint.y + lineLength * Math.sin(fixedRadians);

        ctx.strokeStyle = '#4BBDEF';
        ctx.lineWidth = 2;

        ctx.setLineDash([5, 5]);
        ctx.beginPath();
        ctx.moveTo(midPoint.x, midPoint.y);
        ctx.lineTo(fixedEndX, fixedEndY);
        ctx.stroke();

        const angleRad = cameraCoordinateAngle * Math.PI / 180;
        const startPoint = {
            x: midPoint.x + lineLength * Math.cos(angleRad),
            y: midPoint.y + lineLength * Math.sin(angleRad)
        };

        ctx.setLineDash([]);
        ctx.beginPath();
        ctx.moveTo(startPoint.x, startPoint.y);
        ctx.lineTo(midPoint.x, midPoint.y);
        ctx.stroke();

        const arrowSize = 10;
        const arrowAngle = Math.PI / 6;
        const arrowP1 = {
            x: startPoint.x - Math.cos(angleRad + arrowAngle) * arrowSize,
            y: startPoint.y - Math.sin(angleRad + arrowAngle) * arrowSize
        };
        const arrowP2 = {
            x: startPoint.x - Math.cos(angleRad - arrowAngle) * arrowSize,
            y: startPoint.y - Math.sin(angleRad - arrowAngle) * arrowSize
        };

        ctx.beginPath();
        ctx.lineWidth = 2;
        ctx.moveTo(startPoint.x, startPoint.y);
        ctx.lineTo(arrowP1.x, arrowP1.y);
        ctx.moveTo(startPoint.x, startPoint.y);
        ctx.lineTo(arrowP2.x, arrowP2.y);
        ctx.stroke();

        const extendedRadius = 30;
        const startAngle = directionAngleMap[gcameraDirection] * Math.PI / 180;
        let spanAngle = 0;

        if (gcameraDirection == 0) {
            spanAngle = gcameraCoordinateAngle;
            if (gcameraCoordinateAngle > 180) {
                spanAngle = (gcameraCoordinateAngle - 360);
            }
            if (gcameraCoordinateAngle < -180) {
                spanAngle = (gcameraCoordinateAngle + 360);
            }
        } else if (gcameraDirection == 2) {
            spanAngle = gcameraCoordinateAngle;
            if (gcameraCoordinateAngle > 180) {
                spanAngle = (gcameraCoordinateAngle - 360);
            }
            if (gcameraCoordinateAngle < -180) {
                spanAngle = (gcameraCoordinateAngle + 360);
            }
        } else if (gcameraDirection == 1) {
            spanAngle = gcameraCoordinateAngle;
            if (gcameraCoordinateAngle > 180) {
                spanAngle = -(gcameraCoordinateAngle - 360);
            }
            if (gcameraCoordinateAngle < -180) {
                spanAngle = -(gcameraCoordinateAngle + 360);
            }
        } else if (gcameraDirection == 3) {
            spanAngle = gcameraCoordinateAngle;
            if (gcameraCoordinateAngle > 180) {
                spanAngle = -(gcameraCoordinateAngle - 360);
            }
            if (gcameraCoordinateAngle < -180) {
                spanAngle = -(gcameraCoordinateAngle + 360);
            }
        }

        const endAngle = startAngle + (spanAngle * Math.PI / 180);
        
        // console.log(`gcameraDirection: ${gcameraDirection}`);
        // console.log(`startAngle (radians): ${startAngle}`);
        // console.log(`spanAngle (degrees): ${spanAngle}`);
        // console.log(`spanAngle (radians): ${spanAngle * Math.PI / 180}`);
        // console.log(`endAngle (radians): ${endAngle}`);
        if(gFirstGetCoordinateAngle)
        {
            ctx.lineWidth = 3;
            ctx.setLineDash([1, 2]);
            ctx.beginPath();
            ctx.arc(midPoint.x, midPoint.y, extendedRadius, endAngle,startAngle, spanAngle > 0);
            ctx.stroke();
        }
    }
}

function XYMdoeCameraDirectionSelectOnChange(element){

    var cameraDirection = document.getElementById('CameraInformation_Direction_select_' + gDeviceIndex);

    if(cameraDirection)
    {
        gcameraDirection = cameraDirection.value;
        var deviceType = document.getElementById('deviceTypeSel_' + gDeviceIndex).value;
        // if(deviceType != 11)
        // {
            
        // }
        updateCameraDirectionArrowHead();
        updateCameraInfoCameraApply();
    }

}

let gZoneModeInitDRP = 1;
let gQuadrilaterals = [];
let gLastQuadrilaterals = [];
let gDraggingQuadrilateral = null;
let gDraggingCornerIndex = -1;
let gLastSelectedQuad = null;


function onMicZoneMode(e){
    gZoneModeIsOpen = true;
    gZoneModeInitDRP = window.devicePixelRatio || 1;
    createMicZoneModePopup(gDeviceIndex);
    ZoneModeInitialize(gDeviceIndex);

    var jsonmsg = {};
    jsonmsg.Command = "GetZoneModeConfig";
    jsonmsg.SoundTabIndex = gDeviceIndex;
    sendMessage("GetZoneModeConfig", jsonmsg);

    lastZoneModeConfig = null;

    var backgroundWindow = document.getElementById('background_zonemode_block_Window');
    backgroundWindow.style.display = 'block';

    var backgroundmodelNameLabel = document.getElementById('modelNameLabel');
    backgroundmodelNameLabel.style.display = 'none';
    var backgroundpowerBtn = document.getElementById('powerBtn');
    backgroundpowerBtn.style.display = 'none';
    var backgroundlogoutBtn = document.getElementById('logoutBtn');
    backgroundlogoutBtn.style.display = 'none';
    var backgroundLabelProfile = document.getElementById('Label_Profile');
    backgroundLabelProfile.style.display = 'none';
    var backgroundSelectProfile = document.getElementById('Select_Profile');
    backgroundSelectProfile.style.display = 'none';
    var backgrounDirectorProfile = document.getElementById('DirectorBtn');
    if(backgrounDirectorProfile)
        backgrounDirectorProfile.style.display = 'none';

}

function createMicZoneModePopup(index){
    
    var devicesel = document.getElementById("deviceTypeSel_"+gDeviceIndex);
    let deviceTypeString = transferDeviceTypeToString(devicesel.value); 

    var popupWindow = document.getElementById('mic_zonemode_popup_Window_'+index);
    popupWindow.innerHTML = '';
    popupWindow.style.userSelect = 'none';
    popupWindow.style.WebkitUserDrag = 'none'; 
    popupWindow.draggable = false;
        var titleBar = document.createElement('tr');            
        var titleBarRow = document.createElement("td");
        titleBarRow.className = 'MicZonetitleBarRow';
        titleBarRow.style.userSelect = 'none';
        titleBarRow.style.WebkitUserDrag = 'none'; 
        titleBarRow.draggable = false;

            var cell1 = document.createElement("td");
            cell1.className = "title-bar-cell micZoneModelogo-cell";
                var logoImage = document.createElement('img');
                    logoImage.id = 'logo_image';
                    logoImage.className = 'micZoneMode-popup-Window-logo-Image';
                    logoImage.src = '../imagesaibox/CamConnect.png';
                    logoImage.style.userSelect = 'none';
                    logoImage.style.WebkitUserDrag = 'none'; 
                    logoImage.draggable = false;
            cell1.appendChild(logoImage);

            var cell2 = document.createElement("td");
            cell2.className = "title-bar-cell title-cell";
                var mic_xy_title = document.createElement('label');
                mic_xy_title.className = 'Font_Arial_18_bold mic-xy-title';
                mic_xy_title.textContent = window.LanguageManager.getTranslatedText("Zone_Mode");
                mic_xy_title.style.userSelect = 'none'; 
                mic_xy_title.style.WebkitUserDrag = 'none';
                mic_xy_title.draggable = false;
            cell2.appendChild(mic_xy_title);

            var cell3 = document.createElement("td");
            cell3.className = "title-bar-cell close-button-cell";
                var closeButton = document.createElement('button');
                closeButton.id = 'close_mic_Popup_'+index;
                closeButton.className = 'close-popup-btn';
                closeButton.setAttribute("onclick", "closeZoneModeWindow(this)");
                closeButton.style.userSelect = 'none';
                closeButton.style.WebkitUserDrag = 'none'; 
                closeButton.draggable = false;
            cell3.appendChild(closeButton);

        titleBarRow.appendChild(cell1);
        titleBarRow.appendChild(cell2);
        titleBarRow.appendChild(cell3);

    titleBar.appendChild(titleBarRow);

    var RoomSizeSections_tr = document.createElement('tr');
    RoomSizeSections_tr.style.userSelect = 'none';
    RoomSizeSections_tr.style.WebkitUserDrag = 'none'; 
    RoomSizeSections_tr.draggable = false;
        var RoomSizeSections_td = document.createElement('td');
        RoomSizeSections_td.className = "MicZoneRoomSizeSections_td";
        RoomSizeSections_td.style.userSelect = 'none';
        RoomSizeSections_td.style.WebkitUserDrag = 'none'; 
        RoomSizeSections_td.draggable = false;
            var Room_Size_label = document.createElement('label');
            Room_Size_label.id = 'Room_Size_label';
            Room_Size_label.className = 'Room_Size_label  Font_Arial_16_bold';
            Room_Size_label.textContent = "Room Size: ";
            Room_Size_label.style.userSelect = 'none';
            Room_Size_label.style.WebkitUserDrag = 'none'; 
            Room_Size_label.draggable = false;

            var Room_Size_value = document.createElement('label');
            Room_Size_value.id = 'Room_Size_value'+ index;
                var Room_Size_H_value = document.createElement('label');
                Room_Size_H_value.id = 'Room_Size_H_value_' + index;
                Room_Size_H_value.className = 'Room_Size_value Font_Arial_16_bold';
                Room_Size_H_value.textContent = "10";
                Room_Size_H_value.style.userSelect = 'none';
                Room_Size_H_value.style.WebkitUserDrag = 'none'; 
                Room_Size_H_value.draggable = false;

                var Room_Size_H_value_label = document.createElement('label');
                Room_Size_H_value_label.className = 'Room_Size_value Font_Arial_16_bold';
                Room_Size_H_value_label.textContent = "(H)";
                Room_Size_H_value_label.style.userSelect = 'none';
                Room_Size_H_value_label.style.WebkitUserDrag = 'none'; 
                Room_Size_H_value_label.draggable = false;

                var Room_Size_HV_value_center_label = document.createElement('label');
                Room_Size_HV_value_center_label.className = 'Room_Size_value Font_Arial_16_bold';
                Room_Size_HV_value_center_label.textContent = ",";
                Room_Size_HV_value_center_label.style.userSelect = 'none';
                Room_Size_HV_value_center_label.style.WebkitUserDrag = 'none'; 
                Room_Size_HV_value_center_label.draggable = false;

                var Room_Size_V_value = document.createElement('label');
                Room_Size_V_value.id = 'Room_Size_V_value_' + index;
                Room_Size_V_value.className = 'Room_Size_value Font_Arial_16_bold';
                Room_Size_V_value.textContent = "10";
                Room_Size_V_value.style.userSelect = 'none';
                Room_Size_V_value.style.WebkitUserDrag = 'none'; 
                Room_Size_V_value.draggable = false;

                var Room_Size_V_value_label = document.createElement('label');
                Room_Size_V_value_label.className = 'Room_Size_value Font_Arial_16_bold';
                Room_Size_V_value_label.textContent = "(V)";
                Room_Size_V_value_label.style.userSelect = 'none';
                Room_Size_V_value_label.style.WebkitUserDrag = 'none'; 
                Room_Size_V_value_label.draggable = false;

            Room_Size_value.appendChild(Room_Size_H_value);
            Room_Size_value.appendChild(Room_Size_H_value_label);
            Room_Size_value.appendChild(Room_Size_HV_value_center_label);
            Room_Size_value.appendChild(Room_Size_V_value);
            Room_Size_value.appendChild(Room_Size_V_value_label);

            var Room_Size_button = document.createElement('button');
            Room_Size_button.id          = "Refresh_Layout_button_" + index;
            Room_Size_button.className   = "Refresh_Layout_button Refresh_Layout_button_style";
            Room_Size_button.setAttribute("onclick", "updateRefreshZoneMapLayout(this)");
            Room_Size_button.innerText = "Refresh Layout";
            Room_Size_button.type = "button";
            Room_Size_button.style.userSelect = 'none';
            Room_Size_button.style.WebkitUserDrag = 'none'; 
            Room_Size_button.draggable = false;
            
        RoomSizeSections_td.appendChild(Room_Size_label);
        RoomSizeSections_td.appendChild(Room_Size_value);
        RoomSizeSections_td.appendChild(Room_Size_button);

    RoomSizeSections_tr.appendChild(RoomSizeSections_td);


    var InfoSections_canvasContainer_td = document.createElement('td');
    InfoSections_canvasContainer_td.id = 'InfoSections_canvasContainer_td_' + index;
    InfoSections_canvasContainer_td.className = 'ZoneModeInfoSections_canvasContainer_td';
    InfoSections_canvasContainer_td.style.userSelect = 'none';
    InfoSections_canvasContainer_td.style.WebkitUserDrag = 'none'; 
    InfoSections_canvasContainer_td.draggable = false;

        var InfoSections = document.createElement('td');
        InfoSections.className = 'ZoneModeInfoSections';
        InfoSections.style.userSelect = 'none';
        InfoSections.style.WebkitUserDrag = 'none'; 
        InfoSections.draggable = false;
            //------------------
            var ZoneModeVoiceSourceSection = document.createElement('tr');
            ZoneModeVoiceSourceSection.id =  'ZoneModeVoiceSourceSection_' + index;
            ZoneModeVoiceSourceSection.className = 'ZoneModeVoiceSourceSection';
            ZoneModeVoiceSourceSection.style.userSelect = 'none';
            ZoneModeVoiceSourceSection.style.WebkitUserDrag = 'none'; 
            ZoneModeVoiceSourceSection.draggable = false;

                var ZoneModeArrayMicrophoneTitle_td = document.createElement('td');
                ZoneModeArrayMicrophoneTitle_td.id = 'ZoneModeArrayMicrophoneTitle_td';
                ZoneModeArrayMicrophoneTitle_td.className = 'ArrayMicrophonemicTitle_td';
                    var ArrayMicrophonemicTitle = document.createElement('label');
                    ArrayMicrophonemicTitle.id          = "ArrayMicrophonemicTitle_" + index;
                    ArrayMicrophonemicTitle.className = 'ArrayMicrophonemicTitle Font_Arial_16_bold';
                    ArrayMicrophonemicTitle.textContent = window.LanguageManager.getTranslatedText("Array_Microphone");
                    ArrayMicrophonemicTitle.style.userSelect = 'none';
                    ArrayMicrophonemicTitle.style.WebkitUserDrag = 'none'; 
                    ArrayMicrophonemicTitle.draggable = false;
                ZoneModeArrayMicrophoneTitle_td.appendChild(ArrayMicrophonemicTitle);


                var ZoneModeArrayMicrophone_Microphone_td = document.createElement('td');
                ZoneModeArrayMicrophone_Microphone_td.id          = "ZoneModeArrayMicrophone_Microphone_td_" + index;
                ZoneModeArrayMicrophone_Microphone_td.className    = "ArrayMicrophone_Microphone_td";

                    var ZoneModeArrayMicrophone_Microphone_label = document.createElement('label');
                    ZoneModeArrayMicrophone_Microphone_label.id          = "ZoneModeArrayMicrophone_Microphone_label_" + index;
                    ZoneModeArrayMicrophone_Microphone_label.className   = "ZoneModeArrayMicrophone_Microphone_label  Font_Arial_14_bold";
                    ZoneModeArrayMicrophone_Microphone_label.textContent =  window.LanguageManager.getTranslatedText("Microphone") + " :";
                    ZoneModeArrayMicrophone_Microphone_label.style.textAlign = 'right';
                    ZoneModeArrayMicrophone_Microphone_label.style.userSelect = 'none';
                    ZoneModeArrayMicrophone_Microphone_label.style.WebkitUserDrag = 'none'; 
                    ZoneModeArrayMicrophone_Microphone_label.draggable = false;
                    
                    var ZoneModeArrayMicrophone_Microphone_value = document.createElement('label');
                    ZoneModeArrayMicrophone_Microphone_value.id          = "ZoneModeArrayMicrophone_Microphone_value_" + index;
                    ZoneModeArrayMicrophone_Microphone_value.className   = "ZoneModeArrayMicrophone_Microphone_value  Font_Arial_14_bold";
                    ZoneModeArrayMicrophone_Microphone_value.textContent = deviceTypeString;//"Yamaha:RM-CG(Coordinate)";
                    ZoneModeArrayMicrophone_Microphone_value.style.textAlign = 'right';
                    ZoneModeArrayMicrophone_Microphone_value.style.userSelect = 'none';
                    ZoneModeArrayMicrophone_Microphone_value.style.WebkitUserDrag = 'none'; 
                    ZoneModeArrayMicrophone_Microphone_value.draggable = false;

                ZoneModeArrayMicrophone_Microphone_td.appendChild(ZoneModeArrayMicrophone_Microphone_label);
                
                if(deviceTypeString !== 'Audio-Technica:ATND1061(Coordinate)'
                && deviceTypeString !== 'Shure:MXA920(Coordinate)'
                && deviceTypeString !== 'Sennheiser:TCC2(Coordinate)'
                && deviceTypeString !== 'Sennheiser:TCCM(Coordinate)')
                {
                    ZoneModeArrayMicrophone_Microphone_td.appendChild(ZoneModeArrayMicrophone_Microphone_value);
                }

                var ZoneModeArrayMicrophone_Microphone_ForLongName_td = document.createElement('td');
                ZoneModeArrayMicrophone_Microphone_ForLongName_td.id          = "ZoneModeArrayMicrophone_Microphone_ForLongName_td_" + index;
                ZoneModeArrayMicrophone_Microphone_ForLongName_td.className    = "ArrayMicrophone_Microphone_td";
                ZoneModeArrayMicrophone_Microphone_ForLongName_td.style.userSelect = 'none';
                ZoneModeArrayMicrophone_Microphone_ForLongName_td.style.WebkitUserDrag = 'none'; 
                ZoneModeArrayMicrophone_Microphone_ForLongName_td.draggable = false;

                if(deviceTypeString === 'Audio-Technica:ATND1061(Coordinate)'
                || deviceTypeString === 'Shure:MXA920(Coordinate)'
                || deviceTypeString === 'Sennheiser:TCC2(Coordinate)'
                || deviceTypeString === 'Sennheiser:TCCM(Coordinate)')
                {
                    if(deviceTypeString === 'Audio-Technica:ATND1061(Coordinate)')
                    {
                        ZoneModeArrayMicrophone_Microphone_value.style.width = '320px';
                    }
                    else
                    {
                        ZoneModeArrayMicrophone_Microphone_value.style.width = '280px';
                    }
                    ZoneModeArrayMicrophone_Microphone_value.style.textAlign = 'right';

                    ZoneModeArrayMicrophone_Microphone_ForLongName_td.appendChild(ZoneModeArrayMicrophone_Microphone_value);
                }
                
                var ZoneModeVoiceSourceDetect_XY_td = document.createElement('td');
                ZoneModeVoiceSourceDetect_XY_td.id          = "ZoneModeVoiceSourceDetect_XY_td_" + index;
                ZoneModeVoiceSourceDetect_XY_td.className   = "VoiceSourceDetect_XY_td";
                ZoneModeVoiceSourceDetect_XY_td.style.textAlign = 'right';
                ZoneModeVoiceSourceDetect_XY_td.style.userSelect = 'none';
                ZoneModeVoiceSourceDetect_XY_td.style.WebkitUserDrag = 'none'; 
                ZoneModeVoiceSourceDetect_XY_td.draggable = false;

                    var ZoneModeVoiceSourceDetect_XY_label = document.createElement('label');
                    ZoneModeVoiceSourceDetect_XY_label.id          = "ZoneModeVoiceSourceDetect_XY_label_" + index;
                    ZoneModeVoiceSourceDetect_XY_label.className   = "ZoneModeVoiceSourceDetect_XY_label Font_Arial_14_bold";
                    ZoneModeVoiceSourceDetect_XY_label.textContent = "Pos. (x,y) : ";
                    ZoneModeVoiceSourceDetect_XY_label.style.userSelect = 'none';
                    ZoneModeVoiceSourceDetect_XY_label.style.WebkitUserDrag = 'none'; 
                    ZoneModeVoiceSourceDetect_XY_label.draggable = false;

                    var ZoneModeVoiceSourceDetect_XY_value_td = document.createElement('td');
                    ZoneModeVoiceSourceDetect_XY_value_td.className = 'ZoneModeVoiceSourceDetect_XY_value_td';

                        var ZoneModeVoiceSourceDetect_XY_value_left = document.createElement('label');
                        ZoneModeVoiceSourceDetect_XY_value_left.id          = "VoiceSourceDetect_XY_value_left_" + index;
                        ZoneModeVoiceSourceDetect_XY_value_left.className   = "VoiceSourceDetect_XY_value_left Font_Arial_14_bold";
                        ZoneModeVoiceSourceDetect_XY_value_left.textContent = "(";
                        ZoneModeVoiceSourceDetect_XY_value_left.style.userSelect = 'none';
                        ZoneModeVoiceSourceDetect_XY_value_left.style.WebkitUserDrag = 'none'; 
                        ZoneModeVoiceSourceDetect_XY_value_left.draggable = false;

                        var ZoneModeVoiceSourceDetect_XY_value_X = document.createElement('label');
                        ZoneModeVoiceSourceDetect_XY_value_X.id          = "ZoneModeArrayMicrophone_XY_value_X_" + index;
                        ZoneModeVoiceSourceDetect_XY_value_X.className   = "VoiceSourceDetect_XY_value_X Font_Arial_14_bold";
                        ZoneModeVoiceSourceDetect_XY_value_X.textContent = "0";
                        ZoneModeVoiceSourceDetect_XY_value_X.style.textAlign = "center";
                        ZoneModeVoiceSourceDetect_XY_value_X.style.userSelect = 'none';
                        ZoneModeVoiceSourceDetect_XY_value_X.style.WebkitUserDrag = 'none'; 
                        ZoneModeVoiceSourceDetect_XY_value_X.draggable = false;

                        var ZoneModeVoiceSourceDetect_XY_value_center = document.createElement('label');
                        ZoneModeVoiceSourceDetect_XY_value_center.id          = "ZoneModeVoiceSourceDetect_XY_value_center_" + index;
                        ZoneModeVoiceSourceDetect_XY_value_center.className   = "VoiceSourceDetect_XY_value_center Font_Arial_14_bold";
                        ZoneModeVoiceSourceDetect_XY_value_center.textContent = ",";
                        ZoneModeVoiceSourceDetect_XY_value_center.style.userSelect = 'none';
                        ZoneModeVoiceSourceDetect_XY_value_center.style.WebkitUserDrag = 'none'; 
                        ZoneModeVoiceSourceDetect_XY_value_center.draggable = false;

                        var ZoneModeVoiceSourceDetect_XY_value_Y = document.createElement('label');
                        ZoneModeVoiceSourceDetect_XY_value_Y.id          = "ZoneModeArrayMicrophone_XY_value_Y_" + index;
                        ZoneModeVoiceSourceDetect_XY_value_Y.className   = "VoiceSourceDetect_XY_value_Y Font_Arial_14_bold";
                        ZoneModeVoiceSourceDetect_XY_value_Y.textContent = "0";
                        ZoneModeVoiceSourceDetect_XY_value_Y.style.textAlign = "center";
                        ZoneModeVoiceSourceDetect_XY_value_Y.style.userSelect = 'none';
                        ZoneModeVoiceSourceDetect_XY_value_Y.style.WebkitUserDrag = 'none'; 
                        ZoneModeVoiceSourceDetect_XY_value_Y.draggable = false;

                        var ZoneModeVoiceSourceDetect_XY_value_right = document.createElement('label');
                        ZoneModeVoiceSourceDetect_XY_value_right.id          = "ZoneModeVoiceSourceDetect_XY_value_right_" + index;
                        ZoneModeVoiceSourceDetect_XY_value_right.className   = "VoiceSourceDetect_XY_value_right Font_Arial_14_bold";
                        ZoneModeVoiceSourceDetect_XY_value_right.textContent = ')';
                        ZoneModeVoiceSourceDetect_XY_value_right.style.userSelect = 'none';
                        ZoneModeVoiceSourceDetect_XY_value_right.style.WebkitUserDrag = 'none'; 
                        ZoneModeVoiceSourceDetect_XY_value_right.draggable = false;

                    ZoneModeVoiceSourceDetect_XY_value_td.appendChild(ZoneModeVoiceSourceDetect_XY_value_left);
                    ZoneModeVoiceSourceDetect_XY_value_td.appendChild(ZoneModeVoiceSourceDetect_XY_value_X);
                    ZoneModeVoiceSourceDetect_XY_value_td.appendChild(ZoneModeVoiceSourceDetect_XY_value_center);
                    ZoneModeVoiceSourceDetect_XY_value_td.appendChild(ZoneModeVoiceSourceDetect_XY_value_Y);
                    ZoneModeVoiceSourceDetect_XY_value_td.appendChild(ZoneModeVoiceSourceDetect_XY_value_right);
                    
                    
                //ZoneModeVoiceSourceDetect_XY_td.appendChild(ZoneModeVoiceSourceDetect_XY_label);
                //ZoneModeVoiceSourceDetect_XY_td.appendChild(ZoneModeVoiceSourceDetect_XY_value_td);
                
            ZoneModeVoiceSourceSection.appendChild(ZoneModeArrayMicrophoneTitle_td);
            ZoneModeVoiceSourceSection.appendChild(ZoneModeArrayMicrophone_Microphone_td);
            ZoneModeVoiceSourceSection.appendChild(ZoneModeArrayMicrophone_Microphone_ForLongName_td);
            ZoneModeVoiceSourceSection.appendChild(ZoneModeVoiceSourceDetect_XY_td);  
            //------------------            
            var ZoneModeAddSection = document.createElement('tr');
            ZoneModeAddSection.id =  'ZoneModeAddSection_' + index;
            ZoneModeAddSection.className = 'ZoneModeAddSection';
            ZoneModeAddSection.style.userSelect = 'none';
            ZoneModeAddSection.style.WebkitUserDrag = 'none'; 
            ZoneModeAddSection.draggable = false;

                var ZoneModeAddTitle_td = document.createElement('td');
                ZoneModeAddTitle_td.id = 'ZoneModeAddTitle_td';
                ZoneModeAddTitle_td.className = 'ArrayMicrophonemicTitle_td';
                    var ZoneModeAddTitle = document.createElement('label');
                    ZoneModeAddTitle.id          = "ZoneModeAddTitle_" + index;
                    ZoneModeAddTitle.className = 'ArrayMicrophonemicTitle Font_Arial_16_bold';
                    ZoneModeAddTitle.textContent = window.LanguageManager.getTranslatedText("Mic_Zone");
                    ZoneModeAddTitle.style.userSelect = 'none';
                    ZoneModeAddTitle.style.WebkitUserDrag = 'none'; 
                    ZoneModeAddTitle.draggable = false;
                ZoneModeAddTitle_td.appendChild(ZoneModeAddTitle);
                
                var ZoneModeEdit_td = document.createElement('td');
                ZoneModeEdit_td.id = 'ZoneModeEdit_td';
                ZoneModeEdit_td.className = "ZoneModeEdit_td";

                    var ZoneModeEditButton_label = document.createElement('label');
                    ZoneModeEditButton_label.id          = "ZoneModeEditButton_label_" + index;
                    ZoneModeEditButton_label.className   = "ZoneModeEditButton_label Font_Arial_14_bold";
                    ZoneModeEditButton_label.textContent =  window.LanguageManager.getTranslatedText("Operation") + " :";
                    ZoneModeEditButton_label.style.textAlign = 'center';
                    ZoneModeEditButton_label.style.userSelect = 'none';
                    ZoneModeEditButton_label.style.WebkitUserDrag = 'none'; 
                    ZoneModeEditButton_label.draggable = false;


                    var ZoneModeClearButton = document.createElement('button');
                    ZoneModeClearButton.id = 'ZoneModeClearButton_' + index;
                    ZoneModeClearButton.className = 'ZoneModeClearButton ZoneModeClearButton_style';
                    ZoneModeClearButton.innerText = window.LanguageManager.getTranslatedText("Clear_All");
                    ZoneModeClearButton.setAttribute("onclick", "updateZoneModeClearAllButton(this)");
                    ZoneModeClearButton.type = "button";
                    ZoneModeClearButton.style.userSelect = 'none';
                    ZoneModeClearButton.style.WebkitUserDrag = 'none'; 
                    ZoneModeClearButton.draggable = false;

                    var ZoneModeApplyButton = document.createElement('button');
                    ZoneModeApplyButton.id = 'ZoneModeApplyButton_' + index;
                    ZoneModeApplyButton.className = 'ZoneModeApplyButton ZoneModeApplyButton_style';
                    ZoneModeApplyButton.innerText = window.LanguageManager.getTranslatedText("Apply");
                    ZoneModeApplyButton.setAttribute("onclick", "updateZoneModeApply(this)");
                    ZoneModeApplyButton.type = "button";
                    ZoneModeApplyButton.style.userSelect = 'none';
                    ZoneModeApplyButton.style.WebkitUserDrag = 'none'; 
                    ZoneModeApplyButton.draggable = false;

                    var Room_Pos_td = document.createElement('td');
                    Room_Pos_td.id          = "ArrayMicrophone_Microphone_td_" + index;
                    Room_Pos_td.className   = "ArrayMicrophone_Microphone_td";
                    Room_Pos_td.style.userSelect = 'none';
                    Room_Pos_td.style.WebkitUserDrag = 'none'; 
                    Room_Pos_td.draggable = false;

                        var Room_Pos_label = document.createElement('label');
                        Room_Pos_label.id          = "Room_Pos_label_" + index;
                        Room_Pos_label.style.width  = "120px";
                        Room_Pos_label.style.textAlign = 'right';
                        Room_Pos_label.className   = "Font_Arial_14_bold";
                        Room_Pos_label.textContent = window.LanguageManager.getTranslatedText("Pos")+" (x,y) : ";
                        Room_Pos_label.style.userSelect = 'none';
                        Room_Pos_label.style.WebkitUserDrag = 'none'; 
                        Room_Pos_label.draggable = false;

                        var Room_Pos_XY_value_td = document.createElement('td');
                        Room_Pos_XY_value_td.className = 'VoiceSourceDetect_XY_label_td';
                        Room_Pos_XY_value_td.style.userSelect = 'none';
                        Room_Pos_XY_value_td.style.WebkitUserDrag = 'none'; 
                        Room_Pos_XY_value_td.draggable = false;

                            var Room_Pos_XY_value_left = document.createElement('label');
                            Room_Pos_XY_value_left.id          = "VoiceSourceDetect_XY_value_left_" + index;
                            Room_Pos_XY_value_left.className   = "VoiceSourceDetect_XY_value_left Font_Arial_14_bold";
                            Room_Pos_XY_value_left.textContent = "(";
                            Room_Pos_XY_value_left.style.userSelect = 'none';
                            Room_Pos_XY_value_left.style.WebkitUserDrag = 'none'; 
                            Room_Pos_XY_value_left.draggable = false;

                            var Room_Pos_XY_value_X = document.createElement('label');
                            Room_Pos_XY_value_X.id          = "ZoneModeRoom_Pos_XY_value_X_" + index;
                            Room_Pos_XY_value_X.className   = "VoiceSourceDetect_XY_value_X Font_Arial_14_bold";
                            Room_Pos_XY_value_X.textContent = "0";
                            Room_Pos_XY_value_X.style.textAlign = "center";
                            Room_Pos_XY_value_X.style.userSelect = 'none';
                            Room_Pos_XY_value_X.style.WebkitUserDrag = 'none'; 
                            Room_Pos_XY_value_X.draggable = false;

                            var Room_Pos_XY_value_center = document.createElement('label');
                            Room_Pos_XY_value_center.id          = "VoiceSourceDetect_XY_value_center_" + index;
                            Room_Pos_XY_value_center.className   = "VoiceSourceDetect_XY_value_center Font_Arial_14_bold";
                            Room_Pos_XY_value_center.textContent = ",";
                            Room_Pos_XY_value_center.style.userSelect = 'none';
                            Room_Pos_XY_value_center.style.WebkitUserDrag = 'none'; 
                            Room_Pos_XY_value_center.draggable = false;

                            var Room_Pos_XY_value_Y = document.createElement('label');
                            Room_Pos_XY_value_Y.id          = "ZoneModeRoom_Pos_XY_value_Y_" + index;
                            Room_Pos_XY_value_Y.className   = "VoiceSourceDetect_XY_value_Y Font_Arial_14_bold";
                            Room_Pos_XY_value_Y.textContent = "0";
                            Room_Pos_XY_value_Y.style.textAlign = "center";
                            Room_Pos_XY_value_Y.style.userSelect = 'none';
                            Room_Pos_XY_value_Y.style.WebkitUserDrag = 'none'; 
                            Room_Pos_XY_value_Y.draggable = false;

                            var Room_Pos_XY_value_right = document.createElement('label');
                            Room_Pos_XY_value_right.id          = "VoiceSourceDetect_XY_value_right_" + index;
                            Room_Pos_XY_value_right.className   = "VoiceSourceDetect_XY_value_right Font_Arial_14_bold";
                            Room_Pos_XY_value_right.textContent = ')';
                            Room_Pos_XY_value_right.style.userSelect = 'none';
                            Room_Pos_XY_value_right.style.WebkitUserDrag = 'none'; 
                            Room_Pos_XY_value_right.draggable = false;

                        Room_Pos_XY_value_td.appendChild(Room_Pos_XY_value_left);
                        Room_Pos_XY_value_td.appendChild(Room_Pos_XY_value_X);
                        Room_Pos_XY_value_td.appendChild(Room_Pos_XY_value_center);
                        Room_Pos_XY_value_td.appendChild(Room_Pos_XY_value_Y);
                        Room_Pos_XY_value_td.appendChild(Room_Pos_XY_value_right);
                        
                    Room_Pos_td.appendChild(Room_Pos_label);
                    Room_Pos_td.appendChild(Room_Pos_XY_value_td);
  
                ZoneModeEdit_td.appendChild(ZoneModeEditButton_label);
                ZoneModeEdit_td.appendChild(ZoneModeClearButton);
                ZoneModeEdit_td.appendChild(ZoneModeApplyButton);
                
            ZoneModeAddSection.appendChild(ZoneModeAddTitle_td);
            ZoneModeAddSection.appendChild(ZoneModeEdit_td);
            ZoneModeAddSection.appendChild(Room_Pos_td);
            //------------------

            var ZoneModeInfoSection = document.createElement('tr');
            ZoneModeInfoSection.id =  'ZoneModeInfoSection_' + index;
            ZoneModeInfoSection.className = 'ZoneModeInfoSection';
            ZoneModeInfoSection.style.userSelect = 'none';
            ZoneModeInfoSection.style.WebkitUserDrag = 'none'; 
            ZoneModeInfoSection.draggable = false;
            ZoneModeInfoSection.style.display ="none";

                var ZoneModeInfoSectionTitle_td = document.createElement('td');
                ZoneModeInfoSectionTitle_td.id = 'ZoneModeInfoSectionTitle_td';
                ZoneModeInfoSectionTitle_td.className = 'ArrayMicrophonemicTitle_td';
                    var ArrayMicrophonemicTitle = document.createElement('label');
                    ArrayMicrophonemicTitle.id          = "ArrayMicrophonemicTitle_" + index;
                    ArrayMicrophonemicTitle.className = 'ArrayMicrophonemicTitle Font_Arial_16_bold';
                    ArrayMicrophonemicTitle.textContent = window.LanguageManager.getTranslatedText("Mic_Zone_Information");
                    ArrayMicrophonemicTitle.style.userSelect = 'none';
                    ArrayMicrophonemicTitle.style.WebkitUserDrag = 'none'; 
                    ArrayMicrophonemicTitle.draggable = false;
                    ZoneModeInfoSectionTitle_td.appendChild(ArrayMicrophonemicTitle);
                    

                var ZoneModeInfoSection_td = document.createElement('td');
                ZoneModeInfoSection_td.id          = "ZoneModeArrayMicrophone_Microphone_td_" + index;
                ZoneModeInfoSection_td.className    = "ArrayMicrophone_Microphone_td";

                    var ZoneModeArrayMicrophone_Microphone_label = document.createElement('label');
                    ZoneModeArrayMicrophone_Microphone_label.id          = "ZoneModeArrayMicrophone_Microphone_label_" + index;
                    ZoneModeArrayMicrophone_Microphone_label.className   = "ZoneModeArrayMicrophone_Microphone_label  Font_Arial_14_bold";
                    ZoneModeArrayMicrophone_Microphone_label.textContent = "ID : ";
                    ZoneModeArrayMicrophone_Microphone_label.style.textAlign = 'right';
                    ZoneModeArrayMicrophone_Microphone_label.style.userSelect = 'none';
                    ZoneModeArrayMicrophone_Microphone_label.style.WebkitUserDrag = 'none'; 
                    ZoneModeArrayMicrophone_Microphone_label.draggable = false;
                    var ZoneModeArrayMicrophone_Microphone_value = document.createElement('label');
                    ZoneModeArrayMicrophone_Microphone_value.id          = "ZoneModeArrayMicrophone_Microphone_ID_" + index;
                    ZoneModeArrayMicrophone_Microphone_value.className   = "ZoneModeArrayMicrophone_Microphone_value  Font_Arial_14_bold";
                    ZoneModeArrayMicrophone_Microphone_value.textContent = "";
                    ZoneModeArrayMicrophone_Microphone_value.style.textAlign = 'center';
                    ZoneModeArrayMicrophone_Microphone_value.style.userSelect = 'none';
                    ZoneModeArrayMicrophone_Microphone_value.style.WebkitUserDrag = 'none'; 
                    ZoneModeArrayMicrophone_Microphone_value.draggable = false;

                ZoneModeInfoSection_td.appendChild(ZoneModeArrayMicrophone_Microphone_label);
                ZoneModeInfoSection_td.appendChild(ZoneModeArrayMicrophone_Microphone_value);
                
                var ZoneModeInfoSection_XY_td = document.createElement('td');
                ZoneModeInfoSection_XY_td.id          = "ZoneModeInfoSection_XY_td_" + index;
                ZoneModeInfoSection_XY_td.className   = "VoiceSourceDetect_XY_td";
                ZoneModeInfoSection_XY_td.style.textAlign = 'right';
                ZoneModeInfoSection_XY_td.style.userSelect = 'none';
                ZoneModeInfoSection_XY_td.style.WebkitUserDrag = 'none'; 
                ZoneModeInfoSection_XY_td.draggable = false;

                    var ZoneModeInfoSection_XY_label = document.createElement('label');
                    ZoneModeInfoSection_XY_label.id          = "ZoneModeVoiceSourceDetect_XY_label_" + index;
                    ZoneModeInfoSection_XY_label.className   = "ZoneModeVoiceSourceDetect_XY_label Font_Arial_14_bold";
                    ZoneModeInfoSection_XY_label.textContent = window.LanguageManager.getTranslatedText("Pos")+" (x,y) : ";
                    ZoneModeInfoSection_XY_label.style.userSelect = 'none';
                    ZoneModeInfoSection_XY_label.style.WebkitUserDrag = 'none'; 
                    ZoneModeInfoSection_XY_label.draggable = false;

                    var ZoneModeInfoSection_XY_value_td = document.createElement('td');
                    ZoneModeInfoSection_XY_value_td.className = 'ZoneModeVoiceSourceDetect_XY_value_td';

                        var ZoneModeInfoSection_XY_value_left = document.createElement('label');
                        ZoneModeInfoSection_XY_value_left.id          = "ZoneModeInfoSection_XY_value_left_" + index;
                        ZoneModeInfoSection_XY_value_left.className   = "VoiceSourceDetect_XY_value_left Font_Arial_14_bold";
                        ZoneModeInfoSection_XY_value_left.textContent = "(";
                        ZoneModeInfoSection_XY_value_left.style.textAlign = "right";
                        ZoneModeInfoSection_XY_value_left.style.userSelect = 'none';
                        ZoneModeInfoSection_XY_value_left.style.WebkitUserDrag = 'none'; 
                        ZoneModeInfoSection_XY_value_left.draggable = false;

                        var ZoneModeInfoSection_XY_value_X = document.createElement('label');
                        ZoneModeInfoSection_XY_value_X.id          = "ZoneModeArrayMicrophone_Microphone_Zone_X_" + index;
                        ZoneModeInfoSection_XY_value_X.className   = "VoiceSourceDetect_XY_value_X Font_Arial_14_bold";
                        ZoneModeInfoSection_XY_value_X.textContent = "0";
                        ZoneModeInfoSection_XY_value_X.style.textAlign = "center";
                        ZoneModeInfoSection_XY_value_X.style.userSelect = 'none';
                        ZoneModeInfoSection_XY_value_X.style.WebkitUserDrag = 'none'; 
                        ZoneModeInfoSection_XY_value_X.draggable = false;

                        var ZoneModeInfoSection_XY_value_center = document.createElement('label');
                        ZoneModeInfoSection_XY_value_center.id          = "ZoneModeVoiceSourceDetect_XY_value_center_" + index;
                        ZoneModeInfoSection_XY_value_center.className   = "VoiceSourceDetect_XY_value_center Font_Arial_14_bold";
                        ZoneModeInfoSection_XY_value_center.textContent = ",";
                        ZoneModeInfoSection_XY_value_center.style.userSelect = 'none';
                        ZoneModeInfoSection_XY_value_center.style.WebkitUserDrag = 'none'; 
                        ZoneModeInfoSection_XY_value_center.draggable = false;

                        var ZoneModeInfoSection_XY_value_Y = document.createElement('label');
                        ZoneModeInfoSection_XY_value_Y.id          = "ZoneModeArrayMicrophone_Microphone_Zone_Y_" + index;
                        ZoneModeInfoSection_XY_value_Y.className   = "VoiceSourceDetect_XY_value_Y Font_Arial_14_bold";
                        ZoneModeInfoSection_XY_value_Y.textContent = "0";
                        ZoneModeInfoSection_XY_value_Y.style.textAlign = "center";
                        ZoneModeInfoSection_XY_value_Y.style.userSelect = 'none';
                        ZoneModeInfoSection_XY_value_Y.style.WebkitUserDrag = 'none'; 
                        ZoneModeInfoSection_XY_value_Y.draggable = false;

                        var ZoneModeInfoSection_XY_value_right = document.createElement('label');
                        ZoneModeInfoSection_XY_value_right.id          = "ZoneModeInfoSection_XY_value_right" + index;
                        ZoneModeInfoSection_XY_value_right.className   = "VoiceSourceDetect_XY_value_right Font_Arial_14_bold";
                        ZoneModeInfoSection_XY_value_right.textContent = ')';
                        ZoneModeInfoSection_XY_value_right.style.userSelect = 'none';
                        ZoneModeInfoSection_XY_value_right.style.WebkitUserDrag = 'none'; 
                        ZoneModeInfoSection_XY_value_right.draggable = false;

                    ZoneModeInfoSection_XY_value_td.appendChild(ZoneModeInfoSection_XY_value_left);
                    ZoneModeInfoSection_XY_value_td.appendChild(ZoneModeInfoSection_XY_value_X);
                    ZoneModeInfoSection_XY_value_td.appendChild(ZoneModeInfoSection_XY_value_center);
                    ZoneModeInfoSection_XY_value_td.appendChild(ZoneModeInfoSection_XY_value_Y);
                    ZoneModeInfoSection_XY_value_td.appendChild(ZoneModeInfoSection_XY_value_right);
                    
                //ZoneModeInfoSection_XY_td.appendChild(ZoneModeInfoSection_XY_label);
                //ZoneModeInfoSection_XY_td.appendChild(ZoneModeInfoSection_XY_value_td);

                var ZoneModeInfoSection_Area_td = document.createElement('td');
                ZoneModeInfoSection_Area_td.id          = "ZoneModeArrayMicrophone_Microphone_td_" + index;
                ZoneModeInfoSection_Area_td.className    = "ArrayMicrophone_Microphone_td";

                    var ZoneModeArrayMicrophone_Microphone_label = document.createElement('label');
                    ZoneModeArrayMicrophone_Microphone_label.id          = "ZoneModeArrayMicrophone_Microphone_label_" + index;
                    ZoneModeArrayMicrophone_Microphone_label.className   = "ZoneModeArrayMicrophone_Microphone_label  Font_Arial_14_bold";
                    ZoneModeArrayMicrophone_Microphone_label.textContent = window.LanguageManager.getTranslatedText("Area") + " :";
                    ZoneModeArrayMicrophone_Microphone_label.style.textAlign = 'right';
                    ZoneModeArrayMicrophone_Microphone_label.style.userSelect = 'none';
                    ZoneModeArrayMicrophone_Microphone_label.style.WebkitUserDrag = 'none'; 
                    ZoneModeArrayMicrophone_Microphone_label.draggable = false;
                    var ZoneModeArrayMicrophone_Microphone_value = document.createElement('label');
                    ZoneModeArrayMicrophone_Microphone_value.id          = "ZoneModeArrayMicrophone_Microphone_Zone_Area_" + index;
                    ZoneModeArrayMicrophone_Microphone_value.className   = "ZoneModeArrayMicrophone_Microphone_value  Font_Arial_14_bold";
                    ZoneModeArrayMicrophone_Microphone_value.textContent = "";
                    ZoneModeArrayMicrophone_Microphone_value.style.textAlign = 'center';
                    ZoneModeArrayMicrophone_Microphone_value.style.userSelect = 'none';
                    ZoneModeArrayMicrophone_Microphone_value.style.WebkitUserDrag = 'none'; 
                    ZoneModeArrayMicrophone_Microphone_value.draggable = false;

                ZoneModeInfoSection_Area_td.appendChild(ZoneModeArrayMicrophone_Microphone_label);
                ZoneModeInfoSection_Area_td.appendChild(ZoneModeArrayMicrophone_Microphone_value);
                
            ZoneModeInfoSection.appendChild(ZoneModeInfoSectionTitle_td);
            ZoneModeInfoSection.appendChild(ZoneModeInfoSection_td);
            ZoneModeInfoSection.appendChild(ZoneModeInfoSection_XY_td);
            ZoneModeInfoSection.appendChild(ZoneModeInfoSection_Area_td);

            //------------------

            var ZoneModeRoomVoiceDetectSection = document.createElement('tr');
            ZoneModeRoomVoiceDetectSection.id =  'ZoneModeRoomVoiceDetectSection_' + index;
            ZoneModeRoomVoiceDetectSection.className = 'ZoneModeRoomVoiceDetectSection';
            ZoneModeRoomVoiceDetectSection.style.userSelect = 'none';
            ZoneModeRoomVoiceDetectSection.style.WebkitUserDrag = 'none'; 
            ZoneModeRoomVoiceDetectSection.draggable = false;
        
                var ZoneModeRoomVoiceDetectSectionTitle_td = document.createElement('td');
                ZoneModeRoomVoiceDetectSectionTitle_td.id = 'ZoneModeRoomVoiceDetectSectionTitle_td';
                ZoneModeRoomVoiceDetectSectionTitle_td.className = 'ArrayMicrophonemicTitle_td';
                    var ArrayMicrophonemicTitle = document.createElement('label');
                    ArrayMicrophonemicTitle.id          = "ArrayMicrophonemicTitle_" + index;
                    ArrayMicrophonemicTitle.className = 'ArrayMicrophonemicTitle Font_Arial_16_bold';
                    ArrayMicrophonemicTitle.textContent = window.LanguageManager.getTranslatedText("Voice_Source_Detect");
                    ArrayMicrophonemicTitle.style.userSelect = 'none';
                    ArrayMicrophonemicTitle.style.WebkitUserDrag = 'none'; 
                    ArrayMicrophonemicTitle.draggable = false;
                ZoneModeRoomVoiceDetectSectionTitle_td.appendChild(ArrayMicrophonemicTitle);
    
                
                var ZoneModeRoomVoiceDetectSection_XY_td = document.createElement('td');
                ZoneModeRoomVoiceDetectSection_XY_td.id          = "ZoneModeRoomVoiceDetectSection_XY_td_" + index;
                ZoneModeRoomVoiceDetectSection_XY_td.className   = "VoiceSourceDetect_XY_td";
                ZoneModeRoomVoiceDetectSection_XY_td.style.textAlign = 'right';
        
                    var ZoneModeVoiceSourceDetect_XY_label = document.createElement('label');
                    ZoneModeVoiceSourceDetect_XY_label.id          = "ZoneModeVoiceSourceDetect_XY_label_" + index;
                    ZoneModeVoiceSourceDetect_XY_label.className   = "ZoneModeVoiceSourceDetect_XY_label Font_Arial_14_bold";
                    ZoneModeVoiceSourceDetect_XY_label.textContent = window.LanguageManager.getTranslatedText("Pos")+" (x,y) : ";
                    ZoneModeVoiceSourceDetect_XY_label.style.userSelect = 'none';
                    ZoneModeVoiceSourceDetect_XY_label.style.WebkitUserDrag = 'none'; 
                    ZoneModeVoiceSourceDetect_XY_label.draggable = false;
        
                    var ZoneModeVoiceSourceDetect_XY_value_td = document.createElement('td');
                    ZoneModeVoiceSourceDetect_XY_value_td.className = 'ZoneModeVoiceSourceDetect_XY_value_td';
        
                        var ZoneModeVoiceSourceDetect_XY_value_left = document.createElement('label');
                        ZoneModeVoiceSourceDetect_XY_value_left.id          = "VoiceSourceDetect_XY_value_left_" + index;
                        ZoneModeVoiceSourceDetect_XY_value_left.className   = "VoiceSourceDetect_XY_value_left Font_Arial_14_bold";
                        ZoneModeVoiceSourceDetect_XY_value_left.textContent = "(";
                        ZoneModeVoiceSourceDetect_XY_value_left.style.userSelect = 'none';
                        ZoneModeVoiceSourceDetect_XY_value_left.style.WebkitUserDrag = 'none'; 
                        ZoneModeVoiceSourceDetect_XY_value_left.draggable = false;
        
                        var ZoneModeVoiceSourceDetect_XY_value_X = document.createElement('label');
                        ZoneModeVoiceSourceDetect_XY_value_X.id          = "ZoneModeVoiceSourceDetect_XY_value_X_" + index;
                        ZoneModeVoiceSourceDetect_XY_value_X.className   = "VoiceSourceDetect_XY_value_X Font_Arial_14_bold";
                        ZoneModeVoiceSourceDetect_XY_value_X.textContent = "0";
                        ZoneModeVoiceSourceDetect_XY_value_X.style.textAlign = "center";
                        ZoneModeVoiceSourceDetect_XY_value_X.style.userSelect = 'none';
                        ZoneModeVoiceSourceDetect_XY_value_X.style.WebkitUserDrag = 'none'; 
                        ZoneModeVoiceSourceDetect_XY_value_X.draggable = false;
        
                        var ZoneModeVoiceSourceDetect_XY_value_center = document.createElement('label');
                        ZoneModeVoiceSourceDetect_XY_value_center.id          = "ZoneModeVoiceSourceDetect_XY_value_center_" + index;
                        ZoneModeVoiceSourceDetect_XY_value_center.className   = "VoiceSourceDetect_XY_value_center Font_Arial_14_bold";
                        ZoneModeVoiceSourceDetect_XY_value_center.textContent = ",";
                        ZoneModeVoiceSourceDetect_XY_value_center.style.userSelect = 'none';
                        ZoneModeVoiceSourceDetect_XY_value_center.style.WebkitUserDrag = 'none'; 
                        ZoneModeVoiceSourceDetect_XY_value_center.draggable = false;
        
                        var ZoneModeVoiceSourceDetect_XY_value_Y = document.createElement('label');
                        ZoneModeVoiceSourceDetect_XY_value_Y.id          = "ZoneModeVoiceSourceDetect_XY_value_Y_" + index;
                        ZoneModeVoiceSourceDetect_XY_value_Y.className   = "VoiceSourceDetect_XY_value_Y Font_Arial_14_bold";
                        ZoneModeVoiceSourceDetect_XY_value_Y.textContent = "0";
                        ZoneModeVoiceSourceDetect_XY_value_Y.style.textAlign = "center";
                        ZoneModeVoiceSourceDetect_XY_value_Y.style.userSelect = 'none';
                        ZoneModeVoiceSourceDetect_XY_value_Y.style.WebkitUserDrag = 'none'; 
                        ZoneModeVoiceSourceDetect_XY_value_Y.draggable = false;
        
                        var ZoneModeVoiceSourceDetect_XY_value_right = document.createElement('label');
                        ZoneModeVoiceSourceDetect_XY_value_right.id          = "ZoneModeVoiceSourceDetect_XY_value_right_" + index;
                        ZoneModeVoiceSourceDetect_XY_value_right.className   = "VoiceSourceDetect_XY_value_right Font_Arial_14_bold";
                        ZoneModeVoiceSourceDetect_XY_value_right.textContent = ')';
                        ZoneModeVoiceSourceDetect_XY_value_right.style.userSelect = 'none';
                        ZoneModeVoiceSourceDetect_XY_value_right.style.WebkitUserDrag = 'none'; 
                        ZoneModeVoiceSourceDetect_XY_value_right.draggable = false;
        
                    ZoneModeVoiceSourceDetect_XY_value_td.appendChild(ZoneModeVoiceSourceDetect_XY_value_left);
                    ZoneModeVoiceSourceDetect_XY_value_td.appendChild(ZoneModeVoiceSourceDetect_XY_value_X);
                    ZoneModeVoiceSourceDetect_XY_value_td.appendChild(ZoneModeVoiceSourceDetect_XY_value_center);
                    ZoneModeVoiceSourceDetect_XY_value_td.appendChild(ZoneModeVoiceSourceDetect_XY_value_Y);
                    ZoneModeVoiceSourceDetect_XY_value_td.appendChild(ZoneModeVoiceSourceDetect_XY_value_right);
                    
                    
                ZoneModeRoomVoiceDetectSection_XY_td.appendChild(ZoneModeVoiceSourceDetect_XY_label);
                ZoneModeRoomVoiceDetectSection_XY_td.appendChild(ZoneModeVoiceSourceDetect_XY_value_td);
        
                var ZoneModeRoomVoiceDetectSection_Area_td = document.createElement('td');
                ZoneModeRoomVoiceDetectSection_Area_td.id          = "ZoneModeArrayMicrophone_Microphone_td_" + index;
                ZoneModeRoomVoiceDetectSection_Area_td.className    = "ArrayMicrophone_Microphone_td";
        
                    var ZoneModeArrayMicrophone_Microphone_label = document.createElement('label');
                    ZoneModeArrayMicrophone_Microphone_label.id          = "ZoneModeArrayMicrophone_Microphone_label_" + index;
                    ZoneModeArrayMicrophone_Microphone_label.className   = "ZoneModeArrayMicrophone_Microphone_label  Font_Arial_14_bold";
                    ZoneModeArrayMicrophone_Microphone_label.textContent = window.LanguageManager.getTranslatedText("Zone") + " :";
                    ZoneModeArrayMicrophone_Microphone_label.style.textAlign = 'right';
                    ZoneModeArrayMicrophone_Microphone_label.style.userSelect = 'none';
                    ZoneModeArrayMicrophone_Microphone_label.style.WebkitUserDrag = 'none'; 
                    ZoneModeArrayMicrophone_Microphone_label.draggable = false;
                    var ZoneModeArrayMicrophone_Microphone_value = document.createElement('label');
                    ZoneModeArrayMicrophone_Microphone_value.id          = "ZoneModeVoiceSourceDetect_Microphone_value_" + index;
                    ZoneModeArrayMicrophone_Microphone_value.className   = "ZoneModeArrayMicrophone_Microphone_value  Font_Arial_14_bold";
                    ZoneModeArrayMicrophone_Microphone_value.textContent = "";
                    ZoneModeArrayMicrophone_Microphone_value.style.textAlign = 'center';
                    ZoneModeArrayMicrophone_Microphone_value.style.userSelect = 'none';
                    ZoneModeArrayMicrophone_Microphone_value.style.WebkitUserDrag = 'none'; 
                    ZoneModeArrayMicrophone_Microphone_value.draggable = false;
                    
        
                ZoneModeRoomVoiceDetectSection_Area_td.appendChild(ZoneModeArrayMicrophone_Microphone_label);
                ZoneModeRoomVoiceDetectSection_Area_td.appendChild(ZoneModeArrayMicrophone_Microphone_value);
                
            ZoneModeRoomVoiceDetectSection.appendChild(ZoneModeRoomVoiceDetectSectionTitle_td);
            ZoneModeRoomVoiceDetectSection.appendChild(ZoneModeRoomVoiceDetectSection_XY_td);
            ZoneModeRoomVoiceDetectSection.appendChild(ZoneModeRoomVoiceDetectSection_Area_td);


        //InfoSections.appendChild(RoomSetupSection);
        InfoSections.appendChild(ZoneModeVoiceSourceSection);
        InfoSections.appendChild(ZoneModeAddSection);
        InfoSections.appendChild(ZoneModeInfoSection);
        InfoSections.appendChild(ZoneModeRoomVoiceDetectSection);
        
        //------------------

        var canvasContainer_td = document.createElement('td');
        canvasContainer_td.id = 'canvasContainer_' + index;
 
            var canvas_td = document.createElement('td');
            canvas_td.className = 'ZoneModecanvas_td';
                var gridCanvas = document.createElement('canvas');
                gridCanvas.id = 'ZoneMode_xy_canvas_grid_' + index;
                gridCanvas.className = 'xyZoneModecanvas xyZoneModecanvas_border';
                gridCanvas.style.position = 'absolute';
                gridCanvas.style.zIndex = '0';

                var rectCanvas = document.createElement('canvas');
                rectCanvas.id = 'ZoneMode_xy_canvas_rect_' + index;
                rectCanvas.className = 'xyZoneModecanvas-noneBackGround xyZoneModecanvas_border';
                rectCanvas.style.position = 'absolute';
                rectCanvas.style.zIndex = '1';


                var micCanvas = document.createElement('canvas');
                micCanvas.id = 'ZoneMode_xy_canvas_mic_' + index;
                micCanvas.className = 'xyZoneModecanvas-noneBackGround xyZoneModecanvas_border';
                micCanvas.style.position = 'absolute';
                micCanvas.style.zIndex = '2';

                var soundPointCanvas = document.createElement('canvas');
                soundPointCanvas.id = 'ZoneMode_xy_canvas_soundPoint_' + index;
                soundPointCanvas.className = 'xyZoneModecanvas-noneBackGround xyZoneModecanvas_border';
                soundPointCanvas.style.position = 'absolute';
                soundPointCanvas.style.zIndex = '3';

                var mouseCanvas = document.createElement('canvas');
                mouseCanvas.id = 'ZoneMode_xy_canvas_mouse_' + index;
                mouseCanvas.className = 'xyZoneModecanvas-noneBackGround xyZoneModecanvas_border';
                mouseCanvas.style.position = 'absolute';
                mouseCanvas.style.zIndex = '4';
                
                mouseCanvas.addEventListener('mousemove',  onthrottledZoneModeMouseMove);
                mouseCanvas.addEventListener('mousedown',  onZoneModeMouseDown);
                mouseCanvas.addEventListener('mouseup',    onZoneModeMouseUp);

            canvas_td.appendChild(gridCanvas);
            canvas_td.appendChild(rectCanvas);
            canvas_td.appendChild(micCanvas);
            canvas_td.appendChild(soundPointCanvas);
            canvas_td.appendChild(mouseCanvas);

        canvasContainer_td.appendChild(canvas_td);

    InfoSections_canvasContainer_td.appendChild(InfoSections);
    InfoSections_canvasContainer_td.appendChild(canvasContainer_td);

    popupWindow.appendChild(titleBar);
    popupWindow.appendChild(InfoSections_canvasContainer_td);

    popupWindow.style.display = 'block';



}

function changeRoomHeightinput(e)
{
    var RoomHeightValue = document.getElementById('Room_Height_input_'+gDeviceIndex);
    var currentValue = parseInt(RoomHeightValue.value);
    console.log('currentValue--->',currentValue);
    if(currentValue < 8)
    {
        RoomHeightValue.value = 8;
    }
}

let gZoneModeIsDrawing = false;
let gZoneModeStartX = 0;
let gZoneModeStartY = 0;
let gRectangles = [];
let gLastRectangles = [];
let gDeletedIds = [];
let gRectangleCount = 0;
let gActiveRectangles = [];
let gDraggingRectangle = null;
let gZoneModeOffsetX = 0;
let gZoneModeOffsetY = 0;
let gZoneModeStartPoint = { x: 0, y: 0 };
let gZoneModeInittSetUp = false;
let gDrawingPromise = null;
let gResizeTimeout = null;
let gLastSelectedRect = null;
let gResizingRectangle = null;
let gZoneModeIsOpen = false;
let gZoneModeSoundXYData = {};
let gIsFirstDraw = true;
let gIsLoadingConfig = false;

function rotateImage(ctx, img, x, y, angleDegrees, size) 
{
    if (!img || !img.complete) return;

    ctx.save();
    ctx.translate(x, y);
    ctx.rotate((angleDegrees * Math.PI) / 180);
    ctx.drawImage(img, -size / 2, -size / 2, size, size);
    ctx.restore();
}

class Quadrilateral {
    constructor(points) {
        this.points = points;
        if (gIsLoadingConfig) {
            this.id = null;
        } else {
            // 先不分配 ID，由外部控制
            this.id = null;
        }
        this.isSelected = false;
        this.wasSelected = false;
        this.imgZoneCancel = new Image();
        this.imgZoneCancel.src = '../images/item_cancel.png';
        this.imgZoneResize = new Image();
        this.imgZoneResize.src = '../images/item_resize.png';
    }
    assignNextAvailableId() {
        // 清理重複的 ID 並排序
        gDeletedIds = [...new Set(gDeletedIds)].sort((a, b) => a - b);
        
        // 檢查 gDeletedIds 中是否有不在 gActiveRectangles 中的 ID
        const validDeletedIds = gDeletedIds.filter(id => !gActiveRectangles.includes(id));
        //console.log('assignNextAvailableId - Valid deleted IDs:', validDeletedIds, 'gActiveRectangles:', gActiveRectangles);
        
        if (validDeletedIds.length > 0) {
            // 使用有效的已刪除 ID 中最小的一個
            const newId = validDeletedIds[0];
            // 從 gDeletedIds 中移除這個 ID
            const index = gDeletedIds.indexOf(newId);
            gDeletedIds.splice(index, 1);
            //console.log('assignNextAvailableId - Reused valid deleted ID:', newId, 'Remaining gDeletedIds:', gDeletedIds);
            return newId;
        }
    
        // 如果沒有有效的已刪除 ID，找到最小的缺失 ID
        return this.findSmallestMissingId(gActiveRectangles);
    }

    findSmallestMissingId(activeIds) {
        if (activeIds.length === 0) {
            //console.log('assignNextAvailableId - No active IDs, starting with 1');
            return 1;
        }
        
        // 確保數組已排序，並去除重複值
        const sortedIds = [...new Set(activeIds)].sort((a, b) => a - b);
        //console.log('assignNextAvailableId - Sorted active IDs:', sortedIds);
        
        // 檢查是否從 1 開始
        if (sortedIds[0] > 1) {
            //console.log('assignNextAvailableId - Missing ID 1, returning 1');
            return 1;
        }
        
        // 從 1 開始逐一檢查每個數字是否存在
        for (let expectedId = 1; expectedId <= sortedIds[sortedIds.length - 1]; expectedId++) {
            if (!sortedIds.includes(expectedId)) {
                //console.log('assignNextAvailableId - Found missing ID:', expectedId);
                return expectedId;
            }
        }
        
        // 如果所有 ID 都是連續的，返回最大 ID + 1
        const nextId = Math.max(...sortedIds) + 1;
        //console.log('assignNextAvailableId - All IDs continuous, next ID:', nextId);
        return nextId;
    }

    draw(ctx, dpr) {
        ctx.beginPath();
        ctx.moveTo(this.points[0].x, this.points[0].y);
        for (let i = 1; i < this.points.length; i++) {
            ctx.lineTo(this.points[i].x, this.points[i].y);
        }
        ctx.closePath();
        ctx.fillStyle = this.isSelected ? 'rgba(100, 200, 100, 0.7)' : 'rgba(100, 200, 100, 0.39)';
        ctx.fill();

        const center = this.getCenter();
        ctx.fillStyle = 'black';
        ctx.font = `${16 / dpr}px Arial`;
        ctx.textAlign = 'center';
        ctx.textBaseline = 'middle';
        ctx.fillText(this.id, center.x, center.y);

        if (this.isSelected) 
        {
            const ICON_SIZE = 16;
            const CIRCLE_RADIUS = ICON_SIZE / 1.5;
            const OFFSET = 20;

            const rightTop = this.points[1];

            const cancelX = rightTop.x - OFFSET;
            const cancelY = rightTop.y;

            ctx.beginPath();
            ctx.fillStyle = 'rgba(0, 0, 200, 0.4)';
            ctx.arc(cancelX, cancelY, CIRCLE_RADIUS, 0, Math.PI * 2);
            ctx.fill();
            if (this.imgZoneCancel && this.imgZoneCancel.complete) 
            {
                ctx.drawImage(this.imgZoneCancel, cancelX - ICON_SIZE / 2, cancelY - ICON_SIZE / 2, ICON_SIZE, ICON_SIZE);
            }

            this.points.forEach((point, index) => {
                ctx.beginPath();
                ctx.fillStyle = 'rgba(0, 0, 200, 0.4)';
                ctx.arc(point.x, point.y, CIRCLE_RADIUS, 0, Math.PI * 2);
                ctx.fill();
                
                if (this.imgZoneResize && this.imgZoneResize.complete) {
                    if (index === 1 || index === 3) 
                    {
                        rotateImage(ctx, this.imgZoneResize, point.x, point.y, 90, ICON_SIZE);
                    } 
                    else 
                    {
                        ctx.drawImage(this.imgZoneResize, point.x - ICON_SIZE / 2, point.y - ICON_SIZE / 2, ICON_SIZE, ICON_SIZE);
                    }
                }
            });
        }
    }

    contains(x, y) {
        let inside = false;
        const n = this.points.length;
        for (let i = 0, j = n - 1; i < n; j = i++) {
            const pi = this.points[i];
            const pj = this.points[j];
            if ((pi.y > y) !== (pj.y > y) && (x < pi.x + (pj.x - pi.x) * (y - pi.y) / (pj.y - pi.y))) {
                inside = !inside;
            }
        }
        return inside;
    }

    isOnCancelButton(x, y) {
        const ICON_SIZE = 16;
        const OFFSET = 20;
        const rightTop = this.points[1];
        const cancelX = rightTop.x - OFFSET;
        const cancelY = rightTop.y;
        return Math.abs(x - cancelX) < ICON_SIZE / 2 && Math.abs(y - cancelY) < ICON_SIZE / 2;
    }

    isOnCorner(x, y) {
        const ICON_SIZE = 16;
        for (let i = 0; i < this.points.length; i++) {
            const p = this.points[i];
            if (Math.abs(x - p.x) < ICON_SIZE / 2 && Math.abs(y - p.y) < ICON_SIZE / 2) {
                return i;
            }
        }
        return -1;
    }

    getCenter() {
        let sumX = 0, sumY = 0;
        this.points.forEach(p => {
            sumX += p.x;
            sumY += p.y;
        });
        return { x: sumX / 4, y: sumY / 4 };
    }

    constrainCorner(index, newX, newY) 
    {
        const points = this.points;
        const BUFFER = 10;
        let constrainedX = newX;
        let constrainedY = newY;
    
        const canvas = document.getElementById('ZoneMode_xy_canvas_rect_' + gDeviceIndex);
        const maxX = canvas.width / (window.devicePixelRatio || 1);
        const maxY = canvas.height / (window.devicePixelRatio || 1);
    
        constrainedX = Math.max(0, Math.min(constrainedX, maxX));
        constrainedY = Math.max(0, Math.min(constrainedY, maxY));
    
        if (index === 0) 
            {
            constrainedX = Math.min(constrainedX, 
                Math.min(points[1].x, points[2].x) - BUFFER);
            constrainedY = Math.min(constrainedY, 
                Math.min(points[2].y, points[3].y) - BUFFER);
        } 
        else if (index === 1) 
        {
            constrainedX = Math.max(constrainedX, 
                Math.max(points[0].x, points[3].x) + BUFFER);
            constrainedY = Math.min(constrainedY, 
                Math.min(points[2].y, points[3].y) - BUFFER);
        } 
        else if (index === 2) 
        {
            constrainedX = Math.max(constrainedX, 
                Math.max(points[0].x, points[3].x) + BUFFER);
            constrainedY = Math.max(constrainedY, 
                Math.max(points[0].y, points[1].y) + BUFFER);
        } 
        else if (index === 3) 
        {
            constrainedX = Math.min(constrainedX, 
                Math.min(points[1].x, points[2].x) - BUFFER);
            constrainedY = Math.max(constrainedY, 
                Math.max(points[0].y, points[1].y) + BUFFER);
        }
    
        const candidatePos = { x: constrainedX, y: constrainedY };
    
        if (wouldCauseIntersection(points, candidatePos, index)) 
        {
            return { x: points[index].x, y: points[index].y };
        }
    
        return candidatePos;
    }
}


function doLinesIntersect(p1, q1, p2, q2) 
{
    function orientation(p, q, r) 
    {
        const val = (q.y - p.y) * (r.x - q.x) - (q.x - p.x) * (r.y - q.y);
        if (Math.abs(val) < 1e-9) return 0;
        return (val > 0) ? 1 : 2;
    }

    function onSegment(p, q, r) 
    {
        return q.x <= Math.max(p.x, r.x) && q.x >= Math.min(p.x, r.x) &&
               q.y <= Math.max(p.y, r.y) && q.y >= Math.min(p.y, r.y);
    }

    const o1 = orientation(p1, q1, p2);
    const o2 = orientation(p1, q1, q2);
    const o3 = orientation(p2, q2, p1);
    const o4 = orientation(p2, q2, q1);

    if (o1 !== o2 && o3 !== o4) return true;

    if (o1 === 0 && onSegment(p1, p2, q1)) return true;
    if (o2 === 0 && onSegment(p1, q2, q1)) return true;
    if (o3 === 0 && onSegment(p2, p1, q2)) return true;
    if (o4 === 0 && onSegment(p2, q1, q2)) return true;

    return false;
}

function wouldCauseIntersection(points, testPos, movedCorner) 
{
    const testPoints = [...points];
    testPoints[movedCorner] = testPos;

    for (let i = 0; i < 4; i++) 
    {
        for (let j = i + 2; j < 4; j++) 
            {
            if (j === i + 2 || (i === 0 && j === 3)) continue;
            
            if (doLinesIntersect(
                testPoints[i], testPoints[(i + 1) % 4],
                testPoints[j], testPoints[(j + 1) % 4]
            )) {
                return true;
            }
        }
    }
    return false;
}


let throttleTimeout = null;
const THROTTLE_DELAY = 30;

function onthrottledZoneModeMouseMove(e) 
{
    if (throttleTimeout) return;

    throttleTimeout = setTimeout(() => {
        handleMouseMove(e);
        throttleTimeout = null;
    }, THROTTLE_DELAY);
}

function getCanvasContext() {
    const canvas = document.getElementById('ZoneMode_xy_canvas_rect_' + gDeviceIndex);
    const dpr = window.devicePixelRatio || 1;
    return { canvas, ctx: canvas.getContext('2d'), dpr, width: canvas.width / dpr, height: canvas.height / dpr };
}

function getMousePosition(e, canvas) {
    const bounds = canvas.getBoundingClientRect();
    return {
        x: e.clientX - bounds.left,
        y: e.clientY - bounds.top
    };
}

function constrainToBounds(x, y, canvasWidth, canvasHeight) {
    return {
        x: Math.max(0, Math.min(x, canvasWidth)),
        y: Math.max(0, Math.min(y, canvasHeight))
    };
}

function adjustRectangleBounds(startX, startY, width, height, canvasWidth, canvasHeight, minSize = 35) { //Zone Size Change
    let finalX = startX;
    let finalY = startY;
    let finalWidth = width;
    let finalHeight = height;

    // Adjust if rectangle exceeds canvas bounds
    if (finalX < 0) {
        finalWidth += finalX;
        finalX = 0;
    }
    if (finalY < 0) {
        finalHeight += finalY;
        finalY = 0;
    }
    if (finalX + finalWidth > canvasWidth) {
        finalWidth = canvasWidth - finalX;
    }
    if (finalY + finalHeight > canvasHeight) {
        finalHeight = canvasHeight - finalY;
    }

    // Ensure minimum size
    finalWidth = Math.abs(finalWidth) < minSize ? (finalWidth >= 0 ? minSize : -minSize) : finalWidth;
    finalHeight = Math.abs(finalHeight) < minSize ? (finalHeight >= 0 ? minSize : -minSize) : finalHeight;

    return { x: finalX, y: finalY, width: finalWidth, height: finalHeight };
}

function handleMouseMove(e) {
    // const dpr = window.devicePixelRatio || 1;
    let canvasRect = document.getElementById('ZoneMode_xy_canvas_rect_' + gDeviceIndex);
    let canvasX = document.getElementById('ZoneModeRoom_Pos_XY_value_X_' + gDeviceIndex);
    let canvasY = document.getElementById('ZoneModeRoom_Pos_XY_value_Y_' + gDeviceIndex);

    let devicesel = document.getElementById("deviceTypeSel_"+gDeviceIndex);
    let deviceTypeString = transferDeviceTypeToString(devicesel.value); 

    let range = 10;
    // let ctx = canvasRect.getContext('2d');
    // const bounds = canvasRect.getBoundingClientRect();
    // const currentX = (e.clientX - bounds.left);
    // const currentY = (e.clientY - bounds.top);

    const { canvas, ctx, dpr, width: canvasWidth, height: canvasHeight } = getCanvasContext();
    const { x: currentX, y: currentY } = getMousePosition(e, canvas);

    
    if(deviceTypeString ==   'Yamaha:RM-CG(Coordinate)')
    {
        range = 8;
    }

    canvasX.textContent = parseFloat(range * parseFloat(currentX/canvasWidth).toFixed(2)).toFixed(1);
    canvasY.textContent = parseFloat(range - range * parseFloat(currentY/canvasHeight).toFixed(2)).toFixed(1);

    // 清除畫布並重新繪製所有四邊形
    ctx.clearRect(0, 0, canvasRect.width / dpr, canvasRect.height / dpr);
    gQuadrilaterals.forEach(quad => quad.draw(ctx, dpr));

    if (gDraggingQuadrilateral) {
        if (gDraggingCornerIndex !== -1) {
            // 拖動角點
            const constrained = gDraggingQuadrilateral.constrainCorner(gDraggingCornerIndex, currentX, currentY);
            const bounded = constrainToBounds(constrained.x, constrained.y, canvasWidth, canvasHeight);
            gDraggingQuadrilateral.points[gDraggingCornerIndex].x = bounded.x;
            gDraggingQuadrilateral.points[gDraggingCornerIndex].y = bounded.y;
            updateSelectedQuadrilateralInfo(gDraggingQuadrilateral);
        } else {
            // 拖動整個四邊形
            const dx = currentX - gZoneModeStartPoint.x;
            const dy = currentY - gZoneModeStartPoint.y;

            let canMove = true;
            const tempPoints = gDraggingQuadrilateral.points.map(point => ({
                x: point.x + dx,
                y: point.y + dy
            }));

            for (const point of tempPoints) {
                if (point.x < 0 || point.x > canvasWidth || point.y < 0 || point.y > canvasHeight) {
                    canMove = false;
                    break;
                }
            }


            if (canMove) {
                gDraggingQuadrilateral.points.forEach(point => {
                    point.x += dx;
                    point.y += dy;
                });
                gZoneModeStartPoint.x = currentX;
                gZoneModeStartPoint.y = currentY;
                updateSelectedQuadrilateralInfo(gDraggingQuadrilateral);
            }
        }
        ZoneModeRedrawCanvas(ctx);
    } else if (gZoneModeIsDrawing) {
        // 繪製預覽矩形
        let width = currentX - gZoneModeStartPoint.x;
        let height = currentY - gZoneModeStartPoint.y;
        const { x: finalX, y: finalY, width: finalWidth, height: finalHeight } = adjustRectangleBounds(
            gZoneModeStartPoint.x, gZoneModeStartPoint.y, width, height, canvasWidth, canvasHeight
        );

        ctx.strokeStyle = 'red';
        ctx.setLineDash([5 * dpr, 3 * dpr]);
        ctx.lineWidth = 2;
        ctx.strokeRect(finalX, finalY, finalWidth, finalHeight);
        ctx.setLineDash([]);
    }
}

function onZoneModeMouseDown(e) {
    const { canvas, ctx } = getCanvasContext();
    const { x: clickX, y: clickY } = getMousePosition(e, canvas);

    for (let i = 0; i < gQuadrilaterals.length; i++) {
        const quad = gQuadrilaterals[i];
        if (quad.isSelected && quad.isOnCancelButton(clickX, clickY)) {
            gDeletedIds.push(quad.id);
            gDeletedIds.sort((a, b) => a - b);
            gQuadrilaterals.splice(i, 1);

            const index = gActiveRectangles.indexOf(quad.id);
            if (index > -1) 
            {
                gActiveRectangles.splice(index, 1);
                gActiveRectangles.sort((a, b) => a - b); // 保持排序
            }
            ZoneModeRedrawCanvas(ctx);
            return;
        }

        if (quad.isSelected) {
            const cornerIndex = quad.isOnCorner(clickX, clickY)

            if (cornerIndex !== -1) {
                gDraggingQuadrilateral = quad;
                gDraggingCornerIndex = cornerIndex;
                return;
            }
        }
    }

    gZoneModeStartPoint = { x: clickX, y: clickY };
    gDraggingQuadrilateral = null;

    let selectedQuad = null;
    for (const quad of gQuadrilaterals) {
        if (quad.contains(clickX, clickY)) {
            selectedQuad = quad;
            break;
        }
    }

    if (selectedQuad) {
        gQuadrilaterals.forEach(quad => quad.isSelected = false);
        selectedQuad.isSelected = true;
        gDraggingQuadrilateral = selectedQuad;
        gLastSelectedQuad = selectedQuad;
        updateSelectedQuadrilateralInfo(selectedQuad);
    } else {
        gZoneModeIsDrawing = true;
        if (gLastSelectedQuad) {
            updateSelectedQuadrilateralInfo(gLastSelectedQuad);
        }
    }

    ZoneModeRedrawCanvas(ctx);
}

function findSmallestMissingId(activeIds) {
    if (activeIds.length === 0) {
        return 1; // 如果沒有任何 ID，從 1 開始
    }
    
    // 確保數組已排序
    const sortedIds = [...activeIds].sort((a, b) => a - b);
    
    // 檢查是否從 1 開始
    if (sortedIds[0] > 1) {
        return 1;
    }
    
    // 尋找第一個缺失的 ID
    for (let i = 0; i < sortedIds.length - 1; i++) {
        const currentId = sortedIds[i];
        const nextId = sortedIds[i + 1];
        
        // 如果下一個 ID 不是連續的，返回缺失的 ID
        if (nextId - currentId > 1) {
            return currentId + 1;
        }
    }
    
    // 如果所有 ID 都是連續的，返回最大 ID + 1
    return Math.max(...sortedIds) + 1;
}

function onZoneModeMouseUp(e) {
    const { canvas, ctx, width: canvasWidth, height: canvasHeight } = getCanvasContext();
    const { x: endX, y: endY } = getMousePosition(e, canvas);

    if (gZoneModeIsDrawing) {
        let width = endX - gZoneModeStartPoint.x;
        let height = endY - gZoneModeStartPoint.y;
        const { x: finalX, y: finalY, width: finalWidth, height: finalHeight } = adjustRectangleBounds(
            gZoneModeStartPoint.x, gZoneModeStartPoint.y, width, height, canvasWidth, canvasHeight
        );

        const points = [
            { x: finalX, y: finalY },
            { x: finalX + finalWidth, y: finalY },
            { x: finalX + finalWidth, y: finalY + finalHeight },
            { x: finalX, y: finalY + finalHeight }
        ];
        
        // 直接建立四邊形，不使用建構子中的 ID 分配
        const newQuad = new Quadrilateral(points);
        // 手動分配 ID（確保與 assignNextAvailableId 邏輯一致）
        newQuad.id = newQuad.assignNextAvailableId();
        newQuad.ZoneType = 1;

        //console.log('onZoneModeMouseUp - Assigned newZoneID:', newQuad.id);

        gQuadrilaterals.push(newQuad);
        gActiveRectangles.push(newQuad.id);
        gActiveRectangles.sort((a, b) => a - b);
        
        // 啟用清除按鈕
        if (document.getElementById('ZoneModeClearButton_' + gDeviceIndex)) {
            document.getElementById('ZoneModeClearButton_' + gDeviceIndex).disabled = false;
        }
        
        //console.log('onZoneModeMouseUp - Final state - gActiveRectangles:', gActiveRectangles, 'gDeletedIds:', gDeletedIds);
    }

    gDraggingQuadrilateral = null;
    gDraggingCornerIndex = -1;
    gZoneModeIsDrawing = false;

    ZoneModeRedrawCanvas(ctx);
}

function updateSelectedQuadrilateralInfo(quad) {
    let devicesel = document.getElementById("deviceTypeSel_" + gDeviceIndex);
    let deviceTypeString = transferDeviceTypeToString(devicesel.value);
    const canvasCamera = document.getElementById('ZoneMode_xy_canvas_mouse_' + gDeviceIndex);
    let x_scale = 12 / canvasCamera.width;
    let y_scale = 12 / canvasCamera.height;
    if (deviceTypeString === 'Yamaha:RM-CG(Coordinate)') {
        x_scale = 12 / canvasCamera.width;
        y_scale = 12 / canvasCamera.height;
    }
    if (deviceTypeString === 'Nureva:HDL410(Coordinate)' ||
        deviceTypeString === 'Audio-Technica:ATND1061(Coordinate)' ||
        deviceTypeString === 'Shure:MXA920(Coordinate)' ||
        deviceTypeString === 'Sennheiser:TCCM(Coordinate)' ||
        deviceTypeString === 'Sennheiser:TCC2(Coordinate)') {
        x_scale = 12 / canvasCamera.width;
        y_scale = 12 / canvasCamera.height;
    }

    const dpr = window.devicePixelRatio || 1;

    let area = 0;
    for (let i = 0; i < quad.points.length; i++) {
        const j = (i + 1) % quad.points.length;
        area += quad.points[i].x * quad.points[j].y;
        area -= quad.points[j].x * quad.points[i].y;
    }
    area = Math.abs(area) / 2;

    const realArea = (area * x_scale * y_scale * dpr * dpr).toFixed(2);

    document.getElementById('ZoneModeArrayMicrophone_Microphone_ID_' + gDeviceIndex).textContent = quad.id;
    document.getElementById('ZoneModeArrayMicrophone_Microphone_Zone_Area_' + gDeviceIndex).textContent = realArea;
}

function clearSelectedRectangleInfo() 
{
    document.getElementById('ZoneModeArrayMicrophone_Microphone_ID_' + gDeviceIndex).textContent = '';
    //document.getElementById('ZoneModeArrayMicrophone_Microphone_Zone_X_' + gDeviceIndex).textContent = '';
    //document.getElementById('ZoneModeArrayMicrophone_Microphone_Zone_Y_' + gDeviceIndex).textContent = '';
    document.getElementById('ZoneModeArrayMicrophone_Microphone_Zone_Area_' + gDeviceIndex).textContent = '';
}

function clearSelectedQuadrilateralInfo() {
    document.getElementById('ZoneModeArrayMicrophone_Microphone_ID_' + gDeviceIndex).textContent = '';
    document.getElementById('ZoneModeArrayMicrophone_Microphone_Zone_Area_' + gDeviceIndex).textContent = '';
}

function ZoneModeRedrawCanvas(ctx) {
    const dpr = window.devicePixelRatio || 1;
    ctx.clearRect(0, 0, ctx.canvas.width / dpr, ctx.canvas.height / dpr);
    gQuadrilaterals.forEach(quad => quad.draw(ctx, dpr));
    if (gLastQuadrilaterals !== gQuadrilaterals) {
        gLastQuadrilaterals = gQuadrilaterals;
    }
}

function ZoneModeInitializeCanvas(canvas, w, h) {
    const dpr = window.devicePixelRatio || 1;
    canvas.width = w * dpr;
    canvas.height = h * dpr;
    canvas.style.width = w + 'px';
    canvas.style.height = h + 'px';
    const ctx = canvas.getContext('2d');
    ctx.setTransform(1, 0, 0, 1, 0, 0);
    ctx.clearRect(0, 0, canvas.width, canvas.height);
    ctx.scale(dpr, dpr);
    return ctx;
}

function ZoneModeInitDrawGrid(gridCanvas)
{
    const dpr = window.devicePixelRatio || 1;
    let w = h = 750;
    let divisionsX = 120;
    let divisionsY = 120;
    let devicesel = document.getElementById("deviceTypeSel_"+gDeviceIndex);
    let deviceTypeString = transferDeviceTypeToString(devicesel.value); 
    
    if(deviceTypeString === 'Nureva:HDL410(Coordinate)'
    || deviceTypeString === 'Audio-Technica:ATND1061(Coordinate)'
    || deviceTypeString === 'Shure:MXA920(Coordinate)'
    || deviceTypeString === 'Sennheiser:TCC2(Coordinate)'
    || deviceTypeString === 'Sennheiser:TCCM(Coordinate)')
    {
        divisionsX = 120;
        divisionsY = 120;
    }

    if(gDrawingPromise) return;
    if(dpr == gZoneModeInitDRP && !gZoneModeInittSetUp) return;
    if(gZoneModeInittSetUp) gZoneModeInittSetUp = false;
    
    let ctx = gridCanvas.getContext('2d');
    ctx.setTransform(1, 0, 0, 1, 0, 0);
    ctx.clearRect(0, 0, gridCanvas.width, gridCanvas.height);
    ctx.scale(dpr, dpr);

    ctx.strokeStyle = 'black';
    ctx.font = '12px Arial';
    ctx.fillStyle = 'black';

    let gridSizeX = w / divisionsX;
    let gridSizeY = h / divisionsY;
    
    function drawGridAndScales() {
        for (let i = 0; i <= divisionsX; i++) {
            let x = gridSizeX * i;
            ctx.beginPath();
            ctx.lineWidth = (i % 10 === 0) ? 1/dpr : 0.35/dpr;
            ctx.moveTo(x, 0);
            ctx.lineTo(x, h);
            ctx.stroke();
            if (i > 0 && i % 10 === 0) {
                if(i < divisionsX) {
                    ctx.fillText(i/10, (x+3), (h-4));
                } else {
                    ctx.fillText(i/10, (x-10), (h-4));
                }
            }
        }

        for (let j = 0; j <= divisionsY; j++) {
            let y = h - gridSizeY * j;
            ctx.beginPath();
            ctx.lineWidth = (j % 10 === 0) ? 1/dpr : 0.35/dpr;
            ctx.moveTo(0, y);
            ctx.lineTo(w, y);
            ctx.stroke();
            if(j % 10 === 0) {
                const value = (j/10).toString();
                if(j === 0) {
                    ctx.fillText(value, 3, (y-3));
                } else if(j === divisionsY) {
                    ctx.fillText(value, 3, (y+10));
                } else {
                    ctx.fillText(value, 3, (y-3));
                }
            }
        }

        ctx.strokeStyle = 'black';
        ctx.lineWidth = 2/dpr;
        ctx.strokeRect(0, 0, w, h);
    }

    drawGridAndScales();

    if(gDrawingPromise) 
    {
        return gDrawingPromise;
    }

    gDrawingPromise = new Promise((resolve, reject) => {
        const img = new Image();
        img.src = './images/Web_RMCG.png';

        if(deviceTypeString === 'Yamaha:RM-CG(Coordinate)')
        {
            img.src = './images/Web_RMCG.png';
        }
        if(deviceTypeString === 'Nureva:HDL410(Coordinate)')
        {
            img.src = './images/Web_HDL410.png';
        }
        if(deviceTypeString === 'Audio-Technica:ATND1061(Coordinate)')
        {
            img.src = './images/Web_ATND1061.png';
        }
        if(deviceTypeString === 'Shure:MXA920(Coordinate)')
        {
            img.src = './images/Web_MXA920.png';
        }
        if(deviceTypeString === 'Sennheiser:TCC2(Coordinate)')
        {
            img.src = './images/Web_TCC2.png';
        }
        if(deviceTypeString === 'Sennheiser:TCCM(Coordinate)')
        {
            img.src = './images/Web_TCCM.png';
        }

        img.onload = () => {
            let imgWidth = 60;
            let imgHeight = 60;
            if(deviceTypeString === 'Nureva:HDL410(Coordinate)')
            {
                imgWidth = 120;
                imgHeight = 50;
            }
            let centerX = (w - imgWidth) / 2;
            let centerY = (h - imgHeight) / 2;

            if(deviceTypeString === 'Nureva:HDL410(Coordinate)')
            {
                centerY = centerY + 350;     
            }
            ctx.drawImage(img, centerX, centerY, imgWidth, imgHeight);

            gZoneModeInitDRP = dpr;
            resolve();
        };
        
        img.onerror = (err) => {
            console.error('Error loading image:', err);
            reject(err);
        };
    }).finally(() => {
        gDrawingPromise = null;
    });
    return gDrawingPromise;
    
}

function ZoneModeInitialize(index) {
    let devicesel = document.getElementById("deviceTypeSel_" + gDeviceIndex);
    let deviceTypeString = transferDeviceTypeToString(devicesel.value);
    let w = 750, h = 750;

    const gridCanvas = document.getElementById('ZoneMode_xy_canvas_grid_' + index);
    const rectCanvas = document.getElementById('ZoneMode_xy_canvas_rect_' + index);
    const mouseCanvas = document.getElementById('ZoneMode_xy_canvas_mouse_' + index);
    const micCanvas = document.getElementById('ZoneMode_xy_canvas_mic_' + index);
    const soundCanvas = document.getElementById('ZoneMode_xy_canvas_soundPoint_' + index);

    ZoneModeInitializeCanvas(gridCanvas, w, h);
    ZoneModeInitializeCanvas(rectCanvas, w, h);
    ZoneModeInitializeCanvas(mouseCanvas, w, h);
    ZoneModeInitializeCanvas(micCanvas, w, h);
    ZoneModeInitializeCanvas(soundCanvas, w, h);

    gZoneModeInittSetUp = true;
    return ZoneModeInitDrawGrid(gridCanvas);
}

window.addEventListener('resize', () => {
    if (gResizeTimeout) {
        clearTimeout(gResizeTimeout);
    }

    gResizeTimeout = setTimeout(() => {
        let w = 750, h = 750;
        const dpr = window.devicePixelRatio || 1;
        const gridCanvas = document.getElementById('ZoneMode_xy_canvas_grid_' + gDeviceIndex);
        const rectCanvas = document.getElementById('ZoneMode_xy_canvas_rect_' + gDeviceIndex);
        const mouseCanvas = document.getElementById('ZoneMode_xy_canvas_mouse_' + gDeviceIndex);

        if (!gridCanvas || !rectCanvas || !mouseCanvas) return;

        ZoneModeInitializeCanvas(gridCanvas, w, h);
        ZoneModeInitializeCanvas(rectCanvas, w, h);
        ZoneModeInitializeCanvas(mouseCanvas, w, h);

        gZoneModeInittSetUp = true;

        const gridCtx = gridCanvas.getContext('2d');
        gridCtx.setTransform(1, 0, 0, 1, 0, 0);
        gridCtx.scale(dpr, dpr);

        ZoneModeInitDrawGrid(gridCanvas).then(() => {
            const rectCtx = rectIFrame = rectCanvas.getContext('2d');
            ZoneModeRedrawCanvas(rectCtx);
        }).catch(err => {
            console.error('Error during resize:', err);
        });
    }, 50);
});

function updateSelectedRectangleInfo(rect) 
{
    let devicesel = document.getElementById("deviceTypeSel_"+gDeviceIndex);
    let deviceTypeString = transferDeviceTypeToString(devicesel.value); 
    const canvasCamera = document.getElementById('ZoneMode_xy_canvas_mouse_' + gDeviceIndex);
    let x_scale = 12 / canvasCamera.width;
    let y_scale = 12 / canvasCamera.height;
    if(deviceTypeString === 'Yamaha:RM-CG(Coordinate)')
    {
        x_scale = 12 / canvasCamera.width;
        y_scale = 12 / canvasCamera.height;
    }
    if(deviceTypeString === 'Nureva:HDL410(Coordinate)'
    || deviceTypeString === 'Audio-Technica:ATND1061(Coordinate)'
    || deviceTypeString === 'Shure:MXA920(Coordinate)'
    || deviceTypeString === 'Sennheiser:TCCM(Coordinate)'
    || deviceTypeString === 'Sennheiser:TCC2(Coordinate)')
    {
        x_scale = 12 / canvasCamera.width;
        y_scale = 12 / canvasCamera.height;
    }

    const dpr = window.devicePixelRatio || 1;

    const realX = (rect.x * x_scale * dpr).toFixed(2);
    const realY = (rect.y * y_scale * dpr).toFixed(2);
    const realWidth = (Math.abs(rect.width) * x_scale * dpr).toFixed(2);
    const realHeight = (Math.abs(rect.height) * y_scale * dpr).toFixed(2);
    const areaText = `${realWidth} * ${realHeight}`; 

    document.getElementById('ZoneModeArrayMicrophone_Microphone_ID_' + gDeviceIndex).textContent = rect.id;
    //document.getElementById('ZoneModeArrayMicrophone_Microphone_Zone_X_' + gDeviceIndex).textContent = realX;
    //document.getElementById('ZoneModeArrayMicrophone_Microphone_Zone_Y_' + gDeviceIndex).textContent = realY;
    document.getElementById('ZoneModeArrayMicrophone_Microphone_Zone_Area_' + gDeviceIndex).textContent = areaText;

}

let lastZoneModeConfig = null;


function isZoneModeConfigEqual(msg1, msg2) {
    if (!msg1 || !msg2) return false;

    const basicFieldsEqual =
        msg1.Reply === msg2.Reply &&
        msg1.SoundTabIndex === msg2.SoundTabIndex &&
        msg1.ZoneModeEnable === msg2.ZoneModeEnable;

    if (msg1.ZoneModeConfig && msg2.ZoneModeConfig) {
        const config1 = msg1.ZoneModeConfig;
        const config2 = msg2.ZoneModeConfig;

        if (config1.MicZoneItemArray && config2.MicZoneItemArray) {
            if (config1.MicZoneItemArray.length !== config2.MicZoneItemArray.length) {
                return false;
            }
            for (let i = 0; i < config1.MicZoneItemArray.length; i++) {
                const zone1 = config1.MicZoneItemArray[i];
                const zone2 = config2.MicZoneItemArray[i];
                if (
                    zone1.ZoneID !== zone2.ZoneID ||
                    zone1.ZoneType !== zone2.ZoneType ||
                    zone1.AccordingToMicCoordinateTopLeftX !== zone2.AccordingToMicCoordinateTopLeftX ||
                    zone1.AccordingToMicCoordinateTopLeftY !== zone2.AccordingToMicCoordinateTopLeftY ||
                    zone1.AccordingToMicCoordinateBottomRightX !== zone2.AccordingToMicCoordinateBottomRightX ||
                    zone1.AccordingToMicCoordinateBottomRightY !== zone2.AccordingToMicCoordinateBottomRightY
                ) {
                    return false;
                }
            }
        } else if (config1.MicZoneItemArray !== config2.MicZoneItemArray) {
            return false;
        }
    } else if (msg1.ZoneModeConfig !== msg2.ZoneModeConfig) {
        return false;
    }

    return basicFieldsEqual;
}

function updatedZoneModeConfig(msg) {

    ZoneFullMap_GetZoneConfig(msg);
    if (lastZoneModeConfig && isZoneModeConfigEqual(msg, lastZoneModeConfig)) 
    {
        return;
    }
    lastZoneModeConfig = JSON.parse(JSON.stringify(msg));

    let micGroup = getDeviceCameraMappingIndex();
    let devicesel = document.getElementById("deviceTypeSel_" + gDeviceIndex);
    let deviceTypeString = devicesel ? transferDeviceTypeToString(devicesel.value) : "";
    if (!deviceTypeString) return;

    if (!['Yamaha:RM-CG(Coordinate)', 'Audio-Technica:ATND1061(Coordinate)',
          'Shure:MXA920(Coordinate)', 'Sennheiser:TCC2(Coordinate)',
          'Sennheiser:TCCM(Coordinate)'].includes(deviceTypeString)) {
        return;
    }

    if ('SoundTabIndex' in msg) {
        UnblockUIforPage();
        const Enable = msg.ZoneModeEnable;
        let deviceMappingIndex = getDeviceCameraMappingIndex();

        if (Enable) {
            createCameraMappingArrayDiv(micGroup, 128);
            const selectMicChannel = document.getElementById("selectMicChannel_" + deviceMappingIndex);
            selectMicChannel.innerHTML = '';
            const Option1 = document.createElement("option");
            Option1.text = "128";
            Option1.value = "128";
            selectMicChannel.appendChild(Option1);
            document.getElementById("zoneModeSetting_" + deviceMappingIndex).disabled = false;
            document.getElementById("selectMicChannel_" + deviceMappingIndex).value = 128;
            document.getElementById("selectMicChannel_" + deviceMappingIndex).disabled = true;
        }

        if (document.getElementById('ZoneMode_connectCheckboxInput_' + micGroup)) {
            document.getElementById('ZoneMode_connectCheckboxInput_' + micGroup).checked = Enable;
        }
        if (document.getElementById('zoneModeSetting_' + micGroup)) {
            document.getElementById('zoneModeSetting_' + micGroup).disabled = !Enable;
        }
        let handFreeMode = document.getElementById('HandFreeMode_connectCheckboxInput_' + gDeviceIndex);
        if (handFreeMode) {
            changeHandFreeModeStatus(handFreeMode);
        }

        sendMessage("GetMicEnableHandFree", gDeviceIndex);
        sendMessage("GetSoundCamMap", gDeviceIndex);
        sendMessage("GetZoneMapDetection", gDeviceIndex);
        sendMessage("GetMicEnableHandFree", gDeviceIndex);
    }

    if ('ZoneModeConfig' in msg) {
        const rectCanvas = document.getElementById('ZoneMode_xy_canvas_rect_' + gDeviceIndex);
        if(!rectCanvas) return;
        const rectCtx = rectCanvas.getContext('2d');
        const config = msg.ZoneModeConfig;
        gIsLoadingConfig = true;
        gQuadrilaterals = [];
        gActiveRectangles = [];
        gDeletedIds = [];
        gLastSelectedQuad = null;

        let canvasSize_Width = 750;
        let canvasSize_Height = 750;
        let centerOffsetX = 600;
        let centerOffsetY = 600;
        let resizeCanvas_Width = 1200;
        let resizeCanvas_Height = 1200;

        if (deviceTypeString === 'Yamaha:RM-CG(Coordinate)') {
            centerOffsetX = 600;
            centerOffsetY = 600;
            resizeCanvas_Width = 1200;
            resizeCanvas_Height = 1200;
        } else if (['Audio-Technica:ATND1061(Coordinate)', 'Shure:MXA920(Coordinate)',
                   'Sennheiser:TCC2(Coordinate)', 'Sennheiser:TCCM(Coordinate)'].includes(deviceTypeString)) {
            centerOffsetX = 600;
            centerOffsetY = 600;
            resizeCanvas_Width = 1200;
            resizeCanvas_Height = 1200;
        } else if (deviceTypeString === 'Nureva:HDL410(Coordinate)') {
            centerOffsetX = 600;
            centerOffsetY = 1200;
            resizeCanvas_Width = 1200;
            resizeCanvas_Height = 1200;
        }

        const scaleX = canvasSize_Width / resizeCanvas_Width; // 750/800 = 0.9375
        const scaleY = canvasSize_Height / resizeCanvas_Height;

        const processZones = () => {
            config.MicZoneItemArray.forEach(zoneItem => {
                try {
                    if (zoneItem.ZoneType === 1 && zoneItem.ZoneID !== 0) {
                        // 根據設備類型調整偏移
                        let offsetX = -100, offsetY = -100;
                        if (deviceTypeString === 'Yamaha:RM-CG(Coordinate)') {
                            offsetX = -100; // 500 - 600   
                            offsetY = -100;
                        }

                        const points = [
                            { // 頂左
                                x: ((zoneItem.PolygonTopLeftX || zoneItem.RectTopLeftX) - offsetX) * scaleX,
                                y: ((zoneItem.PolygonTopLeftY || zoneItem.RectTopLeftY) - offsetY) * scaleY
                            },
                            { // 頂右
                                x: ((zoneItem.PolygonTopRightX || zoneItem.RectBottomRightX) - offsetX) * scaleX,
                                y: ((zoneItem.PolygonTopRightY || zoneItem.RectTopLeftY) - offsetY) * scaleY
                            },
                            { // 底右
                                x: ((zoneItem.PolygonBottomRightX || zoneItem.RectBottomRightX) - offsetX) * scaleX,
                                y: ((zoneItem.PolygonBottomRightY || zoneItem.RectBottomRightY) - offsetY) * scaleY
                            },
                            { // 底左
                                x: ((zoneItem.PolygonBottomLeftX || zoneItem.RectTopLeftX) - offsetX) * scaleX,
                                y: ((zoneItem.PolygonBottomLeftY || zoneItem.RectBottomRightY) - offsetY) * scaleY
                            }
                        ];

                        // 確保座標在畫布範圍內
                        const webPoints = points.map(point => ({
                            x: Math.round(Math.max(0, Math.min(point.x, canvasSize_Width))),
                            y: Math.round(Math.max(0, Math.min(point.y, canvasSize_Height)))
                        }));

                        const micCoordKeys = [
                            ['AccordingToMicCoordinateTopLeftX', 'AccordingToMicCoordinateTopLeftY'],
                            ['AccordingToMicCoordinateTopRightX', 'AccordingToMicCoordinateTopRightY'],
                            ['AccordingToMicCoordinateBottomRightX', 'AccordingToMicCoordinateBottomRightY'],
                            ['AccordingToMicCoordinateBottomLeftX', 'AccordingToMicCoordinateBottomLeftY']
                        ];
                        webPoints.forEach((point, index) => {
                            const expectedMicX = zoneItem[micCoordKeys[index][0]];
                            const expectedMicY = zoneItem[micCoordKeys[index][1]];
                            const webMicX = (point.x / scaleX) - (centerOffsetX / scaleX) + offsetX;
                            const webMicY = (point.y / scaleY) - (centerOffsetY / scaleY) + offsetY;
                        });

                        const quad = new Quadrilateral(webPoints);
                        quad.id = zoneItem.ZoneID;
                        quad.ZoneType = zoneItem.ZoneType;

                        gQuadrilaterals.push(quad);
                        gActiveRectangles.push(quad.id);
                    }
                } catch (error) {
                    console.error('Error processing zone item:', error, zoneItem);
                }
            });
        };

        gActiveRectangles.sort((a, b) => a - b);

        processZones();
        gIsLoadingConfig = false;

        const maxExistingId = gActiveRectangles.length > 0 ? Math.max(...gActiveRectangles) : 0;
        gDeletedIds = [];
        for (let i = 1; i <= maxExistingId; i++) {
            if (!gActiveRectangles.includes(i)) {
                gDeletedIds.push(i);
            }
        }
        gDeletedIds.sort((a, b) => a - b);
        //console.log('Initialized gDeletedIds:', gDeletedIds, 'gActiveRectangles:', gActiveRectangles);

        requestAnimationFrame(() => {
            ZoneModeRedrawCanvas(rectCtx);
        });

        if (gLastSelectedQuad) {
            updateSelectedQuadrilateralInfo(gLastSelectedQuad);
        } else {
            clearSelectedQuadrilateralInfo();
        }
    }
}

 function updateZoneModeClearAllButton()
 {
    gQuadrilaterals = [];
    gRectangles = [];
    gActiveRectangles = [];
    gDeletedIds = [];
    gRectangleCount = 0;
    gLastSelectedRect = null;
    gIsFirstDraw = true;

    const rectCanvas = document.getElementById('ZoneMode_xy_canvas_rect_' + gDeviceIndex);
    const rectCtx = rectCanvas.getContext('2d');
    ZoneModeRedrawCanvas(rectCtx);
    

    if(document.getElementById('ZoneModeClearButton_' + gDeviceIndex))
        document.getElementById('ZoneModeClearButton_' + gDeviceIndex).disabled = true;


 }

function updateZoneModeApply()
{
    let devicesel = document.getElementById("deviceTypeSel_"+gDeviceIndex);
    let deviceTypeString = transferDeviceTypeToString(devicesel.value); 
    let webSpaceWidth = 12;
    let webSpaceHeight = 12;
    let offsetX = -1;
    let offsetY = -1;

    if(deviceTypeString == 'Yamaha:RM-CG(Coordinate)')
    {
        webSpaceWidth = 12;
        webSpaceHeight = 12;
        offsetX = -1;
        offsetY = -1;
    }

    if(deviceTypeString == 'Sennheiser:TCC2(Coordinate)' 
    || deviceTypeString == 'Sennheiser:TCCM(Coordinate)'
    || deviceTypeString == 'Audio-Technica:ATND1061(Coordinate)'
    || deviceTypeString == 'Shure:MXA920(Coordinate)' )
    {
        webSpaceWidth = 12;
        webSpaceHeight = 12;
        offsetX = -1;
        offsetY = -1;
    }
    
    const scaleFactor = 10000;
    const webCanvasWidth = 750;
    const webCanvasHeight = 750;
    const targetCanvasWidth = 1000;
    const targetCanvasHeight = 1000;
    const targetSpaceWidth = 10;
    const targetSpaceHeight = 10;
    const webPixelPerMeter = webCanvasWidth / webSpaceWidth;
    const targetPixelPerMeter = targetCanvasWidth / targetSpaceWidth;
    
    // 處理新的 Quadrilateral 格式
    const scaledRectangles = gQuadrilaterals.map(quad => {
        // 從四邊形計算包圍矩形
        const minX = Math.min(...quad.points.map(p => p.x));
        const minY = Math.min(...quad.points.map(p => p.y));
        const maxX = Math.max(...quad.points.map(p => p.x));
        const maxY = Math.max(...quad.points.map(p => p.y));
        
        // 創建矩形對象
        const rect = {
            x: minX,
            y: minY,
            width: maxX - minX,
            height: maxY - minY
        };
        
        const realX = (rect.x / webPixelPerMeter);
        const realY = webSpaceHeight - (rect.y / webPixelPerMeter);
        
        const realXWithOffset = realX + offsetX;
        const realYWithOffset = realY + offsetY;
        
        const mappedX = realXWithOffset * targetPixelPerMeter;
        const mappedY = (targetSpaceHeight - realYWithOffset) * targetPixelPerMeter;
        
        const mappedWidth = rect.width * (targetPixelPerMeter / webPixelPerMeter);
        const mappedHeight = rect.height * (targetPixelPerMeter / webPixelPerMeter);
        
        return {
            x: mappedX * scaleFactor,
            y: mappedY * scaleFactor,
            ZoneType: 1, // 固定為 MicSoundZone
            width: mappedWidth * scaleFactor,
            height: mappedHeight * scaleFactor,
            id: quad.id,
            isSelected: quad.isSelected,
            wasSelected: quad.wasSelected,
            imgZoneCancel: {},
            imgZoneResize: {},
            // 新增多邊形資訊 - 修正座標轉換
            isPolygon: true,
            isRealPolygon: true,
            polygonPoints: quad.points.map(point => {
                // 將 web 座標轉換為真實米數座標
                const realPointX = point.x / webPixelPerMeter;
                const realPointY = webSpaceHeight - (point.y / webPixelPerMeter);
                
                // 加上偏移量
                const realPointXWithOffset = realPointX + offsetX;
                const realPointYWithOffset = realPointY + offsetY;
                
                // 轉換到目標座標系
                const targetPointX = realPointXWithOffset * targetPixelPerMeter;
                const targetPointY = (targetSpaceHeight - realPointYWithOffset) * targetPixelPerMeter;
                
                return {
                    x: targetPointX * scaleFactor,
                    y: targetPointY * scaleFactor
                };
            })
        };
    });
    
    var jsonmsg = {};
    jsonmsg.Command = "SetZoneModeConfig";
    jsonmsg.ZoneModeConfig = scaledRectangles;
    jsonmsg.SoundTabIndex = gDeviceIndex;
    sendMessage("SetZoneModeConfig", jsonmsg);

    if(document.getElementById('ZoneModeClearButton_' + gDeviceIndex)) 
    {
        document.getElementById('ZoneModeClearButton_' + gDeviceIndex).disabled = false;
    }

    if (document.getElementById('ZoneModeApplyButton_' + gDeviceIndex)) 
    {
        document.getElementById('ZoneModeApplyButton_' + gDeviceIndex).disabled = true;
        blockUIforPage();

        setTimeout(function () {
           UnblockUIforPage();
           document.getElementById('ZoneModeApplyButton_' + gDeviceIndex).disabled = false;
        }, 1000);
    }
}

function onBackToHomeSettingClick()
{
    const popupWindow = document.getElementById("mic_backToHomeSetting_popup_Window");
    if (popupWindow) 
    {
        popupWindow.style.display = "block";


        popupWindow.innerHTML = ""; 
        const table_Advanced = document.createElement("table");
        table_Advanced.id = "table_Advanced";
        table_Advanced.className = "advanced-table";

        var titleBar = document.createElement('tr');            
        var titleBarRow = document.createElement("td");
        titleBarRow.className = 'BackToHomeTitleBarRow';
            var cell1 = document.createElement("td");
            cell1.className = "title-bar-cell micZoneModelogo-cell";
                var logoImage = document.createElement('img');
                    logoImage.id = 'gBackToHomelogo_image';
                    logoImage.className = 'BackToHome-popup-Window-logo-Image';
                    logoImage.src = '../imagesaibox/CamConnect.png';
            cell1.appendChild(logoImage);

            var cell2 = document.createElement("td");
            cell2.className = "title-bar-cell title-cell";
                var mic_xy_title = document.createElement('label');
                mic_xy_title.className = 'Font_Arial_18_bold mic-xy-title';
                mic_xy_title.textContent = 'CamConnect Processor';
            cell2.appendChild(mic_xy_title);

            var cell3 = document.createElement("td");
            cell3.className = "title-bar-cell close-button-cell";
                var closeButton = document.createElement('button');
                closeButton.id = 'gBackToHome_close_mic_Popup';
                closeButton.className = 'close-popup-btn';
                closeButton.setAttribute("onclick", "closeBackToHomeWindow(this)");
            cell3.appendChild(closeButton);

        titleBarRow.appendChild(cell1);
        titleBarRow.appendChild(cell2);
        titleBarRow.appendChild(cell3);

        titleBar.appendChild(titleBarRow);

        let tr_HomeTime = document.createElement("tr");
        tr_HomeTime.className = "stream_tr2 Font_Arial_14";

        let td_HomeTime = document.createElement("td");
        let label_BackToHometime = document.createElement("label");
        label_BackToHometime.id = "gBackToHomeBackToHometime";
        label_BackToHometime.className = "Font_Arial_14 label_tr";
        label_BackToHometime.style.cssText = "width : 160px; margin-left : 30px; margin-top : 10px;  margin-bottom : 10px;";
        label_BackToHometime.innerText = window.LanguageManager.getTranslatedText("Back_to_Home_Time");

        /*
        let select_SelectModelHomeTimes = document.createElement("select");
        select_SelectModelHomeTimes.id = "gBackToHomeSelectModelHomeTimes";
        select_SelectModelHomeTimes.className = "selectH32";
        select_SelectModelHomeTimes.style.cssText = "width : 210px; margin-left : 92px; text-align-last: left;   margin-top : 10px; margin-bottom : 10px;";
        select_SelectModelHomeTimes.setAttribute("onchange", "BackToHomeSelectModelApplyStatusChange()");

        for (let i = 0; i < gSelectModelHomeTimesOptions[document.getElementById("GobalSelectLanguage").value].length; i++) {
            let option = document.createElement("option");
            option.value = i;
            option.innerText = gSelectModelHomeTimesOptions[document.getElementById("GobalSelectLanguage").value][i];
            select_SelectModelHomeTimes.appendChild(option);
        }
        */
        var input_BackToHomTriggerTimeInput = document.createElement("input");
        input_BackToHomTriggerTimeInput.id = "gBackToHomeSelectModelHomeTimes";
        input_BackToHomTriggerTimeInput.style.cssText  = "width:210px; height:30px; Font_Arial_14; margin-left : 55px; margin-top : 10px; margin-bottom : 10px;text-align-last: left;"
        input_BackToHomTriggerTimeInput.type = "text";
        input_BackToHomTriggerTimeInput.maxLength = "120";
        input_BackToHomTriggerTimeInput.setAttribute("onchange", "BackToHomeSelectModelApplyStatusChange()");

        td_HomeTime.appendChild(label_BackToHometime);
        td_HomeTime.appendChild(input_BackToHomTriggerTimeInput);
        tr_HomeTime.appendChild(td_HomeTime);

        let tr_HomeCamera = document.createElement("tr");
        tr_HomeCamera.className = "stream_tr2 Font_Arial_14";

        let td_HomeCamera = document.createElement("td");
        let label_BackHomeCamera = document.createElement("label");
        label_BackHomeCamera.id = "gBackToHomeCamera";
        label_BackHomeCamera.className = "Font_Arial_14 label_tr";
        if(document.getElementById("GobalSelectLanguage").value == 0)
        {
            label_BackHomeCamera.style.cssText = "width : 152px;  margin-left : 30px;";
        }
        else
        {
            label_BackHomeCamera.style.cssText = "width : 160px;  margin-left : 30px;";
        }
        
        label_BackHomeCamera.innerText = window.LanguageManager.getTranslatedText("Back_to_Home_Camera");

        let select_SelectModelHomeCamera = document.createElement("select");
        select_SelectModelHomeCamera.id = "gBackToHomeSelectModelHomeCamera";
        select_SelectModelHomeCamera.className = "selectH32";

        if(document.getElementById("GobalSelectLanguage").value == 0)
        {
            select_SelectModelHomeCamera.style.cssText = "width : 210px; margin-left : 63px;  text-align-last: left;";
        }
        else
        {
            select_SelectModelHomeCamera.style.cssText = "width : 210px; margin-left : 55px;  text-align-last: left;";
        }


        select_SelectModelHomeCamera.addEventListener("mouseout", onMouseoutCameraItem);
        select_SelectModelHomeCamera.addEventListener("mouseover", onMouseoverCameraItem);
        //select_SelectModelHomeCamera.addEventListener("change", BackToHomeSelectModelHomeCameraOnChange);
        select_SelectModelHomeCamera.setAttribute("onchange", "BackToHomeSelectModelHomeCameraOnChange()");

        let option_All = document.createElement("option");
        option_All.value = 0;
        option_All.text = window.LanguageManager.getTranslatedText("All_Camera");
        option_All.selected = true;

        select_SelectModelHomeCamera.appendChild(option_All);

        let camHint = document.createElement("div");
        camHint.id = "gBackToHomeSelectModelHomeCameraHint";
        camHint.classList.add('cameratooltip');
        //camHint.display = "none";
        camHint.style.cssText = "left: 1260px; top: 425px; display: none;";

        td_HomeCamera.appendChild(label_BackHomeCamera);
        td_HomeCamera.appendChild(select_SelectModelHomeCamera);
        td_HomeCamera.appendChild(camHint);
        tr_HomeCamera.appendChild(td_HomeCamera);

        let tr_HomePosition = document.createElement("tr");
        tr_HomePosition.className = "stream_tr2 Font_Arial_14";

        let td_HomePosition = document.createElement("td");
        let label_HomePosition = document.createElement("label");
        label_HomePosition.id = "gBackToHomePosition";
        label_HomePosition.className = "Font_Arial_14 label_tr";
        label_HomePosition.style.cssText = "width : 152px;  margin-left : 30px;";
        label_HomePosition.innerText = window.LanguageManager.getTranslatedText("Back_to_Home_Position");

        let select_HomePosition = document.createElement("select");
        select_HomePosition.id = "gBackToHomeSelectModelHomePosition";
        select_HomePosition.className = "selectH32";
        select_HomePosition.style.cssText = "margin-left : 63px; width : 124px;  text-align-last: left;";
        select_HomePosition.setAttribute("onchange", "BackToHomeSelectModelHomePositionOnChange()");

        let option_Home = document.createElement("option");
        option_Home.value = 0;
        option_Home.text = window.LanguageManager.getTranslatedText("Home");

        let option_Preset = document.createElement("option");
        option_Preset.value = 1;
        option_Preset.text = window.LanguageManager.getTranslatedText("Preset");

        select_HomePosition.appendChild(option_Home);
        select_HomePosition.appendChild(option_Preset);

        let input_HomePosition = document.createElement("input");
        input_HomePosition.id = "gBackToHomeInputModelHomePosition";
        input_HomePosition.style.cssText = "margin-left : 8px; height : 32px; width : 80px; text-align-last: left;";
        input_HomePosition.type = "number";
        input_HomePosition.min = "0";
        input_HomePosition.max = "255";
        input_HomePosition.value = 0;
        input_HomePosition.disabled = true;
        input_HomePosition.setAttribute("onchange", "onBackToHomeInputModelHomePositionChange()");

        var applyButton = document.createElement("button");
        applyButton.id = "gBtnBackToHomeModeApply";
        applyButton.type = "button";
        applyButton.className = "BackToHomeBtn_style applyButton";
        applyButton.style.cssText = "margin-left : 355px; margin-top : 10px;";
        applyButton.disabled = true;
        applyButton.innerText = window.LanguageManager.getTranslatedText("Apply");
        applyButton.setAttribute("onclick", "onBackToHomeApplyClick()");       

        td_HomePosition.appendChild(label_HomePosition);
        td_HomePosition.appendChild(select_HomePosition);
        td_HomePosition.appendChild(input_HomePosition);
        tr_HomePosition.appendChild(td_HomePosition);

        table_Advanced.appendChild(tr_HomeTime);
        table_Advanced.appendChild(tr_HomeCamera);
        table_Advanced.appendChild(tr_HomePosition);

        popupWindow.appendChild(titleBar);
        popupWindow.appendChild(table_Advanced);
        popupWindow.appendChild(applyButton);
        

        sendMessage("GetGlobalBackToHomeSetting",gDeviceIndex);
    }


}

function updateBackToHomeSetting(msg)
{
    //console.log('updateBackToHomeSetting:', msg);

    var SelectModelHomeTimes    = document.getElementById("gBackToHomeSelectModelHomeTimes");
    var SelectModelHomePosition    = document.getElementById("gBackToHomeSelectModelHomePosition");
    let input_HomePosition = document.getElementById("gBackToHomeInputModelHomePosition");
    let SelectModelHomeCamera = document.getElementById("gBackToHomeSelectModelHomeCamera");

    if(SelectModelHomeTimes && "BackToHomeTime" in msg)
    {
        SelectModelHomeTimes.value = msg.BackToHomeTime;
    }

    
    if(SelectModelHomePosition && "BackToHomePosIndex" in msg)
    {
        SelectModelHomePosition.value = msg.BackToHomePosIndex;
        if(SelectModelHomePosition.value == 0)
        {
            if(input_HomePosition)
                input_HomePosition.disabled = true;
        }
        else
        {
            if(input_HomePosition)
                input_HomePosition.disabled = false;
        }
    }

    if(input_HomePosition && "BackToHomeCameraPreset" in msg)
    {
        input_HomePosition.value  = msg.BackToHomeCameraPreset;
    }

    if(SelectModelHomeCamera && "BackToHomeSwitchCamera" in msg &&  "BackToHomeCameraArray" in msg)
    {
        for (var i = 0; i < SelectModelHomeCamera.options.length; i++)
        {
            var option = SelectModelHomeCamera.options[i];
        }
        while (SelectModelHomeCamera.options.length > 0) 
        {
            SelectModelHomeCamera.remove(0); 
        }

        let option_All = document.createElement("option");
        option_All.value = 0;
        option_All.text = window.LanguageManager.getTranslatedText("All_Camera");
        option_All.selected = true;
        SelectModelHomeCamera.appendChild(option_All);

        for(var i=0; i<msg.BackToHomeCameraArray.length;i++)
        {
            var option = $("<option />");
            option.val(msg.BackToHomeCameraArray[i].Camera).text(msg.BackToHomeCameraArray[i].Model);
            $("#gBackToHomeSelectModelHomeCamera").append(option);
        }

        if(msg.BackToHomeSwitchCamera ==  'All' || msg.BackToHomeSwitchCamera == '')
        {

        }
        else{
            //console.log(msg.BackToHomeSwitchCamera);
            SelectModelHomeCamera.value = msg.BackToHomeSwitchCamera;
        }
    
    }
}

function onBackToHomeApplyClick()
{
    let BackToHomeModeApply = document.getElementById("gBtnBackToHomeModeApply");
    if(BackToHomeModeApply)
        BackToHomeModeApply.disabled = true;

    var SelectModelHomeTimes    = document.getElementById("gBackToHomeSelectModelHomeTimes");
    var SelectModelHomePosition    = document.getElementById("gBackToHomeSelectModelHomePosition");
    let input_HomePosition = document.getElementById("gBackToHomeInputModelHomePosition");
    let SelectModelHomeCamera = document.getElementById("gBackToHomeSelectModelHomeCamera");

    var setObj = {
        Command: "SetGlobalBackToHomeSetting"
    };

    if(SelectModelHomeTimes)
        setObj.BackToHomeTime = parseInt(SelectModelHomeTimes.value, 10);

    if(SelectModelHomeCamera)
        setObj.BackToHomeSwitchCamera = SelectModelHomeCamera.value;
    if(setObj.BackToHomeSwitchCamera == 0) setObj.BackToHomeSwitchCamera = 'All';

    if(SelectModelHomePosition)
        setObj.BackToHomePosIndex = parseInt(SelectModelHomePosition.value, 10);

    if(input_HomePosition)
        setObj.BackToHomeCameraPreset = parseInt(input_HomePosition.value, 10);
    sendMessage("SetGlobalBackToHomeSetting", setObj);
}

function closeBackToHomeWindow()
{
    const popupWindow = document.getElementById("mic_backToHomeSetting_popup_Window");
    if (popupWindow) 
    {
        popupWindow.style.display = 'none';
    }

}

function BackToHomeSelectModelHomePositionOnChange()
{
    let BackToHomeModeApply = document.getElementById("gBtnBackToHomeModeApply");
    if(BackToHomeModeApply)
        BackToHomeModeApply.disabled = false;

}

function BackToHomeSelectModelHomeCameraOnChange()
{
    let BackToHomeModeApply = document.getElementById("gBtnBackToHomeModeApply");
    if(BackToHomeModeApply)
        BackToHomeModeApply.disabled = false;
}

function BackToHomeSelectModelApplyStatusChange()
{

    let BackToHomeModeApply = document.getElementById("gBtnBackToHomeModeApply");
    if(BackToHomeModeApply)
        BackToHomeModeApply.disabled = false;

    let InputModelHomeTriggerTime = document.getElementById("gBackToHomeSelectModelHomeTimes");
    if(InputModelHomeTriggerTime)
    {
        if(InputModelHomeTriggerTime.value < 0)
        {
            InputModelHomeTriggerTime.value = 0;
        }
        else if (InputModelHomeTriggerTime.value > 999)
        {
            InputModelHomeTriggerTime.value = 999;
        }
    }
}

function BackToHomeSelectModelHomePositionOnChange()
{
    let input_HomePosition = document.getElementById("gBackToHomeInputModelHomePosition");
    let select_HomePosition = document.getElementById("gBackToHomeSelectModelHomePosition");
    let BackToHomeModeApply = document.getElementById("gBtnBackToHomeModeApply");
    if(BackToHomeModeApply)
        BackToHomeModeApply.disabled = false;
    if(input_HomePosition && select_HomePosition)
    {
        console.log(select_HomePosition.value);
        if(select_HomePosition.value == 1)
        {
            input_HomePosition.disabled = false;
        }
        else
        {
            input_HomePosition.disabled = true;
        }
    }
}

function onBackToHomeInputModelHomePositionChange()
{
    let InputModelHomePosition = document.getElementById("gBackToHomeInputModelHomePosition");
    if(InputModelHomePosition)
    {
        console.log(InputModelHomePosition.value);
        if(InputModelHomePosition.value < 0)
        {
            InputModelHomePosition.value = 0;
        }
        else if (InputModelHomePosition.value > 255)
        {
            InputModelHomePosition.value = 255;
        }
    }
    let BackToHomeModeApply = document.getElementById("gBtnBackToHomeModeApply");
    if(BackToHomeModeApply)
        BackToHomeModeApply.disabled = false;

}

const TAB_COUNT = 24;
let isDebugMode = false;             
let debugDataMap = [];               
let currentTabIndex = null;          
let offsetX = 0, offsetY = 0;
let isDragging = false;
let gDebugModePopupIsOpen = false;
let recordingStartTime = 0;  
let recordInterval = null;
let recordBlinkInterval = null;
let deBugModeRecordStatus = false;

function InitDebugModeOfPage(){
    const LabelDebugMode = document.getElementById("Label_DebugMode");
    const BtnDebugModeStart = document.getElementById("Btn_DebugModeStart");
    const BtnDebugModeStop = document.getElementById("Btn_DebugModeStop");

    if(isDebugModeDisplay)
    {
        LabelDebugMode.style.display = 'block';
        BtnDebugModeStart.style.display = 'block';
        BtnDebugModeStop.style.display = 'block';
    }
    else
    {
        LabelDebugMode.style.display = 'none';
        BtnDebugModeStart.style.display = 'none';
        BtnDebugModeStop.style.display = 'none';
    }
}

function getFormattedDateTime() {
  const now = new Date();
  const year = now.getFullYear();
  const month = String(now.getMonth() + 1).padStart(2, '0');
  const day = String(now.getDate()).padStart(2, '0');
  const hours = String(now.getHours()).padStart(2, '0');
  const minutes = String(now.getMinutes()).padStart(2, '0');
  const seconds = String(now.getSeconds()).padStart(2, '0');
  return `${year}-${month}-${day} ${hours}_${minutes}_${seconds}`;
}

function updatedGetMicDebugMessageInfo(msg) {
  if (!isDebugMode) return;
  //console.log('updatedGetMicDebugMessageInfo->',msg);

  const now = getFormattedDateTime();
  const index = msg.SoundTabIndex;

  if (!debugDataMap[index]) {
    debugDataMap[index] = [ [], [] ];
    createTabForIndex(index); 
  }

  debugDataMap[index][0].push(now);
  const dataString = `${msg.DebugMessage}`;
  debugDataMap[index][1].push(dataString);
  
  if (Number(currentTabIndex) === Number(index)) {
    updateTabContent(index);
  }

  if (currentTabIndex === null) {
    showTab(index);
  }

  recordLightImg.src = "./images/Selected.png";
  setTimeout(() => {
    recordLightImg.src = "./images/Disable.png";
  }, 100);
}

function createTabForIndex(index) {
  const tabArea = document.getElementById("tabArea");
  const tabContentContainer = document.getElementById("tabContentContainer");

  const btn = document.createElement("button");
  btn.id = `tabBtn_${index}`;
  btn.className = "tabButton";
  btn.innerText = `Tab ${index}`;
  btn.onclick = () => {
    showTab(index);
  };
  tabArea.appendChild(btn);

  const contentDiv = document.createElement("div");
  contentDiv.id = `tabContent_${index}`;
  contentDiv.style.display = "none";
  tabContentContainer.appendChild(contentDiv);
}

function showTab(index) {
  currentTabIndex = index;

  for (let i = 0; i < TAB_COUNT; i++) {
    const div = document.getElementById(`tabContent_${i}`);
    if (div) {
      div.style.display = "none";
    }
  }

  const currentDiv = document.getElementById(`tabContent_${index}`);
  if (currentDiv) {
    currentDiv.style.display = "block";
  }

  updateTabContent(index);
}

function updateTabContent(index) {
  const contentDiv = document.getElementById(`tabContent_${index}`);
  if (!contentDiv) return;

  const dataArray = debugDataMap[index] || [];
  contentDiv.innerHTML = "";

  dataArray.forEach(line => {
    const p = document.createElement("p");
    p.textContent = line;
    contentDiv.appendChild(p);
  });
}

function formatRecordingTime(totalSeconds) {
  let hours = Math.floor(totalSeconds / 3600);
  let remainder = totalSeconds % 3600;
  let minutes = Math.floor(remainder / 60);
  let seconds = remainder % 60;

  let result = "";

  if (hours > 0) {
    result += `${hours}h `;
  }
  if (hours > 0 || minutes > 0) {
    result += `${minutes}m `;
  }
  result += `${seconds}s`;

  return result.trim();
}


function onStart() {
  openDebugWindow();
  isDebugMode = true;
  document.getElementById("Btn_DebugModeStart").disabled = true;
  document.getElementById("Btn_DebugModeStop").disabled = false;

  debugDataMap = [];
  currentTabIndex = null;
  document.getElementById("tabArea").innerHTML = "";
  document.getElementById("tabContentContainer").innerHTML = "";

  recordingStartTime = Date.now();
  let recordLightImg = document.getElementById("recordLightImg");
  if (recordLightImg) {
    recordLightImg.style.display = 'block';
    recordLightImg.src = "./images/Selected.png";
    deBugModeRecordStatus = true;
  }

  let label = document.getElementById("Label_DebugMode_RecordTime");
  if (label) {
    label.style.display = 'block';
    label.textContent = `Record Time : `;
  }

  recordInterval = setInterval(() => {
    if (!isDebugMode) return;
    
    let elapsedMs = Date.now() - recordingStartTime;
    let sec = Math.floor(elapsedMs / 1000);
    if(sec > 3600)
    {
        onStop();
        return;
    }

    let label = document.getElementById("Label_DebugMode_RecordTime");
    if (label) {
      label.style.display = 'block';
      label.textContent = `Record Time : ${formatRecordingTime(sec)}`;
    }
  }, 1000);
}

// async function onStop() {
//     isDebugMode = false;
//     document.getElementById("Btn_DebugModeStop").disabled = true;
//     document.getElementById("Btn_DebugModeStart").disabled = false;
  
//     if (recordInterval) {
//       clearInterval(recordInterval);
//       recordInterval = null;
//     }
//     if (recordBlinkInterval) {
//       clearInterval(recordBlinkInterval);
//       recordBlinkInterval = null;
//     }

//     let label = document.getElementById("Label_DebugMode_RecordTime");
    
//     if (label) {
//       label.textContent = "Record Time :";
//       label.style.display = 'none';
//     }  
    
//     let recordLightImg = document.getElementById("recordLightImg");
//     if (recordLightImg) {
//       recordLightImg.style.display = 'none';
//       recordLightImg.src = "./images/Disable.png";
//     }

//     closeDebugWindow();
  
//     let connectedTabs = [];
//     let maxLines = 0;
//     for (let i = 0; i < TAB_COUNT; i++) {
//       if (soundSettingMap[i]) {
//         connectedTabs.push(i);
//         const length = debugDataMap[i] ? debugDataMap[i][0].length : 0; 
//         if (length > maxLines) {
//           maxLines = length;
//         }
//       }
//     }
  
//     const rows = [];
  
//     const headerRow = [];
//     for (let idx of connectedTabs) {
//       headerRow.push(`Tab${idx} Time`);
//       headerRow.push(`Tab${idx} Message`);
//     }
//     rows.push(headerRow);
  
//     for (let lineIndex = 0; lineIndex < maxLines; lineIndex++) {
//       let rowCells = [];
//       for (let idx of connectedTabs) {
//         const timeArr = debugDataMap[idx] ? debugDataMap[idx][0] : [];
//         const msgArr  = debugDataMap[idx] ? debugDataMap[idx][1] : [];
  
//         const timeValue = (lineIndex < timeArr.length) ? timeArr[lineIndex] : "";
//         const msgValue  = (lineIndex < msgArr.length)  ? msgArr[lineIndex]  : "";
  
//         rowCells.push(timeValue, msgValue);
//       }
//       rows.push(rowCells);
//     }
  
//     if (maxLines === 0) {
//       rows.push(["No data"]); 
//     }
  
//     const csvContent = generateCSV(rows);
  
//     const currentTime = getFormattedDateTime().replace(/:/g, "_");
//     const fileName = `All Mic tabs ${currentTime}.csv`;
//     const blob = new Blob([csvContent], { type: "text/csv;charset=utf-8;" });
//     const url = URL.createObjectURL(blob);
  
//     const a = document.createElement("a");
//     a.href = url;
//     a.download = fileName;
//     a.click();
//     URL.revokeObjectURL(url);
//   }

async function onStop() {
    isDebugMode = false;
    document.getElementById("Btn_DebugModeStop").disabled = true;
    document.getElementById("Btn_DebugModeStart").disabled = false;
  
    if (recordInterval) {
      clearInterval(recordInterval);
      recordInterval = null;
    }
    if (recordBlinkInterval) {
      clearInterval(recordBlinkInterval);
      recordBlinkInterval = null;
    }
  
    let label = document.getElementById("Label_DebugMode_RecordTime");
    if (label) {
      label.textContent = "Record Time :";
      label.style.display = 'none';
    }
  
    let recordLightImg = document.getElementById("recordLightImg");
    if (recordLightImg) {
      recordLightImg.style.display = 'none';
      recordLightImg.src = "./images/Disable.png";
    }
  
    closeDebugWindow();
  
    let connectedTabs = [];
    for (let i = 0; i < TAB_COUNT; i++) {
      if (soundSettingMap[i]) {
        connectedTabs.push(i);
      }
    }
  
    let allData = [];
    for (let idx of connectedTabs) {
      if (debugDataMap[idx]) {
        const timeArr = debugDataMap[idx][0] || [];
        const msgArr  = debugDataMap[idx][1] || [];
        for (let i = 0; i < timeArr.length; i++) {
          allData.push({
            time: timeArr[i],
            message: msgArr[i],
            tab: idx
          });
        }
      }
    }
  
    if (allData.length === 0) {
      const rows = [["No data"]];
      const csvContentNoData = generateCSV(rows);
      downloadCSV(csvContentNoData);
      return;
    }
  
    let timeGroups = {};
    for (let entry of allData) {
      const { time, message, tab } = entry;
      if (!timeGroups[time]) {
        timeGroups[time] = {};
      }
      if (!timeGroups[time][tab]) {
        timeGroups[time][tab] = [];
      }
      timeGroups[time][tab].push(message);
    }
  
    let sortedTimes = Object.keys(timeGroups).sort((a, b) => a.localeCompare(b));
  
    const rows = [];
    const headerRow = [];
    for (let idx of connectedTabs) {
      headerRow.push(`Tab${idx} Time`);
      headerRow.push(`Tab${idx} Message`);
    }
    rows.push(headerRow);
  
    for (let time of sortedTimes) {
      let tabData = timeGroups[time];
  
      let maxCountAtThisTime = 0;
      for (let idx of connectedTabs) {
        const messages = tabData[idx] || [];
        if (messages.length > maxCountAtThisTime) {
          maxCountAtThisTime = messages.length;
        }
      }
  
      for (let rowIndex = 0; rowIndex < maxCountAtThisTime; rowIndex++) {
        let rowCells = [];
        for (let idx of connectedTabs) {
          const messages = tabData[idx] || [];
          if (messages[rowIndex] !== undefined) {
            rowCells.push(time);
            rowCells.push(messages[rowIndex]);
          } else {
            rowCells.push("");
            rowCells.push("");
          }
        }
        rows.push(rowCells);
      }
    }
  
    const csvContent = generateCSV(rows);
    downloadCSV(csvContent);
  
    function downloadCSV(csvData) {
      const currentTime = getFormattedDateTime().replace(/:/g, "_");
      const fileName = `All Mic tabs ${currentTime}.csv`;
      const blob = new Blob([csvData], { type: "text/csv;charset=utf-8;" });
      const url = URL.createObjectURL(blob);
  
      const a = document.createElement("a");
      a.href = url;
      a.download = fileName;
      a.click();
      URL.revokeObjectURL(url);
    }
  }

function generateCSV(rows) 
{
    return rows.map(row => row.map(cell => csvEscapeCell(cell)).join(",")).join("\r\n");
}

function csvEscapeCell(cell) {
    if (cell == null) cell = "";
    else if (typeof cell !== "string") cell = String(cell);
    cell = cell.replace(/"/g, '""');
    return `"${cell}"`;
}

function openDebugWindow() {
  gDebugModePopupIsOpen = true;
  const popupWin = document.getElementById(`debugMode_popup_Window`);
//   popupWin.style.display = 'block';

//   popupWin.addEventListener("mousedown", function(e) {
//     isDragging = true;
//     offsetX = e.clientX - popupWin.offsetLeft;
//     offsetY = e.clientY - popupWin.offsetTop;
//   });

//   document.addEventListener("mousemove", function(e) {
//   if (isDragging) {
//       popupWin.style.left = (e.clientX - offsetX) + "px";
//       popupWin.style.top = (e.clientY - offsetY) + "px";
//   }
//   });
//   document.addEventListener("mouseup", function() {
//   isDragging = false;
//   });
}

function closeDebugWindow() {
  gDebugModePopupIsOpen = false;
  const popupWindow = document.getElementById('debugMode_popup_Window');
//   popupWindow.style.display = 'none';
}

var gCamConnectStatusMap = new Map();

function updateCamConnectStatus(msg)
{
    //console.log('msg.IPAddress:',msg.IPAddress);
    //console.log('msg.Result:',msg.Result);
    //console.log('updateCamConnectStatus msg:',msg);

    gCamConnectStatusMap.clear();
    if( 'CamConnectStatusArray' in msg)
    {
        if('CamConnectStatusArrayCount' in msg)
        {
            var statusArrayCount = msg.CamConnectStatusArrayCount;
            if(statusArrayCount ==0) return;

            let camIpLocation = "";            
            
            let camStatusString = "";


            var camTableCount = 0;
            if(document.getElementById("tableSearchCamera"))
                camTableCount = document.getElementById("tableSearchCamera").rows.length;
            var camTableIndex = 0;
            var isFindCamera = false;
            var isDanteSource = false;
            var danteSourceCountName = "DanteCH01";
            var danteSourceString = "";
            var camDisplayNameString = "";

            for(index=0;index < statusArrayCount; index++)
            {               
                isDanteSource = msg.CamConnectStatusArray[index].IsDante;
                if(isDanteSource)
                {
                    danteSourceString =  msg.CamConnectStatusArray[index].DanteSource;
                }
                else
                {
                    danteSourceString = "";
                }

                camIpLocation =  msg.CamConnectStatusArray[index].IPAddress;

                camStatusString = msg.CamConnectStatusArray[index].CamConnectStatus;

                camDisplayNameString =   msg.CamConnectStatusArray[index].DisplayName;

                gCamConnectStatusMap.set(camDisplayNameString,camStatusString);

                //Camera list
                isFindCamera = false;
                camTableCount = 0;
                if(document.getElementById("tableSearchCamera"))
                    camTableCount = document.getElementById("tableSearchCamera").rows.length;
                for(camTableIndex= 0 ; camTableIndex < camTableCount; camTableIndex++)
                {
                    if(isDanteSource)
                    {
                        if(document.getElementById("cameraName_"+camTableIndex))
                        {
                            if(document.getElementById("cameraName_"+camTableIndex).innerText == danteSourceString)
                            {
                                var getIpString =  camIpLocation;
                                if(getIpString.length > (danteSourceCountName.length+1))
                                    getIpString = getIpString.substring(danteSourceCountName.length +1,getIpString.length -1);
                                else
                                    getIpString ="";
            
                                document.getElementById("cameraIP_"+camTableIndex).innerText =getIpString;
            
                                isFindCamera = true;
                                break;
                            }                  
                        }
                        
                    }
                    else
                    {
                        if(document.getElementById("cameraIP_"+camTableIndex))
                        {
                            if(document.getElementById("cameraIP_"+camTableIndex).innerText == camIpLocation)
                            {
                                isFindCamera = true;
                                break;
                            }   
                        }
                    }
                }

                if(isFindCamera)
                {
                    let camSourceIp = "";
                    if(isDanteSource)
                        camSourceIp = danteSourceString;
                    else
                        camSourceIp = camIpLocation;
            
                    updateCamTableStatus(camTableIndex,camSourceIp,camStatusString);
                }
                
            }
        }
    }
    refreshSelectCameraOptions();
    updateZoneFullMapCameraConnection();
}

function checkCamConnectStatus(camDisplayName)
{
    //console.log('checkCamConnectStatus  camDisplayName:',camDisplayName);
    if(camDisplayName == "Off" || camDisplayName == "OFF" || camDisplayName == window.LanguageManager.getTranslatedText('Off') 
        || camDisplayName == window.LanguageManager.getTranslatedText('OFF') || camDisplayName == -1 || camDisplayName == "-1" 
        || camDisplayName == window.LanguageManager.getTranslatedText('All_Camera'))
        return true;

    if(gCamConnectStatusMap.has(camDisplayName))
    {
        let connectStatus = gCamConnectStatusMap.get(camDisplayName);
        //console.log('checkCamConnectStatus  connectStatus:',connectStatus);
        if(connectStatus == window.LanguageManager.getTranslatedText('Connected') 
            || connectStatus == window.LanguageManager.getTranslatedText('Disconnecting')
            || connectStatus == 'Disconnecting'
            || connectStatus == window.LanguageManager.getTranslatedText('Ready') 
            || connectStatus == 'Ready'
            || connectStatus == 'Pending'
            || connectStatus == '')
        {
            return true;
        }
        else
        {
            return false;
        }                
    }
    else
        return false;
}

function refreshSelectCameraOptions()
{
    var micGroup = getDeviceCameraMappingIndex();
    var micTabPage = gDeviceIndex;
    var currentSoundType = "0";
    if(document.getElementById("deviceTypeSel_" + micTabPage))
        currentSoundType = document.getElementById("deviceTypeSel_" + micTabPage).value;

    var micSelect = parseInt(currentSoundType);
    var selectChannel = 0;
    if(!document.getElementById("selectMicChannel_" + micGroup))
        selectChannel = 0;
    else
        selectChannel = document.getElementById("selectMicChannel_" + micGroup).value;
    
    var micSelectChannel = parseInt(selectChannel);

    for (var arrayIndex = 0; arrayIndex < micSelectChannel; arrayIndex++) 
    {
        var cameraMappingSelectItem = document.getElementById("cameraMappingSeleceItem_div_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" + arrayIndex);
        var cameraMappingSecondSelectItem = document.getElementById("cameraMappingSecondSeleceItem_div_" + micTabPage + "_" + micSelect + "_" + micGroup + "_" + arrayIndex);
        
        if(cameraMappingSelectItem)
        {
            for(var optionIndex =0; optionIndex < cameraMappingSelectItem.options.length;optionIndex++)
            {
                var option = cameraMappingSelectItem.options.item(optionIndex);
                //console.log('refreshSelectCameraOptions  option.val:',option.value);
                if(option.text == "Off")
                { 
                    if(cameraMappingSelectItem.value == option.value)
                        cameraMappingSelectItem.style.color = "#000000";
                    option.style.color = "#000000";
                }
                else
                {
                    if(checkCamConnectStatus(option.value))
                    {
                        if(cameraMappingSelectItem.value == option.value)
                            cameraMappingSelectItem.style.color = "#000000";
                        option.style.color = "#000000";
                    }
                    else
                    {
                        if(cameraMappingSelectItem.value == option.value)
                            cameraMappingSelectItem.style.color = "#b01726";
                        option.style.color = "#b01726";
                    }
                }
            }
        }
        if(cameraMappingSecondSelectItem)
        {
            for(var optionIndex =0; optionIndex < cameraMappingSecondSelectItem.options.length;optionIndex++)
            {
                var option = cameraMappingSecondSelectItem.options.item(optionIndex);
                if(option.text == "Off")
                { 
                    if(cameraMappingSecondSelectItem.value == option.value)
                        cameraMappingSecondSelectItem.style.color = "#000000";
                    option.style.color = "#000000";
                }
                else
                {
                    if(checkCamConnectStatus(option.value))
                    {
                        if(cameraMappingSecondSelectItem.value == option.value)
                            cameraMappingSecondSelectItem.style.color = "#000000";
                        option.style.color = "#000000";
                    }
                    else
                    {
                        if(cameraMappingSecondSelectItem.value == option.value)
                            cameraMappingSecondSelectItem.style.color = "#b01726";
                        option.style.color = "#b01726";
                    }
                }
            }
        }
    }

    let SelectModelHomeCamera = document.getElementById("gBackToHomeSelectModelHomeCamera");
    if(SelectModelHomeCamera)
    {
        
        for(var optionIndex =0; optionIndex < SelectModelHomeCamera.options.length;optionIndex++)
        {
            var option = SelectModelHomeCamera.options.item(optionIndex);
            //console.log('SelectModelHomeCamera  option.val:',option.text);
            if(option.text == "All")
            { 
                if(SelectModelHomeCamera.value == option.value)
                    SelectModelHomeCamera.style.color = "#000000";
                option.style.color = "#000000";
            }
            else
            {
                if(checkCamConnectStatus(option.text))
                {
                    if(SelectModelHomeCamera.value == option.value)
                        SelectModelHomeCamera.style.color = "#000000";
                    option.style.color = "#000000";
                }
                else
                {
                    if(SelectModelHomeCamera.value == option.value)
                        SelectModelHomeCamera.style.color = "#b01726";
                    option.style.color = "#b01726";
                }
            }
            
        }
    }

    for (var layoutCamPosIndex = 1; layoutCamPosIndex < 5; layoutCamPosIndex++) 
    {
        var selElm = document.getElementById("layoutCamPos" + layoutCamPosIndex);
        if(selElm)
        {
            for(var optionIndex =0; optionIndex < selElm.options.length;optionIndex++)
            {
                var option = selElm.options.item(optionIndex);
                //console.log('SelectModelHomeCamera  option.val:',option.text);
                if(option.text == "Off")
                { 
                    if(selElm.value == option.value)
                        selElm.style.color = "#000000";
                    option.style.color = "#000000";
                }
                else
                {
                    if(checkCamConnectStatus(option.text))
                    {
                        if(selElm.value == option.value)
                            selElm.style.color = "#000000";
                        option.style.color = "#000000";
                    }
                    else
                    {
                        if(selElm.value == option.value)
                            selElm.style.color = "#b01726";
                        option.style.color = "#b01726";
                    }
                }
                
            }
        }
    }
    
}

function updateGetSystemSetting(obj)
{
    if (obj.System && typeof obj.System.EnableAIDirector !== 'undefined') 
    {
        const enableAIDirector = obj.System.EnableAIDirector;
        let DirectorBtn = document.getElementById("DirectorBtn");

        if(!isViewerLogin)
        {
            if(enableAIDirector)
            {
                if(DirectorBtn)
                {
                    DirectorBtn.style.display = "block";
                }
            }
            else
            {
                if(DirectorBtn)
                {
                    DirectorBtn.style.display = "none";
                }
            }  
        }
    }

}
